'\" Color=Green
'\" 
'\" Copyright (c) 1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) palette.n 1.3 95/08/12 17:35:36
'\" 
.so STk-man.macros
.TH Tk:set-palette! n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tk:set-palette!, Tk:bisque \- Modify the Tk color palette
.SH SYNOPSIS
(\fBTk:set-palette! \fIbackground\fR)
.sp
(\fBTk:set-palette! \fIname value \fR?\fIname value ...\fR?)
.sp
(\fBTk:bisque\fR)
.BE

.SH DESCRIPTION
.PP
The \fBTk:set-palette!\fR procedure changes the color scheme for Tk.
It does this by modifying the colors of existing widgets and by changing
the option database so that future widgets will use the new color scheme.
If \fBTk:set-palette!\fR is invoked with a single argument, the
argument is the name of a color to use as the normal background
color;  \fBTk:set-palette!\fR will compute a complete color palette
from this background color.
Alternatively, the arguments to \fBTk:set-palette!\fR may consist of any number
of \fIname\fR\-\fIvalue\fR pairs, where the first argument of the pair
is the name of an option in the Tk option database and the second
argument is the new value to use for that option.  The following
database names are currently supported:
.DS L
.ta 4c 8c
\fBactiveBackground	foreground	selectColor
activeForeground	highlightBackground	selectBackground
background	highlightColor	selectForeground
disabledForeground	insertBackground	troughColor\fR
.DE
\fBTk:set-palette!\fR tries to compute reasonable defaults for any
options that you don't specify.  You can specify options other
than the above ones and Tk will change those options on widgets as
well.  This feature may be useful if you are using custom widgets with
additional color options.
.PP
Once it has computed the new value to use for each of the color options,
\fBTk:set-palette!\fR scans the widget hierarchy to modify the options
of all existing widgets.  For each widget, it checks to see if any
of the above options is defined for the widget.  If so, and if the
option's current value is the default, then the value is changed;  if
the option has a value other than the default, \fBTk:set-palette!\fR
will not change it.  The default for an option is the one provided by
the widget \fB(list-ref (w 'configure option) 3)\fR unless
\fBTk:set-palette!\fR has been run previously, in which case it is the
value specified in the previous invocation of \fBTk:set-palette!\fR.
.PP
After modifying all the widgets in the application, \fBTk:set-palette!\fR
adds options to the option database to change the defaults for
widgets created in the future.  The new options are added at
priority \fBwidgetDefault\fR, so they will be overridden by options
from the .Xdefaults file or options specified on the command-line
that creates a widget.
.PP
The procedure \fBTk:bisque\fR is provided for backward compatibility:
it restores the application's colors to the light brown (``bisque'')
color scheme used in Tk 3.6 and earlier versions.

