/*****************************************************************************
 * xosdparams_ui.c: Xosd Parameters Xaw GUI
 *****************************************************************************
 * $Id: xosdparams_ui.c,v 1.11 2004/11/20 10:41:47 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2004 Pingus
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <math.h>

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#include "strtab.h"
#include "xdtv.h"
#include "grab.h"
#include "x11.h"
#include "toolbox.h"
# include "popup_ui.h"

//#ifdef USE_LIBXOSD <= xosd inside now
#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
# include "../pixmaps/xosd_commonxosdoptions.xpm"
# include "../pixmaps/xosd_mainxosdoptions.xpm"
# include "../pixmaps/xosd_vtxxosdoptions.xpm"
# include "../pixmaps/xosd_openmainoptions.xpm"
# include "../pixmaps/xosd_updmainxosd.xpm"
# include "../pixmaps/xosd_updvtxxosd.xpm"
# include "../pixmaps/xosd_applysave.xpm"
#endif
#endif
//#endif <= xosd inside now


//#ifdef USE_LIBXOSD <= xosd inside now
#include <xosd.h>

/*-------------------------------------------------------------------------*/
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern void OptionsAction (Widget, XEvent *, String *, Cardinal *);
extern void action_cb (Widget widget, XtPointer clientdata, XtPointer call_data);
extern void update_main_xosd();
extern void update_vtx_xosd();
extern Widget app_shell, c_xosdaction;
extern Display *dpy;
extern Atom wm_protocols[2];
extern int debug;
extern int message_timer;
extern int outline_offset;
extern int shadow_offset;
extern char *font, *font_vtx, *colour, *outline_colour;
extern int libxosd_ok, libxosd;

xosd *main_test_osd;
xosd *vtx_test_osd;

static Widget xosdparams_shell, xosdparams_paned;
static Widget l_mess_timer, s_mess_timer;
static Widget l_out_offset, s_out_offset;
static Widget l_sdw_offset, s_sdw_offset;
static Widget c_text_color, c_outline_color;
static Widget c_main_font_type, c_main_font_size;
static Widget c_vtx_font_type, c_vtx_font_size;
static Widget c_test_main_xosd, c_test_vtx_xosd;
static Widget c_openmain, c_xosd, c_mainxosd, c_vtx,  c_xosdparamssave;

char main_font[50], main_size[50];
char vtx_font[50], vtx_size[50];

int main_font_type, main_font_size;
int vtx_font_type, vtx_font_size;

#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

/*------------------------------------------------------------------------*/

#define MESS_TIMER_RANGE          20.0
#define OUT_OFFSET_RANGE          20.0
#define SDW_OFFSET_RANGE          20.0

/*------------------------------------------------------------------------*/

struct CALL_ACTION call_options_6 = { 0, "Options", {NULL} };

/*------------------------------------------------------------------------*/

enum {
  TEXT_COLOR,
  OUTLINE_COLOR,
  MAIN_FONT_TYPE,
  MAIN_FONT_SIZE,
  VTX_FONT_TYPE,
  VTX_FONT_SIZE
};

static struct STRTAB text_color_list[] = {
  {0, "white"},  
  {1, "DeepSkyBlue"},  
  {2, "Cyan"},
  {3, "SpringGreen"},
  {4, "LawnGreen"},
  {5, "Gold"},
  {6, "Yellow"},
  {7, "OrangeRed"},
  {8, "DeepPink"},
  {9, "Magenta"},
  {10, "SandyBrown"},
  {11, "LightSalmon"},
  {-1, NULL}
};

static struct STRTAB outline_color_list[] = {
  {0, "black"},  
  {1, "red"},  
  {2, "DarkViolet"},  
  {3, "RoyalBlue4"},  
  {4, "DeepSkyBlue4"},          
  {5, "turquoise4"},   
  {6, "khaki4"},       
  {7, "IndianRed4"}, 
  {8, "brown4"},  
  {9, "DarkSlateGray4"},  
  {10, "cyan4"},             
  {11, "SpringGreen4"},      
  {-1, NULL}
};

static struct STRTAB xosd_font_type_list[] = {
  {0, "courier"},  
  {1, "lucidatypewriter"},  
  {2, "helvetica"},
  {3, "lucida"},
  {4, "new century schoolbook"},
  {5, "times"},
  {6, "bitstream vera sans mono"},
  {7, "bitstream vera serif"},
  {8, "bitstream vera sans"},
  {9, "ledfixed"},
  {-1, NULL}
};

static struct STRTAB xosd_font_size_list[] = {
  {0, "*"},    
  {1, "80"},  
  {2, "100"},  
  {3, "120"},
  {4, "140"},
  {5, "180"},
  {6, "240"},
  {7, "260"},
  {8, "280"},  
  {9, "300"},  
  {-1, NULL}
};
/*-------------------------------------------------------------------------*/

void
destroy_xosd_test()
{
  xosd_destroy (main_test_osd);
  xosd_destroy (vtx_test_osd); 
}

void
update_xosd_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  update_main_xosd ();
  update_vtx_xosd ();
}

void
update_main_xosd_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  Dimension x, y;
  Dimension w, h;  

  XtVaGetValues (app_shell, XtNx, &x, XtNy, &y,
                XtNwidth, &w, XtNheight, &h, NULL);
  
  update_main_xosd ();

  if (xosd_is_onscreen(main_test_osd))  
    xosd_hide (main_test_osd);  
  if (xosd_is_onscreen(vtx_test_osd))      
    xosd_hide (vtx_test_osd);  
  main_test_osd = xosd_create (2);
  
  if (!main_test_osd)
    {
      fprintf (stderr, "Error initializing osd: %s\n", xosd_error);
      libxosd_ok = 0;
      return;
   }
  if (xosd_set_font(main_test_osd, font))
    if (xosd_set_font(main_test_osd, osd_default_font))
      {
        fprintf (stderr, "ABORT: %s\n", xosd_error);
	libxosd_ok = 0;
	return;
      }  
  
  xosd_set_font (main_test_osd, font);
  xosd_set_shadow_offset (main_test_osd, shadow_offset);
  xosd_set_colour (main_test_osd, colour);
  xosd_set_outline_offset(main_test_osd, outline_offset);
  xosd_set_outline_colour(main_test_osd, outline_colour);  
  xosd_set_align(main_test_osd, XOSD_center);
  xosd_set_pos (main_test_osd, XOSD_bottom);
  xosd_set_vertical_offset (main_test_osd, -y - h + sheight);
  xosd_set_align (main_test_osd, XOSD_center);
  xosd_set_horizontal_offset (main_test_osd,x + w/2 - swidth/2);  
  xosd_set_bar_length(main_test_osd, w/20);
  xosd_display (main_test_osd, 0,XOSD_string,"XOSD: 50%");  
  xosd_display (main_test_osd, 1, XOSD_percentage, 50);
  xosd_set_timeout(main_test_osd, message_timer/1000);  
}

void
update_vtx_xosd_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  Dimension x, y;
  Dimension w, h;  
  
  XtVaGetValues (app_shell, XtNx, &x, XtNy, &y,
                XtNwidth, &w, XtNheight, &h, NULL);
  
  update_vtx_xosd ();
  
  if (xosd_is_onscreen(vtx_test_osd))    
    xosd_hide (vtx_test_osd);
  if (xosd_is_onscreen(main_test_osd))      
    xosd_hide (main_test_osd);       
  vtx_test_osd = xosd_create (3);
  
  if (!vtx_test_osd)
    {
      fprintf (stderr, "Error initializing osd: %s\n", xosd_error);
      libxosd_ok = 0;
      return;
   }
  if (xosd_set_font(vtx_test_osd, font))
    if (xosd_set_font(vtx_test_osd, osd_default_font))
      {
        fprintf (stderr, "ABORT: %s\n", xosd_error);
	libxosd_ok = 0;
	return;
      }
  
  xosd_set_font (vtx_test_osd, font_vtx);
  xosd_set_shadow_offset (vtx_test_osd, shadow_offset);
  xosd_set_colour (vtx_test_osd, colour);
  xosd_set_outline_offset(vtx_test_osd, outline_offset);
  xosd_set_outline_colour(vtx_test_osd, outline_colour);  
  xosd_set_align(vtx_test_osd, XOSD_center);
  xosd_set_pos (vtx_test_osd, XOSD_bottom);
  xosd_set_vertical_offset (vtx_test_osd, -y - h + sheight);
  xosd_set_align (vtx_test_osd, XOSD_center);
  xosd_set_horizontal_offset (vtx_test_osd,x + w/2 - swidth/2);  
  xosd_display (vtx_test_osd, 0, XOSD_string, "XOSD Teletext Text 1");  
  xosd_display (vtx_test_osd, 1, XOSD_string, "XOSD Teletext Text 2"); 
  xosd_display (vtx_test_osd, 2, XOSD_string, "XOSD Teletext Text 3"); 
  xosd_set_timeout(vtx_test_osd, message_timer/1000);  
}


/*-------------------------------------------------------------------------*/

static void
xosdparams_menu_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int cd = (int) clientdata;
  int j;
  char label[64];
  if (!font)
    font = strdup("-*-bitstream vera sans mono-*-*-*-*-*-240-*-*-*-*-*-*");
  if (!font_vtx)
    font_vtx = strdup("-*-bitstream vera sans mono-*-*-*-*-*-180-*-*-*-*-*-*");

  switch (cd)
    {
    case TEXT_COLOR:
      if (-1 != (j = popup_menu (widget, "Text Color", text_color_list)))
        {
          colour = int_to_str (j, text_color_list);
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Text Color",colour);
          XtVaSetValues (c_text_color, XtNlabel, label, NULL);
	  if (debug)
	    fprintf(stderr,"Text Color: %s\n",colour);
        }
      break;
    case OUTLINE_COLOR:
      if (-1 != (j = popup_menu (widget, "Outline Color", outline_color_list)))
        {
          outline_colour = int_to_str (j, outline_color_list);
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Outline Color",outline_colour);
          XtVaSetValues (c_outline_color, XtNlabel, label, NULL);
	  if (debug)
	    fprintf(stderr,"Outline Color: %s\n",outline_colour);
        }
      break;     
    case MAIN_FONT_TYPE:
      if (-1 != (j = popup_menu (widget, "Main Font Type", xosd_font_type_list)))
        {
          main_font_type = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Type",
                   int_to_str (main_font_type, xosd_font_type_list));
          XtVaSetValues (c_main_font_type, XtNlabel, label, NULL);
          sprintf (main_font, int_to_str (main_font_type, xosd_font_type_list));
	  sprintf (font,strdup("-*-%s-*-*-*-*-*-%s-*-*-*-*-*-*"),main_font,main_size);
	  if (debug) {
	    fprintf(stderr,"Main Font Type: %s\n",main_font);
	    fprintf(stderr,"Main Font: %s\n",font);	  
	  }
        }
      break;        
    case MAIN_FONT_SIZE:
      if (-1 != (j = popup_menu (widget, "Main Font Size", xosd_font_size_list)))
        {
          main_font_size = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Size",
                   int_to_str (main_font_size, xosd_font_size_list));
          XtVaSetValues (c_main_font_size, XtNlabel, label, NULL);
          sprintf (main_size, int_to_str (main_font_size, xosd_font_size_list));
	  sprintf (font,strdup("-*-%s-*-*-*-*-*-%s-*-*-*-*-*-*"),main_font,main_size);
	  if (debug) {
	    fprintf(stderr,"Main Font Size: %s\n",main_size);
	    fprintf(stderr,"Main Font: %s\n",font);
	  }
        }
      break;
    case VTX_FONT_TYPE:
      if (-1 != (j = popup_menu (widget, "Teletext Font Type", xosd_font_type_list)))
        {
          vtx_font_type = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Type",
                   int_to_str (vtx_font_type, xosd_font_type_list));
          XtVaSetValues (c_vtx_font_type, XtNlabel, label, NULL);
	  sprintf (vtx_font, int_to_str (vtx_font_type, xosd_font_type_list));
	  sprintf (font_vtx,strdup("-*-%s-*-*-*-*-*-%s-*-*-*-*-*-*"),vtx_font,vtx_size);
	  if (debug) {	  
	    fprintf(stderr,"Main Font Type: %s\n",vtx_font);
	    fprintf(stderr,"Main Font: %s\n",font_vtx);
	  }
	  
        }
      break;        
    case VTX_FONT_SIZE:
      if (-1 != (j = popup_menu (widget, "Teletext Font Size", xosd_font_size_list)))
        {
          vtx_font_size = j;
          sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Size",
                   int_to_str (vtx_font_size, xosd_font_size_list));
          XtVaSetValues (c_vtx_font_size, XtNlabel, label, NULL);  
	  sprintf (vtx_size, int_to_str (vtx_font_size, xosd_font_size_list));
	  sprintf (font_vtx,strdup("-*-%s-*-*-*-*-*-%s-*-*-*-*-*-*"),vtx_font,vtx_size);
	  if (debug) {
	    fprintf(stderr,"Main Font Size: %s\n",vtx_size);
	    fprintf(stderr,"Main Font: %s\n",font_vtx);
	  } 
        }
      break;            
    default:
      break;
    }
}

static void
xosd_jump_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  char *name;
  int value = 0;
  float data;  
  char label[64];

  data = *(float *) call_data;
  name = XtName (XtParent (widget));

  if (0 == strcmp(name, "mess_timer"))
    {
      value = (int) rint(data * MESS_TIMER_RANGE);
      if (value == 0)
        value = 1;
      message_timer = value*1000;

      if (s_mess_timer)
        set_float (s_mess_timer, XtNtopOfThumb, (float)value/MESS_TIMER_RANGE);

      sprintf(label, "%-" LABEL_WIDTH3 "s: %4d", "Message Timer", value);       
      if (l_mess_timer)
        XtVaSetValues(l_mess_timer, XtNlabel, label, NULL);
      if (debug)
        fprintf(stderr,"Message Timer: %d\n",message_timer);
    }
  if (0 == strcmp(name, "out_offset"))
    {
      value = (int) rint(data * OUT_OFFSET_RANGE);
      outline_offset = value;

      if (s_out_offset)
        set_float (s_out_offset, XtNtopOfThumb, (float)value/OUT_OFFSET_RANGE);

      sprintf(label, "%-" LABEL_WIDTH3 "s: %4d", "Outline Offset", value);
      if (l_out_offset)
        XtVaSetValues(l_out_offset, XtNlabel, label, NULL);
      if (debug)
        fprintf(stderr,"Outline Offset: %d\n",outline_offset);
    }
  if (0 == strcmp(name, "sdw_offset"))
    {
      value = (int) rint(data * SDW_OFFSET_RANGE);
      shadow_offset = value;

      if (s_sdw_offset)
        set_float (s_sdw_offset, XtNtopOfThumb, (float)value/SDW_OFFSET_RANGE);

      sprintf(label, "%-" LABEL_WIDTH3 "s: %4d", "Shadow Offset", value);
      if (l_sdw_offset)
        XtVaSetValues(l_sdw_offset, XtNlabel, label, NULL);
      if (debug)
        fprintf(stderr,"Shadow Offset: %d\n",shadow_offset);
    }        
}

static void
xosd_scroll_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int move = (int) call_data;
  Dimension length;
  float shown, top1, top2;
  char *name;
  float step = 1.0;
  float range = 1.0;

  name = XtName (XtParent (widget));

  XtVaGetValues (widget,
                 XtNlength, &length,
                 XtNshown, &shown, XtNtopOfThumb, &top1, NULL);

  if (strcmp(name, "mess_timer") == 0)
    {
      range = MESS_TIMER_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "out_offset") == 0)
    {
      range = OUT_OFFSET_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "sdw_offset") == 0)
    {
      range = SDW_OFFSET_RANGE;
      step = 1.0;
    }        

  if (move > 0)
    top2 = top1 + step/range;
  else
    top2 = top1 - step/range;
  if (top2 < 0.0)
    top2 = 0.0;
  if (top2 > 1.0)
    top2 = 1.0;

  xosd_jump_scb (widget, clientdata, &top2);

}


/*--------------------------------------------------------------------------*/

static void
close_xosdparamswin (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  XtCallActionProc (xosdparams_shell, "XosdParams", NULL, NULL, 0);
}

void
XosdParamsAction (Widget widget, XEvent * event, String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;
  
  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Config: wm_save_yourself\n");
          XSetCommand (XtDisplay (xosdparams_shell), XtWindow (xosdparams_shell), NULL, 0);
          return;
        }
    }

  if (xosdparams_shell == NULL)
    {
      fprintf(stderr, "XosdParamsAction: ooops: xosdparams_shell is NULL\n");
      return;
    }

  if (mapped)
    {
      XtPopdown (xosdparams_shell);
      mapped = 0;
      if (libxosd && c_xosdaction)
        XtVaSetValues (c_xosdaction, XtNlabel, "Xosd             :      (On)     Ctrl+X", NULL);  
      else if (c_xosdaction)
        XtVaSetValues (c_xosdaction, XtNlabel, "Xosd             :     (Off)     Ctrl+X", NULL);        
    }
  else
    {
      XtPopup (xosdparams_shell, XtGrabNone);
      mapped = 1;
      if (c_xosdaction)
        XtVaSetValues (c_xosdaction, XtNlabel, "Xosd             : (Options)    Shift+X", NULL);
      if (first)
        {
          XSetWMProtocols (XtDisplay (xosdparams_shell), XtWindow (xosdparams_shell), wm_protocols, 2);
          first = 0;
        }
    }
}

/*--------------------------------------------------------------------------*/

void
create_xosdparamswin()
{
  Widget c, p;
  char label[64];

  xosdparams_shell = XtVaAppCreateShell ("XosdParams", "XdTV",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell, XtNvisual,vinfo->visual,
				   XtNcolormap,colormap, XtNdepth,vinfo->depth,
				   NULL);

  xosdparams_paned =
    XtVaCreateManagedWidget ("paned", panedWidgetClass, xosdparams_shell, NULL);

  /* Xosd Label */
  c_xosd = XtVaCreateManagedWidget ("lxosd", labelWidgetClass, xosdparams_paned,
                           PANED_FIX, NULL);    

			   
  /* Message Timer */
  p =
    XtVaCreateManagedWidget ("mess_timer", panedWidgetClass, xosdparams_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_mess_timer = XtVaCreateManagedWidget ("lmess_timer", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_mess_timer = XtVaCreateManagedWidget ("smess_timer", scrollbarWidgetClass, p,
					  PANED_FIX, NULL);
  set_float(s_mess_timer, XtNtopOfThumb, (float)message_timer/1000/MESS_TIMER_RANGE);
  sprintf (label, "%-" LABEL_WIDTH3 "s: %4d", "Message Timer", message_timer/1000);
  XtVaSetValues (l_mess_timer, XtNlabel, label, NULL);  
  XtAddCallback (s_mess_timer, XtNjumpProc, xosd_jump_scb, NULL);
  XtAddCallback (s_mess_timer, XtNscrollProc, xosd_scroll_scb, NULL);

  
  /* Xosd Text Color Menu */
  c_text_color = c = XtVaCreateManagedWidget ("Text Color", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) TEXT_COLOR);
  if (!colour)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Text Color","lawngreen");
  else
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Text Color",colour);
  XtVaSetValues (c, XtNlabel, label, NULL);

    
  /* Xosd Outline Color Menu */
  c_outline_color = c = XtVaCreateManagedWidget ("Outline Color", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) OUTLINE_COLOR);
  if (!outline_colour)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Text Color","black");
  else  
  sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Outline Color",outline_colour);
  XtVaSetValues (c, XtNlabel, label, NULL);  

  
  /* Outline Offset */
  p =
    XtVaCreateManagedWidget ("out_offset", panedWidgetClass, xosdparams_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_out_offset = XtVaCreateManagedWidget ("lout_offset", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_out_offset = XtVaCreateManagedWidget ("sout_offset", scrollbarWidgetClass, p,
					  PANED_FIX, NULL);
  set_float(s_out_offset, XtNtopOfThumb, (float)outline_offset/OUT_OFFSET_RANGE);  
  sprintf (label, "%-" LABEL_WIDTH3 "s: %4d", "Outline Offset", outline_offset);
  XtVaSetValues (l_out_offset, XtNlabel, label, NULL);  
  XtAddCallback (s_out_offset, XtNjumpProc, xosd_jump_scb, NULL);
  XtAddCallback (s_out_offset, XtNscrollProc, xosd_scroll_scb, NULL);
  
  
  /* Shadow Offset */
  p =
    XtVaCreateManagedWidget ("sdw_offset", panedWidgetClass, xosdparams_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_sdw_offset = XtVaCreateManagedWidget ("lsdw_offset", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_sdw_offset = XtVaCreateManagedWidget ("sdw_offset", scrollbarWidgetClass, p,
					  PANED_FIX, NULL);
  set_float(s_sdw_offset, XtNtopOfThumb, (float)shadow_offset/SDW_OFFSET_RANGE);  
  sprintf (label, "%-" LABEL_WIDTH3 "s: %4d", "Shadow Offset", shadow_offset);
  XtVaSetValues (l_sdw_offset, XtNlabel, label, NULL);
  XtAddCallback (s_sdw_offset, XtNjumpProc, xosd_jump_scb, NULL);
  XtAddCallback (s_sdw_offset, XtNscrollProc, xosd_scroll_scb, NULL);
  
  
  /* Main Xosd Label */
  c_mainxosd = XtVaCreateManagedWidget ("lmainxosd", labelWidgetClass, xosdparams_paned,
                           PANED_FIX, NULL);      
 
 
  /* Xosd Main Font Type Menu */
  c_main_font_type = c = XtVaCreateManagedWidget ("Main Font Type", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) MAIN_FONT_TYPE);
  if (!font)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Type","bitstream vera sans mono");
  else
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Type",main_font);
  XtVaSetValues (c, XtNlabel, label, NULL);  

    
  /* Xosd Main Font Size Menu */
  c_main_font_size = c = XtVaCreateManagedWidget ("Main Font Size", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) MAIN_FONT_SIZE);
    if (!font)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Size","240");
  else
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Main Font Size",main_size);
  XtVaSetValues (c, XtNlabel, label, NULL);  

  
/* Test Main Xosd Action */
  c_test_main_xosd = c = XtVaCreateManagedWidget ("ltestmainxosd", commandWidgetClass, xosdparams_paned, PANED_FIX, NULL);
    XtAddCallback (c, XtNcallback, update_main_xosd_cb, (XtPointer) NULL);      
 
    
  /* Xosd Label */
  c_vtx = XtVaCreateManagedWidget ("lvtx", labelWidgetClass, xosdparams_paned,
                           PANED_FIX, NULL);        


  /* Xosd Teletext Font Type Menu */
  c_vtx_font_type = c = XtVaCreateManagedWidget ("Teletext Font Type", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) VTX_FONT_TYPE);
  if (!font_vtx)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Type","bitstream vera sans mono");
  else
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Type",vtx_font);
  XtVaSetValues (c, XtNlabel, label, NULL);    

    
  /* Xosd Teletext Font Size Menu */
  c_vtx_font_size = c = XtVaCreateManagedWidget ("Teletext Font Size", commandWidgetClass, xosdparams_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, xosdparams_menu_cb, (XtPointer) VTX_FONT_SIZE);
    if (!font_vtx)
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Size","180");
  else
    sprintf (label, "%-" LABEL_WIDTH3 "s: %s", "Teletext Font Size",vtx_size);
  XtVaSetValues (c, XtNlabel, label, NULL);   

   
/* Test Teletext Xosd Action */
  c_test_vtx_xosd = c = XtVaCreateManagedWidget ("ltestvtxxosd", commandWidgetClass, xosdparams_paned, PANED_FIX, NULL);
    XtAddCallback (c, XtNcallback, update_vtx_xosd_cb, (XtPointer) NULL);        

  
   
/* Open Main Options Menu */
  c_openmain = XtVaCreateManagedWidget ("lopenmain", commandWidgetClass, xosdparams_paned, PANED_FIX, NULL);
    XtAddCallback (c_openmain, XtNcallback, action_cb, (XtPointer) & call_options_6);  


/* Button to close Xosd Parameters GUI */
  c_xosdparamssave = c = XtVaCreateManagedWidget ("lxosdparamssave", commandWidgetClass, xosdparams_paned, PANED_FIX, NULL);
  XtAddCallback (c, XtNcallback, update_xosd_cb, (XtPointer) NULL);      
  XtAddCallback (c, XtNcallback, save_cb, (XtPointer) NULL);
  XtAddCallback (c, XtNcallback, close_xosdparamswin, (XtPointer) NULL);

#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(xosdparams_shell),
                          RootWindowOfScreen(XtScreen(xosdparams_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(xosdparams_shell, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_openmainoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_openmain, XtNbitmap, icon_pixmap, NULL);

  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_commonxosdoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_xosd, XtNbitmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_mainxosdoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_mainxosd, XtNbitmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_vtxxosdoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_vtx, XtNbitmap, icon_pixmap, NULL); 

/////////////////////////////////////////////////////////////////////////////////////////:
  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_updmainxosd_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_test_main_xosd, XtNbitmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_updvtxxosd_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_test_vtx_xosd, XtNbitmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(xosdparams_paned),
                          RootWindowOfScreen(XtScreen(xosdparams_paned)),
                          xosd_applysave_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_xosdparamssave, XtNbitmap, icon_pixmap, NULL);             
#endif  
#endif  
}
//#endif <= xosd inside now
