/*****************************************************************************
 * messenger.c: to make xaw popup message error
 *****************************************************************************
 * $Id: popup_ui.c,v 1.8 2004/09/18 22:21:11 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 *	Copyright (C) 1998/07/13 -- 1998/07/29 by Nobuyuki Maruichi
 *      From mwxcd 1.32
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>

#include "stringuty.h"
#include "config.h"

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS 
#include "../pixmaps/popup_infos.xpm"
#endif
#endif



#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif

Widget pErrorShell;
Widget errorMessage, errorArea, errorPopdown;
extern int debug;
extern Atom wm_protocols[2];

void popdownErrorShell(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget pErrorShell = (Widget)client_data;

	XtPopdown(pErrorShell);
}

void messengerSelected(Widget w, XtPointer client_data, XtPointer call_data)
{
	int result;
	int argcount;
	int argWidgetTop;
	int buttons;
	int currentCount;
	PointorsLink *linkBuffer;
	PointorsLink *currentLink = (PointorsLink*)client_data;
	Widget messengerPopup;
	Widget popupButton;
	XtCallbackProc callbackProc;

	linkBuffer = (PointorsLink*)terminalSearch(currentLink, prevPointersLink);
	currentCount = terminalCount(currentLink, prevPointersLink);
	argcount = VaGetValuesLink(linkBuffer,
				XtRInt,	&result, sizeof(result),
				XtRInt,	&argWidgetTop, sizeof(argWidgetTop),
				XtRInt,	&buttons, sizeof(buttons),
				XtRWidget, &messengerPopup, 0,
				XtRWidget, &popupButton, 0,
				XtRCallback, &callbackProc, 0,
				NULL);

	*((int*)linkBuffer->data_ptr) = result = currentCount - argWidgetTop;
	if(callbackProc != NULL)
		callbackProc((Widget)currentLink->data_ptr, linkBuffer, (XtPointer)result);
	if(popupButton != NULL) {
		XtSetSensitive(popupButton, True);
	}
	if(messengerPopup != NULL) {
		XtPopdown(messengerPopup);
		XtDestroyWidget(messengerPopup);
	}
	VaDestroyPointorsLink(linkBuffer);
}

void SetPopupPosition(Widget popupShell)
{
	Position x, y;
	/* Dimension width, height; */

	XtTranslateCoords(XtParent(popupShell),	/* Widget */
				(Position) 0,	/* x */
				(Position) 0,	/* y */
				&x, &y);	/* coords on root window */

	XtVaSetValues(popupShell, XtNx, x, XtNy, y, NULL);
}

PointorsLink *messengerPrintf(Widget parent, Widget popupButton,
				XtCallbackProc callbackProc, XtPointer client_data,
				const char **buttonMessages, const char *formattedString, ...)
{
	int argcount;
	int argWidgetTop;
	int result = 0;
	int buttons;
	int counter;
	PointorsLink *linkBuffer, *wLink_ptr;
	char messButtonName[40];
	char buffer[4096];
	Widget fromHoizWidget;
	Widget *messengerButtons;
	Widget messengerPopup, messengerForm, messengerLabel;
	va_list argument;

	va_start(argument, formattedString);

	vsprintf(buffer, formattedString, argument);

	buttons = arrayCount((XtPointer*)buttonMessages);
	if(buttons > 256) {
		fprintf(stderr, "%s:%d:multiMessagePrintf():"
				"To many buttons!! [%d]\n", __FILE__, __LINE__, buttons);
		exit(1);
	}
	messengerButtons = (Widget*)XtMalloc(sizeof(*messengerButtons) * buttons);
	messengerPopup = XtVaCreatePopupShell(
				"messengerPopup",
				transientShellWidgetClass,
				parent,
				NULL);

	messengerForm = XtVaCreateManagedWidget(
				"messengerForm",
				formWidgetClass,
				messengerPopup,
				NULL);

	messengerLabel = XtVaCreateManagedWidget(
				"messengerLabel",
				labelWidgetClass,
				messengerForm,
				XtNlabel, buffer,
				NULL);

	argcount = VaCreateValuesLink(&linkBuffer, 
				XtRInt,	&result, sizeof(result),
				XtRInt,	&argWidgetTop, sizeof(argWidgetTop),
				XtRInt,	&buttons, sizeof(buttons),
				XtRWidget, messengerPopup, 0,
				XtRWidget, popupButton, 0,
				XtRCallback, callbackProc, 0,
				NULL);

	*((int*)linkBuffer->nextLink->data_ptr) = argWidgetTop = argcount;

	for(counter = 0, fromHoizWidget = NULL;counter < buttons;
				fromHoizWidget = *(messengerButtons+counter), ++counter) {
		sprintf(messButtonName, "messengerButton%d", counter);
		*(messengerButtons+counter) =
				XtVaCreateManagedWidget(
						messButtonName,
						commandWidgetClass,
						messengerForm,
						XtNfromVert, messengerLabel,
						XtNlabel, *(buttonMessages + counter),
						NULL);
		if(fromHoizWidget != NULL) {
			XtVaSetValues(*(messengerButtons+counter), XtNfromHoriz, fromHoizWidget, NULL);
		}
		argcount += VaAddValuesLink(&linkBuffer, XtRWidget, *(messengerButtons+counter), 0, NULL);
	}
	wLink_ptr = (PointorsLink*)numSearch(linkBuffer, argWidgetTop, nextPointersLink);
	for(counter = 0;counter < buttons && wLink_ptr != NULL; ++counter, wLink_ptr = wLink_ptr->nextLink) {
		XtAddCallback(*(messengerButtons+counter), XtNcallback, messengerSelected, wLink_ptr);
	}
	SetPopupPosition(messengerPopup);
	XtRealizeWidget(messengerPopup);
	XtPopup(messengerPopup, XtGrabExclusive);
	va_end(argument);

	return(linkBuffer);
}

void ErrorPopUp(Widget pShell, Widget mess_w,
					Widget area, Widget popdown, const char *message_ptr)
{
	Widget parent_w;
	Position x = 0, y = 0;
	Dimension width, height;
	void XtMoveWidget(Widget , Position, Position);
	Dimension popupButtonWidth, errorAreaWidth;
	extern int debug;

	parent_w = XtParent(pShell);
	if(parent_w != NULL) {
		XtVaGetValues(parent_w, XtNwidth, &width, XtNheight, &height, NULL);
		XtTranslateCoords(parent_w, 		/* Widget */
				(Position) width/2, 	/* x */
				(Position) height/2,	/* y */
				&x, &y); 		/* coords on root window */
	}
	XtVaSetValues(pShell, XtNx, x, XtNy, y,NULL);
	XtVaSetValues(mess_w, XtNlabel, message_ptr, NULL);
	XtMoveWidget(pShell, x, y);
	XtPopup(pShell, XtGrabExclusive);
        XSetWMProtocols (XtDisplay (pShell), XtWindow (pShell), wm_protocols, 2);	
	XtVaGetValues(popdown, XtNwidth, &popupButtonWidth, NULL);
	XtVaGetValues(mess_w, XtNwidth, &errorAreaWidth, NULL);
	XtVaSetValues(mess_w, XtNinternalWidth, 4, NULL);
	XawFormDoLayout(area, False);
	XtVaSetValues(mess_w, XtNinternalWidth, 2, NULL);
	//XtVaSetValues(popdown, XtNhorizDistance, (errorAreaWidth - popupButtonWidth) / 2, NULL);
	XawFormDoLayout(area, True);
	if (debug)
	  {
		printf("errorAreaWidth = %d, popdownButtonWidth = %d, NewPos = %d",
				errorAreaWidth, popupButtonWidth,
				(errorAreaWidth - popupButtonWidth) / 2);
		XtVaGetValues(popdown, XtNx, &popupButtonWidth, NULL);
		printf(" -> %d\n", popupButtonWidth);
	  }
}

void PopupMessage(const char *message)
{
	ErrorPopUp(pErrorShell, errorMessage, errorArea, errorPopdown, message);
}

void popuperror_init(XtAppContext app_context, Widget topLevel)
{
	pErrorShell = XtCreatePopupShell(
			"pErrorShell",
			transientShellWidgetClass,
			topLevel,
			NULL,
			0
			);
	errorArea = XtVaCreateManagedWidget(
			"errorArea",
			/*panedWidgetClass,*/
			formWidgetClass,
			pErrorShell,
			NULL
			);
	errorMessage = XtVaCreateManagedWidget(
			"errorMessage",
			labelWidgetClass,
			errorArea,
			NULL
			);
	errorPopdown = XtVaCreateManagedWidget(
			"errorPopdown",
			commandWidgetClass,
			errorArea,
			NULL
			);
	XtAddCallback(errorPopdown, XtNcallback, popdownErrorShell, pErrorShell);
        XtInstallAllAccelerators (errorArea, pErrorShell);	
	if (debug)
	  fprintf(stderr,"popup message error initialised!\n");
	#ifdef HAVE_XPM
  		XpmCreatePixmapFromData(XtDisplay(pErrorShell),
                          RootWindowOfScreen(XtScreen(pErrorShell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(pErrorShell, XtNiconPixmap, icon_pixmap, NULL);
	#ifdef HAVE_PIXMAPS 
  		XpmCreatePixmapFromData(XtDisplay(pErrorShell),
                          RootWindowOfScreen(XtScreen(pErrorShell)),
                          popup_infos_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  		XtVaSetValues(errorPopdown, XtNbitmap, icon_pixmap, NULL);      
	#endif
	#endif
}

void
HidePopup2 (Widget widget, XEvent * event,
         String * params, Cardinal * num_params)
{
  XtPopdown(pErrorShell);
}
