/*****************************************************************************
 * main.c: main xdtv source
 *****************************************************************************
 * $Id: main.c,v 1.340 2004/12/05 23:14:14 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * This software was based on xawtv. Those portions are
 * Copyright (C) 1997 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <dirent.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/mman.h>

#include "config.h"

#define ALEVT_ENABLED 1

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xmd.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>

#include "writefile.h"
#include "mixer.h"
#include "channel.h"
#include "channels.h"
#include "strtab.h"
#include "grab.h"
#include "vop.h"
#include "aop.h"
#include "audio.h"
#include "x11.h"
#include "toolbox.h"
#include "wmhooks.h"
#include "lirc.h"
#include "file.h"
#include "cpu_accel.h"
#include "memcpy.h"
#include "deinterlace.h"
#include "divx.h"
#include "divx_ui.h"
#include "subtitles_ui.h"
#include "popup_ui.h"
#include "xscreensaver.h"
#include "xdtv.h"
#include "x11params_ui.h"
#include "blackborder.h"
#include "file_sel.h"
#include "plugin.h"
#include "plugin_ui.h"
#include "grab_ui.h"

#ifdef HAVE_XPM
# include <X11/xpm.h>
#endif

#ifdef HAVE_FFMPEG
# include <ffmpeg/avcodec.h>
#endif

#ifdef HAVE_XPM
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
#include "../pixmaps/main_mainactions.xpm"
#include "../pixmaps/main_channelsoptions.xpm"
#include "../pixmaps/main_openx11options.xpm"
#include "../pixmaps/main_openpluginoptions.xpm"
#include "../pixmaps/main_openmozaicchannels.xpm"
#include "../pixmaps/main_openchanneleditor.xpm"
#include "../pixmaps/main_applysave.xpm"
#include "../pixmaps/main_quit.xpm"
#endif
#endif

#ifdef HAVE_LIBXXF86DGA
# ifdef  HAVE_XFREE86_4            // In fact have XFree86 4.X.X
#  include <X11/Xproto.h>
#  define XF86DGA_MAJOR_VERSION XDGA_MAJOR_VERSION
#  define XF86DGA_MINOR_VERSION XDGA_MINOR_VERSION
# endif
# include <X11/extensions/xf86dga.h>
# include <X11/extensions/xf86dgastr.h>
#endif

#ifdef HAVE_LIBXXF86VM
# include <X11/extensions/xf86vmode.h>
# include <X11/extensions/xf86vmstr.h>
int vm_count;
XF86VidModeModeInfo **vm_modelines;
#endif

#ifdef HAVE_LIBXINERAMA
# include <X11/extensions/Xinerama.h>
XineramaScreenInfo *xinerama;
int nxinerama;
#endif

#ifdef HAVE_LIBXDPMS
# include <X11/extensions/dpms.h>
# ifndef  HAVE_XFREE86_4
// XFree 3.3.x has'nt prototypes for this ...
Bool DPMSQueryExtension (Display *, int *, int *);
Bool DPMSCapable (Display *);
Status DPMSInfo (Display *, CARD16 *, BOOL *);
Status DPMSEnable (Display *);
Status DPMSDisable (Display *);
# endif
#endif

#ifdef ALEVT_ENABLED
# include "alevt.h"
# include "alevtparams_ui.h"
extern int real_alevt_in_use;
extern void stop_subtitles();
extern void start_subtitles();
#endif

#ifdef HAVE_VIDEO_XV
int xvtv = 0;
int xvtv_overlay = -1;
extern char* xv_video_name;
int cmdline_xv_video_port = 0;
#endif

#ifdef HAVE_XV
int disable_xv = 0;
int cmdline_xv_img_port = 0;
#else
int disable_xv = 1;
#endif

#ifdef HAVE_BKTR
extern int bktr_mode, bktr_read;
#endif

//#ifdef USE_LIBXOSD <== xosd inside now
#include <xosd.h>
#include <xosdparams_ui.h>
static xosd *osd_main, *osd_vtx, *osd_bar;
char *font;
char *font_vtx;
char *colour;
char *outline_colour;
int outline_offset;
int shadow_offset;
int libxosd_ok = 1;
int libxosd = 0;
//#endif <== xosd inside now

int message_timer = 6000;
extern char lastfilename[256];

#ifdef HAVE_LIBJPEG
int jpegpcent = 75;
#endif

/*-------------------------------------------------------------------------*/

#define KEYPAD_TIME	    6000
#define ZAP_TIME            5000
#define CAP_TIME              20
#define SCAN_TIME            100
#define MUTE_TIME            100    //0.1 sec mute when switching channels
#define WIDTH_INC             64
#define HEIGHT_INC            48
#define VIDMODE_DELAY        100    // 0.1 sec
#define NB_SUBPAGENO          23
#define BRIGHT_RANGE         100
#define HUE_RANGE            100
#define CONTRAST_RANGE       100
#define COLOR_RANGE          100
#define VOLUME_RANGE         100

/*--- public variables ----------------------------------------------------*/

static int keypad_value = -1, doublekey = -1, doublekey_firstisone = -1;
static int subpageno = 0;

int res_mode = 0;
int noDGA = 0;
int alevt1st = 0;
int have_config = 0;
int pointer_on = 1, on_skip = 0;
int debug = 0;
int fs = 0;
int de = 1;
int fs_width, fs_height, fs_xoff, fs_yoff;
int pix_width= 128, pix_height = 96;
int bpp = 0;
int have_MMX = 0;
int memcpy_method = MEMCPY_PROBE;
int force_capture = -1;
int stay = 0;
int staytmp = 0;
int decoration = 1;
//int decoration = 1;
//int decorationtmp = 1;
int subactive = 0;
int zap_start, zap_fast;
int lirc;
int xfree_ext = 1;
int have_dga = 0;
int have_vm = 0;
int xawpopup = 1;
int oldswitch = 1;
int nodecoinit = 0;

char *res_modes[] = {"bright", "contrast", "color", "hue"};
char *video_base = NULL;
char alevtarg [256];
char alevtinit [256];
char *ppmfile;
char *jpegfile;
char *filepath = NULL;
char modename[64];
char *progname;

static void keypad_timeout(XtPointer client_data, XtIntervalId *id);

void set_volume (void);
void set_subtitles_pageno(char*);


Atom wm_protocols[2], xawtv_remote, xawtv_station, xa_deactivate;
XtWorkProcId idle_id = 0;
XtIntervalId title_timer, audio_timer, zap_timer, scan_timer, on_timer, keypad_timer;
static XtIntervalId xscreensaver_timer;
static int kdescreensaver_was_running=0;

XtAppContext app_context;
Widget app_shell        = NULL;
Widget tv               = NULL;
Widget opt_shell        = NULL;
Widget opt_paned        = NULL;
Widget chan_shell       = NULL;
Widget conf_shell       = NULL;
Widget on_shell         = NULL;
Widget on_label         = NULL;
Widget vtx_shell        = NULL;
Widget vtx_label        = NULL;
Widget c_norm           = NULL;
Widget c_input          = NULL;
Widget c_freq           = NULL;
Widget c_audio          = NULL;
Widget c_cap            = NULL;
Widget c_deinterlace    = NULL;
Widget c_stayontop      = NULL;
Widget c_decoration     = NULL;
Widget divx_shell       = NULL;
Widget divxaudio_shell  = NULL;
Widget streamparams_shell= NULL;
Widget c_record         = NULL;
Widget c_subpageno      = NULL;
Widget c_alevt          = NULL;
Widget c_zap            = NULL;
Widget c_graball        = NULL;
Widget c_simple_actions = NULL;
Widget c_main_actions   = NULL;
Widget c_channel_options= NULL;
Widget c_togglesub      = NULL;
Widget s_bright         = NULL;
Widget l_bright         = NULL;
Widget s_color          = NULL;
Widget l_color          = NULL;
Widget s_hue            = NULL;
Widget l_hue            = NULL;
Widget s_contrast       = NULL;
Widget l_contrast       = NULL;
Widget s_volume         = NULL;
Widget l_volume         = NULL;
Widget chan_viewport    = NULL;
Widget chan_box         = NULL;
Widget c_x11paramswin   = NULL;
Widget c_pluginwin      = NULL;
Widget c_chanwin        = NULL;
Widget c_editorwin      = NULL;
Widget c_applysave      = NULL;
Widget c_quit           = NULL;

//#ifdef USE_LIBXOSD <== xosd inside now
Widget c_xosdaction     = NULL;
//#endif <== xosd inside now

/*--- drivers -------------------------------------------------------------*/

extern char *avifilename;
extern int avibench,avinoaudioout,avi_audio_fragments,avi_audio_sizefragment;
extern Widget t_subpagenum;

/*--- channels ------------------------------------------------------------*/

struct STRTAB *cmenu = NULL;
char title[256];
char title2[256];
char channel_title[256] = {'\0'};

int cur_color;
int cur_bright;
int cur_hue;
int cur_contrast;
int cur_capture;
static enum deinterlace cur_deinterlace = DEINTERLACE_NONE;

int cur_mute = 0;
int cur_volume = 100;

/*--- actions -------------------------------------------------------------*/

/* conf.c */
extern void create_editorwin ();
extern void editor_station_switched ();
extern void editor_list_update ();
extern void save_cb (Widget widget, XtPointer clientdata, XtPointer call_data);

void CloseMainAction (Widget, XEvent *, String *, Cardinal *);
void ShowtimeAction (Widget, XEvent *, String *, Cardinal *);
//#ifdef USE_LIBXOSD <== xosd inside now
void XosdAction(Widget, XEvent *, String *, Cardinal *);
void XosdParamsAction(Widget, XEvent *, String *, Cardinal *);
void Show_bar(int ,int);
//#endif <== xosd inside now
void SetResAction (Widget, XEvent *, String *, Cardinal *);
void SetBgAction (Widget, XEvent *, String *, Cardinal *);
void SetFgAction (Widget, XEvent *, String *, Cardinal *);
void SetShadowAction (Widget, XEvent *, String *, Cardinal *);
void SetChannelAction (Widget, XEvent *, String *, Cardinal *);
void SetSourceAction (Widget, XEvent *, String *, Cardinal *);
void TuneAction (Widget, XEvent *, String *, Cardinal *);
void ScanAction (Widget, XEvent *, String *, Cardinal *);
void ChannelAction (Widget, XEvent *, String *, Cardinal *);
void VolumeAction (Widget, XEvent *, String *, Cardinal *);
void PointerAction (Widget, XEvent *, String *, Cardinal *);
void FullScreenAction (Widget, XEvent *, String *, Cardinal *);
void CallTitleAction (Widget, XEvent *, String *, Cardinal *);
void OptionsAction (Widget, XEvent *, String *, Cardinal *);
void ChannelsAction (Widget, XEvent *, String *, Cardinal *);
void EditorAction (Widget, XEvent *, String *, Cardinal *);
void RemoteAction (Widget, XEvent *, String *, Cardinal *);
void ZapAction (Widget, XEvent *, String *, Cardinal *);
void SubPageAction (Widget, XEvent *, String *, Cardinal *);
void PluginAction (Widget, XEvent *, String *, Cardinal *);
void GrabAction (Widget, XEvent *, String *, Cardinal *);
void SnapAction (Widget, XEvent *, String *, Cardinal *);
void AleVTAction (Widget, XEvent *, String *, Cardinal *);
void AleVTParamsAction (Widget, XEvent *, String *, Cardinal *);
void x11ParamsAction (Widget, XEvent *, String *, Cardinal *);
void StreamParamsAction (Widget, XEvent *, String *, Cardinal *);
void SetBlackborderAction (Widget , XEvent *, String *, Cardinal *);
void StayOnTopAction (Widget, XEvent *, String *, Cardinal *);
void DecorationAction (Widget, XEvent *, String *, Cardinal *);
void DeinterlaceAction (Widget, XEvent *, String *, Cardinal *);
void SubtitlesPagenoAction (Widget, XEvent *, String *, Cardinal *);
void UnSubtitlesPagenoAction (Widget, XEvent *, String *, Cardinal *);
void autoscroll (Widget, XEvent *, String *, Cardinal *);
void ToggleSubAction (Widget, XEvent *, String *, Cardinal *);
void RecordMovieAction (Widget, XEvent *, String *, Cardinal *);
void SaveAction (Widget, XEvent *, String *, Cardinal *);
void AOPAction (Widget, XEvent *, String *, Cardinal *);
void VOPAction (Widget, XEvent *, String *, Cardinal *);

XtActionsRec actionTable[] = {
  {"CloseMain", CloseMainAction},
  {"SetRes", SetResAction},
  {"SetBg", SetBgAction},
  {"SetFg", SetFgAction},
  {"SetShadow", SetShadowAction},
  {"SetChannel", SetChannelAction},
  {"Tune", TuneAction},
  {"Scan", ScanAction},
  {"Channel", ChannelAction},
  {"Pointer", PointerAction},
  {"FullScreen", FullScreenAction},
  {"CallTitle", CallTitleAction},  
  {"Options", OptionsAction},
  {"Channels", ChannelsAction},
  {"Editor", EditorAction},
  {"Remote", RemoteAction},
  {"Zap", ZapAction},
  {"SubPage", SubPageAction},
  {"Plugin", PluginAction},
  {"Grab", GrabAction},  
  {"Snap", SnapAction},
  {"Help", help_AC},
  {"Hide", HidePopup}, 
  {"Hide2", HidePopup2},   
  {"Hidefilesel", Hidefilesel},
  {"Showtime", ShowtimeAction},
//#ifdef USE_LIBXOSD <== xosd inside now
  {"Xosd",XosdAction},
  {"XosdParams",XosdParamsAction},  
//#endif <== xosd inside now
  {"Volume", VolumeAction},
  {"AleVT", AleVTAction},
  {"AleVTParams", AleVTParamsAction},
  {"x11Params", x11ParamsAction},
  {"StreamParams", StreamParamsAction},
  {"SetBlackborder", SetBlackborderAction},
  {"StayOnTop", StayOnTopAction},
  {"Decoration", DecorationAction},
  {"RecordMovie", RecordMovieAction},
  {"DivX", DivXAction},
  {"DivXAudio", DivXAudioAction},
  {"Deinterlace", DeinterlaceAction},
  {"SubtitlesPageno", SubtitlesPagenoAction},
  {"UnSubtitlesPageno", UnSubtitlesPagenoAction},
  {"autoscroll", autoscroll},
  {"ToggleSub", ToggleSubAction},
  {"Save", SaveAction},
  {"AOP", AOPAction},
  {"VOP", VOPAction}
};

static struct STRTAB stereo[] = {
  {0, "auto"},
  {1, "mono"},
  {2, "stereo"},
  {-1, NULL}
};

static struct STRTAB cap_list[] = {
  {CAPTURE_OFF, "off"},
  {CAPTURE_OVERLAY, "overlay"},
  {CAPTURE_GRABDISPLAY, "grabdisplay"},
  {-1, NULL}
};

struct STRTAB deinterlace_list[] = {
  {DEINTERLACE_NONE,     "None"},
#ifdef ARCH_X86
  {DEINTERLACE_BOB,      "Bob"},
  {DEINTERLACE_WEAVE,    "Weave"},
  {DEINTERLACE_GREEDY,   "Greedy"},
  {DEINTERLACE_ONEFIELD, "One Field"},
#endif
  {DEINTERLACE_LINEARBLEND, "Linear Blend"},
  {-1, NULL}
};

static struct STRTAB grab_list[] = {
  {0, "Grab a Window Image (ppm)"},
  {1, "Grab a Fullscreen Image (ppm)"},
#ifdef HAVE_LIBJPEG
  {2, "Grab a Window Image (jpeg)"},
  {3, "Grab a Fullscreen Image (jpeg)"},
  {4, "Grab Parameters"},  
#endif
  {-1, NULL}
};

struct STRTAB simple_actions_list[] = {
  {0, "Audio (un)mute                (A)"},
  {1, "Audio (un)mute + TVMUTE (Shift+A)"},  
  {2, "Show time                     (H)"},
  {3, "Mouse Pointer hidden/visible  (M)"},
  {4, "Fullscreen on/off             (F)"},
  {5, "Call Nxtvepg Title Infos     (F1)"}, 
  {-1, NULL}
};

struct STRTAB record_list[] = {
  {RECORD_START, "Record Start"},
  {RECORD_STOP,  "Record Stop"},
  {RECORD_PREVIEW,  "Preview Last Record"},  
  {RECORD_SCHEDULE,  "Schedule a Record"},    
  {RECORD_VIDEO_PARAM, "Video Parameters"},
  {RECORD_AUDIO_PARAM, "Audio Parameters"},
  {STREAM_SERVER_PARAM, "Streaming Parameters"},
  {-1, NULL}
};

struct STRTAB alevt_list[] = {
  {0,  "AleVT Start/Stop"},
  {1, "AleVT Parameters"},
  {-1, NULL}
};

//#ifdef USE_LIBXOSD <== xosd inside now
struct STRTAB xosd_list[] = {
  {0,  "Xosd Start/Stop"},
  {1, "Xosd Parameters"},
  {-1, NULL}
};
//#endif <== xosd inside now

struct STRTAB zap_list[] = {
  {0, "Slow Zapping"},
  {1, "Fast Zapping"},
  {-1, NULL}
};

struct STRTAB subpageno_list[] = {
  {0,  "all"},
  {1,  "888"},
  {2,  "777"},
  {3,  "150"},
  {4,  "149"},
  {5,  "151"},
  {6,  "160"},
  {7,  "161"},
  {8,  "690"},
  {9,  "778"},
  {10, "784"},
  {11, "884"},
  {12, "885"},
  {13, "886"},
  {14, "887"},
  {15, "889"},
  {16, "890"},
  {17, "891"},
  {18, "892"},
  {19, "893"},
  {20, "895"},
  {21, "897"},
  {22, "Other"},
  {-1, NULL}
};

char *cmd = NULL;

/*--- externs ------------------------------------------------------------*/
extern divx_t divx;
extern void setfps(double);
extern void init_socket(void);
extern void close_socket(void);
extern void do_command(char *);
extern int width_capture, height_capture;
extern int width_capture_max, height_capture_max;
extern int eventmap_checkfirstisone(void);
extern char *sendername;

/*--- EXIT functions----------------------------------------------------------------*/

Boolean
ExitWP (XtPointer client_data)
{
  /* exit if the application is idle,
   * i.e. all the DestroyCallback's are called.
   */
  exit (0);
}

void
ExitCB (Widget widget, XtPointer client_data, XtPointer calldata)
{

  if (is_divx_in_progress())
    divx_stop();

  aop_close();

  plugins_close();

#ifdef ALEVT_ENABLED
  if (real_alevt_in_use)
    stop_alevt();

  stop_subtitles();
#endif

  if (-1 != cur_sender)
    save_last_channel(cur_sender);

  mixer_close ();
  grabbers[grabber]->grab_close ();

  video_overlay (NULL);
  video_close ();

  if (fs)
    XtCallActionProc (widget, "FullScreen", NULL, NULL, 0);

//#ifdef USE_LIBXOSD <== xosd inside now
  xosd_destroy (osd_vtx);
  xosd_destroy (osd_main);
  xosd_destroy (osd_bar);   
  destroy_xosd_test();     
//#endif <== xosd inside now

  XtAppAddWorkProc (app_context, ExitWP, NULL);
  XtDestroyWidget (app_shell);
  close_socket();
}

/*--- Functions --------------------------------------------------*/

void sigpipe_handler(int sig) {
  fprintf(stderr, "received SIGPIPE\n");
}


void
sigint_handler(int sig)
{
  XKeyEvent kev;

  memset(&kev, 0, sizeof(XKeyEvent));
  kev.type = KeyPress;
  kev.send_event = True;
  kev.display = XtDisplay(tv);
  kev.window = XtWindow(tv);
  kev.keycode = XKeysymToKeycode(dpy, XK_Escape);
  printf("SIGINT received\n");

  XSendEvent(XtDisplay(tv), XtWindow(tv), True, 0, (XEvent *)&kev );
}

static void
lirc_input(XtPointer data, int *fd, XtInputId *iproc)
{
    if (debug)
	fprintf(stderr,"lirc_input triggered\n");
    if (-1 == lirc_tv_havedata()) {
	fprintf(stderr,"lirc: connection lost\n");
	XtRemoveInput(*iproc);
	close(*fd);
    }
}

/* ------------ screensaver management -----------------------------*/

static void
xscreensaver_timefunc(XtPointer clientData, XtIntervalId *id)
{
    static int first = 1;
    int status;
    char *err;

    if (debug)
	fprintf(stderr,"xscreensaver_timefunc\n");
    xscreensaver_timer = 0;
    if (first) {
	xscreensaver_init(dpy);
	first = 0;
    }
    status = xscreensaver_command(dpy,xa_deactivate,0,debug,&err);
    if (0 != status) {
	if (debug)
	    fprintf(stderr,"xscreensaver_command: %s\n",err);
	return;
    }
    xscreensaver_timer = XtAppAddTimeOut(app_context,30000, xscreensaver_timefunc,NULL);
}

static void
do_screensaver(int fs_state)
{
    static int timeout,interval,prefer_blanking,allow_exposures;

#ifdef HAVE_LIBXDPMS
    static BOOL dpms_on;
    CARD16 dpms_state;
    int dpms_dummy;
#endif

    if (fs_state) {
	/* fullscreen on -- disable screensaver */
	XGetScreenSaver(dpy,&timeout,&interval,
			&prefer_blanking,&allow_exposures);
	XSetScreenSaver(dpy,0,0,DefaultBlanking,DefaultExposures);
#ifdef HAVE_LIBXDPMS
	if ((DPMSQueryExtension(dpy, &dpms_dummy, &dpms_dummy)) &&
	    (DPMSCapable(dpy)))
	{
	  DPMSInfo(dpy, &dpms_state, &dpms_on);
          DPMSDisable(dpy);
	   if(debug) fprintf(stderr,"disable DPMS\n");
	}
#endif
	xscreensaver_timer = XtAppAddTimeOut(app_context,30000, xscreensaver_timefunc,NULL);
	   if(debug) fprintf(stderr,"disable screensaver\n");
	   
#ifndef __NetBSD__
	/* test kscreensaver: if true => disable kscreensaver */
        if (kdescreensaver_was_running)
           system("dcop kdesktop KScreensaverIface enable false &>/dev/null");  
#endif
	   
    } else {
	/* fullscreen off -- enable screensaver */
	XSetScreenSaver(dpy,timeout,interval,prefer_blanking,allow_exposures);
#ifdef HAVE_LIBXDPMS
	if ((DPMSQueryExtension(dpy, &dpms_dummy, &dpms_dummy)) &&
	    (DPMSCapable(dpy)) && (dpms_on))
	{
	  DPMSEnable(dpy);
	   if(debug) fprintf(stderr,"enable DPMS\n");
	}
#endif
	if (xscreensaver_timer)
	    XtRemoveTimeOut(xscreensaver_timer);
	   if(debug) fprintf(stderr,"enable screensaver\n");

#ifndef __NetBSD__
	/* test kscreensaver : if true => enable kscreensaver */
	if (kdescreensaver_was_running) 
           system("dcop kdesktop KScreensaverIface enable true &>/dev/null");
#endif
	   
    }
}

/* ------------ END screensaver management --------------------------*/

/* ------------- onscreen display OSD ------------------------------*/

//#ifdef USE_LIBXOSD <== xosd inside now
void
update_main_xosd()
{
  if (xosd_is_onscreen(osd_main))
    xosd_hide (osd_main);
  if (xosd_is_onscreen(osd_bar))    
  xosd_hide (osd_bar);
  
  osd_bar = xosd_create(2);     
  osd_main = xosd_create (1);
   if (!osd_main)
   {
      fprintf (stderr, "Error initializing osd: %s\n", xosd_error);
      libxosd_ok = 0;
      return;
   }

   if (xosd_set_font(osd_main, font))
       if (xosd_set_font(osd_main, osd_default_font))
       {
	  fprintf (stderr, "ABORT: %s\n", xosd_error);
	  libxosd_ok = 0;
	  return;
       }
   
   xosd_set_colour(osd_main, colour);
   if (shadow_offset)
     xosd_set_shadow_offset (osd_main, shadow_offset);

   xosd_set_outline_colour(osd_main,outline_colour);   
   if (outline_offset)
     xosd_set_outline_offset(osd_main,outline_offset);   
}

void
update_vtx_xosd()
{
  if (xosd_is_onscreen(osd_vtx))   
    xosd_hide (osd_vtx);
   
   osd_vtx = xosd_create (3);
   if (!osd_vtx)
   {
          fprintf (stderr, "Error initializing osd: %s\n", xosd_error);
	  libxosd_ok = 0;
	  return;
   }

   if (xosd_set_font(osd_vtx, font_vtx))
       if (xosd_set_font(osd_vtx, osd_default_font))
       {
	  fprintf (stderr, "ABORT: %s\n", xosd_error);
	  libxosd_ok = 0;
	  return;
       }

   xosd_set_colour(osd_vtx, colour);
   if (shadow_offset)
     xosd_set_shadow_offset (osd_vtx, shadow_offset);

     xosd_set_outline_colour(osd_vtx,outline_colour);       
   if (outline_offset)
     xosd_set_outline_offset(osd_vtx,outline_offset); 
}
//#endif <== xosd inside now

void
create_onscreen ()
{
  on_shell = XtVaCreateWidget ("onscreen", transientShellWidgetClass,
                               app_shell, XtNoverrideRedirect, True,
			       XtNvisual,vinfo->visual,
			       XtNcolormap,colormap,
			       XtNdepth,vinfo->depth, NULL);
  on_label = XtVaCreateManagedWidget ("label", labelWidgetClass, on_shell,
                                      NULL);
  vtx_shell = XtVaCreateWidget ("vtx", transientShellWidgetClass,
				app_shell, XtNoverrideRedirect, True,
				XtNvisual,vinfo->visual, XtNcolormap,colormap,
				XtNdepth,vinfo->depth, NULL);
  vtx_label = XtVaCreateManagedWidget ("label", labelWidgetClass, vtx_shell,
				       NULL);
}


static void xaw_xosd_init(void) {
  static int already_done=0;
  if(already_done) return;
  already_done=1;
  if (!font)
    font = strdup("-*-bitstream vera sans mono-*-*-*-*-*-240-*-*-*-*-*-*");
  if (!font_vtx)
    font_vtx = strdup("-*-bitstream vera sans mono-*-*-*-*-*-180-*-*-*-*-*-*");
  if (!colour)
    colour = strdup("lawngreen");
  if (!outline_colour)
    outline_colour = strdup("black");  
  update_main_xosd();
  update_vtx_xosd();
}




void
popdown_onscreen (XtPointer client_data, XtIntervalId * id)
{
  XtPopdown (on_shell);
  on_timer = 0;
  title[0] = 0;  
}

void
//#ifndef USE_LIBXOSD <== xosd inside now
//osd (int x_osd, int y_osd, char *osd_msg, int osd_time) <== xosd inside now
//#else <== xosd inside now
osd_xaw (int x_osd, int y_osd, char *osd_msg, int osd_time)
//#endif <== xosd inside now
{
  /* if x_osd and y_osd > 0, the put osd window at x_osd and y_osd from top
   * left main window corner.
   * if x_osd < 0, center horizontaly osd window.
   * if y_osd < 0, y origin is the bottom of the main window...
   */
  static int first = 1;
  Dimension x, y;
  Dimension w, h;
  Dimension w_osd, h_osd;
  int vtx;

  Widget shell,label;
    
  vtx = (osd_time<0);  // DIRTY !!!!, should be a parameter
  if(vtx) {
    shell = vtx_shell; label = vtx_label;
  } else {
    shell = on_shell; label = on_label;
  }
  
  if(vtx) write_sub(osd_msg);
  if(vtx && *osd_msg == '\0') {
    XtPopdown (shell);
    return;
  }
  
  if(app_shell)
  {
    XtVaGetValues (app_shell, XtNx, &x, XtNy, &y, NULL);
    XtVaGetValues (app_shell, XtNwidth, &w, XtNheight, &h, NULL);
  }
  
  if(label)
  {
    XtVaSetValues (label, XtNlabel, osd_msg, NULL);
    XtVaGetValues (label, XtNwidth, &w_osd, XtNheight, &h_osd, NULL);
  }

  if (x_osd > 0)
    x_osd += x;
  else
    x_osd = x + (w - w_osd)/2;

  if (y_osd > 0)
    y_osd += y;
  else
    y_osd = y + h - h_osd + y_osd;

  if(shell)
  {
    XtVaSetValues (shell, XtNx, x_osd, XtNy, y_osd, NULL);
    XtPopup (shell, XtGrabNone);
  }

  if (vtx) return;

  if (on_timer)
    XtRemoveTimeOut (on_timer);

  if (osd_time > 0)
    on_timer = XtAppAddTimeOut
      (app_context, osd_time, popdown_onscreen, NULL);
       
  if (first && on_shell && on_label)
    {
      first = 0;
      XDefineCursor (dpy, XtWindow (on_shell), no_ptr);
      XDefineCursor (dpy, XtWindow (on_label), no_ptr);
    }
}

//#ifdef USE_LIBXOSD <== xosd inside now
void osd_xosd(int x_osd, int y_osd, char *osd_msg, int osd_time, int vtx)
{
  xosd *osd;
  Dimension x, y;
  Dimension w, h;

  XtVaGetValues (app_shell, XtNx, &x, XtNy, &y,
                XtNwidth, &w, XtNheight, &h, NULL);

  if (vtx)
    osd=osd_vtx;
  else
    osd=osd_main;

  if (x_osd > 0)
  {
    x_osd += x;
    xosd_set_align(osd, XOSD_left);
  }
  else
  {
    x_osd = x + w/2 - swidth/2;
    xosd_set_align(osd, XOSD_center);
  }

  if (y_osd > 0)
  {
    y_osd += y;
    xosd_set_pos(osd, XOSD_top);
  }
  else
  {
    y_osd = -(y + h - sheight + y_osd );
    xosd_set_pos(osd, XOSD_bottom);
  }

  if(vtx) write_sub(osd_msg);
  if(vtx && *osd_msg == '\0' && xosd_is_onscreen(osd)) {
    xosd_hide(osd);
    xosd_display (osd, 0, XOSD_string,"");
    xosd_display (osd, 1, XOSD_string,"");
    xosd_display (osd, 2, XOSD_string,"");
    return;
  }

 xosd_set_vertical_offset(osd, y_osd);
 xosd_set_horizontal_offset(osd, x_osd);
 if (!vtx)
 {
   xosd_set_timeout(osd, osd_time/1000);
   xosd_display (osd, 0, XOSD_string, osd_msg);
 }
 else
 {
   xosd_display (osd, 0, XOSD_string, strtok(osd_msg,"\n"));
   xosd_display (osd, 1, XOSD_string, strtok(NULL,"\n"));
   xosd_display (osd, 2, XOSD_string, strtok(NULL,"\n"));
 }
}

void osd(int x_osd, int y_osd, char *osd_msg, int osd_time)
{
  if (libxosd && libxosd_ok)
    osd_xosd(x_osd, y_osd, osd_msg, osd_time, osd_time<0);
  else
    osd_xaw(x_osd, y_osd, osd_msg, osd_time);
}
//#endif <== xosd inside now

void
display_onscreen ()
{
  if (on_skip)
    {
      on_skip = 0;
      return;
    }
  if (!fs && de)
    return;
  
  osd(30, 20, title, message_timer);

}

//#ifdef USE_LIBXOSD <== xosd inside now
void
Show_bar(int type,int percent)
{

Dimension x, y;
Dimension w, h;
char value[20];

  XtVaGetValues (app_shell, XtNx, &x, XtNy, &y,
                XtNwidth, &w, XtNheight, &h, NULL);
	
  switch(type)
  {
    case 1 :
      sprintf (value, "Volume: %d%%", cur_volume);
      break;
    case 2 :
      sprintf (value, "Bright: %d%%", cur_bright*100/65535);
      break;
    case 3 :
      sprintf (value, "Color: %d%%", cur_color*100/65535);	
      break;
    case 4 :
      sprintf (value, "Hue: %d%%", cur_hue*100/65535);
      break;
    case 5 :
      sprintf (value, "Contrast: %d%%", cur_contrast*100/65535);
    break;
  }
  if (debug)
    fprintf(stderr,"x:%d |    y:%d |    w:%d|    h:%d|    screen_height:%d| screen_width:%d\n",x,y,w,h,sheight,swidth);
  
  // Hayvan.... 
  //if (xosd_is_onscreen(osd_bar) && cur_capture == CAPTURE_OVERLAY)
  //  xosd_hide(osd_bar); or xosd_scroll(osd_bar,2);
 
  xosd_set_font (osd_bar, font);
  
  if (shadow_offset)
    xosd_set_shadow_offset (osd_bar, shadow_offset);
    
  xosd_set_colour (osd_bar, colour);    
  if (outline_offset)
    xosd_set_outline_offset(osd_bar,outline_offset);  
    
  xosd_set_outline_colour(osd_bar,outline_colour);
  xosd_set_pos (osd_bar, XOSD_bottom);
  xosd_set_vertical_offset (osd_bar, -y - h + sheight);
  xosd_set_align (osd_bar, XOSD_center);
  xosd_set_horizontal_offset (osd_bar,x + w/2 - swidth/2);
  
  xosd_set_timeout(osd_bar, message_timer/1000); 
  xosd_set_bar_length(osd_bar, w/20);
  
  xosd_display (osd_bar, 0,XOSD_string,value);
  if (percent >=0 && percent <=100)  
    xosd_display (osd_bar, 1, XOSD_percentage, percent);
}
//#endif <== xosd inside now

/* ------------- END onscreen display OSD ---------------------------*/

// -------------- TV Function ---------------------------------------*/

static Boolean
idle_grabdisplay (XtPointer data)
{
  static long count, lastsec;
  struct timeval tv;
  struct timezone tz;

  plugin_idle_actions();
  if(!idle_id) {
    /* should never happen, but happens
       perhaps when XtRemoveWorkProc is called at a bad moment ? */
    if(debug>1)
      fprintf(stderr, "idle_grabdisplay should not be called here\n");
    return TRUE;
  }
  if (debug)
    {
      gettimeofday (&tv, &tz);
      if (tv.tv_sec != lastsec)
        {
          if (lastsec == tv.tv_sec - 1)
            {
              printf ("fps:%ld\n", count);
              fflush(stderr);
            }
          lastsec = tv.tv_sec;
          count = 0;
        }
      count++;
    }

  if (-1 == video_displayframe())
    {
      if(debug) fprintf(stderr, "video_displayframe failed\n");
      usleep (300000);
    }
  return FALSE;
}

void
set_title ()
{

  //tvtuner[cur_channel].name = chrrent channel number
  //channels[cur_sender]->name = current channel name
  //grabbers[grabber]->norms[cur_norm].str = current norm used
  //cur_fine = channel fine tune
  //int_to_str(cur_deinterlace, deinterlace_list) = current filter used
  
  title[0] = 0;
  
  if (-1 != cur_sender)
    {
      if (channels[cur_sender]->fine == 0)
        {
          if (cur_deinterlace == DEINTERLACE_NONE)
            sprintf (title, "%s", channels[cur_sender]->name);
          else 
	    sprintf (title, "%s (%s)", channels[cur_sender]->name, int_to_str(cur_deinterlace, deinterlace_list));
        }
      else
        {
	  if (cur_deinterlace == DEINTERLACE_NONE)
            sprintf (title, "%s (%d)", channels[cur_sender]->name, cur_fine);
	  else
            sprintf (title, "%s (%d) (%s)", channels[cur_sender]->name, cur_fine, int_to_str(cur_deinterlace, deinterlace_list));
        }
    }
  else
    sprintf (title, "?? (channel:%s fine:%d)", tvtuner[cur_channel].name, cur_fine);

    
  if (is_divx_in_progress())
    sprintf(title, "%s Recording", title);

  XtVaSetValues (app_shell, XtNtitle, title, NULL);
  display_onscreen ();

  if (title_timer)
    {
      XtRemoveTimeOut (title_timer);
      title_timer = 0;
      title[0] = 0;
    }
}

void
set_property (int freq, char *channel, char *name)
{
  int len;
  char line[80];

  len = sprintf (line, "%.3f", (float) freq / 16) + 1;
  len += sprintf (line + len, "%s", channel) + 1;
  if (NULL != name)
    len += sprintf (line + len, "%s", name) + 1;
  XChangeProperty (dpy, XtWindow (app_shell),
                   xawtv_station, XA_STRING, 8, PropModeReplace, line, len);
}

void
set_title_timeout (XtPointer client_data, XtIntervalId * id)
{
  on_skip = 1;
  set_title ();
}

void
set_timer_title ()
{
  XtVaSetValues (app_shell, XtNtitle, title, NULL);
  
  //#ifdef USE_LIBXOSD <== xosd inside now
  if (libxosd && libxosd_ok)
  {  
    if (xosd_is_onscreen(osd_main))    
      xosd_hide(osd_main);
    if (xosd_is_onscreen(osd_bar))      
      xosd_hide(osd_bar);
  }
  //#endif <== xosd inside now
  
  display_onscreen ();
  if (title_timer)
    XtRemoveTimeOut (title_timer);
  title_timer = XtAppAddTimeOut
    (app_context, message_timer, set_title_timeout, NULL);
  title[0] = 0;
}


void
change_audio (int mode)
{
  title[0] = 0;
  if (grabbers[grabber]->grab_audio)
    grabbers[grabber]->grab_audio (-1, -1, &mode);
    //grabbers[grabber]->grab_audio (-1, -1, &mode); // double init needed for some of Nicam TV Cards: don't work!
    sprintf (title, "%-" LABEL_WIDTH "s : %s", "Audio", stereo[mode].str);
  if (c_audio)
    XtVaSetValues (c_audio, XtNlabel, title, NULL);
  set_title ();
  sprintf (title + strlen (title), " (%s)", stereo[mode].str);
  XtVaSetValues (app_shell, XtNtitle, title, NULL);
}


void
watch_audio (XtPointer data, XtIntervalId * id)
{
  on_skip = 1;
  change_audio (0);
  audio_timer = 0;
}

void
set_norm (int j)
{
  title[0] = 0;
  sprintf (title, "%-" LABEL_WIDTH "s : %s", "TV Norm",
           grabbers[grabber]->norms[j].str);
  if (c_norm)
    XtVaSetValues (c_norm, XtNlabel, title, NULL);
    
  sprintf (title,"TV Norm: %s", grabbers[grabber]->norms[j].str);    
    
  cur_norm = j;
  grabbers[grabber]->grab_input (-1, cur_norm);
  if(grabbers[grabber]->is525(cur_norm)) {
    cur_maxwidth = 640;
    cur_maxheight = 480;
    cur_maxfpsnum = 30000;
    cur_maxfpsden = 1001;
  } else {
    cur_maxwidth = 768;
    cur_maxheight = 576;
    cur_maxfpsnum = 25;
    cur_maxfpsden = 1;
  }
  cur_secam = grabbers[grabber]->issecam(cur_norm);
  video_new_size ();
}

void
set_source (int j)
{
  title[0] = 0;
  sprintf (title, "%-" LABEL_WIDTH "s : %s", "Video Source",
           grabbers[grabber]->inputs[j].str);
  if (c_input)
    XtVaSetValues (c_input, XtNlabel, title, NULL);

  sprintf (title,"Video Source: %s", grabbers[grabber]->inputs[j].str);        
  cur_input = j;
  grabbers[grabber]->grab_input (cur_input, -1);
}

void
set_freqtab (int j)
{
  title[0] = 0;
  sprintf (title, "%-" LABEL_WIDTH "s : %s", "Frequency table",
           chan_names[j].str);
  if (c_freq)
    XtVaSetValues (c_freq, XtNlabel, title, NULL);

  sprintf (title,"Frequency table: %s", chan_names[j].str);
     
  chan_tab = j;
}

/* not null when GRABDISPLAY is necessary */
static int cur_mask_capture=0;

static void
set_capture (int capture, int save)
{
  char *fmt = NULL;
  title[0] = 0;
  title2[0] = 0;

  if (cur_capture == capture)
    {
      if (cur_capture == CAPTURE_GRABDISPLAY && !idle_id)
        idle_id = XtAppAddWorkProc (app_context, idle_grabdisplay, NULL);
      return;
    }
  if(capture!=CAPTURE_GRABDISPLAY && cur_mask_capture) {
    sprintf (title,"Capture: grabdisplay (locked)"); 
    return;
  }

  if (debug) {
    fprintf(stderr,"currrent capture = %d\n",cur_capture);
    fprintf(stderr,"currrent sender = %d\n",cur_sender);
  }
    
  /* first turn off... */
  switch (cur_capture)
    {
    case CAPTURE_GRABDISPLAY:
      if (idle_id)
        XtRemoveWorkProc (idle_id);
      idle_id = 0;
      XClearArea (XtDisplay (tv), XtWindow (tv), 0, 0, 0, 0, True);
      break;

    case CAPTURE_OVERLAY:
      video_overlay (NULL);
      break;
    }

  cur_capture = capture;

  /* ... then turn on */
  switch (cur_capture)
    {
    case CAPTURE_OFF:
      plugin_idle_actions();
      fmt = "Off";
      break;

    case CAPTURE_GRABDISPLAY:
      idle_id = XtAppAddWorkProc (app_context, idle_grabdisplay, NULL);
      fmt = "Grabdisplay";
      break;

    case CAPTURE_OVERLAY:
      plugin_idle_actions();
      video_overlay (grabbers[grabber]->grab_overlay);
      fmt = "Overlay";
      break;
    }

  video_new_size();

  if (cur_sender != -1 && save)
    channels[cur_sender]->capture = cur_capture;

  if (c_cap) {
    sprintf (title, "%-" LABEL_WIDTH "s : %s", "Capture", fmt);
    XtVaSetValues (c_cap, XtNlabel, title, NULL);
  }
    
  sprintf (title,"Capture: %s",fmt);  
}

/* used by divx or vop */
void set_capture_temp_grab(int grab, int mask) {
  if(grab) {
    set_capture(CAPTURE_GRABDISPLAY,0);
    cur_mask_capture |= mask;
  } else {
    cur_mask_capture &= ~mask;
    if(cur_sender != -1 && !cur_mask_capture)
      set_capture(channels[cur_sender]->capture,0);
  }
  if (c_cap)
    XtVaSetValues(c_cap, XtNsensitive, cur_mask_capture ? False : True, NULL);
}

/* the RightWay[tm] to set float resources (copyed from Xaw specs) */
void
set_float (Widget widget, char *name, float value)
{
  Arg args[1];

  if (sizeof (float) > sizeof (XtArgVal))
    {
      /*
       * If a float is larger than an XtArgVal then pass this
       * resource value by reference.
       */
      XtSetArg (args[0], name, &value);
    }
  else
    {
      /*
       * Convince C not to perform an automatic conversion, which
       * would truncate 0.5 to 0.
       */
      XtArgVal *l_top = (XtArgVal *) & value;
      XtSetArg (args[0], name, *l_top);
    }
  XtSetValues (widget, args, 1);
}

void
set_picparams (int color, int bright, int hue, int contrast)
{
  char label [64];

  if (color != -1)
    {
      cur_color = color;
      if (s_color)
      {
        set_float (s_color, XtNtopOfThumb, (float) cur_color / 65536);
	if (debug)
	  fprintf (stderr, "color: %5d\n", cur_color);
	sprintf (label, "%-" LABEL_WIDTH2 "s:%3d%%", "Color", cur_color*100/65536);
        XtVaSetValues (l_color, XtNlabel, label, NULL);
      }
      if (cur_sender != -1)
        channels[cur_sender]->color = cur_color;
    }
  if (bright != -1)
    {
      cur_bright = bright;
      if (s_bright)
      {
        set_float (s_bright, XtNtopOfThumb, (float) cur_bright / 65536);
	if (debug)
	  fprintf (stderr, "bright: %3d\n", cur_bright);
	sprintf (label, "%-" LABEL_WIDTH2 "s:%3d%%", "Bright", cur_bright*100/65536);
        XtVaSetValues (l_bright, XtNlabel, label, NULL);
      }
      if (cur_sender != -1)
        channels[cur_sender]->bright = cur_bright;
    }
  if (hue != -1)
    {
      cur_hue = hue;
      if (s_hue)
      {
        set_float (s_hue, XtNtopOfThumb, (float) cur_hue / 65536);
	if (debug)
	  fprintf (stderr, "hue: %3d\n", cur_hue);
	sprintf (label, "%-" LABEL_WIDTH2 "s:%3d%%", "Hue", cur_hue*100/65536);
        XtVaSetValues (l_hue, XtNlabel, label, NULL);
      }
      if (cur_sender != -1)
        channels[cur_sender]->hue = cur_hue;
    }
  if (contrast != -1)
    {
      cur_contrast = contrast;
      if (s_contrast)
      {
        set_float (s_contrast, XtNtopOfThumb, (float) cur_contrast / 65536);
	if (debug)
	  fprintf (stderr, "contrast: %3d\n", cur_contrast);
	sprintf (label, "%-" LABEL_WIDTH2 "s:%3d%%", "Contrast", cur_contrast*100/65536);
        XtVaSetValues (l_contrast, XtNlabel, label, NULL);
      }
      if (cur_sender != -1)
        channels[cur_sender]->contrast = cur_contrast;
    }
  grabbers[grabber]->grab_picture (cur_color, cur_bright, cur_hue,
                                   cur_contrast);
}

void
set_deinterlace(int j)
{
  int len;
  int i;

  title[0] = 0;
  cur_deinterlace = j;
  if (cur_sender != -1)
    channels[cur_sender]->deinterlace = cur_deinterlace;
    
  set_deinterlace_vop(cur_deinterlace);
  sprintf (title, "%-" LABEL_WIDTH "s : %s", "Deinterlace",
           int_to_str(j, deinterlace_list));

  len = strlen(title);

  for (i=len; i<=38-6; i++) // 6 = strlen("CTRL+D")
    title[i] = ' ';
  title[i] = 0;
  strcat(title, "Ctrl+D");

  if (c_deinterlace)
    XtVaSetValues (c_deinterlace, XtNlabel, title, NULL);

  title[len] = 0;
  
  sprintf (title, "Deinterlace: %s", int_to_str(j, deinterlace_list));
    
}

int
set_stayontop(int j)
{
  static int top = 0;
  title[0] = 0;
  
  if (!wm_stay_on_top)
    return 0;

  if (j == -1)
    top = 1 - top;
  else
    top = j;

  stay = top;

  if(top)
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Stay on Top      :     (Yes)          T");
    if (c_stayontop)
    XtVaSetValues (c_stayontop, XtNlabel, title, NULL);
    sprintf (title,"Stay on Top: Yes");
  }
  else
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Stay on Top      :      (No)          T");
        if (c_stayontop)
    XtVaSetValues (c_stayontop, XtNlabel, title, NULL);
    sprintf (title,"Stay on Top: No"); 
  }

  // if Yes/No, just transmit top value
  // if OnBottom/Normal/OnTop, transmit (top-1)
  wm_stay_on_top(dpy, XtWindow(app_shell), top);

//#ifdef USE_LIBXOSD <== xosd inside now
  if (xosd_is_onscreen(osd_main))      
    xosd_hide(osd_main);
  if (xosd_is_onscreen(osd_vtx))          
	  xosd_hide(osd_vtx);
//#endif <== xosd inside now
  return 1;
}

int
set_decoration(int j)
{
  title[0] = 0;

  //if (!wm_decoration)
  //  return 0;  
  
  if (j == -1)
    decoration = 1 - decoration;
  else
    decoration = j;

  wm_decoration(app_shell, decoration);

  if(decoration)
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Window Decoration:     (Yes)          B");
    if (c_decoration)
    XtVaSetValues (c_decoration, XtNlabel, title, NULL);
    sprintf (title,"Decoration: On");
  }
  else
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Window Decoration:      (No)          B");
    if (c_decoration)
    XtVaSetValues (c_decoration, XtNlabel, title, NULL);
    sprintf (title,"Decoration: Off");       
  }

  de = decoration ;
  return 1;
}

int
set_subpage(char *name)
{
  // on active la page slectionne puis on met a jour les GUI et l'OSD
  cur_subpage=name;
  if(subactive) set_subtitles_pageno(name);
  if(str_to_int_noatoi(name,subpageno_list)!=-1)
    sprintf (title,"%-" LABEL_WIDTH "s : %s       Alt/Ctrl+P", "Subtitles Page",name);
  else
    sprintf (title,"%-" LABEL_WIDTH "s : Other=%s Alt/Ctrl+P", "Subtitles Page",name);
  if (c_subpageno)
    XtVaSetValues (c_subpageno, XtNlabel, title, NULL);
  sprintf (title,"Subtitles Page: %s",name);
  
  if (cur_sender != -1)
    channels[cur_sender]->subpage = name;  
  return 1;
}

int
set_subpageno(int j)
{
  char *subpageno_str;
  title[0] = 0;

  // traitement des "je droule les pages dans un sens ou dans l'autre"
  // "Other" is forbidden here....
  if (j == -1)
      subpageno = (subpageno+1)%(NB_SUBPAGENO-1);
  else if (j == -2)
  {
      if(subpageno == 0) subpageno = NB_SUBPAGENO-2;
      else subpageno = (subpageno-1)%(NB_SUBPAGENO-1);
  }

  // permet de sparer les pages "perso" des pages proposes par dfaut
  subpageno_str = int_to_str(subpageno, subpageno_list);
  if(subpageno_str == NULL) return 0;

  // cette ligne permet de faire le browsing des pages proposes par dfaut
  cur_subpage = subpageno_str;
  set_subpage (cur_subpage);  
  return 1;
}

int set_subactive(int j) 
{
  int subactive_prec = subactive;
  title[0] = 0;
  if(j == -1) subactive = !subactive;
  else subactive = j;
  
  if(subactive != subactive_prec) {
    if(subactive)
      set_subtitles_pageno(cur_subpage);
    else
      set_subtitles_pageno(NULL);
  }
  
  if(subactive)
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Subtitles        :      (On)          P");
    if (c_togglesub)
    XtVaSetValues (c_togglesub, XtNlabel, title, NULL);
    sprintf (title,"Subtitles: On");
  }
  else
  {
    sprintf (title,"%-" LABEL_WIDTH "s","Subtitles        :     (Off)          P");
        if (c_togglesub)
    XtVaSetValues (c_togglesub, XtNlabel, title, NULL);
    sprintf (title,"Subtitles: Off");    
  }
  
  return 1;
}

void
record_movie(int j)
{
  char *fmt = NULL;
  Dimension w,h;
  int record, prev_record;
  pthread_t thread, thread2;
  
  title[0] = 0;

  record = is_divx_in_progress() ? RECORD_START : RECORD_STOP;
  prev_record = record;

  if (j == -1)
    {
      /* j = -1 means toggle state, but between RECORD_START
       * and RECORD_STOP only
       */
      record = record==RECORD_START ? RECORD_STOP : RECORD_START;
    }
  else
    {
      /* If record is in progress, do not allow to
       * raise RECORD_VIDEO_PARAM, RECORD_AUDIO_PARAM
       * PREVIEW can be done during a record
       */
      if (record == RECORD_START && (j == RECORD_VIDEO_PARAM || j == RECORD_AUDIO_PARAM))
      {
	PopupMessage("The Video & Audio Recorder Options Windows\ncan't be reached during a record\nNo preview possible\n");
        return;
      }
      else
        record = j;
    }

  if (record == prev_record)
    return;

  switch(record)
    {
    case RECORD_START:
      XtVaGetValues (tv, XtNwidth, &w, XtNheight, &h, NULL);
      divx_init(w, h);
      if (c_record)
        XtVaSetValues (c_record, XtNlabel, "Record Movie     :      (On)          R", NULL);
      fmt = "On";
      break;

    case RECORD_STOP:
      divx_stop();
      if (c_record)
        XtVaSetValues (c_record, XtNlabel, "Record Movie     :     (Off)          R", NULL);
      fmt = "Off";
      break;

    case RECORD_PREVIEW:
      fmt = "Preview Last Record";
      if (lastfilename[0] != 0)
        pthread_create (&thread, NULL, (void *(*)(void *)) system, lastfilename);
      else
        PopupMessage("Launch a record before trying to preview it\n");
      break;
      
    case RECORD_SCHEDULE:
      fmt = "Schedule a Record";
      pthread_create (&thread2, NULL, (void *(*)(void *)) system, "xterm -geometry 80x35+0+0 -title 'Schedule a Record: (Need AT & CRON)' -e sh xdtv_record.sh");
      break;      
      
    case RECORD_VIDEO_PARAM:
      record = prev_record;
      fmt = "Video Options";
      DivXAction(NULL, NULL, NULL, NULL);
      break;

    case RECORD_AUDIO_PARAM:
      record = prev_record-1;
      fmt = "Audio Options";      
      DivXAudioAction(NULL, NULL, NULL, NULL);
      break;

    case STREAM_SERVER_PARAM:
      record = prev_record-1;
      fmt = "Stream Options";
      StreamParamsAction(NULL, NULL, NULL, NULL);
      break;

    }
       
  if (is_divx_in_progress())
    sprintf (title, "<<  Streaming Server Started..  >>");
  else
    sprintf (title, "<<  Streaming Server Stopped!!  >>");
      
  if (c_streaming && divx.stream)
    XtVaSetValues (c_streaming, XtNlabel, title, NULL);

  sprintf (title, "Record Movie: %s",fmt);
  set_timer_title ();    
}

void
select_alevt(int j)
{
#ifdef ALEVT_ENABLED

  title[0] = 0;  

  if (device.vbi == NULL)
  {
    PopupMessage("AleVT can't be use when the vbi device is not activated\n");
    return;
  }
  
  if (j == -1)
    /* for xdtv_command teletext */
    j = 0;

  // fabrication des arguments AleVT en provenance de la GUI

  if (alevt1st == 0)
  {
    strcpy (alevtarg,"");

    if (alevt_error_reduction != 0)
      strcat (alevtarg,"-noerc ");

    if (alevt_error_bell != 0)
      strcat (alevtarg,"-nobell ");

    switch(alevt_charset)
      {
      case 0:
	break;
      case 1:
        strcat (alevtarg,"-charset latin-2 ");
	break;
      case 2:
        strcat (alevtarg,"-charset koi8-r ");
	break;
      case 3:
        strcat (alevtarg,"-charset iso8859-7 ");
	break;
      }

    switch(alevt_finetune_mode)
    {
    case 0:
      break;
    case 1:
      strcat (alevtarg,"-finetune auto ");
      break;
    case 2:
        strcat (alevtarg,"-finetune ");
        strcat (alevtarg,alevt_finetune_str);
        strcat (alevtarg," ");
      break;
    }
    strcat (alevtarg,alevt_defaultpage_str);
  }

  switch(j)
    {
    case 0:
  	if (real_alevt_in_use == 1)
	{
	  if (c_alevt)
	    XtVaSetValues (c_alevt, XtNlabel, "Teletext (AleVT) :     (Off)     Ctrl+A", NULL);
	  sprintf (title, "Teletext: Off"); 
	  stop_alevt();
	}
  	else
  	{
	  if (c_alevt)
	    XtVaSetValues (c_alevt, XtNlabel, "Teletext (AleVT) :      (On)     Ctrl+A", NULL);
	  sprintf (title, "Teletext: On");  
    	  strcpy (alevtinit, "alevt ");
    	  strcat (alevtinit,alevtarg);
    	  start_alevt(alevtinit);
  	}
	break;
    case 1:
        if (real_alevt_in_use == 1 && c_alevt)
          XtVaSetValues (c_alevt, XtNlabel, "Teletext (AleVT) :      (On)     Ctrl+A", NULL);
        AleVTParamsAction(NULL, NULL, NULL, NULL);
	break;
    }

  fprintf(stderr,"alevt full command: %s\n",alevtinit);
  set_timer_title ();     
    
#endif
}


//#ifdef USE_LIBXOSD <== xosd inside now
void
select_xosd(int j)
{
  title[0] = 0;   
 
    /* for xdtv_command */    
    if (j == -1)
      j = 0;
  
  switch(j)
    {
    case 0:
        libxosd=!libxosd;  
	if(libxosd) xaw_xosd_init();
  	if (libxosd && libxosd_ok)
	{
          sprintf (title,"%-" LABEL_WIDTH "s","Xosd             :      (On)     Ctrl+X");
          if (c_xosdaction)
            XtVaSetValues (c_xosdaction, XtNlabel, title, NULL);
          sprintf (title,"Xosd: On");
	}
  	else
  	{
          sprintf (title,"%-" LABEL_WIDTH "s","Xosd             :     (Off)     Ctrl+X");
          if (c_xosdaction)
            XtVaSetValues (c_xosdaction, XtNlabel, title, NULL);
          sprintf (title,"Xosd: Off");
  	}
        if (xosd_is_onscreen(osd_main))
          xosd_hide(osd_main);
        if (xosd_is_onscreen(osd_vtx))
          xosd_hide(osd_vtx);
        if (xosd_is_onscreen(osd_bar))
          xosd_hide(osd_bar);
        XtPopdown (on_shell);
        XtPopdown (vtx_shell);   
	break;
    case 1:
        sprintf (title,"Xosd: Options");    
        XosdParamsAction(NULL, NULL, NULL, NULL);
	break;
    }  
}
//#endif <== xosd inside now

void
pixit (void)
{
  Pixmap pix;
  char *data;

  if (0 == pix_width || 0 == pix_height)
    return;

  if (cur_sender != -1)
    {
      strcpy (title, channels[cur_sender]->name);

      data = get_image (x11_native_format, pix_width, pix_height);
      if (data != NULL)
        {
          pix = x11_create_pixmap (channels[cur_sender]->button, data,
                                   pix_width, pix_height, title);
          if (pix != 0)
            {
              if (channels[cur_sender]->pixmap)
                XFreePixmap (dpy, channels[cur_sender]->pixmap);
              channels[cur_sender]->pixmap = pix;
              XtVaSetValues (channels[cur_sender]->button,
                             XtNbackgroundPixmap, pix,
                             XtNlabel, "",
                             XtNwidth, pix_width, XtNheight, pix_height, NULL);
            }
        }
    }
}

void
set_channel (struct CHANNEL *channel)
{
  /* image parameters */
  set_picparams (channel->color, channel->bright,
                 channel->hue, channel->contrast);
  set_capture (channel->capture, 1);

  /* input source */
  if (cur_input != channel->source)
    set_source (channel->source);
  if (cur_norm != channel->norm)
    set_norm (channel->norm);

  /* station */
  cur_channel = channel->channel;
  cur_fine = channel->fine;
  grabbers[grabber]->grab_tune (channel->freq);
  cur_freq = channel->freq;
  editor_station_switched ();
  set_property (channel->freq, channel->cname, channel->name);

  /* deinterlace */
  if (cur_deinterlace != channel->deinterlace)
    set_deinterlace (channel->deinterlace);
    
  /* subpage */
  set_subpage (channel->subpage);

  set_title ();

  if(doublekey) {
    if (keypad_timer)
      {
	XtRemoveTimeOut (keypad_timer);
	keypad_timer = 0;
      }
    keypad_timer = XtAppAddTimeOut (app_context, KEYPAD_TIME, keypad_timeout, NULL);
  }

  if (zap_timer)
    {
      XtRemoveTimeOut (zap_timer);
      zap_timer = 0;
    }
  if (scan_timer)
    {
      XtRemoveTimeOut (scan_timer);
      scan_timer = 0;
    }
  if (audio_timer)
    {
      XtRemoveTimeOut (audio_timer);
      audio_timer = 0;
    }
  audio_timer = XtAppAddTimeOut (app_context, 10000, watch_audio, NULL);
  
//#ifdef USE_LIBXOSD <== xosd inside now
  if (xosd_is_onscreen(osd_bar))
    xosd_hide(osd_bar);
//#endif <== xosd inside now
  osd(-1, -1, "", -1);
}

void
change_int (char *name, char *par, int *val)
{
  title[0] = 0;
  switch (par[0])
    {
    case '+':
    case '-':
      *val += atoi (par);
      break;
    default:
      *val = atoi (par);
      break;
    }
  if (*val < 0)
    *val = 0;
  if (*val > 65535)
    *val = 65535;
  sprintf (title, "%s: %d%%", name, *val * 100 / 65535);
}



void
set_volume ()
{
  char label[64];

  mixer_set_volume (cur_volume);
  mixer_set_mute (cur_mute);

  if (s_volume)
  {
    set_float (s_volume, XtNtopOfThumb, (float) cur_volume / 100);
    if (debug)
      fprintf (stderr, "volume: %3d\n", cur_volume);
    sprintf (label, "%-" LABEL_WIDTH2 "s:%3d%%", "Volume", cur_volume);
    XtVaSetValues (l_volume, XtNlabel, label, NULL);
  }
}

static void
keypad_timeout(XtPointer client_data, XtIntervalId *id)
{
    if (debug)
	fprintf(stderr, "keypad: timeout!!!\n");
    keypad_value = -1;
    keypad_timer = 0;
}



void
scan_timeout (XtPointer client_data, XtIntervalId * id)
{
  static String argv[] = { "next", NULL };

  scan_timer = 0;

  /* check */
  if (!grabbers[grabber]->grab_tuned)
    return;
  if (grabbers[grabber]->grab_tuned ())
    return;

  XtCallActionProc (tv, "Tune", NULL, argv, 1);
  scan_timer = XtAppAddTimeOut (app_context, SCAN_TIME, scan_timeout, NULL);
}

#ifdef HAVE_LIBXXF86VM
static void
vidmode_timer (XtPointer clientData, XtIntervalId * id)
{
  set_capture (CAPTURE_OVERLAY, 1);
}

static void
set_vidmode (int nr)
{
  if (CAPTURE_OVERLAY == cur_capture)
    video_overlay (NULL);
  usleep (VIDMODE_DELAY * 1000);
  if (debug)
    fprintf (stderr, "switching video mode to %dx%d now\n",
             vm_modelines[nr]->hdisplay, vm_modelines[nr]->vdisplay);
  XF86VidModeSwitchToMode (dpy, XDefaultScreen (dpy), vm_modelines[nr]);

  if (CAPTURE_OVERLAY == cur_capture)
    {
      cur_capture = 0;
      XtAppAddTimeOut (app_context, VIDMODE_DELAY, vidmode_timer, NULL);
    }
}
#endif

/* --- grab (single frames) to file ----------------------------------*/

void
select_snap (int jpeg, int size)
{
  void *buffer;
  char *filename = NULL;
  char *fmt = NULL;
  char *snapbase = "snap";
  char begin_name[256] = {'\0'};
  char *name = NULL;
  Dimension width = cur_maxwidth;
  Dimension height = cur_maxheight;
  title[0] = 0;

// Get TV Program Title if Nxtvepg send it to xdTV
if (channel_title[0] != 0) 
{
  sprintf(begin_name, "snap-%s",channel_title);
  snapbase = begin_name;
} 

// full size window
if (size == 1)
{
  width = cur_maxwidth;
  height = cur_maxheight;
}
// same size window
if (size == 0)
  XtVaGetValues (tv, XtNwidth, &width, XtNheight, &height, NULL);


  strcpy (title, "Grabbing...");
  set_timer_title ();

  if (NULL == (buffer = get_image(VIDEO_RGB24_BE, width, height)))
    {
      strcpy (title, "Grabbing Failed");
      set_timer_title ();
      return;
    }
  if (NULL == filepath)
    filepath = getcwd(NULL,0);  
    
  if (NULL == filename)
    {
      if (jpeg && (jpegfile != NULL))
	snapbase = jpegfile;
      else if (!jpeg && (ppmfile != NULL))
	snapbase = ppmfile;
      if (-1 != cur_sender)
        {
          name = channels[cur_sender]->name;
        }
      else
        {
          name = "???";
        }
      filename = snap_filename (snapbase, name, jpeg ? "jpeg" : "ppm");
    }

  if (jpeg)
    {
#ifdef HAVE_LIBJPEG
      write_jpeg (filepath, filename, buffer, width, height, jpegpcent, 0);
      if (size == 0)
      {
        fmt = "%-" LABEL_WIDTH "s :  (Saved!)     Ctrl+J";
        sprintf (title, "Window jpeg saved");
      }
      if (size == 1)
      {
        fmt = "%-" LABEL_WIDTH "s :  (Saved!)          J";
        sprintf (title, "Fullscreen jpeg saved");	
      }

#else
      sprintf (title, "no jpeg support, sorry");
#endif
    }
  else
    {
      write_ppm (filepath, filename, buffer, width, height);

      if (size == 0) 
      {
        fmt = "%-" LABEL_WIDTH "s :  (Saved!)     Ctrl+G";
        sprintf (title, "Window ppm saved");
      }
      if (size == 1) 
      {
        fmt = "%-" LABEL_WIDTH "s :  (Saved!)          G";
        sprintf (title, "Fullscreen ppm saved");	
      }
    }

  set_timer_title ();

  sprintf (title, fmt, "Grab an Image");
  if (c_graball)
    XtVaSetValues (c_graball, XtNlabel, title, NULL);

}

void
button_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  struct CHANNEL *channel = clientdata;
  int i;

  if (is_divx_in_progress() && (!divx.chg))
    return;

  pixit ();
  for (i = 0; i < count; i++)
    if (channels[i] == channel)
      break;
  cur_sender = i;
  set_channel (channels[i]);
}

/* Xaw: Mozaic Channels -----------------------------------------*/

void
create_chanwin ()
{
  chan_shell = XtVaAppCreateShell ("Channels", "XdTV",
                                   topLevelShellWidgetClass,
                                   dpy, XtNclientLeader, app_shell,
				   XtNvisual,vinfo->visual,
				   XtNcolormap,colormap,
				   XtNdepth,vinfo->depth,NULL);
  chan_viewport = XtVaCreateManagedWidget ("viewport",
                                           viewportWidgetClass, chan_shell,
                                           XtNallowHoriz, False,
                                           XtNallowVert, True, NULL);
  chan_box = XtVaCreateManagedWidget ("channelbox",
                                      boxWidgetClass, chan_viewport,
                                      XtNsensitive, True, NULL);
}

/* Xaw: Stations -----------------------------------------*/

void channel_menu(void)
{
    int  i,max,len;
    char str[100];

    if (cmenu)
	free(cmenu);
    cmenu = malloc((count+1)*sizeof(struct STRTAB));
    memset(cmenu,0,(count+1)*sizeof(struct STRTAB));
    for (i = 0, max = 0; i < count; i++) {
	len = strlen(channels[i]->name);
	if (max < len)
	    max = len;
    }
    for (i = 0; i < count; i++) {
	cmenu[i].nr      = i+1;
	cmenu[i].str     = channels[i]->name;
	if (channels[i]->key) {
	    sprintf(str,"%2d  %-*s  %s",i+1,
		    max+2,channels[i]->name,channels[i]->key);
	} else {
	    sprintf(str,"%2d  %-*s",i+1,max+2,channels[i]->name);
	}
	cmenu[i].str=strdup(str);
    }
    editor_list_update ();
}

//--- channel hopping ---------------------------------------

void
zap_timeout (XtPointer client_data, XtIntervalId * id)
{
  static int muted = 0;
  char *fmt = NULL;
  title[0] = 0;

  if (zap_fast && !cur_mute)
    {
      /* mute for fast channel scan */
      muted = cur_mute = 1;
      set_volume ();
    }
  pixit ();
  cur_sender = (cur_sender + 1) % count;
  set_channel (channels[cur_sender]);
  if (cur_sender != zap_start)
    {
      sprintf (title, "Channel Hopping On: %s", channels[cur_sender]->name);
      XtVaSetValues (app_shell, XtNtitle, title, NULL);
      display_onscreen ();
      zap_timer = XtAppAddTimeOut
        (app_context, zap_fast ? CAP_TIME : ZAP_TIME, zap_timeout, NULL);
    }
  else
    {
      if (muted)
        {
          muted = cur_mute = 0;
          set_volume ();
        }
      fmt = "%-" LABEL_WIDTH "s :     (Off)   Ctrl+Z/Z";
      sprintf (title, fmt, "Channel Hopping");
      if (c_zap)
        XtVaSetValues (c_zap, XtNlabel, title, NULL);
    }
}

void
select_zap(int j)
{

  char *fmt = NULL;
  char *fmt2 = NULL;
  title[0] = 0;  

  if (zap_timer)
  {
    XtRemoveTimeOut (zap_timer);
    zap_timer = 0;
    fmt = "%-" LABEL_WIDTH "s :     (Off)   Ctrl+Z/Z";
    fmt2 = "Off";      
  }
  else
  {
    zap_start = (cur_sender == -1) ? 0 : cur_sender;

    switch(j)
    {
      case 0:
        zap_fast = 0;
        fmt = "%-" LABEL_WIDTH "s :    (Slow)          Z";
	break;

      case 1:
        zap_fast = 1;
        fmt = "%-" LABEL_WIDTH "s :    (Fast)     Ctrl+Z";
	break;
    }

    if (count)
      zap_timer = XtAppAddTimeOut
    (app_context, CAP_TIME, zap_timeout, NULL);
    fmt2 = "Start";
  }
    
    sprintf (title, fmt, "Channel Hopping");
    if (c_zap)
      XtVaSetValues (c_zap, XtNlabel, title, NULL);
      
    sprintf (title, "Channel Hopping: %s",fmt2);
    set_timer_title ();  
  
}


/*---------------------- END Functions --------------------------------------*/

/* -------------------- ACTION function -------------------------------------*/

void
SetBlackborderAction (Widget widget, XEvent * event,
                String * params, Cardinal * num_params)
{
      if (*num_params > 0)
        {
          if (0 == strcasecmp (params[0], "inc"))
            set_blackborder(0);
          else if (0 == strcasecmp (params[0], "dec"))
            set_blackborder(1);
          else if ((0 == strcasecmp (params[0], "4:3")) || (0 == strcasecmp (params[0], "1.33:1")))
            set_ybar_ratio(0);
          else if ((0 == strcasecmp (params[0], "16:9")) || (0 == strcasecmp (params[0], "1.78:1")))
            set_ybar_ratio((int)(0.25*YBAR_DEN/2)); 
          else if ((0 == strcasecmp (params[0], "20:9")) || (0 == strcasecmp (params[0], "2.35:1")))
            set_ybar_ratio((int)(0.43*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "1.66:1"))
            set_ybar_ratio((int)(0.20*YBAR_DEN/2));    
          else if (0 == strcasecmp (params[0], "1.85:1"))
            set_ybar_ratio((int)(0.28*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "2.20:1"))
            set_ybar_ratio((int)(0.40*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "2.40:1"))
            set_ybar_ratio((int)(0.45*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "2.55:1"))
            set_ybar_ratio((int)(0.48*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "2.65:1"))
            set_ybar_ratio((int)(0.50*YBAR_DEN/2));
          else if (0 == strcasecmp (params[0], "2.76:1"))
            set_ybar_ratio((int)(0.52*YBAR_DEN/2));
          else
            set_ybar_ratio(atoi(params[0]));
        }
}

void
SetChannelAction (Widget widget, XEvent * event,
                  String * params, Cardinal * num_params)
{
  int i;
  static int last_channel=0;

  if (*num_params > 1)
    return;

#if defined(HAVE_DIVX4LINUX) || defined(HAVE_FFMPEG) || defined(HAVE_XVID)
  if (is_divx_in_progress() && (!divx.chg))
    return;
#endif

  if(!count) return; // no channels configured !

  if (0 == strcmp (params[0], "next"))
    {
      i = (cur_sender + 1) % count;
    }
  else if (0 == strcmp (params[0], "prev"))
    {
      i = (cur_sender + count - 1) % count;
    }
  else if (0 == strcmp (params[0], "back"))
    {
      i = last_channel;
    }
  else
    {
      /* search the configured channels first... */
      for (i = 0; i < count; i++)
        if (0 == strcasecmp (channels[i]->name, params[0]))
          break;
      /* ... if it failes, take the argument as index */
      if (i == count)
        i = atoi (params[0]);
      if(doublekey) {
	int old_keypad_value=keypad_value;
	if(i>=0 && i<=9) {
	  if(keypad_value!=-1) {
	    int j;
	    if(doublekey_firstisone && i==9)
	      j = -1 + keypad_value*10;
	    else
	      j = i + keypad_value*10;
	    if(j<count) i=j;
	  }
	  keypad_value = i;
	  if(doublekey_firstisone) {
	    keypad_value++;
	    if(old_keypad_value==-1 && keypad_value==10)
	      keypad_value=-1;
	  }
	} else
	  keypad_value = -1;
      }
    }
  if (i >= 0 && i < count)
    {
      if (!cur_mute) mixer_set_mute(1);
      pixit ();
      last_channel = cur_sender;
      cur_sender = i;
      set_channel (channels[i]);
      usleep(MUTE_TIME * 1000);
      if (!cur_mute) mixer_set_mute(0);
    }
  osd(-1, -1, "", -1);
}


/*static*/ void
SaveAction (Widget widget, XEvent * event,
                  String * params, Cardinal * num_params)
{
  save_config ();
  title[0] = 0;
  sprintf (title, "Configuration Saved");  
  set_timer_title ();
}

void
SetSourceAction (Widget widget, XEvent * event,
                  String * params, Cardinal * num_params)
{
  int i=0;


  if (*num_params > 1)
    return;

  if (debug)
    fprintf(stderr, "cur_input: %d\n", cur_input);

  if (count && 0 == strcmp (params[0], "next"))
    {
      i = (cur_input + 1) % count;
      if (NULL == grabbers[grabber]->inputs[i].str)
	cur_input = i = 0;
    }
  else if (count && 0 == strcmp (params[0], "prev"))
    {
	if (cur_input>0)
    	    i = (cur_input + count - 1) % count;
	else
	{
	    while (NULL != grabbers[grabber]->inputs[++i].str);
	    i--;
	}
    }
  if (i >= 0 && i < count)
    set_source(i);
}


/* used by nxtvepg, do not remove !! */
void
RemoteAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  Atom type;
  int format, argc, i;
  char *argv[32];
  unsigned long nitems, bytesafter;
  unsigned char *args = NULL;

  if (event->type == PropertyNotify)
    {
#if 0
      fprintf (stderr, "PropertyNotify %s\n",
               XGetAtomName (dpy, event->xproperty.atom));
#endif
      if (event->xproperty.atom == xawtv_remote &&
          Success == XGetWindowProperty (dpy,
                                         event->xproperty.window,
                                         event->xproperty.atom,
                                         0, (65536 / sizeof (long)),
                                         True, XA_STRING,
                                         &type, &format, &nitems, &bytesafter,
                                         &args) && nitems != 0)
        {
          if (debug)
            fprintf (stderr, "remote control: ");

          for (i = 0, argc = 0; i < nitems; i += strlen (args + i) + 1)
            {
              if (debug)
                fprintf (stderr, "'%s' ", args + i);

              argv[argc++] = args + i;
            }

          if (debug)
            fprintf (stderr, "\n");

          if (0 == strcasecmp (argv[0], "setstation") && argc > 1)
            {
              XtCallActionProc (tv, "SetChannel", NULL, argv + 1, 1);
            }
          else if (0 == strcasecmp (argv[0], "setchannel") && argc > 1)
            {
              XtCallActionProc (tv, "Tune", NULL, argv + 1, 1);
            }
          else if (0 == strcasecmp (argv[0], "volume") && argc > 1)
            {
              XtCallActionProc (tv, "Volume", NULL, argv + 1, 1);
            }
          else if (0 == strcasecmp (argv[0], "resmode") && argc > 1)
            {
              res_mode = (res_mode + 1) % 3;
            }
          else if (0 == strcasecmp (argv[0], "resource") && argc > 1)
            {
              char *newarg[2];
              newarg[0] = res_modes[res_mode];
              argv[1] = argv[1];
              XtCallActionProc (tv, "SetRes", NULL, newarg, 2);
            }
          else if (0 == strcasecmp (argv[0], "message") && argc > 1)
            {
	      /* used by nxtvepg do not remove !!!*/
              strcpy (title, argv[1]);
	      strcpy (channel_title, argv[1]);
              set_timer_title ();
            }
          else if (0 == strcasecmp (argv[0], "vtx"))
            {
              if (argc == 1)
                {
                  // single vtx command with no args -> clear osd
                  popdown_onscreen (NULL, NULL);
                }
              else if (argc > 1)
                {
                  // n line vtx command
                  char *s;
                  int size;

                  size=1;
                  for(i=1; i<argc; i++)
                    size += strlen(argv[i])+1;
                  s = malloc(size);
                  *s=0;
                  for(i=1; i<argc-1; i++)
                    sprintf(s, "%s%s\n", s, argv[i]);
                  sprintf(s, "%s%s", s, argv[argc-1]);
                  osd(-1, -1, s, -1);

                  free(s);
                }
            }

          XFree (args);
        }
    }
}


void
ScanAction (Widget widget, XEvent * event,
            String * params, Cardinal * num_params)
{
  static String argv[] = { "next", NULL };

  pixit ();
  XtCallActionProc (tv, "Tune", NULL, argv, 1);
  scan_timer = XtAppAddTimeOut (app_context, SCAN_TIME, scan_timeout, NULL);
}

void
TuneAction (Widget widget, XEvent * event,
            String * params, Cardinal * num_params)
{
  int c, freq;

  if (*num_params < 1)
    return;

  if (is_divx_in_progress() && (!divx.chg))
    return;

  if (0 == strcasecmp (params[0], "next"))
    {
      do
        {
          cur_channel = (cur_channel + 1) % CHAN_ENTRIES;
        }
      while (!tvtuner[cur_channel].freq[chan_tab]);
      cur_fine = defaults.fine;
      cur_sender = -1;
    }
  else if (0 == strcasecmp (params[0], "prev"))
    {
      do
        {
          cur_channel = (cur_channel + CHAN_ENTRIES - 1) % CHAN_ENTRIES;
        }
      while (!tvtuner[cur_channel].freq[chan_tab]);
      cur_fine = defaults.fine;
      cur_sender = -1;
    }
  else if (0 == strcasecmp (params[0], "fine_up"))
    {
      cur_fine++;
      if (cur_sender != -1)
        channels[cur_sender]->fine = cur_fine;
    }
  else if (0 == strcasecmp (params[0], "fine_down"))
    {
      cur_fine--;
      if (cur_sender != -1)
        channels[cur_sender]->fine = cur_fine;
    }
  else
    {
      if (-1 != (c = lookup_channel (params[0])))
        {
          cur_channel = c;
          cur_fine = defaults.fine;
        }
      cur_sender = -1;
    }

  pixit ();

  // Why the hell were those 2 lines here ?
  //cur_sender = -1;
  //set_capture (defaults.capture /* CAPTURE_OVERLAY */ );

  freq = get_freq (cur_channel) + cur_fine;

  if (cur_sender != -1)
    channels[cur_sender]->freq = freq;

  grabbers[grabber]->grab_tune (freq);
  cur_freq = freq;
  editor_station_switched ();
  set_title ();
  set_property (freq, tvtuner[cur_channel].name, NULL);

  if (zap_timer)
    {
      XtRemoveTimeOut (zap_timer);
      zap_timer = 0;
    }
  if (scan_timer)
    {
      XtRemoveTimeOut (scan_timer);
      scan_timer = 0;
    }
  if (audio_timer)
    {
      XtRemoveTimeOut (audio_timer);
      audio_timer = 0;
    }
  audio_timer = XtAppAddTimeOut (app_context, 10000, watch_audio, NULL);
}

void
ChannelAction (Widget widget, XEvent * event,
               String * params, Cardinal * num_params)
{
  int i;

  if (is_divx_in_progress() && (!divx.chg))
    return;

  if (0 == count)
    return;
  i = popup_menu (widget, "Stations", cmenu);

  if (i != -1)
    {
      if (!cur_mute) mixer_set_mute(1);
      pixit ();
      cur_sender = i - 1;
      set_channel (channels[cur_sender]);
      usleep(MUTE_TIME * 1000);
      if (!cur_mute) mixer_set_mute(0);
    }
}

void
PointerAction (Widget widget, XEvent * event,
               String * params, Cardinal * num_params)
{
  pointer_on = !pointer_on;
  title[0] = 0;
  XDefineCursor (dpy, XtWindow (tv), pointer_on ? left_ptr : no_ptr);
  if (!pointer_on)
    sprintf (title,"Pointer: Hidden");
  else
    sprintf (title,"Pointer: Visible");  
  set_timer_title ();
}

Boolean
MyResize (XtPointer client_data)
{
  video_new_size ();

  return TRUE;
}

void
CloseMainAction (Widget widget, XEvent * event,
                 String * params, Cardinal * num_params)
{
  static Dimension x, y, w, h;
  char *argv[32];
  int argc = 0;

  if (event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Main: wm_save_yourself\n");

          argv[argc++] = progname;

          /* position */
          if (fs)
            {
              argv[argc++] = strdup ("-f");
            }
          else
            {
              XtVaGetValues (app_shell,
                             XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                             NULL);
              argv[argc++] = strdup ("-geometry");
              sprintf (argv[argc++] = malloc (32), "%dx%d+%d+%d", w, h, x, y);
            }
          argv[argc++] = strdup ("-c");
          argv[argc++] = strdup (device.video);

          /* grab filename */
          if (ppmfile)
            {
              argv[argc++] = strdup ("-o");
              argv[argc++] = malloc (256);
              argv[argc - 1][0] = '\0';
              if (ppmfile[0] != '/')
                {
                  getcwd (argv[argc - 1], 128);
                  strcat (argv[argc - 1], "/");
                }
              strcat (argv[argc - 1], ppmfile);
            }
          if (jpegfile)
            {
              argv[argc++] = strdup ("-j");
              argv[argc++] = malloc (256);
              argv[argc - 1][0] = '\0';
              if (jpegfile[0] != '/')
                {
                  getcwd (argv[argc - 1], 128);
                  strcat (argv[argc - 1], "/");
                }
              strcat (argv[argc - 1], jpegfile);
            }

          /* options */
          if (!xfree_ext)
            argv[argc++] = strdup ("-x");
          if (!pointer_on)
            argv[argc++] = strdup ("-m");
          if (bpp)
            {
              argv[argc++] = strdup ("-b");
              sprintf (argv[argc++] = malloc (8), "%d", bpp);
            }

          /* channel */
	  if (cur_sender!=-1)
          argv[argc++] = channels[cur_sender]->name;

          XSetCommand (XtDisplay (app_shell), XtWindow (app_shell), argv,
                       argc);
          return;
        }
    }
  ExitCB (widget, NULL, NULL);
}

void
CallTitleAction (Widget widget, XEvent * event,
                  String * params, Cardinal * num_params)
{
  if (channel_title[0] != 0)
  {
    strcpy (title, channel_title);
    set_timer_title ();
  }
}

void
FullScreenAction (Widget widget, XEvent * event,
                  String * params, Cardinal * num_params)
{
  static Dimension x, y, w, h;
  static int rpx, rpy, mouse;
#ifdef HAVE_LIBXXF86VM
  static int vm_switched;
#endif

  Window root, child;
  int wpx, wpy, mask;
  title[0] = 0;
//#ifdef USE_LIBXOSD <== xosd inside now
if (xosd_is_onscreen(osd_bar))          	
  xosd_hide(osd_bar);
//#endif <== xosd inside now

  if (fs)
    {     
      if (wm_fullscreen != NULL)
        {
          wm_fullscreen(dpy, XtWindow(app_shell), 0);
	  do_screensaver(0);
	  //fprintf(stderr,"boucle 1: tirement de l'image\n");
        }
      else
        {

#ifdef HAVE_LIBXXF86VM
          if (have_vm && vm_switched)
            {
              set_vidmode (0);
              vm_switched = 0;
            }
#endif

          if (on_timer)
            {
              XtPopdown (on_shell);
              XtRemoveTimeOut (on_timer);
              on_timer = 0;
            }


          XtVaSetValues (app_shell,
                         XtNwidthInc, WIDTH_INC,
                         XtNheightInc, HEIGHT_INC,
                         XtNx, x + fs_xoff,
                         XtNy, y + fs_yoff, XtNwidth, w, XtNheight, h, NULL);

	  do_screensaver(0);
	  //fprintf(stderr,"boucle 2: avec switch de rsolution\n");

        }
      XWarpPointer (dpy, None, RootWindowOfScreen (XtScreen (tv)),
                    0, 0, 0, 0, rpx, rpy);

      //fprintf(stderr,"decorationtmp = %d\n", decorationtmp);
      if (staytmp == 0 && wm_stay_on_top)
        wm_stay_on_top(dpy, XtWindow(app_shell), 0);
	 
      //if (decorationtmp == 1)
      //  wm_decoration(app_shell, 1); 	
      
      fs = 0;
      if (mouse)
        XtCallActionProc (tv, "Pointer", NULL, NULL, 0);            
      sprintf (title,"Fullscreen: Off");  
      set_timer_title ();
    }
  else
    {
      int vp_x, vp_y, vp_width, vp_height;    
      staytmp = stay;
      //decorationtmp = decoration;
      //fprintf(stderr,"decorationtmp = %d\n", decorationtmp);      
      if (wm_stay_on_top)
        wm_stay_on_top(dpy, XtWindow(app_shell), 1);
      //if (wm_decoration)	
      //  wm_decoration(app_shell, 0);
      
      if (wm_fullscreen != NULL)
        {
          wm_fullscreen(dpy, XtWindow(app_shell), 1);
	  do_screensaver(1);
	  //fprintf(stderr,"boucle 1: tirement de l'image\n");
	  //xscreensaver_timer = XtAppAddTimeOut(app_context,60000, xscreensaver_timefunc,NULL);
        }
      else
        {

	  vp_x = 0;
          vp_y = 0;
          vp_width = swidth;
          vp_height = sheight;
          XQueryPointer (dpy, RootWindowOfScreen (XtScreen (tv)),
                         &root, &child, &rpx, &rpy, &wpx, &wpy, &mask);
	  
#ifdef HAVE_LIBXXF86VM
          if (have_vm)
            {
              int i;
              XF86VidModeGetAllModeLines (dpy, XDefaultScreen (dpy),
                                          &vm_count, &vm_modelines);
              for (i = 0; i < vm_count; i++)
                if (fs_width == vm_modelines[i]->hdisplay &&
                    fs_height == vm_modelines[i]->vdisplay)
                  break;
              if (i != 0 && i != vm_count)
                {
                  set_vidmode (i);
                  vm_switched = 1;
                  vp_width = vm_modelines[i]->hdisplay;
                  vp_height = vm_modelines[i]->vdisplay;
                }
              else
                {
                  vm_switched = 0;
                  vp_width = vm_modelines[0]->hdisplay;
                  vp_height = vm_modelines[0]->vdisplay;
                }

              XWarpPointer (dpy, None, RootWindowOfScreen (XtScreen (tv)),
                            0, 0, 0, 0, vp_width / 2, vp_height / 2);
              XF86VidModeSetViewPort(dpy,XDefaultScreen(dpy),
                    fs_xoff<0?-fs_xoff:0,
                    fs_yoff<0?-fs_yoff:0);

	    }
#endif

          XtVaGetValues (app_shell,
                         XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h, NULL);

#ifdef HAVE_LIBXINERAMA
	if (nxinerama) {
	    /* check which physical screen we are visible on */
	    int i;
	    for (i = 0; i < nxinerama; i++) {
		if (x >= xinerama[i].x_org &&
		    y >= xinerama[i].y_org &&
		    x <  xinerama[i].x_org + xinerama[i].width &&
		    y <  xinerama[i].y_org + xinerama[i].height) {
		    vp_x      = xinerama[i].x_org;
		    vp_y      = xinerama[i].y_org;
		    vp_width  = xinerama[i].width;
		    vp_height = xinerama[i].height;
		    break;
		}
	    }
	}
#endif
	if (debug)
	    fprintf(stderr,"viewport: %dx%d+%d+%d\n",
		    vp_width,vp_height,vp_x,vp_y);

          XtVaSetValues (app_shell, XtNwidthInc, 1, XtNheightInc, 1, NULL);
          XtVaSetValues (app_shell,
                         XtNx, (vp_x & 0xfffc) + (fs_xoff<0?0:fs_xoff),
                         XtNy, vp_y + (fs_yoff<0?0:fs_yoff),
                         XtNwidth, vp_width, XtNheight, vp_height, NULL);

          XRaiseWindow (dpy, XtWindow (app_shell));

	  do_screensaver(1);
	  //fprintf(stderr,"boucle 2: avec switch de rsolution\n");
          //xscreensaver_timer = XtAppAddTimeOut(app_context,60000, xscreensaver_timefunc,NULL);
        }
      XWarpPointer (dpy, None, XtWindow (tv), 0, 0, 0, 0, 30, 15);
      mouse = pointer_on;

      fs = 1;
      if (mouse)
        XtCallActionProc (tv, "Pointer", NULL, NULL, 0);      
      sprintf (title,"Fullscreen: On");  
      set_timer_title ();
    }
  XtAppAddWorkProc (app_context, MyResize, NULL);
}


void
ZapAction (Widget widget, XEvent * event,
           String * params, Cardinal * num_params)
{
  if (*num_params > 0)
  {
      if (0 == strcasecmp (params[0], "fast"))
        select_zap(1);
  }
  else
  {
    select_zap(0);
  }
}

void
ChannelsAction (Widget widget, XEvent * event,
                String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;
  Dimension height, width;
  Position x = 0, y = 0;

  if (!count)
    return;

  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Channels: wm_save_yourself\n");
          XSetCommand (XtDisplay (chan_shell), XtWindow (chan_shell), NULL, 0);
          return;
        }
    }

  if (mapped)
    {
      XtPopdown (chan_shell);
      mapped = 0;
    }
  else
    {
      mapped = 1;
      select_zap(1);
      if (first)
        {
          XtVaGetValues (chan_shell, XtNheight, &height, NULL);
          XtVaGetValues (chan_shell, XtNwidth, &width, NULL);

	  if (count < 4)
	  {
            XtVaSetValues (chan_shell, XtNheight, pix_height+10, NULL);
	    if (count == 1)
              XtVaSetValues (chan_shell, XtNwidth, pix_width+25, NULL);
	    else if (count == 2)
              XtVaSetValues (chan_shell, XtNwidth, pix_width*2+25, NULL);
	    else if (count == 3)
              XtVaSetValues (chan_shell, XtNwidth, pix_width*3+25, NULL);
	  }
	  else if (count > 3 && count < 7)
	  {
	    XtVaSetValues (chan_shell, XtNheight, pix_height*2+10, NULL);
            XtVaSetValues (chan_shell, XtNwidth, pix_width*3+25, NULL);
	  }
	  else if (count > 6)
	  {
            XtVaSetValues (chan_shell, XtNheight, pix_height*3+10, NULL);
            XtVaSetValues (chan_shell, XtNwidth, pix_width*3+25, NULL);
	  }
	  XtVaSetValues(chan_shell, XtNx, x, XtNy, y,NULL); // pour que la fenetre soit en haut  gauche de l'cran
        }
      XtPopup (chan_shell, XtGrabNone);
      if(first) {
	XSetWMProtocols (XtDisplay (chan_shell), XtWindow (chan_shell), wm_protocols, 2);
	first=0;
      }
    }
}


void
RecordMovieAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  record_movie(-1);
}

void
SubtitlesPagenoAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  set_subpageno(-1);
  set_timer_title ();
}

void
UnSubtitlesPagenoAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  set_subpageno(-2);
  set_timer_title ();
}

void
ToggleSubAction (Widget widget, XEvent * event,
		 String * params, Cardinal * num_params)
{
  set_subactive(-1);
  set_timer_title ();
}

void
DeinterlaceAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  set_deinterlace( (cur_deinterlace + 1) % NB_DEINTERLACE );
  set_timer_title ();
}

void
StayOnTopAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  if (set_stayontop(-1))
    set_timer_title ();
}

void
DecorationAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
   if (!nodecoinit)
   {
     if (on_timer)
     {
       XtPopdown (on_shell);
       XtRemoveTimeOut (on_timer);
       on_timer = 0;
     }
    if (set_decoration(-1))
      set_timer_title ();
  }
}

void
VolumeAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  char *msg = (char *)NULL;
  title[0] = 0;

  if (*num_params < 1)
    return;

  if (0 == strcasecmp (params[0], "mute") ||
      0 == strcasecmp (params[0], "tvmute"))
    cur_mute = !cur_mute;
  else if (0 == strcasecmp (params[0], "inc"))
    {
      if(!cur_mute)
	cur_volume += 1;
    }
  else if (0 == strcasecmp (params[0], "dec"))
    {
      if(!cur_mute)
	cur_volume -= 1;
    }
  else
    cur_volume += atoi (params[0]);

  if (cur_volume < 0)
    cur_volume = 0;
  if (cur_volume > 100)
    cur_volume = 100;

  set_volume ();

  if (cur_mute)
    sprintf (title, "Volume: Muted");
  else
    //#ifdef USE_LIBXOSD <== xosd inside now
    if (!libxosd)
    //#endif <== xosd inside now
      sprintf (title, "Volume: %d%%", cur_volume);

   if (0 == strcasecmp (params[0], "tvmute")&&
       grabbers[grabber]->grab_audio) {
     grabbers[grabber]->grab_audio (cur_mute, -1, NULL);
     if (cur_mute)
       sprintf (title, "Volume: TVMuted");
     else
       //#ifdef USE_LIBXOSD <== xosd inside now
       if (!libxosd)
       //#endif <== xosd inside now
        sprintf (title, "Volume: %d%%", cur_volume);
   }

  if (msg)
    sprintf (title, "%s %s", title, msg);

  //#ifdef USE_LIBXOSD <== xosd inside now
  if (libxosd && !cur_mute)
  {
    if (xosd_is_onscreen(osd_main))
      xosd_hide(osd_main);
    Show_bar(1,cur_volume);
  }
  else
  {
    if (xosd_is_onscreen(osd_bar))     
      xosd_hide(osd_bar);
  //#endif <== xosd inside now
     set_timer_title ();
   //#ifdef USE_LIBXOSD <== xosd inside now
   }
   //#endif <== xosd inside now
}

void
SetBgAction (Widget widget, XEvent * event,
             String * params, Cardinal * num_params)
{
  XColor have, exact;

  if (*num_params != 1)
    fprintf (stderr, "SetBg: usage: SetRes(color)\n");
  XAllocNamedColor (dpy, DefaultColormapOfScreen (XtScreen (widget)),
                    params[0], &have, &exact);
  XtVaSetValues (widget, XtNbackground, have.pixel, NULL);
}

void
SetFgAction (Widget widget, XEvent * event,
             String * params, Cardinal * num_params)
{
  XColor have, exact;

  if (*num_params != 1)
    fprintf (stderr, "SetFg: usage: SetRes(color)\n");
  XAllocNamedColor (dpy, DefaultColormapOfScreen (XtScreen (widget)),
                    params[0], &have, &exact);
  XtVaSetValues (widget, XtNforeground, have.pixel, NULL);
}

void
SetShadowAction (Widget widget, XEvent * event,
                 String * params, Cardinal * num_params)
{
  Dimension n;

  if (*num_params != 1)
    fprintf (stderr, "SetShadow: usage: SetShadow(int)\n");
  n = atoi (params[0]);
  XtVaSetValues (widget, "shadowWidth", n, NULL);
}

void
ShowtimeAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
    struct tm *times;
    time_t timet;
    title[0] = 0;

    timet = time(NULL);
    times = localtime(&timet);
    strftime(title, 6, "%k:%M", times);
    set_timer_title ();
}

//#ifdef USE_LIBXOSD <== xosd inside now
void
XosdAction(Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  select_xosd(-1);
  set_timer_title ();  
}
//#endif <== xosd inside now

void
SetResAction (Widget widget, XEvent * event,
              String * params, Cardinal * num_params)
{
  if (*num_params != 2)
    fprintf (stderr, "SetRes: usage: SetRes(resource,value)\n");

  if (0 == strcmp ("color", params[0]))
    {
      change_int (params[0], params[1], &cur_color);
      set_picparams (cur_color, -1, -1, -1);
      //#ifdef USE_LIBXOSD <== xosd inside now
      if (libxosd && libxosd_ok)
        Show_bar(3,cur_color*100/65536);
      //#endif <== xosd inside now
    }
  else if (0 == strcmp ("contrast", params[0]))
    {
      change_int (params[0], params[1], &cur_contrast);
      set_picparams (-1, -1, -1, cur_contrast);
      //#ifdef USE_LIBXOSD <== xosd inside now
      if (libxosd && libxosd_ok)
        Show_bar(5,cur_contrast*100/65536);
      //#endif <== xosd inside now
    }
  else if (0 == strcmp ("bright", params[0]))
    {
      change_int (params[0], params[1], &cur_bright);
      set_picparams (-1, cur_bright, -1, -1);
      //#ifdef USE_LIBXOSD <== xosd inside now
      if (libxosd && libxosd_ok)
        Show_bar(2,cur_bright*100/65536);
      //#endif <== xosd inside now
    }
  else if (0 == strcmp ("hue", params[0]))
    {
      change_int (params[0], params[1], &cur_hue);
      set_picparams (-1, -1, cur_hue, -1);
      //#ifdef USE_LIBXOSD <== xosd inside now
      if (libxosd && libxosd_ok)
        Show_bar(4,cur_hue*100/65536);
      //#endif <== xosd inside now
    }
  else if (0 == strcmp (params[0], "capture"))
    {
      set_capture ((cur_capture + 1) % 3, 1);
    }
  else if (0 == strcmp ("audio", params[0]))
    {
      change_audio (atoi (params[1]));
    }
  else
    return;
//#ifdef USE_LIBXOSD <== xosd inside now
  if (!libxosd) 
//#endif <== xosd inside now
    set_timer_title ();
  return;
}

void
SnapAction (Widget widget, XEvent * event,
            String * params, Cardinal * num_params)
{
  int jpeg = 0; // jpeg | ppn
  int size = 0; // full | win

    if (debug)
      fprintf(stderr,"argument numbers = %d\n",*num_params);

  if (*num_params > 0)
    {
      if (0 == strcasecmp (params[0], "jpeg"))
        jpeg = 1;
      if (0 == strcasecmp (params[0], "ppm"))
        jpeg = 0;
    }

  if (*num_params > 1)
    {
      if (0 == strcasecmp (params[1], "full"))
        size = 1;
      if (0 == strcasecmp (params[1], "win"))
        size = 0;
    }
    if (debug)
      fprintf(stderr,"jpeg = %d , size = %d\n", jpeg, size);
    select_snap(jpeg,size);
}

void
AleVTAction (Widget widget, XEvent * event,
             String * params, Cardinal * num_params)
{
select_alevt(-1);
}

void 
AOPAction (Widget widget, XEvent * event,
	   String * params, Cardinal * num_params)
{
  int r;
  if (*num_params !=1) return;
  r=toggle_aop(params[0]);
  set_volume();
  sprintf(title, "AOP %s: %s", params[0],
	  r==2 ? "on" : r==1 ? "off" : "??");
  set_timer_title ();
}

void 
VOPAction (Widget widget, XEvent * event,
	   String * params, Cardinal * num_params)
{
  int r;
  if (*num_params !=1) return;
  r=toggle_vop(params[0]);
  sprintf(title, "VOP %s: %s", params[0],
	  r==2 ? "on" : r==1 ? "off" : "??");
  set_timer_title ();
}

/* --- Xaw: Main Options GUI -------------------------------------- */
/* --- Xaw: Main Options GUI -------------------------------------- */
/* --- Xaw: Main Options GUI -------------------------------------- */

struct CALL_ACTION call_chan = { 0, "Channels", {NULL} };
struct CALL_ACTION call_editor = { 0, "Editor", {NULL} };
struct CALL_ACTION call_x11params = { 0, "x11Params", {NULL} };
struct CALL_ACTION call_cap = { 2, "SetRes", {"capture", "toggle", NULL} };
struct CALL_ACTION call_togglesub = { 0, "ToggleSub", {NULL} };
struct CALL_ACTION call_stayontop = { 0, "StayOnTop", {NULL} };
struct CALL_ACTION call_decoration = { 0, "Decoration", {NULL} };
struct CALL_ACTION call_help = { 0, "Help", {NULL} };
struct CALL_ACTION call_plugin = { 0, "Plugin", {NULL} };

void
action_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  struct CALL_ACTION *ca = clientdata;

  XtCallActionProc (widget, ca->name, NULL, ca->argv, ca->argc);
}

void
menu_cb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int cd = (int) clientdata;
  int j;
  int notitle = 0;

  switch (cd)
    {
      /* Option window entries */
    case 10:
      if (-1 !=
          (j = popup_menu (widget, "TV Norm", grabbers[grabber]->norms))) {
        set_norm (j);
	if (cur_sender != -1) channels[cur_sender]->norm = cur_norm;
      }
      break;

    case 11:
      if (-1 != (j = popup_menu (widget, "Video Source",
                                 grabbers[grabber]->inputs))) {
	printf("source:%d\n", j);
        set_source (j);
	if (cur_sender != -1) channels[cur_sender]->source = cur_input;
      }
      break;

    case 12:
      if (-1 != (j = popup_menu (widget, "Frequency table", chan_names)))
        set_freqtab (j);
      break;

    case 13:
      if (-1 != (j = popup_menu (widget, "Audio", stereo)))
        {
          change_audio (j);
        }
      break;

    case 14:
      if (-1 != (j = popup_menu (widget, "Capture", cap_list)))
        {
	  set_capture (j, 1);
        }
      break;

    case 15:
      if (-1 != (j = popup_menu (widget, "Deinterlace", deinterlace_list)))
        {
          set_deinterlace (j);
        }
      break;

    case 16:
      if (-1 != (j = popup_menu (widget, "Record movie", record_list)))
        {
          record_movie (j);
        }
      break;

    case 17:
      if (-1 != (j = popup_menu (widget, "Subtitles Page", subpageno_list)))
        {
	  char *s2=int_to_str (j, subpageno_list);
	  if(strcmp(s2, "Other"))
	    set_subpage (int_to_str (j, subpageno_list));
	  else
	    SubPageAction(NULL, NULL, NULL, NULL);
        }
      break;

    case 18:
      if (-1 != (j = popup_menu (widget, "Teletext", alevt_list)))
        {
          select_alevt (j);
        }
      break;

    case 19:
      if (-1 != (j = popup_menu (widget, "Channel Hopping", zap_list)))
        {
          select_zap (j);
        }
      break;

    case 20:
      if (-1 != (j = popup_menu (widget, "Grab an Image", grab_list)))
        {
	switch (j)
	  {
	    case 0:
              select_snap(0,0); // ppm + win: Ctrl + G
              return;

            case 1:
              select_snap(0,1); // ppm + full: G
              return;

            case 2:
              select_snap(1,0); // jpeg + win: Ctrl+J
              return;

            case 3:
              select_snap(1,1); // jpeg + full: J
              return;
	      
            case 4:
              sprintf (title,"Grab: Options");    
              GrabAction(NULL, NULL, NULL, NULL);
              return;	      
	  }
        }
      break;

    case 21:
      if (-1 != (j = popup_menu (widget, "Simple Actions", simple_actions_list)))
        {
	char *tok;
	int argc;

        switch (j)
	  {
	    case 0:
	      tok = "mute";
	      argc = 1;
              VolumeAction (NULL, NULL, &tok, &argc); // audio mute / (un)mute : A
              break;
	      
	    case 1:
	      tok = "tvmute";
	      argc = 1;
              VolumeAction (NULL, NULL, &tok, &argc); // audio mute + TVMUTE / (un)mute +TVMUTE : Shift+A
              break;	      

            case 2:
              ShowtimeAction (NULL, NULL, NULL, NULL); // show time : H
              break;

            case 3:
              PointerAction (NULL, NULL, NULL, NULL); // mouse pointer visible / hidden : M
	      notitle = 1;
              break;

            case 4:
              FullScreenAction (NULL, NULL, NULL, NULL); // fullscreen on / off : F
	      notitle = 1;
	      break;
	      
            case 5:
              CallTitleAction (NULL, NULL, NULL, NULL); // recall nxtvepg title info
	      break;	      

	    default:
              break;
	  }
        }
      break;
//#ifdef USE_LIBXOSD <== xosd inside now
    case 22:
      if (-1 != (j = popup_menu (widget, "Xosd", xosd_list)))
        {
          select_xosd (j);
        }
      break;      
//#endif <== xosd inside now
    default:
      break;
    }

  if (title[0] != 0 && notitle == 0)
    set_timer_title ();
}

void
jump_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  char *name;
  int value;

  name = XtName (XtParent (widget));
  value = (int) (*(float *) call_data * 65535);
#if 0
  fprintf (stderr, "jump to %f (%s/%d)\n", *(float *) call_data, name, value);
#endif

  if (0 == strcmp ("color", name))
    set_picparams (value, -1, -1, -1);

  else if (0 == strcmp ("contrast", name))
    set_picparams (-1, -1, -1, value);

  else if (0 == strcmp ("bright", name))
    set_picparams (-1, value, -1, -1);

  else if (0 == strcmp ("hue", name))
    set_picparams (-1, -1, value, -1);

  else if (0 == strcmp ("volume", name))
    {
      cur_volume = *(float *) call_data * 100 + 0.5;
      set_volume ();
    }

}

void
scroll_scb (Widget widget, XtPointer clientdata, XtPointer call_data)
{
  int move = (int) call_data;
  Dimension length;
  float shown, top1, top2;
  char *name;
  float step;
  float range;
  name = XtName (XtParent (widget));

  XtVaGetValues (widget,
                 XtNlength, &length,
                 XtNshown, &shown, XtNtopOfThumb, &top1, NULL);
  
  if (strcmp(name, "bright") == 0)
    {
      range = BRIGHT_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "hue") == 0)
    {
      range = HUE_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "contrast") == 0)
    {
      range = CONTRAST_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "color") == 0)
    {
      range = COLOR_RANGE;
      step = 1.0;
    }
  else if (strcmp(name, "volume") == 0)
    {
      range = VOLUME_RANGE;
      step = 1.0;
    }
  else
    {
      range = 65535.0;
      step = 5.0;
    }
  
  if (move > 0)
    top2 = top1 + step/range;
  else
    top2 = top1 - step/range;
  if (top2 < 0.0)
    top2 = 0.0;
  if (top2 > 1.0)
    top2 = 1.0;

#if 0
  fprintf (stderr, "scroll by %d\tlength %d\tshown %f\ttop %f => %f\n",
           move, length, shown, top1, top2);
#endif

  jump_scb (widget, clientdata, &top2);
}

void
OptionsAction (Widget widget, XEvent * event,
               String * params, Cardinal * num_params)
{
  static int mapped = 0, first = 1;

  if (event && event->type == ClientMessage)
    {
      if (event->xclient.data.l[0] == wm_protocols[1])
        {
          if (debug)
            fprintf (stderr, "Options: wm_save_yourself\n");
          XSetCommand (XtDisplay (opt_shell), XtWindow (opt_shell), NULL, 0);
          return;
        }
    }

  if (mapped)
    {
      XtPopdown (opt_shell);
      mapped = 0;
    }
  else
    {
      XtPopup (opt_shell, XtGrabNone);
      mapped = 1;
      if (first)
        {
          XSetWMProtocols (XtDisplay (opt_shell), XtWindow (opt_shell),
                           wm_protocols, 2);
          first = 0;
        }
    }
}

void
create_optwin ()
{
  Widget p;

#ifdef HAVE_XPM
#ifdef HAVE_PIXMAPS
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif
#endif
  
  opt_shell = XtVaAppCreateShell ("Options", "XdTV",
                                  topLevelShellWidgetClass,
                                  dpy, XtNclientLeader, app_shell,
				  XtNvisual, vinfo->visual,
				  XtNcolormap, colormap,
				  XtNdepth, vinfo->depth, NULL);
  opt_paned = XtVaCreateManagedWidget ("paned", panedWidgetClass, opt_shell,
                                       NULL);

  c_main_actions = XtVaCreateManagedWidget ("l_main_actions", commandWidgetClass, opt_paned,
                           PANED_FIX, NULL);	   
  XtAddCallback (c_main_actions, XtNcallback, action_cb, (XtPointer) & call_help);
  
  c_simple_actions = XtVaCreateManagedWidget ("simple_actions", commandWidgetClass, opt_paned,
                                         PANED_FIX, NULL);
  XtAddCallback (c_simple_actions, XtNcallback, menu_cb, (XtPointer) 21);
    
if (wm_stay_on_top)
  {
    c_stayontop = XtVaCreateManagedWidget ("stayontop", commandWidgetClass, opt_paned,
                                           PANED_FIX, NULL);
    XtAddCallback (c_stayontop, XtNcallback, action_cb, (XtPointer) & call_stayontop);
  }

if (!nodecoinit)
  {
    c_decoration = XtVaCreateManagedWidget ("decoration", commandWidgetClass, opt_paned,
                                         PANED_FIX, NULL);
    XtAddCallback (c_decoration, XtNcallback, action_cb, (XtPointer) & call_decoration);
  }
  
  c_togglesub = XtVaCreateManagedWidget ("togglesub", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_togglesub, XtNcallback, action_cb, (XtPointer) & call_togglesub);


  c_record = XtVaCreateManagedWidget ("record", commandWidgetClass, opt_paned,
                                           PANED_FIX, NULL);
  XtAddCallback (c_record, XtNcallback, menu_cb, (XtPointer) 16);

    
  c_alevt = XtVaCreateManagedWidget ("teletext", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_alevt, XtNcallback, menu_cb, (XtPointer) 18);


  c_graball = XtVaCreateManagedWidget ("graball", commandWidgetClass, opt_paned,
                                         PANED_FIX, NULL);
  XtAddCallback (c_graball, XtNcallback, menu_cb, (XtPointer) 20);


  c_zap = XtVaCreateManagedWidget ("zapping", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_zap, XtNcallback, menu_cb, (XtPointer) 19);

//#ifdef USE_LIBXOSD <== xosd inside now
  c_xosdaction = XtVaCreateManagedWidget ("Xosd", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_xosdaction, XtNcallback, menu_cb, (XtPointer) 22);
//#endif <== xosd inside now
  
  c_channel_options = XtVaCreateManagedWidget ("l_channel_options", labelWidgetClass, opt_paned,
                           PANED_FIX, NULL);

  c_norm = XtVaCreateManagedWidget ("norm", commandWidgetClass, opt_paned,
                                    PANED_FIX, NULL);
  XtAddCallback (c_norm, XtNcallback, menu_cb, (XtPointer) 10);


  c_input = XtVaCreateManagedWidget ("input", commandWidgetClass, opt_paned,
                                     PANED_FIX, NULL);
  XtAddCallback (c_input, XtNcallback, menu_cb, (XtPointer) 11);


  c_freq = XtVaCreateManagedWidget ("freq", commandWidgetClass, opt_paned,
                                    PANED_FIX, NULL);
  XtAddCallback (c_freq, XtNcallback, menu_cb, (XtPointer) 12);


  c_audio = XtVaCreateManagedWidget ("audio", commandWidgetClass, opt_paned,
                                     PANED_FIX, NULL);
  XtAddCallback (c_audio, XtNcallback, menu_cb, (XtPointer) 13);


  c_cap = XtVaCreateManagedWidget ("cap", commandWidgetClass, opt_paned,
                                   PANED_FIX, NULL);
  XtAddCallback (c_cap, XtNcallback, menu_cb, (XtPointer) 14);


#ifdef HAVE_XV
  c_deinterlace = XtVaCreateManagedWidget ("deinterlace", commandWidgetClass, opt_paned,
                                           PANED_FIX, NULL);
  XtAddCallback (c_deinterlace, XtNcallback, menu_cb, (XtPointer) 15);
#endif


  c_subpageno = XtVaCreateManagedWidget ("subpageno", commandWidgetClass, opt_paned,
                                           PANED_FIX, NULL);
  XtAddCallback (c_subpageno, XtNcallback, menu_cb, (XtPointer) 17);


  p = XtVaCreateManagedWidget ("bright", panedWidgetClass, opt_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_bright = XtVaCreateManagedWidget ("lbright", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_bright = XtVaCreateManagedWidget ("sbright", scrollbarWidgetClass, p,
                                      PANED_FIX, NULL);

  XtAddCallback (s_bright, XtNjumpProc, jump_scb, NULL);

  XtAddCallback (s_bright, XtNscrollProc, scroll_scb, NULL);


  p = XtVaCreateManagedWidget ("hue", panedWidgetClass, opt_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_hue = XtVaCreateManagedWidget ("lhue", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_hue = XtVaCreateManagedWidget ("shue", scrollbarWidgetClass, p,
                                   PANED_FIX, NULL);

  XtAddCallback (s_hue, XtNjumpProc, jump_scb, NULL);

  XtAddCallback (s_hue, XtNscrollProc, scroll_scb, NULL);


  p = XtVaCreateManagedWidget ("contrast", panedWidgetClass, opt_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_contrast = XtVaCreateManagedWidget ("lcontrast", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_contrast = XtVaCreateManagedWidget ("scontrast", scrollbarWidgetClass, p,
                                        PANED_FIX, NULL);

  XtAddCallback (s_contrast, XtNjumpProc, jump_scb, NULL);

  XtAddCallback (s_contrast, XtNscrollProc, scroll_scb, NULL);


  p = XtVaCreateManagedWidget ("color", panedWidgetClass, opt_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_color = XtVaCreateManagedWidget ("lcolor", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_color = XtVaCreateManagedWidget ("scolor", scrollbarWidgetClass, p,
                                     PANED_FIX, NULL);

  XtAddCallback (s_color, XtNjumpProc, jump_scb, NULL);

  XtAddCallback (s_color, XtNscrollProc, scroll_scb, NULL);


  p = XtVaCreateManagedWidget ("volume", panedWidgetClass, opt_paned,
                               XtNorientation, XtEvertical, PANED_FIX, NULL);

  l_volume = XtVaCreateManagedWidget ("lvolume", labelWidgetClass, p,
                               XtNshowGrip, False, NULL);

  s_volume = XtVaCreateManagedWidget ("svolume", scrollbarWidgetClass, p,
                                      PANED_FIX, NULL);

  XtAddCallback (s_volume, XtNjumpProc, jump_scb, NULL);

  XtAddCallback (s_volume, XtNscrollProc, scroll_scb, NULL);

  c_pluginwin = XtVaCreateManagedWidget ("pluginwin", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_pluginwin, XtNcallback, action_cb, (XtPointer) & call_plugin);  

  c_x11paramswin = XtVaCreateManagedWidget ("x11paramswin", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_x11paramswin, XtNcallback, action_cb, (XtPointer) & call_x11params);


  c_editorwin = XtVaCreateManagedWidget ("editorwin", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_editorwin, XtNcallback, action_cb, (XtPointer) & call_editor);
  
  
  c_chanwin = XtVaCreateManagedWidget ("chanwin", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_chanwin, XtNcallback, action_cb, (XtPointer) & call_chan);



  c_applysave = XtVaCreateManagedWidget ("save_config", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);
  XtAddCallback (c_applysave, XtNcallback, save_cb, (XtPointer) NULL);

  c_quit = XtVaCreateManagedWidget ("quit", commandWidgetClass, opt_paned,
                               PANED_FIX, NULL);

  XtAddCallback (c_quit, XtNcallback, ExitCB, NULL);
  
  /* Example with xbm files
  mainactions_pixmap = XCreateBitmapFromData(XtDisplay(opt_paned),
                                       RootWindowOfScreen(XtScreen(opt_paned)),
				       mainactions_bits, mainactions_width, mainactions_height);
  XtVaSetValues( c, XtNbitmap,  mainactions_pixmap, NULL);*/
#ifdef HAVE_XPM
#ifdef HAVE_PIXMAPS
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_mainactions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_main_actions, XtNbitmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_channelsoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_channel_options, XtNbitmap, icon_pixmap, NULL); 
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_openx11options_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_x11paramswin, XtNbitmap, icon_pixmap, NULL);   
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_openpluginoptions_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_pluginwin, XtNbitmap, icon_pixmap, NULL);   
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_openchanneleditor_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_editorwin, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_openmozaicchannels_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_chanwin, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_applysave_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_applysave, XtNbitmap, icon_pixmap, NULL);  
  XpmCreatePixmapFromData(XtDisplay(opt_paned),
                          RootWindowOfScreen(XtScreen(opt_paned)),
                          main_quit_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_quit, XtNbitmap, icon_pixmap, NULL);       
#endif
#endif
}

/* --- END Xaw: Main Options GUI -------------------------------------- */
/* --- END Xaw: Main Options GUI -------------------------------------- */
/* --- END Xaw: Main Options GUI -------------------------------------- */


/* ------------- init functions ----------------------------------------*/

static void
xfree_init ()
{
  int flags, foo, bar, i, ma, mi;

#ifdef HAVE_LIBXXF86DGA
  if (!noDGA)
    {
      if (XF86DGAQueryExtension (dpy, &foo, &bar))
        {
          XF86DGAQueryDirectVideo (dpy, XDefaultScreen (dpy), &flags);
          if (flags & XF86DGADirectPresent)
            {
              XF86DGAQueryVersion (dpy, &ma, &mi);
              fprintf (stderr, "DGA: server=%d.%d, include=%d.%d\n",
                       ma, mi, XF86DGA_MAJOR_VERSION, XF86DGA_MINOR_VERSION);
              if ((ma != XF86DGA_MAJOR_VERSION) || (mi != XF86DGA_MINOR_VERSION))
#ifdef CHECK_XFREE_EXT
                fprintf (stderr, "DGA: version mismatch -- disabled\n");
              else
#else
                fprintf (stderr, "DGA: WARNING: version mismatch !!!\n");
#endif
                have_dga = 1;
            }
        }
    }
#endif
#ifdef HAVE_LIBXXF86VM
  if (XF86VidModeQueryExtension (dpy, &foo, &bar))
    {
      XF86VidModeQueryVersion (dpy, &ma, &mi);
      fprintf (stderr, "VidMode: server=%d.%d, include=%d.%d\n",
               ma, mi, XF86VIDMODE_MAJOR_VERSION, XF86VIDMODE_MINOR_VERSION);
      if ((ma != XF86VIDMODE_MAJOR_VERSION)
          || (mi != XF86VIDMODE_MINOR_VERSION))
#ifdef CHECK_XFREE_EXT
        fprintf (stderr, "VidMode: version mismatch -- disabled\n");
      else
#else
        fprintf (stderr, "VidMode: WARNING: version mismatch !!!\n");
#endif
        {
          have_vm = 1;
          fprintf (stderr, "  available video mode(s):");
          XF86VidModeGetAllModeLines (dpy, XDefaultScreen (dpy),
                                      &vm_count, &vm_modelines);
          for (i = 0; i < vm_count; i++)
            {
              fprintf (stderr, " %dx%d",
                       vm_modelines[i]->hdisplay, vm_modelines[i]->vdisplay);
            }
          fprintf (stderr, "\n");
        }
    }
#endif
}

void
xfree_xinerama_init(Display *dpy)
{
#ifdef HAVE_LIBXINERAMA
    int foo,bar,i;

    if (XineramaQueryExtension(dpy,&foo,&bar) &&
	XineramaIsActive(dpy)) {
	xinerama = XineramaQueryScreens(dpy,&nxinerama);
	for (i = 0; i < nxinerama; i++) {
	    fprintf(stderr,"xinerama %d: %dx%d+%d+%d\n",
		    xinerama[i].screen_number,
		    xinerama[i].width,
		    xinerama[i].height,
		    xinerama[i].x_org,
		    xinerama[i].y_org);
	}
    }
#endif
}

static void display_help_message (FILE *fp)
{
  fprintf(fp, "Do \"man xdtv\" to read the complete syntax\n");
  /* if you really like long help messages: */
  /* system("man xdtv | cat"); */
}

static void display_help_badargoption(FILE *fp, char *arg, char *argopt) {
  fprintf(fp, "Syntax error: %s is not a correct argument of option "
	  "%s\n" , argopt, arg);
  display_help_message(fp);
}

static void display_help_badarg (FILE *fp, char *arg) {
  fprintf(fp, "Syntax error: %s is not a valid argument\n" , arg);
  display_help_message(fp);
}


int
check_mmx(void)
{
  int mmx_flags;

  if ( (mmx_flags = mm_accel ()) == 0 )
    {
      fprintf (stderr, "No MMX detected: deinterlacing will not be available!\n\n");
      return 0;
    }

  if (mmx_flags & MM_ACCEL_X86_MMX)
    fprintf(stderr, "MMX, ");
  if (mmx_flags & MM_ACCEL_X86_SSE)
    fprintf(stderr, "SSE, ");
  if (mmx_flags & MM_ACCEL_X86_MMXEXT)
    fprintf(stderr, "AMD MMX extensions, ");
  if (mmx_flags & MM_ACCEL_X86_SSE2)
    fprintf(stderr, "SSE2, ");
  if (mmx_flags & MM_ACCEL_X86_3DNOW)
    fprintf(stderr, "3DNOW, ");
  fprintf(stderr, "have been detected.\n");

  return mmx_flags;
}

#ifdef HAVE_V4L
void
check_device_old_way(void)
{
#ifdef HAVE_DEVFS

  struct stat buf;

  /* Check for really default available video device */
  if (stat (device.video, &buf) != 0)
    {
      /* default video device does not exist at all */
      /* last chance ? */
      device.video = "/dev/v4l/video0";
    }


  /* Check for really default available vbi device */
  if (stat (device.vbi, &buf) != 0)
    {
      /* default vbi device does not exist at all */
      /* last chance ? */
      device.vbi = "/dev/v4l/vbi0";
    }

#else

  struct stat buf;

  /* Check for really default available video device */
  if (stat (device.video, &buf) == 0)
    {
      /* is it a directory */
      if (S_ISDIR (buf.st_mode))
        {
          /* New fucking idea of Mandrake and RedHat */
          device.video = "/dev/video/video0";

          /* Quickly check if that device exists */
          if (stat (device.video, &buf) != 0)
            {
              /* No, then defaults to /dev/video0 (last chance ?) */
              device.video = "/dev/video0";
            }
        }
    }
  else
    /* default video device does not exist at all */
    {
      /* last chance ? */
      device.video = "/dev/video0";
    }


  /* Check for really default available vbi device */
  if (stat (device.vbi, &buf) == 0)
    {
      /* is it a directory */
      if (S_ISDIR (buf.st_mode))
        {
          /* New fucking idea of Mandrake and RedHat */
          device.vbi = "/dev/video/vbi0";

          /* Quickly check if that device exists */
          if (stat (device.vbi, &buf) != 0)
            {
              /* No, then defaults to /dev/vbi0 (last chance ?) */
              device.vbi = "/dev/vbi0";
            }
        }
    }
  else
    /* default vbi device does not exist at all */
    {
      /* last chance ? */
      device.vbi = "/dev/vbi0";
    }

#endif
  if (debug)
    {
      fprintf(stderr, "Selected default video device : %s\n", device.video);
      fprintf(stderr, "Selected default vbi device   : %s\n", device.vbi);
    }
}

void
check_device(void)
{
  int n;
  struct dirent **namelist;
  FILE *fp;
  char line [128];
  char *test_string;
  char **test_device;

  /* Read entries in /proc/video/dev */
  n = scandir("/proc/video/dev", &namelist, 0, 0);
  if (debug)
    fprintf(stderr, "Get %d files in /proc/video/dev\n", n);
  if (n <= 0)
    {
      // something odd occured, fallback to old detection way
      if (n<0) perror("scandir");
      check_device_old_way();
      return;
    }
  else
    {
      while (n--)
        {
          if ((strcmp(namelist[n]->d_name, "..")==0)||(strcmp(namelist[n]->d_name, ".")==0))
            break;

          if (debug)
            fprintf(stderr, "Checking file /proc/video/dev/%s\n", namelist[n]->d_name);
          if (strncmp(namelist[n]->d_name, "video", 5)== 0)
            {
              test_string = "VID_TYPE_TUNER";
              test_device = &device.video;
            }
          else if (strncmp(namelist[n]->d_name, "vbi", 3)== 0)
            {
              test_string = "VID_TYPE_TELETEXT";
              test_device = &device.vbi;
            }
          else
            {
              test_string = NULL;
              test_device = NULL;
            }

          if (test_string != NULL)
            {
              sprintf(line, "/proc/video/dev/%s", namelist[n]->d_name);
              fp = fopen(line, "r");
              while (NULL != fgets (line, 127, fp))
                {
                  line[strlen(line)-1] = 0;
                  if (debug)
                    fprintf(stderr, "Checking line: '%s'\n", line);
                  if ( (strncmp(line, "type", 4) == 0) && strstr(line, test_string) )
                    {
                      if (debug)
                        fprintf(stderr, "Bingo!\n");
                      *test_device = malloc(16);
#ifndef HAVE_DEVFS
                      sprintf(*test_device, "/dev/%s", namelist[n]->d_name);
#else
                      sprintf(*test_device, "/dev/v4l/%s", namelist[n]->d_name);
#endif
                    }
                }
              fclose(fp);
            }
          free(namelist[n]);
        }
      free(namelist);
    }

  if (debug)
    {
      fprintf(stderr, "Selected default video device : %s\n", device.video);
      fprintf(stderr, "Selected default vbi device   : %s\n", device.vbi);
    }
}
#endif

#define INCRARG(i) \
  argprec=arg; \
  if(++i>=argc) { \
    display_help_badargoption(stderr,arg,"\"\"");\
    exit(0); \
  } \
  arg=argv[i];

/* options which must be parsed again after reading config file*/

static int parse_opts(int argc,char *argv[],int *i)
{
  char *arg=argv[*i], *argprec=NULL;
  if (strcmp (arg, "-rec_fps") == 0)
    {
      INCRARG(*i);
      setfps(atof(arg));
    }
  else if (strcmp (arg, "-rec_width") == 0)
    {
      INCRARG(*i);
      divx.width=atol(arg);
      divx.width=((int)(divx.width / ((double)WRECPAD2) + 0.5 )) * WRECPAD2;
      if(divx.width == 0)
	divx.width= ((int) (4.0 * divx.height / 3 / WRECPAD2 + 0.5)) * WRECPAD2;
    }
  else if (strcmp (arg, "-rec_height") == 0)
    {
      INCRARG(*i);
      divx.height=atol(arg);
      divx.height=(int)(divx.height / ((double)HRECPAD2) + 0.5 ) * HRECPAD2;
      if(divx.height == 0)
	divx.height = ((int)(3.0 * divx.width / 4 / HRECPAD2 + 0.5)) * HRECPAD2;
    }
  else if (strcmp (arg, "-rec_videobr") == 0)
    {
      INCRARG(*i);
      divx.bitrate=atol(arg)*1000L;
    }
  else if (strcmp (arg, "-rec_stereo") == 0)
    {
      INCRARG(*i);
      divx.stereo=str_to_int(arg,booltab);
      if(divx.compress_audio == -1)
	{display_help_badargoption(stderr,argprec,arg); exit(1);}
    }
  else if (strcmp (arg, "-rec_audiobuf") == 0)
    {
      INCRARG(*i);
      divx.audio_buffer_size=atoi(arg);
    }
  else if (strcmp (arg, "-rec_fragments") == 0)
    {
      INCRARG(*i);
      divx.audio_fragments=atoi(arg);
    }
  else if (strcmp (arg, "-rec_fragmentsize") == 0)
    {
      INCRARG(*i);
      divx.audio_sizefragment=atoi(arg);
    }
  else if (strcmp (arg, "-rec_mp3") == 0)
    {
      INCRARG(*i);
      divx.compress_audio=str_to_int(arg,booltab);
      if(divx.compress_audio == -1)
	{display_help_badargoption(stderr,argprec,arg); exit(1);}
    }
  else if (strcmp (arg, "-rec_mp3cbr") == 0)
    {
      INCRARG(*i);
      divx.mp3_bitrate=atoi(arg);
      divx.mp3_vbr=0;
    }
  else if (strcmp (arg, "-rec_mp3vbr") == 0)
    {
      INCRARG(*i);
      divx.mp3_vbr_quality=atoi(arg);
      divx.mp3_quality=2;
      divx.mp3_vbr=1;
    }
  else if (strcmp (arg, "-rec_vcodec") == 0)
    {
      int j;
      struct {char *nom;int numcodec;} codecs[]= {
#ifdef HAVE_FFMPEG
	{"ffmpeg_mpeg4",FFMPEG_MPEG4},
	{"ffmpeg_mpeg1",FFMPEG_MPEG1},
#if LIBAVCODEC_BUILD >= 4734
	{"ffmpeg_ffvhuff",FFMPEG_FFVHUFF},
#endif
	{"ffmpeg_huffyuv",FFMPEG_HUFFYUV},
#endif
#ifdef HAVE_XVID
	{"xvid",XVID},
#endif
#ifdef HAVE_DIVX4LINUX
	{"divx4linux",DIVX4LINUX},
#endif
	{"uncompressed",UNCOMPRESSED},
	{NULL,0}};
      INCRARG(*i);
      for(j=0;codecs[j].nom;j++) {
	printf("%s\n",codecs[j].nom);
	if(!strcmp(arg,codecs[j].nom)) break;
      }
      if(!codecs[j].nom)
	{
	  fprintf(stderr,"codec %s inconnu\n",arg);
	  display_help_badargoption(stderr,argprec,arg);
	  exit(1);
	}
      divx.codec=codecs[j].numcodec;
    }
  else if (strcmp (arg, "-rec_display") == 0)
    {
      INCRARG(*i);
      divx.display_frames = str_to_int(arg,booltab);
      if(divx.display_frames == -1)
	{display_help_badargoption(stderr,argprec,arg); exit(1);}
    }
  else if (strcmp (arg, "-rec_maxgap") == 0)
    {
      INCRARG(*i);
      divx.maxgap=atof(arg);
    }
  else if (strcmp (arg, "-rec_delay") == 0)
    {
      INCRARG(*i);
      divx.delay=atof(arg);
    }
  else if (strcmp (arg, "-rec_sub") == 0)
    {
      INCRARG(*i);
      divx.sub = str_to_int(arg,booltab);
      if(divx.sub == -1)
	{display_help_badargoption(stderr,argprec,arg); exit(1);}
    }
  else if (strcmp (arg, "-rec_chg") == 0)
    {
      INCRARG(*i);
      divx.chg = str_to_int(arg,booltab);
      if(divx.chg == -1)
	{display_help_badargoption(stderr,argprec,arg); exit(1);}
    }
  else if (strcmp (arg, "-rec_filename") == 0)
    {
      INCRARG(*i);
      divx.filename=arg;
    }
  else if (strcmp (arg, "-alevt_arg") == 0)
    {
      INCRARG(*i);
      strcpy(alevtarg,arg);
      alevt1st = 1;
    }
  else if (strcmp (arg, "-rec_stream") == 0)
    {
      INCRARG(*i);
      divx.stream = str_to_int(arg,booltab);;
    }
  else if (strcmp (arg, "-rec_http_port") == 0)
    {
      INCRARG(*i);
      divx.http_port=atoi(arg);
    }
  else if (strcmp (arg, "-capt_width") == 0)
    {
      INCRARG(*i);
      width_capture_max = atoi(arg);
    }
  else if (strcmp (arg, "-capt_height") == 0)
    {
      INCRARG(*i);
      height_capture_max = atoi(arg);
    }
  else if (strcmp (arg, "-force_capt_width") == 0)
    {
      INCRARG(*i);
      width_capture = atoi(arg);
    }
  else if (strcmp (arg, "-force_capt_height") == 0)
    {
      INCRARG(*i);
      height_capture = atoi(arg);
    }
  else if(strcmp (arg, "-ybar") == 0)
    {
      INCRARG(*i);
      set_ybar_ratio(atoi(arg));
    }
  else if (strcmp (arg, "-restoresnd") == 0)
    {
      INCRARG(*i);
      restoresnd = str_to_int(arg,booltab);;
    }
  else if (strcmp (arg, "-noxawpopup") == 0)
    {
      xawpopup = 0;
    }
//#ifdef USE_LIBXOSD <== xosd inside now
  else if (strcmp (arg, "-xosd") == 0)
    {
      libxosd = 1; 
    }
  else if (strcmp (arg, "-vop_autograb") == 0)
    {
      INCRARG(*i);
      vop_autograb = str_to_int(arg,booltab);;
    }
//#endif <== xosd inside now
  else if(!plugin_parse_opts(argc, argv, i))
    return 0;
  return 1;
}

static Boolean docmd (XtPointer data) {
  printf("done\n");
  if(cmd) {do_command(cmd);cmd=NULL;}
  return -1; /* executed once...*/
}

/*----------------------------------------------------------------------*/
/*--- main function-----------------------------------------------------*/
/*----------------------------------------------------------------------*/

int
main (int argc, char *argv[])
{
  int i, noconf, fullscreen, nomouse;
  char *arg, *argprec=NULL;
  char xdtv_v4l_conf[128] = "xdtv_v4l-conf";
  char *vop_cmdline=NULL, *aop_cmdline=NULL;
  Dimension w;
#ifdef HAVE_XPM
  Pixmap icon_pixmap;
  Pixmap icon_shapemask;
#endif
  struct utsname uts;
  struct CHANNEL last_channel;
  int cmdline_probe_memcpy = -1;
  struct sigaction sa;

  progname = strdup (argv[0]);

  uname(&uts);

  /* Better check options before doing anything else.
   As of Nov. 2004, this quick patch is useful for a quick version check
   without running all whistles and bells ;)
   */
  for (i = 1; i < argc; i++)
  {
  arg = argv[i];
  if (strcmp (argv[i], "-version") == 0)
    {
    fprintf (stderr, "%s v%s running on %s/%s (%s).\n",
       PACKAGE, VERSION, uts.sysname, uts.machine, uts.release);
    /* keep compiler & OS happier than ever */
    return 0;
    }
  }
 
  fprintf (stderr, "\nThis is %s %s running on %s/%s (%s).\n",
           PACKAGE, VERSION, uts.sysname, uts.machine, uts.release);


#ifndef _POSIX_THREAD_IS_GNU_PTH
  /* with GNU Pth (GNU Portable Threads)
     the call of XInitThread causes a segfault on the exit
     (at least on OpenBSD 3.0)
   */
  XInitThreads ();
#endif


  app_shell = XtAppInitialize (&app_context, "XdTV", NULL, 0,    /* opt_desc, 7, */
                               &argc, argv, NULL /* fallback_res */ ,
                               NULL, 0);
  /* signal handler */
  memset(&sa, 0, sizeof(sa));
  sa.sa_handler = sigint_handler;
  sa.sa_flags = SA_RESTART;
  sigaction(SIGINT,  &sa, NULL);
  sa.sa_handler = sigpipe_handler;
  sigaction(SIGPIPE, &sa, NULL);

#ifdef HAVE_V4L
  /* Check for really default available device */
  check_device();
#endif

  for (i = 1; i < argc; i++)
    {
       arg = argv[i];
       if (strcmp (argv[i], "-noplugin") == 0)
        {
          set_plugdir(NULL);
          set_default_plugfile(NULL);
        }
      else if(strcmp (argv[i], "-plugin") == 0)
	{
          INCRARG(i);
	  set_default_plugfile(NULL);
	}
      else if(strcmp (argv[i], "-plugindir") == 0)
	{
          INCRARG(i);
	  set_plugdir(arg);
	}
    }

  load_plugins();
    
  // Check for user directory
  check_user_directory ();
  
  // read some special parameters like decoration (read before inits)
  read_first();
  
  /* parse options */
  debug = noconf = fullscreen = nomouse = 0;
  xfree_ext = 1;

  for (i = 1; i < argc; i++)
    {
      arg = argv[i];
      if (strcmp (arg, "-x") == 0)
        {
          xfree_ext = 0;
        }
      else if (strcmp (arg, "-v") == 0)
        {
          INCRARG(i);
          debug = strtol (arg, (char **) NULL, 10);
        }
      else if (strcmp (arg, "-n") == 0)
        {
          noconf = 1;
        }
      else if (strcmp (arg, "-d") == 0)
        {
          noDGA = 1;
        }
      else if (strcmp (arg, "-D") == 0)
        {
          INCRARG(i);
	  sscanf(arg,"%p",&video_base);
	  strcat (xdtv_v4l_conf, " -a ");
          strncat (xdtv_v4l_conf, arg, 20);
        }
      else if (strcmp (arg, "-m") == 0)
        {
          nomouse = 1;
        }
      else if (strcmp (arg, "-f") == 0)
        {
          fullscreen = 1;
	  oldswitch = 1;	   
        }
      else if (strcmp (arg, "-nowd") == 0)
         {
           decoration = 0;
         }
      else if (strcmp (arg, "-stayontop") == 0)
         {
           stay = 1;
         }	 
      else if (strcmp (arg, "-b") == 0)
        {
          INCRARG(i);
	  bpp = strtol (arg, (char **) NULL, 10);
          /* xdtv_v4l-conf needs this too */
          strcat (xdtv_v4l_conf, " -b ");
          strcat (xdtv_v4l_conf, arg);
        }
      else if (strcmp (arg, "-o") == 0)
        {
	  INCRARG(i);
          ppmfile = arg;
          jpegfile = arg;
        }
      else if (strcmp (arg, "-c") == 0)
        {
          INCRARG(i);
          device.video = arg;
          /* xdtv_v4l-conf needs this too */
          //strcat (xdtv_v4l_conf, " -c ");
          //strcat (xdtv_v4l_conf, device);
#ifdef HAVE_VIDEO_XV
	  if(cmdline_xv_video_port == 0)
	    cmdline_xv_video_port = -1;
#endif
        }
      else if (strcmp (arg, "-C") == 0)
        {
          INCRARG(i);
          device.vbi = arg;
        }
      else if (strcmp (arg, "-novbi") == 0)
        {
          device.vbi = NULL;
        }
      else if ((strcmp (arg, "-no-xv") == 0) || (strcmp (arg, "-noxv") == 0))
        {
#ifdef HAVE_XV
          disable_xv = 1;
          fprintf (stderr, "Xv support disabled.\n");
#else
          fprintf (stderr,
                   "Xv support was not compiled in. Option ignored.\n");
#endif
        }
      else if (strcmp (arg, "-xvport") == 0)
        {
#ifdef HAVE_XV
          INCRARG(i);
          cmdline_xv_img_port = atoi(arg);
#else
          fprintf (stderr,
                   "Xv support was not compiled in. Option ignored.\n");
#endif
        }
#ifdef HAVE_VIDEO_XV
      else if (strcmp (arg, "-xvtvport") == 0)
        {
          INCRARG(i);
          cmdline_xv_video_port = atoi(arg);
        }
#endif
      else if (strcmp(arg, "-noplugin") == 0)
        {
          // just to avoid xdtv exiting
        }
      else if (strcmp(arg, "-plugindir") == 0)
        {
          INCRARG(i); // just to avoid xdtv exiting
        }
      else if(strcmp (argv[i], "-plugin") == 0)
	{
          INCRARG(i);
	  load_plugin(arg, 1);
	}
      else if (strcmp (arg, "-probe_memcpy") == 0)
        {
          cmdline_probe_memcpy = MEMCPY_PROBE;
        }
      else if ((strcmp(arg, "-h") == 0)||strcmp(arg, "--help") == 0)
        {
          fprintf (stdout, "\nUsage: %s [options]\n\n", argv[0]);
          display_help_message(stdout);
          exit(0);
        }
      else if (strcmp (arg, "-e") == 0)
        {
	  INCRARG(i);
	  cmd = arg;
        }
      else if (strcmp (arg, "-v4l2") == 0)
	{
	  forcegrabber("v4l2");
	}
      else if (strcmp (arg, "-v4l1") == 0)
	{
	  forcegrabber("video4linux");
	  strcat (xdtv_v4l_conf, " -1 ");
	}
#ifdef HAVE_VIDEO_XV
      else if (strcmp (arg, "-xvtv") == 0)
	{
	  forcegrabber("Xvideo TV-card driver");
	  xvtv = 1;
	}
      else if (strcmp (arg, "-xvtv_overlay") == 0)
	{
	  INCRARG(i);
	  xvtv_overlay = str_to_int(arg,booltab);
	  if(xvtv_overlay == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
#endif
      else if (strcmp (arg, "-capture") == 0)
	{
	  INCRARG(i);
	  force_capture = str_to_int(arg,captab);
	  if(force_capture == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
      else if (strcmp (arg, "-nbufs") == 0)
	{
	  INCRARG(i);
	  nbufs_default = atoi(arg);
	}
      else if (strcmp (arg, "-avi") == 0)
	{
	  INCRARG(i);
	  avifilename = arg;
	  forcegrabber("avi");
	  device.vbi = NULL;
	}
      else if (strcmp (arg, "-avibench") == 0)
	{
	  avibench = 1;
	}
      else if (strcmp (arg, "-avi_audiofragments") == 0)
	{
	  INCRARG(i);
	  avi_audio_fragments=atoi(arg);
	}
      else if (strcmp (arg, "-avi_audiofragmentsize") == 0)
	{
	  INCRARG(i);
	  avi_audio_sizefragment=atoi(arg);
	}
      else if (strcmp (arg, "-avinoaudioout") == 0)
	{
	  avinoaudioout = 1;
	}
      else if (strcmp (arg, "-sub") == 0)
	{
	  INCRARG(i);
	  subactive = str_to_int(arg,booltab);
	  if(subactive == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
#ifdef HAVE_ALSA
      else if (strcmp (arg, "-noalsa") == 0)
	{
	  disable_mixer("alsa");
	  disable_audio("alsa");
	}
#endif
#ifdef HAVE_SUNAUDIO
      else if (strcmp (arg, "-nosunaudio") == 0)
	{
	  disable_mixer("sunaudio");
	  disable_audio("sunaudio");
	}
#endif
#ifdef HAVE_OSS
      else if (strcmp (arg, "-nooss") == 0)
	{
	  disable_mixer("oss");
	  disable_audio("oss");
	}
#endif
      else if (strcmp (arg, "-mixer_dev") == 0)
	{
	  INCRARG(i);
	  mixer_dev = arg;
	}
      else if (strcmp (arg, "-mixer_tvchan") == 0)
	{
	  INCRARG(i);
	  mixer_tvchan = arg;
	}
      else if (strcmp (arg, "-mixer_pcmchan") == 0)
	{
	  INCRARG(i);
	  mixer_pcmchan = arg;
	}
      else if (strcmp (arg, "-audio_dev") == 0)
	{
	  INCRARG(i);
	  audio_dev = arg;
	}
#ifdef HAVE_BKTR
      else if (strcmp (arg, "-bktr_mode") == 0)
	{
	  INCRARG(i);
	  bktr_mode = atoi(arg);
	}
      else if (strcmp (arg, "-bktr_read") == 0)
	{
	  bktr_read = 1;
	}
#endif
      else if (strcmp (arg, "-doublekey") == 0)
	{
	  INCRARG(i);
	  doublekey = str_to_int(arg,booltab);
	}
      else if (strcmp (arg, "-doublekey_firstisone") == 0)
	{
	  INCRARG(i);
	  doublekey_firstisone = str_to_int(arg,booltab);;
	}
      else if (strcmp (arg, "-oldswitch") == 0)
	{
	  oldswitch = 1;
	}
      else if (strcmp (arg, "-nodecoinit") == 0)
	{
	  nodecoinit = 1;
	}
      else if (strcmp (arg, "-grabfmt") == 0)
	{
	  INCRARG(i);
	  grab_format = str_to_int(arg,video_fmt_names);
	  if(grab_format == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
      else if (strcmp (arg, "-x11fmt") == 0)
	{
	  INCRARG(i);
	  x11_native_format = str_to_int(arg,video_fmt_names);
	  if(x11_native_format == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
      else if (strcmp (arg, "-xvfmt") == 0)
	{
	  INCRARG(i);
	  x11_pixmap_format = str_to_int(arg,video_fmt_names);
	  if(x11_pixmap_format == -1)
	    {display_help_badargoption(stderr,argprec,arg); exit(1);}
	}
      else if (strcmp (arg, "-vop") == 0)
	{
	  INCRARG(i);
	  vop_cmdline=arg;
	}
      else if (strcmp (arg, "-aop") == 0)
	{
	  INCRARG(i);
	  aop_cmdline=arg;
	}
      else if(!parse_opts(argc,argv,&i))
        {
	  display_help_badarg(stderr,arg);
	  exit (1);
	}
    }

#ifdef HAVE_VIDEO_XV
  if(cmdline_xv_video_port==-1)
    fprintf(stderr, "*** to enable xvtv or xvtv_overlay use xvtvport option\n");
#endif

  if(x11_native_format==VIDEO_GRAY8)
    strcat (xdtv_v4l_conf, " -g");
  if(!debug)
    strcat (xdtv_v4l_conf, " -q");

  // This is now done here as device may have been
  // modified either by the check_device function
  // or by supplying the -c switch
  strcat (xdtv_v4l_conf, " -c ");
  strcat (xdtv_v4l_conf, device.video);

  if(debug) fprintf(stderr, "execution of \"%s\"\n", xdtv_v4l_conf);
  switch (system (xdtv_v4l_conf))
    {
    case -1:                    /* can't run */
      fprintf (stderr, "could'nt start xdtv_v4l-conf\n");
      break;
    case 0:                    /* ok */
      break;
    default:                    /* non-zero return */
      fprintf (stderr, "xdtv_v4l-conf had some trouble, "
               "trying to continue anyway\n");
      break;
    }

  XtAppAddActions (app_context, actionTable,
                   sizeof (actionTable) / sizeof (XtActionsRec));

  dpy = XtDisplay (app_shell);

  wm_protocols[0] 	= XInternAtom (dpy, "WM_DELETE_WINDOW", False);
  wm_protocols[1] 	= XInternAtom (dpy, "WM_SAVE_YOURSELF", False);
  xawtv_station 	= XInternAtom (dpy, "_XAWTV_STATION", False);
  xawtv_remote 		= XInternAtom (dpy, "_XAWTV_REMOTE", False);
  xa_deactivate 	= XInternAtom (dpy, "DEACTIVATE", False);

  xfree_xinerama_init(dpy);
  
  // init code from mwxcd http://member.nifty.ne.jp/nmaruichi/
  popuperror_init(app_context, app_shell);
  fileDialogInit(app_shell);  

  wm_detect(dpy);

  kdescreensaver_was_running = (system("dcop kdesktop KScreensaverIface isEnabled 2>/dev/null | grep true &>/dev/null")==0);  
  if (debug)
    fprintf(stderr,"Kscreensaver state = %d\n",kdescreensaver_was_running);

  if (xfree_ext)
    xfree_init ();

  tv = video_init ();
  if(height_capture>0) height_capture_max = height_capture;
  if(width_capture>0) width_capture_max = width_capture;

  create_optwin ();
  create_chanwin ();
  create_editorwin ();

  XtVaGetValues (tv, XtNwidth, &w, NULL);
  if (!w)
    {
      fprintf (stderr, "The app-defaults file is not correctly installed.\n");
      fprintf (stderr,
               "You should have installed xdtv by issuing \"make install\".\n");
      fprintf (stderr, "Your fault (core dumped).\n");
      fprintf (stderr, "(you can also temporarily do "
	       " \"cp XdTV.ad ~/XdTV\",\n"
	       "but do not forget to remove it when"
	       " xdtv is installed correctly)\n");
      exit (1);
    }
  
  overlay_format = x11_native_format;

  audio_init ();
  grabber_init ();
  mixer_init ();
  vop_init(vop_cmdline);

#ifdef HAVE_VIDEO_XV
  if(xvtv_overlay == -1)
    xvtv_overlay = strcmp(grabbers[grabber]->name,"v4l2") == 0
      && xv_video_name &&
      strcasecmp(xv_video_name,"video4linux") == 0;
  if(!xvtv_overlay)
    if(strcmp(grabbers[grabber]->name,"Xvideo TV-card driver") !=0)
      have_video_xv=0;
#endif

  /* read config file */
  if (!noconf)
    {
      read_config ();
      for(i=0;i<argc;i++) parse_opts(argc,argv,&i);
    }
  create_divxwin();
  create_divxaudiowin();
  create_streamparamswin();
  create_subpagewin ();
  create_pluginwin ();
  create_grabwin();
  create_alevtparamswin();
  create_x11paramswin();
  create_onscreen ();//xosd need config file...
  if(libxosd) xaw_xosd_init();
//#ifdef USE_LIBXOSD <== xosd inside now
  create_xosdparamswin();  
//#endif <== xosd inside now
  
  /* Ensure everything (MMX, fast_memcpy) is OK for deinterlacing */
  have_MMX = check_mmx();
  if (cmdline_probe_memcpy != -1)
    probe_fast_memcpy(MEMCPY_PROBE);
  else
    {
      load_memcpy_method();
      probe_fast_memcpy(memcpy_method);
    }

  set_capture_size(width_capture_max, height_capture_max);
  set_freqtab (chan_tab);
  channel_menu ();

  if(!strcmp(grabbers[grabber]->name,"avi")) mixer_set_mode(MIXER_MODE_PCM);
  cur_volume = mixer_get_volume ();
  set_volume ();
  
  cur_capture = 0;

  sprintf (modename, "%d x %d ",
           XtScreen (app_shell)->width, XtScreen (app_shell)->height);
  strcat (modename, int_to_str (x11_native_format, video_fmt_names));

#if 0
  strcat (modename, " - using ");
  strcat (modename, grabbers[grabber]->name);
#endif

#ifdef HAVE_XPM
  XpmCreatePixmapFromData(XtDisplay(app_shell),
                          RootWindowOfScreen(XtScreen(app_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(app_shell, XtNiconPixmap, icon_pixmap, NULL);
  
  XpmCreatePixmapFromData(XtDisplay(opt_shell),
                          RootWindowOfScreen(XtScreen(opt_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(opt_shell, XtNiconPixmap, icon_pixmap, NULL);
  XpmCreatePixmapFromData(XtDisplay(chan_shell),
                          RootWindowOfScreen(XtScreen(chan_shell)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(chan_shell, XtNiconPixmap, icon_pixmap, NULL);
#endif

  /* commandes externes */
  init_socket();

  /* lirc support */
  if (debug)
	fprintf(stderr,"main: checking for lirc ...\n");
  if (-1 != (lirc = lirc_tv_init()))
	XtAppAddInput(app_context,lirc,(XtPointer)XtInputReadMask,lirc_input,NULL);

  if(doublekey==-1) doublekey=count>10;

  if(doublekey && doublekey_firstisone==-1) {
    if(eventmap_checkfirstisone())
      doublekey_firstisone=1;
    else
      doublekey_firstisone= (count && channels[0]->key &&
			     (strcmp(channels[0]->key,"KP_1")==0  ||
			      strcmp(channels[0]->key,"KP_End")==0 ||
			      strcmp(channels[0]->key,"1")==0 ||
			      strcmp(channels[0]->key,"ampersand")==0));
  }

  XtRealizeWidget (app_shell);
  create_pointers (app_shell);
  create_bitmaps (app_shell);
  XDefineCursor (dpy, XtWindow (app_shell), left_ptr);
  XSetWMProtocols (XtDisplay (app_shell), XtWindow (app_shell),
                   wm_protocols, 2);

  XtVaSetValues (app_shell,
                 XtNwidthInc, WIDTH_INC,
                 XtNheightInc, HEIGHT_INC,
                 XtNminWidth, WIDTH_INC, XtNminHeight, HEIGHT_INC, NULL);

  if (optind + 1 == argc)
    {
      for (i = 0; i < count; i++)
        if (0 == strcasecmp (channels[i]->name, argv[optind]))
          cur_sender = i;
    }
  
  if(force_capture == -1) {
    if(!grabbers[grabber]->grab_overlay)
      force_capture = CAPTURE_GRABDISPLAY;
    if(!grabbers[grabber]->get_img)
      force_capture = CAPTURE_OVERLAY;
  }

  if(force_capture != -1) defaults.capture = force_capture;

  if (count)
    {
      if(force_capture != -1)
	for (i = 0; i < count; i++)
	  channels[i]->capture = force_capture;

      if ((load_last_channel(&last_channel)) == 0)
        {
	  if(force_capture != -1) last_channel.capture = force_capture;
	  
          for (i = 0; i < count; i++)
            if (channels[i]->freq==last_channel.freq && 
		channels[i]->norm==last_channel.norm &&
		channels[i]->source==last_channel.source &&
		strcmp(channels[i]->name,last_channel.name)==0)
            {
              cur_sender = i;
              break;
            }

          //memcpy(channels[i], &last_channel, sizeof(struct CHANNEL));
          if ((cur_sender < 0) || (cur_sender >= count)) {
            cur_sender = 0;
	    fprintf(stderr,"Warning: last channel not in xdtvrc\n");
	  }
          else
            update_channel(channels[cur_sender],  &last_channel);
          set_channel (channels[cur_sender]);
          pixit();
        }
      else
        {
          if ((cur_sender < 0) || (cur_sender >= count))
            cur_sender = 0;
          set_channel (channels[cur_sender]);
        }
    }
  else
    {
      set_channel (&defaults);
    }

  // subtitles init...
  if(subactive) set_subtitles_pageno(cur_subpage);
  if(cur_subpage) set_subpage(cur_subpage);
  set_subactive(subactive);
    
  if (fullscreen)
  {
    FullScreenAction (NULL, NULL, NULL, NULL);
    decoration = 0 ;
  }
  else
    XtAppAddWorkProc (app_context, MyResize, NULL);
    
  if (nomouse)
    PointerAction (NULL, NULL, NULL, NULL);
   
//#ifdef USE_LIBXOSD <== xosd inside now
   if (libxosd && c_xosdaction)
     XtVaSetValues (c_xosdaction, XtNlabel, "Xosd             :      (On)     Ctrl+X", NULL);   
//#endif <== xosd inside now
        
  if (!have_config)
    XtCallActionProc (tv, "Help", NULL, NULL, 0);
  if(cmd && !idle_id) XtAppAddWorkProc (app_context, docmd, NULL);

  /* the audio thread can start here... */
  aop_init(aop_cmdline);
  
  plugin_init_actions();



  // decoration & stayontop init....
  set_stayontop(stay);  
  
  // deco init = problem with ffwm : NO SOLUTION ACTUALLY.
  // You have to use -nodecoinit at startup
  if (!nodecoinit)
    set_decoration(decoration);
  
   // if no window decoration requested,
   // the first OSD position is not in the window   
   if (decoration)
   {
     strcpy (title, modename);
     set_timer_title ();
   }
   else
     set_timer_title ();
    
  XtAppMainLoop (app_context);
  
  /* keep compiler happy */
  return 0;
}

/*----------------------------------------------------------------------*/
/*--- END main function ------------------------------------------------*/
/*----------------------------------------------------------------------*/

