#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "grab.h"
#include "strtab.h"
#include "vop.h"

#ifdef HAVE_BKTR
struct device_t device = {"/dev/bktr0", "/dev/vbi0", "/dev/tuner0"};
#else
#ifdef HAVE_DEVFS
struct device_t device = {"/dev/v4l/video", "/dev/v4l/vbi", NULL};
#else
struct device_t device = {"/dev/video", "/dev/vbi", NULL};
#endif
#endif

#ifdef HAVE_V4L
extern struct GRABBER grab_v4l;
extern struct GRABBER grab_v4l2;
#endif
extern struct GRABBER grab_dummy;
#ifdef HAVE_BKTR
extern struct GRABBER grab_bktr;
#endif
#ifdef HAVE_VIDEO_XV
extern struct GRABBER grab_xv;
#endif
extern struct GRABBER grab_avi;

struct GRABBER *grabbers[] = {
#ifdef HAVE_V4L
  &grab_v4l2,
  &grab_v4l,
#endif
#ifdef HAVE_BKTR
  &grab_bktr,
#endif
#ifdef HAVE_VIDEO_XV
  &grab_xv,
#endif
  // uncomment the following line to test without a TV-card
  &grab_dummy,
  &grab_avi,
};

video_fmt grab_prefered_fmt[MAX_VIDEO_FMT];
int grabber;

video_fmt grab_format=0;
int nbufs, img=0;
#if defined(HAVE_BKTR) && ! defined(HAVE_V4L)
int nbufs_default=1;
#else
int nbufs_default=3;
#endif
int vbifd = -1;
double videostampmin=0.0,videostampmax=0.0;


void forcegrabber(char *name) {
  int j;
  for(j=0;j<sizeof (grabbers) / sizeof (struct GRABBERS *);j++)
    if(grabbers[j] && strcmp(name, grabbers[j]->name))
      grabbers[j] = NULL;
}


void
grabber_init ()
{
  int fmt_available[MAX_VIDEO_FMT], i;
  for (grabber = 0;
       grabber < sizeof (grabbers) / sizeof (struct GRABBERS *); grabber++)
    {
      if (grabbers[grabber]!=NULL &&
	  -1 != grabbers[grabber]->grab_open(&device))
        break;
    }
  if (grabber == sizeof (grabbers) / sizeof (struct GRABBERS *))
    {
      fprintf (stderr, "@@@@ no video grabber device available\n");
#ifdef HAVE_V4L
      fprintf(stderr, "for v4l2, you need a recent driver, "
	      "see http://bytesex.org/v4l/\n");
#endif
#ifdef HAVE_VIDEO_XV
      fprintf(stderr, "for xvtv, you need an X driver for your TV-card\n"
	      "do 'man v4l' for a common installation\n");
#endif
      exit (1);
    }
  if(grabbers[grabber]==&grab_dummy)
    {
      fprintf(stderr, "no real video grabber device available\n");
      fprintf(stderr, "USE DUMMY DRIVER !\n");
    }
  fprintf(stderr, "*** GRABBER DEVICE TYPE = %s\n", grabbers[grabber]->name);

 /* Start sound acquisition */
  if (grabbers[grabber]->grab_audio)
    grabbers[grabber]->grab_audio (0, 65535, NULL);
  if(grabbers[grabber]->get_img) {
    for(i=1;i<MAX_VIDEO_FMT;i++)
      fmt_available[i]=grabbers[grabber]->fmt_available(i);
    if(grab_format && !fmt_available[grab_format]) {
      fprintf(stderr, "format %s non available on the card\n",
	      int_to_str (grab_format,video_fmt_names));
      exit(1);
    }
    if(grab_format)
      for(i=1;i<MAX_VIDEO_FMT;i++)
	grab_prefered_fmt[i]=grab_format;
    else {
      if(!setpreferred(fmt_available,grab_prefered_fmt)) {
	fprintf(stderr, "No available format on the card !!!\n");
	exit(1);
      }
      /* HI240 format gives a very good images
	 for lowdepth displays even monochrom !!*/
      for(i=1;i<MAX_VIDEO_FMT;i++)
	if((i==VIDEO_RGB03||i==VIDEO_GRAY4||i==VIDEO_GRAY1||
	    i==VIDEO_RGB04b||i==VIDEO_RGB08b||i==VIDEO_RGB08)&&
	   grab_prefered_fmt[i]!=i && fmt_available[VIDEO_HI240])
	  grab_prefered_fmt[i]=VIDEO_HI240;
      grab_format = grab_prefered_fmt[x11_pixmap_format];
    }
  } //end if(grabbers[grabber]->get_img)
}

void *get_image(video_fmt f, int width, int height){
  return get_image_vop(last_vop, f, width, height);
}

void *get_image_before_vop(video_fmt f, int width, int height){
  video_fmt f2;
  void *img;
  if(!grabbers[grabber]->get_img) return NULL;
  f2 = grab_prefered_fmt[f];
  img=grabbers[grabber]->get_img(f2,width,height);
  if(img==NULL) return NULL;
  return convert1(img,f2,f,width,height);
}


int get_image2(void *dest, video_fmt f, int width, int height) {
  return get_image2_vop(last_vop, dest, f, width, height);
}

int get_image2_before_vop(void *dest, video_fmt f, int width, int height) {
  video_fmt f2= grab_prefered_fmt[f];
  void *img;
  if(!grabbers[grabber]->get_img) return 0;
  img=grabbers[grabber]->get_img(f2,width,height);
  if(img==NULL) return 0;
  //void *img2=convert1(img,f2,VIDEO_GRAY1X,width,height);
  //convert2(img2,VIDEO_GRAY1X,dest,f,width,height); //to verify conversions...
  convert2(img,f2,dest,f,width,height);
  return 1;
}
