/*****************************************************************************
 * event.c: eventmap support
 *****************************************************************************
 * $Id: event.c,v 1.12 2004/09/08 21:03:48 alainjj Exp $
 *****************************************************************************
 *
 * (C) 2003 Lucian Langa eventmap support for xdtv
 * Lucian Langa <cooly@eweb.ro>
 * This software was based on xawtv. Those portions are
 * Copyright (C) 2000 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>
#include <errno.h>

#include "commands.h"

extern int debug;

#ifdef HAVE_LIBLIRC_CLIENT
# include <lirc/lirc_client.h>
#endif
#include "lirc.h"
#include "event.h"

/* ----------------------------------------------------------------------- */

static struct event_entry *event_conf_list = NULL;
static struct event_entry *event_builtin_list = NULL;

static void parse_action(struct event_entry *entry)
{
    char *token,*h;

    strcpy(entry->argbuf,entry->action);
    h = entry->argbuf;
    for (;;) {
	while (' ' == *h  ||  '\t' == *h)
	    h++;
	if ('\0' == *h)
	    break;
	if ('"' == *h) {
	    /* quoted string */
	    h++;
	    token = h;
	    while ('\0' != *h  &&  '"' != *h)
		h++;
	} else {
	    /* normal string */
	    token = h;
	    while ('\0' != *h  &&  ' ' != *h  &&  '\t' != *h)
		h++;
	}
	if ('\0' != *h) {
	    *h = 0;
	    h++;
	}
	entry->argv[entry->argc++] = token;
    }
}

int event_register(char *event, char *action, int repeat)
{
    struct event_entry *entry;

    entry = malloc(sizeof(*entry));
    memset(entry,0,sizeof(*entry));
    strncpy(entry->event,event,127);
    strncpy(entry->action,action,127);
    entry->repeat = repeat;
    entry->next = event_conf_list;
    event_conf_list = entry;
    parse_action(entry);
    if (debug)
	fprintf(stderr,"ev: reg conf \"%s\" => \"%s\" , repeat_rate=%d\n",
		entry->event,entry->action, entry->repeat);
    return 0;
}

int change_repeat_last_registered(int repeat) {
  if(event_conf_list==NULL) return -1;
  event_conf_list->repeat=repeat;
  if (debug)
	fprintf(stderr,"changing last mapped event to repeat_rate=%d\n", repeat);
  return 0;
}

int event_register_list(struct event_entry *entry)
{
    for (; NULL != entry &&  0 != entry->event[0]; entry++) {
	entry->next = event_builtin_list;
	event_builtin_list = entry;
	parse_action(entry);
	if (debug)
	    fprintf(stderr,"ev: reg built-in \"%s\" => \"%s\"\n",
		    entry->event,entry->action);
    }
    return 0;
}


int event_dispatch(char *event, int repeat)
{
    struct event_entry *entry = NULL;
    char *name,*arg,*h;

    /* parse */
    if (NULL != (h = strchr(event,'('))) {
	name = event;
	arg = h+1;
	*h = 0;
	if (NULL != (h = strchr(arg,')')))
	    *h = 0;
	if (debug)
	    fprintf(stderr,"ev: dispatch name=%s arg=%s\n",name,arg);
    } else {
	name = event;
	arg = NULL;
	if (debug)
	    fprintf(stderr,"ev: dispatch name=%s\n",name);
    }

    /* search lists */
    if (NULL == entry)
	for (entry = event_conf_list; NULL != entry; entry = entry->next)
	    if (0 == strcasecmp(name,entry->event))
		break;
    if (NULL == entry)
	for (entry = event_builtin_list; NULL != entry; entry = entry->next)
	    if (0 == strcasecmp(name,entry->event))
		break;
    if (NULL == entry) {
	if (debug)
	    fprintf(stderr,"ev: unknown: %s\n",name);
	return 0;
    }
    if (debug)
    {
		fprintf(stderr, "Event:%s do -> %s after %d button press\n", entry->event, entry->action, entry->repeat);
		fprintf(stderr, "repeat:%d\n", repeat);
    }
    if (entry->repeat == 0)
    {
	if (repeat == 0)
	    do_command(entry->action);
    }
    else if (0 == ((entry->repeat+1)*(repeat+1)%entry->repeat))
	do_command(entry->action);

    return 0;
}

void
save_user_events(FILE *fp)
{
	struct event_entry *entry = NULL;
	/* we only need to save user add/modified events */

        fprintf(fp, "#\n# eventmap\n#\n");

        if (NULL == event_conf_list)
	    return;

	for (entry = event_conf_list; NULL != entry; entry = entry->next)
	{
	    fprintf (fp, "%s = %s\n", entry->event, entry->action);
	    fprintf (fp, "repeat = %d\n", entry->repeat);
	}
	for (entry = event_builtin_list; NULL != entry; entry = entry->next)
		printf("built ev: %s\n", entry->event);
}

int eventmap_checkfirstisone(void) {
  struct event_entry *entry = NULL;
  for (entry = event_conf_list; NULL != entry; entry = entry->next)
    if(strcasecmp(entry->event,"lirc-key-1")==0 &&
       strncasecmp(entry->action,"keypad ",7)==0) {
      int n=atoi(entry->action+7);
      return n==0;
    }
  return 0;
}

