/*****************************************************************************
 * cpu_accel.c: MMX accelerated functions
 *****************************************************************************
 * $Id: cpu_accel.c,v 1.3 2004/04/04 18:39:53 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * This software is highly based on mpeg2dec. Those portions are
 * Copyright (C) 1999-2001 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>
 *
 * This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 *
 *****************************************************************************/
#include "config.h"

#include "cpu_accel.h"

#ifdef ARCH_X86
static uint32_t x86_accel (void)
{
    uint32_t eax, ebx, ecx, edx;
    int AMD;
    uint32_t caps;

	/* Slightly weirdified cpuid that preserves the ebx and edi required
	   by gcc for PIC offset table and frame pointer */

#define cpuid(op,eax,ebx,ecx,edx)	\
    asm ( "pushl %%ebx\n" \
	      "cpuid\n" \
	      "movl   %%ebx, %%esi\n" \
	      "popl   %%ebx\n"  \
	 : "=a" (eax),			\
	   "=S" (ebx),			\
	   "=c" (ecx),			\
	   "=d" (edx)			\
	 : "a" (op)			\
	 : "cc", "edi")

    asm ("pushfl\n\t"
	 "popl %0\n\t"
	 "movl %0,%1\n\t"
	 "xorl $0x200000,%0\n\t"
	 "pushl %0\n\t"
	 "popfl\n\t"
	 "pushfl\n\t"
	 "popl %0"
         : "=a" (eax),
	       "=c" (ecx)
	 :
	 : "cc");


    if (eax == ecx)		// no cpuid
	return 0;

    cpuid (0x00000000, eax, ebx, ecx, edx);
    if (!eax)			/* vendor string only */
	return 0;

    AMD = (ebx == 0x68747541) && (ecx == 0x444d4163) && (edx == 0x69746e65);

    cpuid (0x00000001, eax, ebx, ecx, edx);
    if (! (edx & 0x00800000))	/* no MMX */
	return 0;
    caps = MM_ACCEL_X86_MMX;

    if (edx & 0x02000000)	/* SSE - identical to AMD MMX extensions */
	caps |= MM_ACCEL_X86_SSE | MM_ACCEL_X86_MMXEXT;

    if (edx & 0x04000000)	/* SSE2 */
	caps |= MM_ACCEL_X86_SSE2;

    cpuid (0x80000000, eax, ebx, ecx, edx);
    if (eax < 0x80000001)	/* no extended capabilities */
	return caps;

    cpuid (0x80000001, eax, ebx, ecx, edx);

    if (edx & 0x80000000)	/* 3DNOW */
	caps |= MM_ACCEL_X86_3DNOW;

    if (edx & 0x40000000)	/* 3DNOWEXT */
	/*caps |= MM_ACCEL_X86_???*/ ;

    if (AMD && (edx & 0x00400000))	/* AMD MMX extensions */
	caps |= MM_ACCEL_X86_MMXEXT;

    return caps;
}
#endif

uint32_t mm_accel (void)
{
#ifdef ARCH_X86
    static int got_accel = 0;
    static uint32_t accel;

    if (!got_accel) {
	got_accel = 1;
	accel = x86_accel ();
    }

    return accel;
#else
#ifdef HAVE_MLIB
    return MM_ACCEL_MLIB;
#else
    return 0;
#endif
#endif
}

/*
uint32_t mm_support (void)
{
  return mm_accel();
}
*/
