/*****************************************************************************
 * $Id: audio-dummy.c,v 1.3 2004/11/04 21:34:41 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "config.h"
#include "audio.h"

static int sizefmt, freq;
static int dummyaudio_check(void) {
  return 1;
}

static int dummyaudio_open(int mode, int fmtsample, int nchannels, int freq0,
			   int nfrags, int fragsize) {
  if(fmtsample==AUDIO_U8) sizefmt=nchannels; else sizefmt=2*nchannels;
  freq=freq0;
  return 1;
}

static int dummyaudio_close(void) {
  return 0;
}

static int dummyaudio_read(void *r, int n) {
  usleep((unsigned int)(n*1000000LL/sizefmt/freq));
  memset(r, 0, n);
  return n;
}

static int dummyaudio_write(void *w, int n) {
  usleep((unsigned int)(n*1000000LL/sizefmt/freq));
  return n;
}

struct AUDRIVER audio_dummy = {
  "dummyaudio",
  dummyaudio_check,
  dummyaudio_open,
  dummyaudio_close,
  dummyaudio_read,
  dummyaudio_write,
};
