/*****************************************************************************
 * $Id: aop.h,v 1.6 2004/09/19 14:15:39 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/
#ifndef _XDTV_AOP_H_
#define _XDTV_AOP_H_

/* AUDIO OPERATIONS */

#include "audio.h"
typedef struct {
  char *name;
  int fmtsample; /* audio format */
  int nchannels; /* 1 for mono, 2 for stereo */
  int freq;      /* usually 44100 */
  /* treat_audio is the treatment function,
     l is usually aop_sizebuffer, but it can be less if
     the audio device is badly adjusted */
  void (*treat_audio)(unsigned char *dest, unsigned char *src, int l);
} aop;

typedef struct _aop2 {
  aop *a;
  unsigned char *dest_tmp;
  struct _aop2 *prev;
} aop2;

void aop_init(char *cmdline);
void activate_aop(char *name);
void deactivate_aop(char *name);
int toggle_aop(char *name);
void aop_register(aop *a);
int is_aop_running(void);
void aop_wait_write_audio(void);
void aop_close(void);
extern int aop_sizebuffer, debug;

#endif
