/*****************************************************************************
 * $Id: aop-common.c,v 1.12 2004/09/20 20:15:16 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <pthread.h>
#ifndef NOTHAVE_SEM 
#include <semaphore.h>
#endif
#include <sys/time.h>

#include "aop.h"
#include "divx.h"
#include "audio.h"
#include "memcpy.h"
#include "mixer.h"
extern int debug;
extern divx_t divx;

aop2 *last_aop=NULL;

extern void avi_audio_stop(void);
extern void avi_audio_start(void);
extern int avi_extract_audiobuf(void *);
extern struct GRABBER *grabbers[],grab_avi;
extern int grabber;
#ifndef NOTHAVE_SEM 
extern sem_t avi_sem;
#else
extern pthread_mutex_t *avi_mut_video;
#endif
static void *avibuf=NULL; // for avi
static int iavibuf,ravibuf;
static int nfrags=-1,fragsize=2048;
int aop_sizebuffer=3528;
unsigned char *buf=NULL;
static pthread_t aop_thread;
static pthread_mutex_t divx_mutex;
static int avi;
extern double audiostamp;

static int aop_running=0;
int is_aop_running(void) {
  return aop_running;
}

static int audio_read0(unsigned char *r, int l) {
  if(avi) {
    int size_buffer;
    unsigned char *m;
    if(iavibuf>=ravibuf) {
      ravibuf=avi_extract_audiobuf(avibuf);iavibuf=0;
    }
    size_buffer = ravibuf - iavibuf;
    if(size_buffer>l) size_buffer=l;
    m = avibuf+iavibuf;
    iavibuf += size_buffer;
    fast_memcpy(r,m,size_buffer); // BAD!
    return size_buffer;
  } else {
    int l2;
    struct timeval tv;
    l2=audio_read(r,l);
    gettimeofday (&tv, NULL);
    audiostamp=tv.tv_usec/1000000.0+tv.tv_sec;
    return l2;
  }
}

static int get_buffer2_aop(aop2 *a, void *dest, int l);
static unsigned char* get_buffer_aop(aop2 *a, int l, int *l2) {
  if(a==NULL) {
    *l2=audio_read0(buf, l);
    return buf;
  }
  a->dest_tmp=realloc(a->dest_tmp,l);
  *l2=get_buffer2_aop(a, a->dest_tmp,l);
  return a->dest_tmp;
}

static int get_buffer2_aop(aop2 *a, void *dest, int l) {
  unsigned char *src;
  int l2;
  if(a==NULL) return audio_read0(dest, l);
  src=get_buffer_aop(a->prev, l, &l2);
  a->a->treat_audio(dest, src, l2);
  return l2;
}


static void * aop_main (void *arg) {
  int freq=44100,nchannels=1,fmt=AUDIO_S16LE;
  pthread_setcancelstate(PTHREAD_CANCEL_DISABLE,NULL);
  buf=realloc(buf,aop_sizebuffer);
  if(last_aop) {
    freq=last_aop->a->freq;
    nchannels=last_aop->a->nchannels;
    fmt=last_aop->a->fmtsample;
  }
  if(avi) {
    avibuf=malloc(200000);iavibuf=0;ravibuf=0;
    audio_open(AUDIO_WO, fmt, nchannels, freq, nfrags, fragsize);
  } else
    audio_open(AUDIO_RW, fmt, nchannels, freq, nfrags, fragsize);
  while (1) {
    int l;
    unsigned char *s;
#ifdef _POSIX_THREAD_IS_GNU_PTH
    pthread_yield_np();
#endif
    s=get_buffer_aop(last_aop,aop_sizebuffer,&l);
    audio_write(s,l);
    pthread_mutex_lock(&divx_mutex);
    if (is_divx_in_progress()) {
      write_audio_to_avi((short*)s, l/2);
      if(last_aop && 
	 (last_aop->a->freq!=44100 || 
	  last_aop->a->nchannels!=(divx.stereo?2:1) ||
	  last_aop->a->fmtsample!=AUDIO_S16LE))
	fprintf(stderr, "AOP WARNING: converting audio format not implemented\n");
    }
    pthread_mutex_unlock(&divx_mutex);
    if(!avi) {
      pthread_setcancelstate(PTHREAD_CANCEL_ENABLE,NULL);
      pthread_testcancel ();
      pthread_setcancelstate(PTHREAD_CANCEL_DISABLE,NULL);
    }
  }
  return NULL;
}

static void audio_thread_start(void) {
  int ret;
  if(aop_running) return;
  avi=(grabbers[grabber] == &grab_avi);
  if(nfrags==-1) nfrags = avi ? 3 : 48;
  pthread_mutex_init (&divx_mutex, NULL);
  if(avi)
    avi_audio_stop();
  else if (is_divx_in_progress())
    divx_audio_stop();
  aop_running = 1;
  mixer_set_mode (MIXER_MODE_TV2PCM);
#ifdef _POSIX_THREAD_IS_GNU_PTH
  {
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    /* increase if you have a "**Pth** STACK OVERFLOW" */
    pthread_attr_setstacksize(&attr, 256*1024);
    ret = pthread_create (&aop_thread, &attr, aop_main, NULL);
    pthread_attr_destroy(&attr);
  }
#else
  ret = pthread_create (&aop_thread, NULL, aop_main, NULL);
#endif
  if (debug) fprintf(stderr, "aop thread started\n");
}

/* function run to quit properly */
void aop_close(void) {
  void *ret;
  if(!aop_running) return;
  pthread_cancel (aop_thread);
  if(grabbers[grabber] == &grab_avi)
#ifndef NOTHAVE_SEM
    sem_post(&avi_sem);
#else
  pthread_mutex_unlock(avi_mut_video);
#endif
  pthread_join (aop_thread, &ret);
  audio_close();
  mixer_set_mode(MIXER_MODE_TVLINE);
}

static void audio_thread_stop(void) {
  if(!aop_running) return;
  aop_close();
  if(grabbers[grabber] == &grab_avi)
    avi_audio_start();
  else if(is_divx_in_progress())
    divx_audio_start();
  if(avibuf) {free(avibuf);avibuf=NULL;}
  pthread_mutex_destroy(&divx_mutex);
  aop_running=0;
}

void aop_wait_write_audio(void) {
  pthread_mutex_lock(&divx_mutex);
  pthread_mutex_unlock(&divx_mutex);
}

static aop2 *add_aop(aop *a) {
  aop2 *a2=malloc(sizeof(aop2));
  audio_thread_stop();
  if(last_aop!=NULL) {
    if(last_aop->a->fmtsample != a->fmtsample ||
       last_aop->a->nchannels != a->nchannels ||
       last_aop->a->freq != a->freq) {
      fprintf(stderr,"WARNING combining AOP with different formats"
	      "is NOT implemented\n");
      //exit(1);
    }
  }
  a2->a=a;
  a2->prev = last_aop;
  a2->dest_tmp = NULL;
  last_aop=a2;
  audio_thread_start();
  return a2;
}

static void sup_aop(aop2 *a) {
  audio_thread_stop();
  if(a->dest_tmp) free(a->dest_tmp);
  if(a==last_aop) 
    last_aop=a->prev;
  else {
    aop2 *a2=last_aop;
    while(a2!=NULL && a2->prev!=a) a2=a2->prev;
    if(a2!=NULL) a2->prev=a->prev;
  }
  free(a);
  if(last_aop!=NULL) audio_thread_start();
}


static struct _aopregistered {
  aop *a;
  struct _aopregistered *prev;
} *aops = NULL;

void aop_register(aop *a) {
  struct _aopregistered *a2=malloc(sizeof(struct _aopregistered));
  a2->prev=aops;
  a2->a=a;
  aops=a2;
}


extern aop aop_copy;
extern aop aop_demo;
void aop_init(char *cmdline) {
  char *tok,*ctok;
  aop_register(&aop_copy);
  aop_register(&aop_demo);
  if(!cmdline) return;
  cmdline=strdup(cmdline);
  if(cmdline==NULL) return;
  tok= strtok_r(cmdline, ":",&ctok);
  while(tok!=NULL) {
    activate_aop(tok);
    tok=strtok_r(NULL,":",&ctok);
  }
  free(cmdline);
  
  if(debug) {
    aop2 *a=last_aop;
    fprintf(stderr, "VIDEO_OPERATIONS : ");
    while(a!=NULL) {
      fprintf(stderr, "%s ",a->a->name);
      a=a->prev;
    }
    fprintf(stderr,"\n");
  }
}

static aop2 *aop_running_byname(char *name) {
  aop2 *a=last_aop;
  while(a!=NULL && strcmp(a->a->name,name)) a=a->prev;
  return a;
}

static aop *aop_registered_byname(char *name) {
  struct _aopregistered *a=aops;
  while(a!=NULL && strcmp(a->a->name,name)) a=a->prev;
  if(a==NULL) return NULL; else return a->a;
}

int toggle_aop(char *name) {
  aop *a0;
  aop2 *a=aop_running_byname(name);
  if(a!=NULL) {sup_aop(a); return 1;}
  a0=aop_registered_byname(name);
  if(a0!=NULL) {add_aop(a0); return 2;}
  fprintf(stderr, "*** WARNING no aop %s registered\n", name);
  return 0;
}

void activate_aop(char *name) {
  aop *a0;
  aop2 *a=aop_running_byname(name);
  if(a!=NULL) return;
  a0=aop_registered_byname(name);
  if(a0!=NULL) {add_aop(a0); return;}
  fprintf(stderr, "*** WARNING no aop %s registered\n", name);
}

void deactivate_aop(char *name) {
  aop2 *a=aop_running_byname(name);
  if(a!=NULL) sup_aop(a);
}
