(define (simple-pixmap-generator width 
			  height
			  text
			  size
			  font
			  active
			  font_color_1
			  light-active
			  dark-active
			  font_color_0
			  light-inactive
			  dark-inactive)
  (gimp-palette-set-foreground '(0 0 0))
  (let* ((new-image (car (gimp-image-new width height RGB)))
	(menu_shadow (car (gimp-text-fontname new-image -1 0 0 text -1 1 size 0 font)))
	(layer0 (car (gimp-layer-new new-image width height RGBA-IMAGE "Blend" 100 NORMAL-MODE)))
	(text-width (car (gimp-drawable-width menu_shadow)))
	(text-height (car (gimp-drawable-height menu_shadow)))
	(text-offset-x (/ (- width text-width) 2))
	(text-offset-y (- (/ (- height text-height) 2) 1)))
	(if (= active TRUE)
	(gimp-palette-set-foreground font_color_1)
	(gimp-palette-set-foreground font_color_0))
	(set! menu_title (car (gimp-text-fontname new-image -1 0 0 text -1 1 size 0 font)))
	(gimp-image-resize new-image width height 0 0)
	(gimp-image-add-layer new-image layer0 3)
	(gimp-layer-set-offsets menu_title text-offset-x text-offset-y)
	(gimp-layer-set-offsets menu_shadow (+ text-offset-x 1) (+ text-offset-y 1))
;	(plug-in-blur 1 new-image menu_shadow)
	(if (= active TRUE)
	(gimp-palette-set-foreground light-active)
	(gimp-palette-set-foreground light-inactive))
	(if (= active FALSE)
	(gimp-palette-set-background dark-inactive)
	(gimp-palette-set-background dark-active))
	(gimp-edit-blend layer0 FG-BG-RGB-MODE NORMAL-MODE GRADIENT-LINEAR 100 0 REPEAT-NONE FALSE FALSE 0 0 TRUE 0 0 0 (- height 1))
	(gimp-display-new new-image)
	(gimp-image-set-filename new-image "menu.xpm")
  ))
(script-fu-register "simple-pixmap-generator"
		    _"<Toolbox>/Xtns/Script-Fu/XdTv/Simple Menu maker..."
		    "Generate menu pixmaps for XdTv (without logo)"
		    "BlindMan"
		    "BlindMan"
		    "2004"
		    ""
		    SF-ADJUSTMENT _"Menu width" '(300 30 500 1 10 0 0)
		    SF-ADJUSTMENT _"Menu height" '(20 10 300 1 10 0 0)
		    SF-STRING     _"Text" "Menu XdTv"
		    SF-ADJUSTMENT _"Font size (pixels)" '(11 10 25 1 3 0 1)
		    SF-FONT       _"Font" "Tahoma Bold"
		    SF-TOGGLE     _"Active Menu" TRUE
		    SF-COLOR      _"Active Text Color" '(255 239 64)
		    SF-COLOR      _"Light Active Color" '(68 104 174)
		    SF-COLOR      _"Dark Active Color" '(0 51 146)
		    SF-COLOR      _"Inactive Text Color" '(255 252 216)
		    SF-COLOR      _"Light Inactive Color" '(178 178 178)
		    SF-COLOR      _"Dark Inactive Color" '(112 112 112))
