#!/usr/bin/perl -w
#
#	this script is designed to take a standard xmms .m3u playlist
#	where the format is /path/to/your_artist/album/trackname.mp3
#	and output a list of paths for x-cd-record where the format is
# 	different, but will result in your playlist getting burned to 
#	cd still in mp3 format but with the name of the mp3 file 
#	changed to be nnn_artist_trackname.mp3, with all files in the
#	root dir of the cd's filesystem.
#
#	note that this is kind of an in-between translator type thing
#	and just parses one file format into another.  no actual file
#	moving or copying or burning will take place as a result of 
#	running this script.  You'll still have to use x-cd-record to 
#	open the file and acutally master the tracks/burn the cd
#
#	usage:  xm2cd.pl <xmms.m3u> <xcdrecord.lst>
#	where the .m3u file is a standard xmms trask listing, and 
#	xcdrecord.lst is the name of the track list you want to write 
#	it to (doesn't need to exist before the script is run)
#
#	everything else should just work
#
#	by Steve Glista <smiley@fish.malachiarts.org>
#
#

use strict;
use vars qw($DEBUGGING $done_headers);

# Configuration
#

# this should be an xmms playlist
my $playlist = $ARGV[0];

# and this should come out looking like a saved master track project
# be sure to leave the > so when you open the file you can write to it
my $burnlist = "\>$ARGV[1]";

# End configuration
#
#
# the working bits:
# 

# first, open the m3u playlist
open(INPATHS, $playlist)
  or die "Can't open $playlist: $!\n";

## store all lines 
my @paths = <INPATHS>;

## close file cause we don't need it anymore
close(INPATHS);

## open the output file
open(OUTPATHS, $burnlist)
  or die "Can't open $burnlist: $!\n";

## loop the part that does the actual work
foreach my $i (0..@paths-1) {
	my $chompath= $paths[$i];
	chomp $chompath;
	my @trackpath = split /\//, $chompath;
	my $trackname = "$trackpath[3]___$trackpath[5]";
	print OUTPATHS "ADD2 = \"$chompath\"\,\"\/"; 
	printf OUTPATHS ("%03d", $i+1); 
	print OUTPATHS "_$trackname\"\n";
};

close OUTPATHS;
