// -*- mode:C++ ; compile-command: "g++ -I.. -g -c plotfltk.cc" -*-
#ifndef _PLOTFLTK_H
#define _PLOTFLTK_H
#include "first.h"
#include "plot.h"
#include <fstream>
#include <FL/Fl_Menu.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Text_Buffer.H>
#include <FL/Fl_Text_Editor.H>
#ifdef HAVE_LC_MESSAGES
#include <locale.h>
#endif
#include "libintl.h"

#ifndef NO_NAMESPACE_GIAC
namespace giac {
#endif // ndef NO_NAMESPACE_GIAC

#ifdef HAVE_LIBFLTK
  extern int xcas_user_level;
  void set_xcas_user_level(int i);
  std::string cas_recalc_name();
  void swap_io_hist();
  void ckuser_screen();
  // declared here because fluid doesn't strings
  extern std::vector<int> history_endlines,history_positions;
  extern std::string current_program,save_input_value,save_matrix_input_value; 
  vecteur fl_menu2rpn_menu(Fl_Menu_Item * & m);
  extern vecteur undo_history_in,undo_history_out;
  void modify_history();
  void nextfl_menu(Fl_Menu_Item * & m);
  void change_group_fontsize(Fl_Group * g,int labelfontsize);
  void change_button_fontsize(int labelfontsize);
  void change_menu_fontsize(Fl_Menu_Item * m,int n,int labelfontsize);
  extern int old_upper_window_state;
  extern std::vector<int> current_upper_window;
  extern bool waiting_click,horizontal_split;
  extern gen waiting_click_value;
  extern int xcas_output_fontsize,Help_text_fontsize;

  // user_screen==true if display IO screen and non-interactive graph
  // ==false if display history and interactive geo/functions graph
  extern gen save_eqw_data;

  std::string cut_help(const std::string & s,int fontsize,int w);
  void input_before_selected_after(std::string & b,std::string & s,std::string & t);
  gen fltk_input(const gen &,GIAC_CONTEXT0);
  gen fltk_inputform(const gen & args);
  gen fltk_interactive(const gen &);
  class Image:public Fl_Window {
    virtual FL_EXPORT void draw();
    virtual FL_EXPORT int handle(int);
  public:
    FL_EXPORT void Image::resize_halfscreen();
    FL_EXPORT void Image::resize_fullscreen();
    vecteur * plot_instructions_ptr;
    std::vector<int> selected; // all items selected in plot_instructions
    int history_position; // selection front position in history
    std::string debut; // begin string when dragging selection
    gen debut_gen;
    int x_push,y_push,current_x,current_y; // position of mouse click
    int dx,dy; // absolute screen position of Image
    int npixels; // max # of pixels distance for click
    bool fullscreen;
    bool run_plot_view;
    std::string * autoname;
    bool moving;
    bool red_draw;
    bool embedded;
    vecteur parameters;
    int push_in_legende; 
    int deltax,deltay; // all data draw will be shifted from deltax and deltay
    double window_xmin,window_xmax,window_ymin,window_ymax;
    std::vector<logo_turtle> * turtleptr;
    int turtlex,turtley; // Turtle translate
    double turtlezoom; // Zoom factor for turtle screen
#ifdef IPAQ
    Image::Image(int x, int y, int w, int h, const char* l,int my_dx,int my_dy) : npixels(10),moving(false),fullscreen(false),x_push(0),y_push(0),current_x(0),current_y(0),run_plot_view(false),Fl_Window(x, y, w, h, l),dx(my_dx),dy(my_dy),plot_instructions_ptr(&plot_instructions),autoname(&PICTautoname),red_draw(false),embedded(false),push_in_legende(-1),deltax(0),deltay(0),window_xmin(global_window_xmin),window_xmax(global_window_xmax),window_ymin(global_window_ymin),window_ymax(global_window_ymax),turtleptr(0),turtlex(0),turtley(0),turtlezoom(1) { color(FL_WHITE); };
    Image::Image(int x, int y, int w, int h, const char* l) : npixels(10),moving(false),fullscreen(false),x_push(0),y_push(0),current_x(0),current_y(0),run_plot_view(false),Fl_Window(x, y, w, h, l),dx(0),dy(0),plot_instructions_ptr(&plot_instructions),autoname(&PICTautoname),red_draw(false),embedded(false),push_in_legende(-1),deltax(0),deltay(0),window_xmin(global_window_xmin),window_xmax(global_window_xmax),window_ymin(global_window_ymin),window_ymax(global_window_ymax),turtleptr(0),turtlex(0),turtley(0),turtlezoom(1) { color(FL_WHITE); };
#else
    Image::Image(int x, int y, int w, int h, const char* l,int my_dx,int my_dy) : npixels(5),moving(false),fullscreen(false),x_push(0),y_push(0),current_x(0),current_y(0),run_plot_view(false),Fl_Window(x, y, w, h, l),dx(my_dx),dy(my_dy),plot_instructions_ptr(&plot_instructions),autoname(&PICTautoname),red_draw(false),embedded(false),push_in_legende(-1),deltax(0),deltay(0),window_xmin(global_window_xmin),window_xmax(global_window_xmax),window_ymin(global_window_ymin),window_ymax(global_window_ymax),turtleptr(0),turtlex(0),turtley(0),turtlezoom(1) { color(FL_WHITE); };
    Image::Image(int x, int y, int w, int h, const char* l) : npixels(5),moving(false),fullscreen(false),x_push(0),y_push(0),current_x(0),current_y(0),run_plot_view(false),Fl_Window(x, y, w, h, l),dx(0),dy(0),plot_instructions_ptr(&plot_instructions),autoname(&PICTautoname),red_draw(false),embedded(false),push_in_legende(-1),deltax(0),deltay(0),window_xmin(global_window_xmin),window_xmax(global_window_xmax),window_ymin(global_window_ymin),window_ymax(global_window_ymax),turtleptr(0),turtlex(0),turtley(0),turtlezoom(1) { color(FL_WHITE); };
#endif
    void add(const gen & e);
    void add(const vecteur & v);
    void clear(){ plot_instructions.clear(); }
    void geo_zoom(double d);
    void findij(const gen & e0,double x_scale,double y_scale,int & i0,int & j0);
  };
  //  extern Image * Picture;
  enum upper_window_state_list {
    upper_window_hist=0,
    upper_window_geo=1,
    upper_window_mtrw=2,
    upper_window_prog=3,
    upper_window_cas_setup=4,
    upper_window_geo_setup=5,
    upper_window_gen_setup=6,
    upper_window_eqw=7,
    upper_window_help=8,
    upper_window_debug=9,
    upper_window_full_message=10
  };

  void handle_backspace();
  void erase_history_levels();
  void xcas_history_select(int h);
  void gnuplot_fltk(); // interface to drive gnuplot in 3D
  gen makeform(const vecteur & v); // interface for inputforms
  gen fltk_widget_size(const gen & g);
  gen fltk_keyboard(const gen & g);
  gen fltk_current_sheet(const gen & g);
  bool thesheetsort(const gen & a,const gen &b);
  gen fltk_Row(const gen & g);
  gen fltk_Col(const gen & g);
  gen fltk_xyztrange(const gen & g);
  std::ostream & fltk_fl_widget_archive_function(std::ostream & os,void * ptr);
  gen fltk_fl_widget_unarchive_function(std::istream & os,const vecteur & l);
  std::string fltk_fl_widget_texprint_function(void * ptr);
  gen fltk_fl_widget_updatepict_function(const gen &g);

  void Picture2global_window();
  // If an auto-recovery file is found in s directory, returns true
  // and sets newest to the filename
  bool has_autorecover_data(const std::string & s,std::string & newest);

  extern bool interrupt_button;

  void plotfltk_readqueue();
  void help_fltk(const std::string & s);
  void  style_init(Fl_Text_Buffer * textbuf ) ;
  void  style_update(int        pos,		// I - Position of update
	       int        nInserted,	// I - Number of inserted chars
	       int        nDeleted,	// I - Number of deleted chars
	       int        /*nRestyled*/,	// I - Number of restyled chars
	       const char * /*deletedText*/,// I - Text that was deleted
	       void       *cbArg) ;
  void style_unfinished_cb(int, void*);
  extern Fl_Text_Buffer     *stylebuf ;
  extern Fl_Text_Display::Style_Table_Entry styletable[7] ;
  extern bool editor_changed;
  void Editor_changed_cb(int, int nInserted, int nDeleted,int, const char*, void* v);
  // Check that g is one of the following form
  // col1,col2...coln
  // cell1..row,col2,...,coln
  // return the corresponding submatrix of m in mselect
  bool iscell_range(const gen & g,const matrice & m,matrice & mselect,void * ptr=0);
  std::string current_sheet_string(); // return current spreadsheet selection
#endif // HAVE_LIBFLTK

#ifndef NO_NAMESPACE_GIAC
} // namespace giac
#endif // ndef NO_NAMESPACE_GIAC

#endif // _PLOTFLTK_H
