#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qdatetime.h>
#include <qapplication.h>
#ifdef QWS
#include <qdirectpainter_qws.h>
#endif
#include "perf.h"


uint qrnd_val = 1;

QRect perf_rect;
QWidget  *perf_widget;
QPainter *perf_painter;
int  perf_width;
int  perf_height;
int  perf_numcolors;
QColor perf_colors[PERF_MAXCOLORS];

uchar *membuf = 0;
#define MEMBUFSIZE 1024

#ifdef QWS
uchar *perf_fbmem;
#endif


PerfClipping perf_clip = ClipNone;


int perf_qrnd()
{
    int i;
    for ( i=0; i<100000; i++ ) {
	qrnd(640);
	qrnd(48);
    }
    return i*2;
}


int perf_drawpoint()
{
    int i;
    for ( i=0; i<500; i++ ) {
	int x = qrnd(perf_width);
	int y = qrnd(perf_height);
	if ( perf_numcolors > 1 ) {
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	}
	perf_painter->drawPoint( x, y );
    }
    return i;
}


int perf_drawline()
{
    int i;
    for ( i=0; i<500; i++ ) {
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	perf_painter->drawLine( qrnd(perf_width), qrnd(perf_height),
				qrnd(perf_width), qrnd(perf_height) );
    }
    return i;
}

int perf_drawvline()
{
    int i;
    for ( i=0; i<500; i++ ) {
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	int xp = qrnd(perf_width);
	perf_painter->drawLine( xp, qrnd(perf_height),
				xp, qrnd(perf_height) );
    }
    return i;
}


int perf_drawhline()
{
    int i;
    for ( i=0; i<500; i++ ) {
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	int yp = qrnd(perf_height);
	perf_painter->drawLine( qrnd(perf_width), yp,
				qrnd(perf_width), yp);
    }
    return i;
}

int perf_drawrect()
{
    int i;
    for ( i=0; i<500; i++ ) {
	int x = qrnd(perf_width)  - 100;
	int y = qrnd(perf_height) - 100;
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	perf_painter->drawRect( x, y, 100, 100 );
    }
    return i;
}


int perf_fillrect()
{
    int i;
    perf_painter->setPen( Qt::NoPen );
    perf_painter->setBrush( Qt::white );
    for ( i=0; i<500; i++ ) {
	if ( perf_numcolors > 1 )
	    perf_painter->setBrush( perf_colors[qrnd(perf_numcolors)] );
	perf_painter->drawRect( qrnd(perf_width)-100, qrnd(perf_height)-100,
				100, 100 );
    }
    return i;
}


int perf_drawtext()
{
    int i;
    const char text[] = "Hello, world";
    for ( i=0; i<500; i++ ) {
	int x = qrnd(perf_width) - 50;
	int y = qrnd(perf_height);
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	perf_painter->drawText( x, y, 50, 20, Qt::AlignHCenter | Qt::AlignVCenter,
				text );
    }
    return i;
}


int perf_fasttext()
{
    int i;
    const char text[] = "Hello, world";
    for ( i=0; i<500; i++ ) {
	int x = qrnd(perf_width) - 50;
	int y = qrnd(perf_height);
	if ( perf_numcolors > 1 )
	    perf_painter->setPen( perf_colors[qrnd(perf_numcolors)] );
	perf_painter->drawText( x, y, text );
    }
    return i;
}


int perf_bitblt()
{
#define PIXMAP_WIDTH 32
#define PIXMAP_HEIGHT 20
    // create two pixmaps, one red and one blue
    QPixmap pm1( PIXMAP_WIDTH, PIXMAP_HEIGHT );
    QPixmap pm2( PIXMAP_WIDTH, PIXMAP_HEIGHT );
    pm1.fill(Qt::red);
    pm2.fill(Qt::blue);

    int i;
    for ( i=0; i<500; i++ ) {
	bitBlt( perf_widget,
		qrnd(perf_width-PIXMAP_WIDTH),
		qrnd(perf_height-PIXMAP_HEIGHT),
		(i & 1) ? &pm1 : &pm2 );
    }
    return i;
}


int perf_bitblt2()
{
#define PIXMAP_WIDTH 32
#define PIXMAP_HEIGHT 20
    // create two pixmaps, one red and one blue
    QPixmap pm1( PIXMAP_WIDTH, PIXMAP_HEIGHT );
    QPixmap pm2( PIXMAP_WIDTH, PIXMAP_HEIGHT );
    pm1.fill(Qt::red);
    pm2.fill(Qt::blue);

    int i;
    for ( i=0; i<500; i++ ) {
	perf_painter->drawPixmap(
		qrnd(perf_width-PIXMAP_WIDTH),
		qrnd(perf_height-PIXMAP_HEIGHT),
		(i & 1) ? pm1 : pm2 );
    }
    return i;
}

int perf_scrollvert()
{
    int i;
    int amt = perf_height/8;
    for (i = 0; i < 500; i++) {
	perf_widget->scroll(0, (i&1) ? amt : -amt);
    }

    return i;
}

int perf_scrollhorz()
{
    int i;
    int amt = perf_width/8;
    for (i = 0; i < 500; i++) {
	perf_widget->scroll((i&1) ? amt : -amt, 0);
    }

    return i;
}


int perf_paintersetup()
{
    perf_painter->end();
    int i;
    for ( i=0; i<500; i++ ) {
#if 0
	perf_painter->begin( perf_widget );
	perf_painter->end();
#else
	QPainter p;
	p.begin( perf_widget );
	p.end();
#endif
    }
    perf_painter->begin( perf_widget );
    return i;
}


int perf_newdelete()
{
    int tmp = qrnd_val;
    qrnd_val = 2011;
    typedef char *pchar;
#define ARRAY_LEN 100
    pchar array[ARRAY_LEN];
    int i, j, s = 0;
    for (j=0; j<ARRAY_LEN; j++ ) {
	array[j] = new char[2+qrnd(20)];
	s++;
    }
    for ( i=0; i<2000; i++ ) {
	j = qrnd(ARRAY_LEN);
	if ( array[j] ) {
	    delete array[j];
	    array[j] = 0;
	    s++;
	} else {
	    array[j] = new char[2+qrnd(20)];
	    s++;
	}
    }
    for (j=0; j<ARRAY_LEN; j++ ) {
	if ( array[j] ) {
	    delete array[j];
	    s++;
	}
    }
    qrnd_val = tmp;
    return s;
}


int perf_memaccess()
{
    int i;
    for ( i=0; i<1000; i++ ) {
	int n = MEMBUFSIZE - 1;
	uchar *p = membuf+1;
	while ( n-- ) {
	    *p = p[-1] + 1;
	    p++;
	}
    }
    return i;
}


#ifdef QWS
int perf_fbmemaccess()
{
    int i;
    for ( i=0; i<1000; i++ ) {
	int n = MEMBUFSIZE - 1;
	uchar *p = perf_fbmem+1;
	while ( n-- ) {
	    *p = p[-1] + 1;
	    p++;
	}
    }
    return i;
}
#endif


PERF_BEGIN
PERF_ENTRY(drawpoint, "QPainter::drawPoint")
PERF_ENTRY(drawline, "QPainter::drawLine")
PERF_ENTRY(drawvline, "QPainter::drawLine - vertical")
PERF_ENTRY(drawhline, "QPainter::drawLine - horizontal")
PERF_ENTRY(drawrect, "QPainter::drawRect")
PERF_ENTRY(fillrect, "QPainter::fillRect")
PERF_ENTRY(drawtext, "QPainter::drawText - aligned")
PERF_ENTRY(fasttext, "QPainter::drawText - simple")
PERF_ENTRY(bitblt, "QPaintDevice::bitBlt")
PERF_ENTRY(bitblt2, "QPainter::drawPixmap")
PERF_ENTRY(paintersetup, "QPainter::begin")
PERF_ENTRY(scrollvert, "QWidget::scroll - vertical")
PERF_ENTRY(scrollhorz, "QWidget::scroll - horizontal")
PERF_ENTRY(newdelete, "Memory alloc: new/delete")
PERF_ENTRY(memaccess, "Memory access")
#ifdef QWS
PERF_ENTRY(fbmemaccess, "Framebuffer memory access")
#endif
PERF_END


int perf_arraylen = -1;

QString perf_message;

void perf_init()
{
    perf_arraylen = 0;
    while ( perf_array[perf_arraylen].func )
	perf_arraylen++;
    perf_message = "";
    perf_numcolors = 1024;
    membuf = new uchar[MEMBUFSIZE];
    int i;
    for ( i=0; i<MEMBUFSIZE; i++ )
	membuf[i] = i & 0xff;
#ifdef QWS
    QDirectPainter p(QApplication::desktop());
    perf_fbmem = p.frameBuffer();
#endif
}

int perf_count()
{
    return perf_arraylen;
}

const char *perf_name( int i )
{
    return perf_array[i].name;
}

perf_func_t perf_func( int i )
{
    return perf_array[i].func;
}

bool perf_run( int i )
{
    return perf_array[i].run;
}

void perf_set_run( int i, bool run )
{
    perf_array[i].run = run;
}


void perf_runall()
{
    QString buf;
    buf.sprintf("Display: %dx%d %dbpp\n", perf_width, perf_height, QPixmap::defaultDepth());
    perf_message = buf;	    
    int i, perf_index = 0;
    perf_colors[0] = QColor(0,0,0);
    perf_colors[1] = QColor(255,255,255);
    for ( i=2; i<perf_numcolors; i++ ) {
	int r = qrnd(255), g=qrnd(255), b=qrnd(255);
	perf_colors[i] = QColor(r,g,b);
    }
    QRegion rgn;
    if ( perf_clip != ClipNone ) {
	int x, y, w, h;
	if ( perf_clip == ClipRect || perf_clip == ClipRects ) {
	    x = 20;
	    y = 30;
	    w = perf_width  - x*2;
	    h = perf_height - y*2;
	    rgn = QRegion( x, y, perf_width-2*x, perf_height-2*y );
	}
	if ( perf_clip == ClipRects ) {	    // combine with another rect
	    x = perf_width/2;
	    y = perf_height/2;
	    rgn = rgn.subtract( QRegion(x,y,perf_width,perf_height) );
	}
#ifdef QWS
	if ( perf_clip == RawFB )
	    perf_painter = new QDirectPainter(perf_widget);
#endif
    }
    if ( !rgn.isNull() )
	perf_painter->setClipRegion( rgn );
    for ( perf_index = 0; perf_index<perf_arraylen; perf_index++ ) {
	if ( perf_array[perf_index].run ) {
	    QTime dt;
	    int t;
	    dt.start();
	    i = 0;
	    while ( TRUE ) {
		i += (*perf_array[perf_index].func)();
		t = dt.elapsed();
		if ( t >= 4000 )
		    break;
	    }
    	    if ( t == 0 )
		i = -999999999;
	    else if ( i > 2000000 )		// avoid overflow
		i = (i/t)*1000;
	    else
		i = (i*1000)/t;
	    buf.sprintf( "%-12s %10d/sec\n", perf_array[perf_index].name, i );
	    perf_message += buf;	    
	}
    }
    if ( !rgn.isNull() ) {
	perf_painter->setClipping( FALSE );
    }
    perf_painter->fillRect( perf_rect, Qt::white );
#ifdef QWS
    if ( perf_clip == RawFB )
	delete perf_painter;
#endif
    perf_message += "QtPerf Completed\n";
}
