/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the painting module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QIMAGEFORMATPLUGIN_H
#define QIMAGEFORMATPLUGIN_H

#include "qplugin.h"
#include "qfactoryinterface.h"

class QImageFormat;
class QImage;
class QStringList;
class QString;

struct Q_GUI_EXPORT QImageFormatInterface : public QFactoryInterface
{
    virtual bool loadImage(const QString &format, const QString &filename, QImage *) = 0;
    virtual bool saveImage(const QString &format, const QString &filename, const QImage &) = 0;

    virtual bool installIOHandler(const QString &) = 0;
};

Q_DECLARE_INTERFACE(QImageFormatInterface, "http://trolltech.com/Qt/QImageFormatInterface")

#ifndef QT_NO_IMAGEFORMATPLUGIN
class Q_GUI_EXPORT QImageFormatPlugin : public QObject, public QImageFormatInterface
{
    Q_OBJECT
    Q_INTERFACES(QImageFormatInterface:QFactoryInterface)
public:
    QImageFormatPlugin(QObject *parent = 0);
    ~QImageFormatPlugin();

    virtual QStringList keys() const = 0;
    virtual bool loadImage(const QString &format, const QString &filename, QImage *image);
    virtual bool saveImage(const QString &format, const QString &filename, const QImage &image);
    virtual bool installIOHandler(const QString &format) = 0;

};
#endif // QT_NO_IMAGEFORMATPLUGIN
#endif // QIMAGEFORMATPLUGIN_H
