/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the porting application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef RULESFROMXML_H
#define RULESFROMXML_H

#include "qtsimplexml.h"
#include "tokenreplacements.h"
#include <QList>
#include <QStringList>

class QStringList;
class RulesFromXml
{
public:
    enum QtVersion{Qt3, Qt4};
    RulesFromXml(QString xmlFilePath);
    QList<TokenReplacement*> getNoPreprocessPortingTokenRules();
    QStringList getHeaderList(QtVersion qtVersion);
    QStringList getNeededHeaderList();
private:
    QtSimpleXml xml;
        
    bool isParsed;
    QList<TokenReplacement*> tokenRules;
    QStringList qt3Headers;
    QStringList qt4Headers;
    QStringList neededHeaders;
    QStringList inheritsQtClass;
    void parseXml();    
};

#endif
