/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDESIGNER_RESOURCE_H
#define QDESIGNER_RESOURCE_H

#include "formeditor_global.h"

#include <resource.h>

#include <QHash>
#include <QStack>

class DomCustomWidgets;

class FormWindow;
class AbstractFormEditor;

class QDesignerTabWidget;
class QDesignerStackedWidget;
class QDesignerToolBox;
class QLayoutWidget;
struct IContainer;
struct AbstractWidgetDataBaseItem;

class QT_FORMEDITOR_EXPORT QDesignerResource : public Resource
{
public:
    QDesignerResource(FormWindow *fw);
    virtual ~QDesignerResource();

    void copy(QIODevice *dev, const QList<QWidget*> &selection);
    DomUI *copy(const QList<QWidget*> &selection);
    QList<QWidget*> paste(DomUI *ui, QWidget *parentWidget);
    QList<QWidget*> paste(QIODevice *dev, QWidget *parentWidget);

protected:
    virtual QWidget *create(DomUI *ui, QWidget *parentWidget);
    virtual QWidget *create(DomWidget *ui_widget, QWidget *parentWidget);
    virtual QLayout *create(DomLayout *ui_layout, QLayout *layout, QWidget *parentWidget);
    virtual QLayoutItem *create(DomLayoutItem *ui_layoutItem, QLayout *layout, QWidget *parentWidget);
    virtual void applyProperties(QObject *o, const QList<DomProperty*> &properties);
    virtual QList<DomProperty*> computeProperties(QObject *obj);
    virtual DomProperty *createProperty(QObject *object, const QString &propertyName, const QVariant &value);

    virtual QWidget *createWidget(const QString &widgetName, QWidget *parentWidget, const QString &name);
    virtual QLayout *createLayout(const QString &layoutName, QObject *parent, const QString &name);
    virtual void createConnections(DomConnections *connections, QWidget *w);
    virtual void createAuthor(const QString&);
    virtual void createComment(const QString&);
    virtual void applyTabStops(QWidget *widget, DomTabStops *tabStops);

    virtual bool addItem(DomLayoutItem *ui_item, QLayoutItem *item, QLayout *layout);
    virtual bool addItem(DomWidget *ui_widget, QWidget *widget, QWidget *parentWidget);

    virtual DomWidget *createDom(QWidget *widget, DomWidget *ui_parentWidget, bool recursive = true);
    virtual DomLayout *createDom(QLayout *layout, DomLayout *ui_layout, DomWidget *ui_parentWidget);
    virtual DomLayoutItem *createDom(QLayoutItem *item, DomLayout *ui_layout, DomWidget *ui_parentWidget);

    virtual bool checkProperty(QObject *obj, const QString &prop) const;

    bool checkProperty(QDesignerTabWidget *widget, const QString &prop) const;
    bool checkProperty(QDesignerStackedWidget *widget, const QString &prop) const;
    bool checkProperty(QDesignerToolBox *widget, const QString &prop) const;
    bool checkProperty(QLayoutWidget *widget, const QString &prop) const;

    DomWidget *saveWidget(QDesignerTabWidget *widget, DomWidget *ui_parentWidget);
    DomWidget *saveWidget(QDesignerStackedWidget *widget, DomWidget *ui_parentWidget);
    DomWidget *saveWidget(QDesignerToolBox *widget, DomWidget *ui_parentWidget);
    DomWidget *saveWidget(QWidget *widget, IContainer *container, DomWidget *ui_parentWidget);
    
    DomConnections *saveConnections();
    DomCustomWidgets *saveCustomWidgets();
    DomTabStops *saveTabStops();
    virtual QString saveAuthor();
    virtual QString saveComment();

    void layoutInfo(DomWidget *widget, QObject *parent, int *margin, int *spacing);
    
    void changeObjectName(QObject *o, QString name);
    static QString qtify(const QString &name);
    
private:
    FormWindow *m_formWindow;
    bool m_isMainWidget;
    AbstractFormEditor *m_core;
    QHash<QString, QString> m_internal_to_qt;
    QHash<QString, QString> m_qt_to_internal;
    QHash<QString, QString> m_internal_to_qlayout;
    QHash<QString, QString> m_qlayout_to_internal;
    QStack<QLayout*> m_chain;
    QHash<AbstractWidgetDataBaseItem*, bool> m_usedCustomWidgets;
};

#endif // QDESIGNER_RESOURCE_H
