//depot/qt/2.3/tools/qvfb/skin.cpp#2 - edit change 67695 (text)
#include <qbitmap.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qimage.h>
#include <qtimer.h>
#include <qdir.h>
#include <qregexp.h>
#include "skin.h"
#include "qvfb.h"
#include "qvfbview.h"

#include <unistd.h>
#include <stdlib.h>

const int key_repeat_delay = 500;
const int key_repeat_period = 50;
const int joydistance = 10;


Skin::Skin( QVFb *p, const QString &skinFile, int &viewW, int &viewH ) : 
    QWidget(p), view(0), buttonPressed(FALSE), buttonIndex(0), skinValid(FALSE),
    zoom(1.0), numberOfAreas(0), areas(0),
    joystick(-1), joydown(0)
{
    parent = p;

    QFileInfo fi(skinFile);
    QString prefix;
    QString fn;
    if ( fi.isDir() ) {
	prefix = skinFile + "/";
	fn = prefix + fi.baseName() + ".skin";
    } else if (fi.isFile()){
	fn = skinFile;
	prefix = fi.dirPath() + "/";
    }else if (!skinFile.isNull()){
	qDebug("Skin file \"%s\" not found", skinFile.latin1());	
	return;
    }

    QFile f( fn );
    f.open( IO_ReadOnly );
    QTextStream ts( &f );
    ts >> skinImageUpFileName;
    ts >> skinImageDownFileName;
    ts >> viewX1;
    ts >> viewY1;
    ts >> viewW;
    ts >> viewH;
    ts >> numberOfAreas;
//  Debug the skin file parsing
//  printf("read: -%s- -%i- -%i- -%i-\n", skinImage.latin1(), viewX1, viewY1, numberOfAreas );
    areas = new ButtonAreas[numberOfAreas];

    skinImageUpFileName = prefix + skinImageUpFileName;
    skinImageDownFileName = prefix + skinImageDownFileName;

    int i = 0;
    ts.readLine(); // eol
    joystick = -1;
    while (i < numberOfAreas) {
	QString line = ts.readLine();
	if ( line.isNull() )
	    break;
	if ( line[0] != '#' ) {
	    QStringList tok = QStringList::split(QRegExp("[ \t][ \t]*"),line);
	    if ( tok.count()<6 ) {
		qDebug("Broken line: %s",line.latin1());
	    } else {
		areas[i].name = tok[0];
		QString k = tok[1];
		if ( k.left(2).lower() == "0x" ) {
		    areas[i].keyCode = k.mid(2).toInt(0,16);
		} else {
		    areas[i].keyCode = k.toInt();
		}

		int p=0;
		for (int j=2; j<(int)tok.count(); ) {
		    int x = tok[j++].toInt();
		    int y = tok[j++].toInt();
		    areas[i].area.putPoints(p++,1,x,y);
		}

		if ( areas[i].name[0] == '"' && areas[i].name.right(1) == "\"" )
		    areas[i].name = areas[i].name.mid(1,areas[i].name.length()-2);
		if ( areas[i].name.length() == 1 )
		    areas[i].text = areas[i].name;
		if ( areas[i].name == "Joystick" )
		    joystick = i;
		i++;
	    }
	}
    }
    setZoom(1.0);

    t_skinkey = new QTimer( this );
    connect( t_skinkey, SIGNAL(timeout()), this, SLOT(skinKeyRepeat()) );

    QString qpedir = getenv("QPEDIR");
    QFileInfo src(prefix + "defaultbuttons.conf");
    if (src.exists() && !qpedir.isNull()) {
	QFileInfo dst(qpedir + "/etc/defaultbuttons.conf");
	unlink(dst.absFilePath().latin1());
	QString srcFile = src.absFilePath();
	QString origDir = QDir::current().absPath();
	QDir::setCurrent(qpedir+"/etc");
	symlink(srcFile.latin1(), dst.fileName().latin1());
	QDir::setCurrent(origDir);
    }

    skinValid = TRUE;
}

void Skin::skinKeyRepeat()
{
    if ( view ) {
	view->skinKeyReleaseEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text, TRUE );
	view->skinKeyPressEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text, TRUE );
	t_skinkey->start(key_repeat_period);
    }
}

void Skin::calcRegions()
{
    for (int i=0; i<numberOfAreas; i++) {
	QPointArray xa(areas[i].area.count());
	int n = areas[i].area.count();
	for (int p=0; p<n; p++) {
	    xa.setPoint(p,
		int(areas[i].area[p].x()*zoom),
		int(areas[i].area[p].y()*zoom));
	}
	if ( n == 2 ) {
	    areas[i].region = QRegion(xa.boundingRect());
	} else {
	    areas[i].region = QRegion(xa);
	}
    }
}

void Skin::loadImages()
{
    QImage iup(skinImageUpFileName);
    QImage idown(skinImageDownFileName);

    if ( zoom != int(zoom) ) {
	iup = iup.smoothScale(int(iup.width()*zoom),int(iup.height()*zoom));
	idown = idown.smoothScale(int(idown.width()*zoom),int(idown.height()*zoom));
    }
    int conv = ThresholdAlphaDither|AvoidDither;
    //int conv = -1;
    skinImageUp.convertFromImage(iup, conv);
    skinImageDown.convertFromImage(idown, conv);

    if ( zoom == int(zoom) ) {
	QWMatrix scale; scale = scale.scale(zoom,zoom);
	skinImageUp = skinImageUp.xForm(scale);
	skinImageDown = skinImageDown.xForm(scale);
    }

    setFixedSize( skinImageUp.size() );
    QBitmap mask = skinImageUp.mask()
	? *skinImageUp.mask() : skinImageUp.createHeuristicMask();

    QWidget* parent = parentWidget();
    parent->setMask( mask );
    parent->setFixedSize( skinImageUp.size() );
}

Skin::~Skin( )
{
}

void Skin::setZoom( double z )
{
    zoom = z;
    calcRegions();
    loadImages();
    if ( view )
	view->move( int(viewX1*zoom), int(viewY1*zoom) );
}

void Skin::setView( QVFbView *v )
{
    view = v;
    view->setFocus();
    view->move( int(viewX1*zoom), int(viewY1*zoom) );
}


void Skin::paintEvent( QPaintEvent * )
{
    QPainter p( this );
    p.drawPixmap( 0, 0, skinImageUp );
    if (buttonPressed == TRUE) {
	ButtonAreas *ba = &areas[buttonIndex];
	QRect r = ba->region.boundingRect();
	if ( ba->area.count() > 2 )
	    p.setClipRegion(ba->region);
	p.drawPixmap( r.topLeft(), skinImageDown, r);
    }
}


void Skin::mousePressEvent( QMouseEvent *e )
{
    if (e->button() == RightButton) {
	parent->popupMenu();
    } else {
	buttonPressed = FALSE;

	onjoyrelease = -1;
	for (int i = 0; i < numberOfAreas; i++) {
	    ButtonAreas *ba = &areas[i];
	    if ( ba->region.contains( e->pos() ) ) {
		if ( joystick == i ) {
		    joydown = TRUE;
		} else {
		    if ( joydown )
			onjoyrelease = i;
		    else
			startPress(i);
		    break;
    //		Debug message to be sure we are clicking the right areas
    //		printf("%s clicked\n", areas[i].name);
		}
	    }
	}
	
//	This is handy for finding the areas to define rectangles for new skins
//	printf("Clicked in %i,%i\n",  e->pos().x(),  e->pos().y());
	clickPos = e->pos();
    }
}

void Skin::startPress(int i)
{
    buttonPressed = TRUE;
    buttonIndex = i;
    if (view) {
	view->skinKeyPressEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text );
	t_skinkey->start(key_repeat_delay);
	ButtonAreas *ba = &areas[buttonIndex];
	repaint( ba->region.boundingRect(), FALSE );
    }
}

void Skin::endPress()
{
    if (view)
	view->skinKeyReleaseEvent( areas[buttonIndex].keyCode, areas[buttonIndex].text );
    t_skinkey->stop();
    buttonPressed = FALSE;
    ButtonAreas *ba = &areas[buttonIndex];
    repaint( ba->region.boundingRect(), FALSE );
}

void Skin::mouseMoveEvent( QMouseEvent *e )
{
    QPoint newpos =  e->globalPos() - clickPos;
    if ( joydown ) {
	int k1=0, k2=0;
	if ( newpos.x() < -joydistance ) {
	    k1 = joystick+1;
	} else if ( newpos.x() > +joydistance ) {
	    k1 = joystick+3;
	}
	if ( newpos.y() < -joydistance ) {
	    k2 = joystick+2;
	} else if ( newpos.y() > +joydistance ) {
	    k2 = joystick+4;
	}
	if ( k1 || k2 ) {
	    if ( !buttonPressed ) {
		onjoyrelease = -1;
		if ( k1 && k2 ) {
		    startPress(k2);
		    endPress();
		}
		startPress(k1 ? k1 : k2);
	    }
	} else if ( buttonPressed ) {
	    endPress();
	}
    } else if ( buttonPressed == FALSE )
	parent->move( newpos );
}


void Skin::mouseReleaseEvent( QMouseEvent * )
{
    if ( buttonPressed )
	endPress();
    if ( joydown ) {
	joydown = FALSE;
	if ( onjoyrelease >= 0 ) {
	    startPress(onjoyrelease);
	    endPress();
	}
    }
}


