/*
  qpegps is a program for displaying a map centered at the current longitude/
  latitude as read from a gps receiver.

  Copyright (C) 2002 Ralf Haselmeier <Ralf.Haselmeier@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#ifndef MAP_DISP_H
#define MAP_DISP_H


#include "maps.h"

#include <qsocket.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qtextview.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtextstream.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qarray.h>
#include <qwidget.h>
#include <math.h>
#include <qimage.h>

#include "maps.h"
#include "gpsdata.h"
#include "track.h"

class MapDisp : public QWidget
{
    Q_OBJECT
public:
    MapDisp(Qpegps *, QSortedList<MapBase> *mapList, QWidget *parent=0, const char *name=0, WFlags fl=0);
    ~MapDisp();

    Qpegps *application;
    GpsData *gpsData;
    QPixmap *mapdisp;
    QImage *map;
    MapBase *actmap;
    QSortedList<MapBase> *maps;
    QSortedList<MapBase> actMapList;
    double selectedScale;

    QColor statColor;

    void mousePressEvent(QMouseEvent *);
    void keyPressEvent(QKeyEvent *);
    void paintEvent( QPaintEvent *);
    void createMap();
    double coverage(MapBase *, double, double, int, int );

public slots:
    void chooseLessDetailedMap();
    void chooseMoreDetailedMap();
    void showAvailableMaps();
    void clearActMapList();
signals:
    void mouseClick(QWidget *);
    void moreDetail();
    void lessDetail();
    void debugMaps();
};


#endif
