/*
 *
 * Pyldin-601 emulator version 3.1 for Linux,MSDOS,Win32
 * Copyright (c) Sasha Chukov & Yura Kuznetsov, 2000-2004
 *
 */

#ifndef _PYLDIN_
#define _PYLDIN_

#include <string.h>

#define byte	unsigned char
#define word	unsigned short
#define dword	unsigned int

#define NOERROR		0
#define INVALIDOPCODE	-1

extern	int	tick50;	// ⠭  1  TIMER INT 50Hz
extern	dword	vdiskSIZE;
extern	int IRQrequest;

class mc6800{

private:
	/*** ⥫  ⥬  ࠭  ***/
	byte	*MEM;
	byte	*BMEM;
	byte	*vdiskMEM;
	byte	*ROMP[16];

	/*** ROM page register $E6F0 ***/
//	byte	rompage;	// ⥪ ࠭
	byte	*CurrP;		// 㪠⥫  ᮤন ⥪饩 ࠭


	/*** interrupt support ***/
	word	fWai;		// ⠭ ᫥ WAI

	/*** MC6821(22) chip ***/
	byte	fSpeaker;	//  ﭨ 
//	byte	piadrb;

	/*** NEC 765 chip ***/
//	byte	fdctrl;		// $E6C0 - ࠢ ᪮

	//registers here
	word	EAR;
	word	PC;
	word	SP;
	word	X;
	byte	A;
	byte	B;
	byte	P;
	//flags register here
	byte	c;
	byte	v;
	byte	z;
	byte	n;
	byte	i;
	byte	h;

	/*** ⥭     ***/
	void	memw(word a, byte d);
	byte	memr(word a);

	void	Bcpx(int a, int b);
	byte	Bsub(byte o1, byte o2);
	byte	Bsubc(byte o1, byte o2);
	byte	Badd(byte o1, byte o2);
	byte	Baddc(byte o1, byte o2);
	byte	Blsr(byte a);
	byte	Basr(byte a);
	byte	Basl(byte a);
	byte	Bror(byte a);
	byte	Brol(byte a);
inline	void	Bdaa();

inline	byte	NextByte();
inline	void	FetchAddr();
inline	void	TestByte(byte b);
inline	void	TestWord(word w);
inline	void	Branch();

	void	INT17emulator(); //  ࠢ ஫஬ ᪠

public:
	mc6800();
	~mc6800();

	FILE	*logp;

	void	reset();
	void	setDATETIME();

	byte	*getRomPtr(int pag);
	int		step();
	int		global_takts;
};

#endif
