/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <gtk/gtk.h>
#include <glib.h>

#include "KWQButtonGroup.h"
#include "KWQButton.h"

QButtonGroup::QButtonGroup(QWidget * parent, const char * name)
    :_parent(parent)
{
    
}

int QButtonGroup::insert(QButton* button, int id)
{
    g_return_val_if_fail(button, -1);

    GtkRadioButton *gtkbtn = GTK_RADIO_BUTTON (button->getGtkWidget());
    g_return_val_if_fail(gtkbtn, -1);

    GSList *group = gtk_radio_button_get_group(GTK_RADIO_BUTTON (_parent->getGtkWidget()));
    gtk_radio_button_set_group(gtkbtn, group);
    GSList* pos = g_slist_find(group, gtkbtn);
    if (!pos) return -1;
    return g_slist_position(group, pos);
}

void QButtonGroup::remove(QButton* button)
{
    if (!button) return;
    GtkRadioButton *btn = GTK_RADIO_BUTTON(button->getGtkWidget());
    if (!btn) return ;

    gtk_radio_button_set_group(btn, NULL);
}
