/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "KWIQMacros.h"

#if KWIQ && !NDEBUG

#include <glib.h>
void report_g_conv_error(const char* file,int line, GError* err)
{
    if (err != NULL){
	char* errstr="";
	switch(err->code){
	case G_CONVERT_ERROR_NO_CONVERSION:
	    errstr="no conversion";break;
	case G_CONVERT_ERROR_ILLEGAL_SEQUENCE:
	    errstr="illegal seqence";break;
	case G_CONVERT_ERROR_FAILED:
	    errstr="failed";break;
	case  G_CONVERT_ERROR_PARTIAL_INPUT:
	    errstr="paritial input";break;
	case G_CONVERT_ERROR_BAD_URI:
	    errstr="bad uri";break;
	case G_CONVERT_ERROR_NOT_ABSOLUTE_PATH:
	    errstr="not absolute path";break;
	default:	   
 	    errstr="unknown error";
	    break;
	}
	g_printerr("%s:%d: Text conversion failed: %s, (code %d)\n",file,line, errstr,err->code);
	g_printerr("\t error message was: %s",err->message);
    }
}

#endif
