#ifndef _SynchronousLoader_h_
#define _SynchronousLoader_h_

#include <glib.h>
#include "gnet/uri.h"

#include "NRCore/WebCoreResourceLoader.h"

class SynchronousLoader : public WebCoreResourceLoader
{
  GHashTable *requestHeaders;
  GByteArray *requestData;
  
  GHashTable *responseHeaders;
  GByteArray *responseData;
  int status;
  WebCoreResponse *response;
  bool loadFinished;
  GURI* currentURI;
public:
  SynchronousLoader(const gchar* url, GByteArray* outData, GHashTable* outHeaders);
  ~SynchronousLoader();

  bool finished() { return loadFinished; }
  
  void receivedResponse(WebCoreResponse* response);
  void redirectedToURL(const gchar* URL);    
  void addData(const void *data,unsigned int length);
  
  // Either finish, reportError, or cancel must be called before the
  // loader is released, but never more than one.    
  void finish(void);
  void reportError(void);
  void cancel(void);

  gchar* dupFinalURI() { return gnet_uri_get_string(currentURI); }
  int statusCode() ;

};

#endif
