#ifndef Cookie_h
#define Cookie_h
/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>

class  Cookie
{
public:

  Cookie(const gchar * cookieString,
	 const gchar * url);
  ~Cookie();

  const gchar* setCookieString() const { return m_setCookieString; }
  const gchar* cookieString() const { return m_cookieString; }
  const gchar* url() const { return m_url; }
  const gchar* name() const { return m_name; }
  const gchar* value() const { return m_value; }
  const gchar* comment() const { return m_comment; }
  const gchar* domain() const { return m_domain; }
  const gchar* path() const { return m_path; }
  guint maxAge() const { return m_maxAge; }
  bool secure() const { return m_secure; }
  gint version() const { return m_version; }

private:
  void parseCookie(const gchar * cookie);

  gchar* m_setCookieString;
  gchar* m_cookieString;
  gchar* m_url;
  gchar* m_name;
  gchar* m_value;
  gchar* m_comment;
  gchar* m_domain;
  gchar* m_path;
  guint m_maxAge;
  bool m_secure;
  gint m_version;
  GTimeVal m_received;

};
#endif
