#!/bin/sh
CONF_FLAGS=""

NOCONFIGURE=""

for p in $*; do
    eval "$p=1"
done

if [ $noconf ]; then
    export NOCONFIGURE=1
fi

if [ $debug ]; then    
    CONF_FLAGS="${CONF_FLAGS} --enable-debug"
fi

if [ $home ]; then
    export PKG_CONFIG_PATH="${PKG_CONFIG_PATH}:$HOME/lib/pkgconfig"
    CONF_FLAGS="${CONF_FLAGS} --prefix=$HOME"
fi

if [ $curl ]; then 
    if [ $home ]; then
	CONF_FLAGS="${CONF_FLAGS} --with-libcurl-prefix=$HOME"
	echo "* using libcurl from prefix $HOME "
    else
	CONF_FLAGS="${CONF_FLAGS} --with-libcurl"
	echo "* using libcurl "
    fi
fi

if [ $maintainer ]; then
    maintainer=1
    CONF_FLAGS="$CONF_FLAGS --enable-maintainer-mode"
fi


echo
autogen=./autogen.sh

cmd="$autogen "
echo "running $cmd" 

$cmd

configure="./configure"

cmd="$configure $CONF_FLAGS"
if [ -z $noconf  ]; then    
    echo "running $cmd"
    $cmd
else 
    echo "now run $cmd"
fi

