/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Utility functions for dumping IP addresses and
 * serializing/deserializing char's, short's, and int's.
 *
 * Author: Kevin H. Grace, kgrace@mitre.org
 *         The MITRE Corporation
 *         202 Burlington Rd
 *         Bedford, MA  01730
 *         
 *
 * $Id: UtUtil.h,v 1.1.1.1 2003/10/24 10:34:57 br1 Exp $
 * 
 */
#ifndef __UtUtil_h
#define __UtUtil_h

#include <string.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <UtString.h>
#include <UtTime.h>


String DumpAddr(unsigned int addr) {
  struct in_addr a;
  a.s_addr = htonl(addr);
  String s = inet_ntoa(a);
  return(s);
}

String DumpHwAddr(struct sockaddr sa) {
  char buf[128];
  sprintf(buf,"%02X:%02X:%02X:%02X:%02X:%02X",
	  (unsigned char)sa.sa_data[0],
	  (unsigned char)sa.sa_data[1],
	  (unsigned char)sa.sa_data[2],
	  (unsigned char)sa.sa_data[3],
	  (unsigned char)sa.sa_data[4],
	  (unsigned char)sa.sa_data[5]);
  return(buf);
};

String Encode4(unsigned int i) {
  unsigned int j = htonl(i);
  return(String((char*)&j,0,4));
}

String Encode2(unsigned short i) {
  unsigned short j = htons(i);
  return(String((char*)&j,0,2));
}

String Encode1(unsigned char i) {
  return(String((char*)&i,0,1));
}

unsigned int Decode4(const String& s, unsigned int& offset, bool& ok) {
  // Make sure the string is long enough
  if(s.length() < (offset + 4)) {
    ok = false;
    return 0;
  }
  char* p = ((char*)s.c_str()) + offset;
  offset += 4;
  return(ntohl(*((unsigned int*)p)));
}

unsigned short Decode2(const String& s, unsigned int& offset, bool& ok) {
  // Make sure the string is long enough
  if(s.length() < (offset + 2)) {
    ok = false;
    return 0;
  }
  char* p = ((char*)s.c_str()) + offset;
  offset += 2;
  return(ntohs(*((unsigned short*)p)));
}

unsigned char Decode1(const String& s, unsigned int& offset, bool& ok) {
  // Make sure the string is long enough
  if(s.length() < (offset + 1)) {
    ok = false;
    return 0;
  }
  char* p = ((char*)s.c_str()) + offset;
  offset += 1;
  return(*((unsigned char*)p));
}

Time Min(const Time& a, const Time& b) {
  if(double(a) <= double(b)) return(a);
  return(b);
}


#endif
