/*
 *  linux/arch/arm/mach-s3c2410/leds.c
 *
 *  Copyright (C) 2002 SAMSUNG ELECTRONICS 
 *                      SW.LEE <hitchcar@sec.samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/config.h>
#ifdef CONFIG_LEDS
#include <linux/kernel.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/leds.h>
#include <asm/system.h>
#include <asm/mach-types.h>

extern void Led_Display(int data);
/* 
 * See include/asm/arch/system.h
 * In arch_idle functions 
 * Led_Display Function used.
 * By SW.LEE 
 */

extern void Led_Display(int data)
{
  rGPFDAT = rGPFDAT|(0xf<<4);	/* All led off  */
  rGPFDAT = (rGPFDAT&(0xffffff0f))| ((~data & 0xf)<<4);
}


extern void s3c2410_leds_event(led_event_t ledevt)
{
  unsigned long flags;

  local_irq_save(flags);

  switch(ledevt) {
  case led_idle_start:
    Led_Display(1);
    break;

  case led_idle_end:
    Led_Display(2);
    break;

  case led_timer:
    Led_Display(3);
    break;

  case led_red_on:
    Led_Display(0xf);
    break;
  case led_red_off:
    Led_Display(0);
    break;
  default:
    break;
  }

  local_irq_restore(flags);	 
}

static int __init leds_init(void)
{
  leds_event = s3c2410_leds_event;
  return 0;
}

__initcall(leds_init);
#endif
