/*
 *  linux/include/asm-arm/arch-dm310/mmu.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_MMU_H
#define __ASM_ARCH_MMU_H

#include <asm/arch/platform.h>

/*
 * Task size: 3GB
 */
#define TASK_SIZE	(0xc0000000UL)
#define TASK_SIZE_26	(0x04000000UL)

/*
 * This decides where the kernel will search for a free chunk of vm
 * space during mmap's.
 */
#define TASK_UNMAPPED_BASE (TASK_SIZE / 3)

/*
 * Page offset: 3GB
 */
#define PAGE_OFFSET	(0xc0000000UL)

/*
 * DRAM starts at 0x08000000, 16M size (on the EVM)
 * FIXME: The bootloader must set memory configuration
 *        via an ATAG list
 *
 * Some of the DRAM is used as framebuffer memory
 *
 */
#define PHYS_OFFSET	(DM310_SDRAM_BASE)
#define MEM_SIZE        (DM310_SDRAM_SIZE)
#define VIDMEM_OFFSET	(0x08F9A000UL)
#define VIDMEM_SIZE	(0x00066000UL)

/*
 * These macros convert kernel-virtual addresses to physical addresses
 * and vice versa. Physical memory starts at PHYS_OFFSET.
 * Kernel virtual addresses start at PAGE_OFFSET. 
 *
 * On the DM310, the dram is contiguous
 */
#define __virt_to_phys__is_a_macro
#define __virt_to_phys(vpage) ((vpage) - PAGE_OFFSET + PHYS_OFFSET)
#define __phys_to_virt__is_a_macro
#define __phys_to_virt(ppage) ((ppage) + PAGE_OFFSET - PHYS_OFFSET)

/*
 * Virtual view <-> DMA view memory address translations
 * virt_to_bus: Used to translate the virtual address to an
 *              address suitable to be passed to set_dma_addr
 * bus_to_virt: Used to convert an address for DMA operations
 *              to an address that the kernel can use.
 */
#define __virt_to_bus__is_a_macro
#define __virt_to_bus(x)	(x - PAGE_OFFSET + PHYS_OFFSET)
#define __bus_to_virt__is_a_macro
#define __bus_to_virt(x)	(x - PHYS_OFFSET + PAGE_OFFSET)

#endif
