#ifndef __KEYTABLE_H_INCLUDED__
#define __KEYTABLE_H_INCLUDED__


#ifndef NR_KEYS
#define NR_KEYS 128
#endif /* ! NR_KEYS */


#ifndef NR_KEYCODES
#define NR_KEYCODES 128
#endif /* ! NR_KEYCODES */


#define MODIF_2ND 0x01
#define MODIF_CAPS 0x02
#define MODIF_NUM 0x03

#ifndef KEY_IGN
#define KEY_IGN 0
#endif /* ! KEY_IGN */


static unsigned char rawkeytable_table_NormalLower[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_NormalUpper[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_2ndLower[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_2ndUpper[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_PRINTSCREEN,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_NumlockLower[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_NumlockUpper[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_Num2ndLower[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_C,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};

static unsigned char rawkeytable_table_Num2ndUpper[(NR_KEYCODES+1)] = {
KEY_IGN,KEY_IGN,SLKEY_W,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_K,SLKEY_BACK_SPACE,SLKEY_P,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_OFF,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Q,SLKEY_E,SLKEY_T,SLKEY_Y,KEY_IGN,SLKEY_O,SLKEY_I,SLKEY_COMMA,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_RECORDER,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_A,SLKEY_D,SLKEY_G,SLKEY_U,KEY_IGN,SLKEY_L,SLKEY_ENTER,SLKEY_PERIOD,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_SYNCSTART,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_Z,SLKEY_PRINTSCREEN,SLKEY_V,SLKEY_J,SLKEY_CONTACTS,SLKEY_F9,SLKEY_F11,SLKEY_F4,SLKEY_LSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_S,SLKEY_R,SLKEY_B,SLKEY_N,SLKEY_ACTIVITY,SLKEY_HOME,SLKEY_MINUS,SLKEY_FRONTLIGHT,KEY_IGN,SLKEY_RSHIFT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_TAB,SLKEY_SLASH,SLKEY_H,SLKEY_M,SLKEY_F2,KEY_IGN,SLKEY_UP,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_2ND,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,SLKEY_X,SLKEY_F,SLKEY_SPACE,SLKEY_APOSTROPHE,SLKEY_MAIL,SLKEY_LEFT,SLKEY_DOWN,SLKEY_RIGHT,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN,KEY_IGN};



#define STATE_S0 0
#define STATE_S1 1
#define STATE_S2 2
#define STATE_S3 3
#define STATE_S4 4
#define STATE_S5 5
#define STATE_S6 6
#define STATE_S7 7
#define STATE_S8 8
#define STATE_S9 9
#define STATE_S10 10
#define STATE_S11 11
#define STATE_S12 12
#define STATE_S13 13
#define STATE_S14 14
#define STATE_S15 15
#define STATE_S16 16
#define STATE_S17 17
#define STATE_S18 18
#define STATE_S19 19
#define STATE_S20 20
#define STATE_S21 21
#define STATE_S22 22
#define STATE_S23 23
#define STATE_S24 24
#define STATE_S25 25
#define STATE_S26 26
#define STATE_S27 27
#define STATE_S28 28
#define STATE_S29 29
#define STATE_S30 30
#define STATE_S31 31
#define STATE_S32 32
#define STATE_S33 33
#define STATE_S34 34
#define STATE_S35 35
#define STATE_S36 36
#define STATE_S37 37
#define STATE_S38 38
#define STATE_S39 39
#define STATE_S40 40
#define STATE_S41 41
#define STATE_S42 42
#define STATE_S43 43
#define STATE_S44 44
#define STATE_S45 45
#define STATE_S46 46
#define STATE_S47 47
#define STATE_S48 48
#define STATE_S49 49
#define STATE_S50 50
#define STATE_S51 51
#define STATE_S52 52
#define STATE_S53 53
#define STATE_S54 54
#define STATE_S55 55
#define STATE_S56 56
#define STATE_S57 57
#define STATE_S58 58
#define STATE_S59 59
#define STATE_S60 60
#define STATE_S61 61
#define STATE_S62 62
#define STATE_S63 63
#define STATE_S64 64
#define STATE_S65 65
#define STATE_S66 66
#define STATE_S67 67
#define STATE_S68 68
#define STATE_S69 69
#define STATE_S70 70
#define STATE_S71 71
#define STATE_S72 72
#define STATE_S73 73
#define STATE_S74 74
#define STATE_S75 75
#define STATE_S76 76
#define STATE_S77 77
#define STATE_S78 78
#define STATE_S79 79


#define STATE_NUMS_TOTAL 80


#ifdef RAWKEY_MAP_DEBUG
static char *state_names[STATE_NUMS_TOTAL] = {
	"S0",
	"S1",
	"S2",
	"S3",
	"S4",
	"S5",
	"S6",
	"S7",
	"S8",
	"S9",
	"S10",
	"S11",
	"S12",
	"S13",
	"S14",
	"S15",
	"S16",
	"S17",
	"S18",
	"S19",
	"S20",
	"S21",
	"S22",
	"S23",
	"S24",
	"S25",
	"S26",
	"S27",
	"S28",
	"S29",
	"S30",
	"S31",
	"S32",
	"S33",
	"S34",
	"S35",
	"S36",
	"S37",
	"S38",
	"S39",
	"S40",
	"S41",
	"S42",
	"S43",
	"S44",
	"S45",
	"S46",
	"S47",
	"S48",
	"S49",
	"S50",
	"S51",
	"S52",
	"S53",
	"S54",
	"S55",
	"S56",
	"S57",
	"S58",
	"S59",
	"S60",
	"S61",
	"S62",
	"S63",
	"S64",
	"S65",
	"S66",
	"S67",
	"S68",
	"S69",
	"S70",
	"S71",
	"S72",
	"S73",
	"S74",
	"S75",
	"S76",
	"S77",
	"S78",
	"S79"
};
#endif /* RAWKEY_MAP_DEBUG */


static unsigned char state_table_LSHIFT_up[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S0,STATE_S2,STATE_S2,STATE_S4,STATE_S4,STATE_S6,STATE_S6,STATE_S8,STATE_S8,STATE_S10,STATE_S10,STATE_S12,STATE_S12,STATE_S14,STATE_S14,STATE_S16,STATE_S16,STATE_S18,STATE_S18,STATE_S20,STATE_S20,STATE_S22,STATE_S22,STATE_S24,STATE_S24,STATE_S26,STATE_S26,STATE_S28,STATE_S28,STATE_S30,STATE_S30,STATE_S32,STATE_S32,STATE_S34,STATE_S34,STATE_S36,STATE_S36,STATE_S38,STATE_S38,STATE_S40,STATE_S40,STATE_S42,STATE_S42,STATE_S44,STATE_S44,STATE_S46,STATE_S46,STATE_S48,STATE_S48,STATE_S50,STATE_S50,STATE_S52,STATE_S52,STATE_S54,STATE_S54,STATE_S56,STATE_S56,STATE_S58,STATE_S58,STATE_S60,STATE_S60,STATE_S62,STATE_S62,STATE_S64,STATE_S64,STATE_S66,STATE_S66,STATE_S68,STATE_S68,STATE_S70,STATE_S70,STATE_S72,STATE_S72,STATE_S74,STATE_S74,STATE_S76,STATE_S76,STATE_S78,STATE_S78};

static unsigned char state_table_RSHIFT_up[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S1,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S6,STATE_S7,STATE_S8,STATE_S9,STATE_S10,STATE_S11,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S16,STATE_S17,STATE_S18,STATE_S19,STATE_S20,STATE_S21,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S26,STATE_S27,STATE_S28,STATE_S29,STATE_S30,STATE_S31,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S36,STATE_S37,STATE_S38,STATE_S39,STATE_S0,STATE_S1,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S6,STATE_S7,STATE_S8,STATE_S9,STATE_S10,STATE_S11,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S16,STATE_S17,STATE_S18,STATE_S19,STATE_S20,STATE_S21,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S26,STATE_S27,STATE_S28,STATE_S29,STATE_S30,STATE_S31,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S36,STATE_S37,STATE_S38,STATE_S39};

static unsigned char state_table_2nd_up[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S1,STATE_S6,STATE_S7,STATE_S0,STATE_S1,STATE_S6,STATE_S7,STATE_S0,STATE_S1,STATE_S10,STATE_S11,STATE_S16,STATE_S17,STATE_S10,STATE_S11,STATE_S16,STATE_S17,STATE_S10,STATE_S11,STATE_S20,STATE_S21,STATE_S26,STATE_S27,STATE_S20,STATE_S21,STATE_S26,STATE_S27,STATE_S20,STATE_S21,STATE_S30,STATE_S31,STATE_S36,STATE_S37,STATE_S30,STATE_S31,STATE_S36,STATE_S37,STATE_S30,STATE_S31,STATE_S40,STATE_S41,STATE_S46,STATE_S47,STATE_S40,STATE_S41,STATE_S46,STATE_S47,STATE_S40,STATE_S41,STATE_S50,STATE_S51,STATE_S56,STATE_S57,STATE_S50,STATE_S51,STATE_S56,STATE_S57,STATE_S50,STATE_S51,STATE_S60,STATE_S61,STATE_S66,STATE_S67,STATE_S60,STATE_S61,STATE_S66,STATE_S67,STATE_S60,STATE_S61,STATE_S70,STATE_S71,STATE_S76,STATE_S77,STATE_S70,STATE_S71,STATE_S76,STATE_S77,STATE_S70,STATE_S71};



#define UP_TABLES_SIZE 3


static unsigned char *up_tables[UP_TABLES_SIZE] = {
	state_table_LSHIFT_up,state_table_RSHIFT_up,state_table_2nd_up
};


#define SEE_LSHIFT_UP 0
#define SEE_RSHIFT_UP 1
#define SEE_2nd_UP 2
#define UP_NOP -1


static char up_modifs_ref[(NR_KEYCODES+1)] = {
UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,SEE_LSHIFT_UP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,SEE_RSHIFT_UP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,SEE_2nd_UP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP,UP_NOP};


static unsigned char state_table_LSHIFT_down[STATE_NUMS_TOTAL] = {
STATE_S1,STATE_S1,STATE_S3,STATE_S3,STATE_S5,STATE_S5,STATE_S7,STATE_S7,STATE_S9,STATE_S9,STATE_S11,STATE_S11,STATE_S13,STATE_S13,STATE_S15,STATE_S15,STATE_S17,STATE_S17,STATE_S19,STATE_S19,STATE_S21,STATE_S21,STATE_S23,STATE_S23,STATE_S25,STATE_S25,STATE_S27,STATE_S27,STATE_S29,STATE_S29,STATE_S31,STATE_S31,STATE_S33,STATE_S33,STATE_S35,STATE_S35,STATE_S37,STATE_S37,STATE_S39,STATE_S39,STATE_S41,STATE_S41,STATE_S43,STATE_S43,STATE_S45,STATE_S45,STATE_S47,STATE_S47,STATE_S49,STATE_S49,STATE_S51,STATE_S51,STATE_S53,STATE_S53,STATE_S55,STATE_S55,STATE_S57,STATE_S57,STATE_S59,STATE_S59,STATE_S61,STATE_S61,STATE_S63,STATE_S63,STATE_S65,STATE_S65,STATE_S67,STATE_S67,STATE_S69,STATE_S69,STATE_S71,STATE_S71,STATE_S73,STATE_S73,STATE_S75,STATE_S75,STATE_S77,STATE_S77,STATE_S79,STATE_S79};

static unsigned char state_table_RSHIFT_down[STATE_NUMS_TOTAL] = {
STATE_S40,STATE_S41,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S46,STATE_S47,STATE_S48,STATE_S49,STATE_S50,STATE_S51,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S56,STATE_S57,STATE_S58,STATE_S59,STATE_S60,STATE_S61,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S66,STATE_S67,STATE_S68,STATE_S69,STATE_S70,STATE_S71,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S76,STATE_S77,STATE_S78,STATE_S79,STATE_S40,STATE_S41,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S46,STATE_S47,STATE_S48,STATE_S49,STATE_S50,STATE_S51,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S56,STATE_S57,STATE_S58,STATE_S59,STATE_S60,STATE_S61,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S66,STATE_S67,STATE_S68,STATE_S69,STATE_S70,STATE_S71,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S76,STATE_S77,STATE_S78,STATE_S79};

static unsigned char state_table_2nd_down[STATE_NUMS_TOTAL] = {
STATE_S2,STATE_S3,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S8,STATE_S9,STATE_S8,STATE_S9,STATE_S12,STATE_S13,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S18,STATE_S19,STATE_S18,STATE_S19,STATE_S22,STATE_S23,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S28,STATE_S29,STATE_S28,STATE_S29,STATE_S32,STATE_S33,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S38,STATE_S39,STATE_S38,STATE_S39,STATE_S42,STATE_S43,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S48,STATE_S49,STATE_S48,STATE_S49,STATE_S52,STATE_S53,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S58,STATE_S59,STATE_S58,STATE_S59,STATE_S62,STATE_S63,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S68,STATE_S69,STATE_S68,STATE_S69,STATE_S72,STATE_S73,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S78,STATE_S79,STATE_S78,STATE_S79};

static unsigned char state_table_caps_down[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S1,STATE_S14,STATE_S15,STATE_S14,STATE_S15,STATE_S10,STATE_S11,STATE_S14,STATE_S15,STATE_S10,STATE_S11,STATE_S4,STATE_S5,STATE_S4,STATE_S5,STATE_S0,STATE_S1,STATE_S4,STATE_S5,STATE_S20,STATE_S21,STATE_S34,STATE_S35,STATE_S34,STATE_S35,STATE_S30,STATE_S31,STATE_S34,STATE_S35,STATE_S30,STATE_S31,STATE_S24,STATE_S25,STATE_S24,STATE_S25,STATE_S20,STATE_S21,STATE_S24,STATE_S25,STATE_S40,STATE_S41,STATE_S54,STATE_S55,STATE_S54,STATE_S55,STATE_S50,STATE_S51,STATE_S54,STATE_S55,STATE_S50,STATE_S51,STATE_S44,STATE_S45,STATE_S44,STATE_S45,STATE_S40,STATE_S41,STATE_S44,STATE_S45,STATE_S60,STATE_S61,STATE_S74,STATE_S75,STATE_S74,STATE_S75,STATE_S70,STATE_S71,STATE_S74,STATE_S75,STATE_S70,STATE_S71,STATE_S64,STATE_S65,STATE_S64,STATE_S65,STATE_S60,STATE_S61,STATE_S64,STATE_S65};

static unsigned char state_table_num_down[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S1,STATE_S24,STATE_S25,STATE_S24,STATE_S25,STATE_S20,STATE_S21,STATE_S24,STATE_S25,STATE_S10,STATE_S11,STATE_S34,STATE_S35,STATE_S34,STATE_S35,STATE_S30,STATE_S31,STATE_S34,STATE_S35,STATE_S20,STATE_S21,STATE_S4,STATE_S5,STATE_S4,STATE_S5,STATE_S0,STATE_S1,STATE_S4,STATE_S5,STATE_S30,STATE_S31,STATE_S14,STATE_S15,STATE_S14,STATE_S15,STATE_S10,STATE_S11,STATE_S14,STATE_S15,STATE_S40,STATE_S41,STATE_S64,STATE_S65,STATE_S64,STATE_S65,STATE_S60,STATE_S61,STATE_S64,STATE_S65,STATE_S50,STATE_S51,STATE_S74,STATE_S75,STATE_S74,STATE_S75,STATE_S70,STATE_S71,STATE_S74,STATE_S75,STATE_S60,STATE_S61,STATE_S44,STATE_S45,STATE_S44,STATE_S45,STATE_S40,STATE_S41,STATE_S44,STATE_S45,STATE_S70,STATE_S71,STATE_S54,STATE_S55,STATE_S54,STATE_S55,STATE_S50,STATE_S51,STATE_S54,STATE_S55};

static unsigned char state_table_ANY_OTHER_down[STATE_NUMS_TOTAL] = {
STATE_S0,STATE_S1,STATE_S4,STATE_S5,STATE_S4,STATE_S5,STATE_S0,STATE_S1,STATE_S4,STATE_S5,STATE_S10,STATE_S11,STATE_S14,STATE_S15,STATE_S14,STATE_S15,STATE_S10,STATE_S11,STATE_S14,STATE_S15,STATE_S20,STATE_S21,STATE_S24,STATE_S25,STATE_S24,STATE_S25,STATE_S20,STATE_S21,STATE_S24,STATE_S25,STATE_S30,STATE_S31,STATE_S34,STATE_S35,STATE_S34,STATE_S35,STATE_S30,STATE_S31,STATE_S34,STATE_S35,STATE_S40,STATE_S41,STATE_S44,STATE_S45,STATE_S44,STATE_S45,STATE_S40,STATE_S41,STATE_S44,STATE_S45,STATE_S50,STATE_S51,STATE_S54,STATE_S55,STATE_S54,STATE_S55,STATE_S50,STATE_S51,STATE_S54,STATE_S55,STATE_S60,STATE_S61,STATE_S64,STATE_S65,STATE_S64,STATE_S65,STATE_S60,STATE_S61,STATE_S64,STATE_S65,STATE_S70,STATE_S71,STATE_S74,STATE_S75,STATE_S74,STATE_S75,STATE_S70,STATE_S71,STATE_S74,STATE_S75};



#define DOWN_TABLES_SIZE 6


static unsigned char *down_tables[DOWN_TABLES_SIZE] = {
	state_table_LSHIFT_down,state_table_RSHIFT_down,state_table_2nd_down,state_table_caps_down,state_table_num_down,state_table_ANY_OTHER_down
};


#define SEE_LSHIFT_DOWN 0
#define SEE_RSHIFT_DOWN 1
#define SEE_2nd_DOWN 2
#define SEE_caps_DOWN 3
#define SEE_num_DOWN 4
#define SEE_ANY_OTHER_DOWN 5
#define DOWN_NOP -1


static char down_modifs_ref[(NR_KEYCODES+1)] = {
DOWN_NOP,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_LSHIFT_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_RSHIFT_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_2nd_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_caps_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_num_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN,SEE_ANY_OTHER_DOWN};


static unsigned char extmodif_map_2nd[STATE_NUMS_TOTAL] = {0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1};
static unsigned char extmodif_map_CAPS[STATE_NUMS_TOTAL] = {0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1};
static unsigned char extmodif_map_NUM[STATE_NUMS_TOTAL] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

#define EXTMODIF_SHOWSTAT_KEYMAX 4

static unsigned char *extmodif_status_tables[EXTMODIF_SHOWSTAT_KEYMAX] = {
NULL,extmodif_map_2nd,extmodif_map_CAPS,extmodif_map_NUM};


static unsigned char extmove_map_2nd[STATE_NUMS_TOTAL] = {STATE_S6,STATE_S7,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S0,STATE_S1,STATE_S8,STATE_S9,STATE_S16,STATE_S17,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S10,STATE_S11,STATE_S18,STATE_S19,STATE_S26,STATE_S27,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S20,STATE_S21,STATE_S28,STATE_S29,STATE_S36,STATE_S37,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S30,STATE_S31,STATE_S38,STATE_S39,STATE_S46,STATE_S47,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S40,STATE_S41,STATE_S48,STATE_S49,STATE_S56,STATE_S57,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S50,STATE_S51,STATE_S58,STATE_S59,STATE_S66,STATE_S67,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S60,STATE_S61,STATE_S68,STATE_S69,STATE_S76,STATE_S77,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S70,STATE_S71,STATE_S78,STATE_S79};
static unsigned char extmove_map_CAPS[STATE_NUMS_TOTAL] = {STATE_S10,STATE_S11,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S16,STATE_S17,STATE_S18,STATE_S19,STATE_S0,STATE_S1,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S6,STATE_S7,STATE_S8,STATE_S9,STATE_S30,STATE_S31,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S36,STATE_S37,STATE_S38,STATE_S39,STATE_S20,STATE_S21,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S26,STATE_S27,STATE_S28,STATE_S29,STATE_S50,STATE_S51,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S56,STATE_S57,STATE_S58,STATE_S59,STATE_S40,STATE_S41,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S46,STATE_S47,STATE_S48,STATE_S49,STATE_S70,STATE_S71,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S76,STATE_S77,STATE_S78,STATE_S79,STATE_S60,STATE_S61,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S66,STATE_S67,STATE_S68,STATE_S69};
static unsigned char extmove_map_NUM[STATE_NUMS_TOTAL] = {STATE_S20,STATE_S21,STATE_S22,STATE_S23,STATE_S24,STATE_S25,STATE_S26,STATE_S27,STATE_S28,STATE_S29,STATE_S30,STATE_S31,STATE_S32,STATE_S33,STATE_S34,STATE_S35,STATE_S36,STATE_S37,STATE_S38,STATE_S39,STATE_S0,STATE_S1,STATE_S2,STATE_S3,STATE_S4,STATE_S5,STATE_S6,STATE_S7,STATE_S8,STATE_S9,STATE_S10,STATE_S11,STATE_S12,STATE_S13,STATE_S14,STATE_S15,STATE_S16,STATE_S17,STATE_S18,STATE_S19,STATE_S60,STATE_S61,STATE_S62,STATE_S63,STATE_S64,STATE_S65,STATE_S66,STATE_S67,STATE_S68,STATE_S69,STATE_S70,STATE_S71,STATE_S72,STATE_S73,STATE_S74,STATE_S75,STATE_S76,STATE_S77,STATE_S78,STATE_S79,STATE_S40,STATE_S41,STATE_S42,STATE_S43,STATE_S44,STATE_S45,STATE_S46,STATE_S47,STATE_S48,STATE_S49,STATE_S50,STATE_S51,STATE_S52,STATE_S53,STATE_S54,STATE_S55,STATE_S56,STATE_S57,STATE_S58,STATE_S59};

#define EXTMODIF_MOVESTAT_KEYMAX 4

static unsigned char *extmodif_move_tables[EXTMODIF_MOVESTAT_KEYMAX] = {
NULL,extmove_map_2nd,extmove_map_CAPS,extmove_map_NUM};



typedef struct shappda_holdkey_info {
	int type;
	int character;
	void (*func)(void);
} shappda_holdkey_info;

#define HOLDKEYTYPE_CHAR 1
#define HOLDKEYTYPE_FUNC 2

static shappda_holdkey_info shappda_holdkey_UserDef = {
	type: HOLDKEYTYPE_CHAR,
	character: SLKEY_EXCLAM,
	func: NULL
};
static shappda_holdkey_info shappda_holdkey_Mail = {
	type: HOLDKEYTYPE_CHAR,
	character: SLKEY_MAIL2,
	func: NULL
};

static shappda_holdkey_info *holdkey_info[(NR_KEYCODES+1)] = {
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,&shappda_holdkey_UserDef,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,&shappda_holdkey_Mail,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};


static unsigned char *state_to_keymap[STATE_NUMS_TOTAL] = {
rawkeytable_table_NormalLower,rawkeytable_table_NormalUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_NormalLower,rawkeytable_table_NormalUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_2ndLower,rawkeytable_table_2ndUpper,rawkeytable_table_NumlockLower,rawkeytable_table_NumlockUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_NumlockLower,rawkeytable_table_NumlockUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndLower,rawkeytable_table_Num2ndUpper,rawkeytable_table_NormalUpper,rawkeytable_table_NormalUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_NormalUpper,rawkeytable_table_NormalUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_2ndUpper,rawkeytable_table_NumlockUpper,rawkeytable_table_NumlockUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_NumlockUpper,rawkeytable_table_NumlockUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper,rawkeytable_table_Num2ndUpper};


#endif /* ! __KEYTABLE_H_INCLUDED__ */
