/*
 * linux/include/asm-sh/sh7290.h
 *
 * Copyright (c) 2002 Lineo Japan, Inc.
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Hitachi SH7290 support.
 */
#ifndef __ASM_SH_SH7290_H
#define __ASM_SH_SH7290_H 1

#define MMUCR		0xFFFFFFE0
#define PTEH		0xFFFFFFF0
#define PTEL		0xFFFFFFF4
#define TTB		0xFFFFFFF8
#define TEA		0xFFFFFFFC

#define CCR1		0xFFFFFFEC
#define CCR2		0xA40000B0
#define CCR3		0xA40000B4

#define INTEVT2		0xA4000000
#define TRA		0xFFFFFFD0
#define EXPEVT		0xFFFFFFD4

#define IPRA		0xA414FEE2
#define IPRB		0xA414FEE4
#define IPRC		0xA4140016
#define IPRD		0xA4140018
#define IPRE		0xA414001A
#define IPRF		0xA4080000
#define IPRG		0xA4080002
#define IPRH		0xA4080004
#define IPRI		0xA4080006

#define IMR0		0xA4080040
#define IMR1		0xA4080042
#define IMR2		0xA4080044
#define IMR3		0xA4080046
#define IMR4		0xA4080048
#define IMR5		0xA408004A
#define IMR6		0xA408004C
#define IMR7		0xA408004E
#define IMR8		0xA4080050
#define IMR9		0xA4080052

#define IMCR0		0xA4080060
#define IMCR1		0xA4080062
#define IMCR2		0xA4080064
#define IMCR3		0xA4080066
#define IMCR4		0xA4080068
#define IMCR5		0xA408006A
#define IMCR6		0xA408006C
#define IMCR7		0xA408006E
#define IMCR8		0xA4080070
#define IMCR9		0xA4080072

#define ICR0		0xA414FEE0
#define ICR1		0xA4140010
#define ICR2		0xA4140020

#define IRR0		0xA4140004

#define CMNCR		0xA4FD0000
#define CS0BCR		0xA4FD0004
#define CS2BCR		0xA4FD0008
#define CS3BCR		0xA4FD000C
#define CS4BCR		0xA4FD0010
#define CS5ABCR		0xA4FD0014
#define CS5BBCR		0xA4FD0018
#define CS6ABCR		0xA4FD001C
#define CS6BBCR		0xA4FD0020
#define CS0WCR		0xA4FD0024
#define CS2WCR		0xA4FD0028
#define CS3WCR		0xA4FD002C
#define CS4WCR		0xA4FD0030
#define CS5AWCR		0xA4FD0034
#define CS5BWCR		0xA4FD0038
#define CS6AWCR		0xA4FD003C
#define CS6BWCR		0xA4FD0040

#define SAR0		0xA4010020
#define DAR0		0xA4010024
#define DMATCR0		0xA4010028
#define CHCR0		0xA401002C
#define SAR1		0xA4010030
#define DAR1		0xA4010034
#define DMATCR1		0xA4010038
#define CHCR1		0xA401003C
#define SAR2		0xA4010040
#define DAR2		0xA4010044
#define DMATCR2		0xA4010048
#define CHCR2		0xA401004C
#define SAR3		0xA4010050
#define DAR3		0xA4010054
#define DMATCR3		0xA4010058
#define CHCR3		0xA401005C
#define SAR4		0xA4010070
#define DAR4		0xA4010074
#define DMATCR4		0xA4010078
#define CHCR4		0xA401007C
#define SAR5		0xA4010080
#define DAR5		0xA4010084
#define DMATCR5		0xA4010088
#define CHCR5		0xA401008C

#define DMAOR		0xA4010060
#define DMARS0		0xA4090000
#define DMARS1		0xA4090004
#define DMARS2		0xA4090008

#define UCLKCR		0xA40A0008
#define FCLKCR		0xA40A000C
#define FRQCR		0xA415FF80

#define BARA		0xFFFFFFB0
#define BAMRA		0xFFFFFFB4
#define BBRA		0xFFFFFFB8

#define BARB		0xFFFFFFA0
#define BAMRB		0xFFFFFFA4
#define BBRB		0xFFFFFFA8
#define BDRB		0xFFFFFF90
#define BDMRB		0xFFFFFF94
#define BRCR		0xFFFFFF98

#define BETR		0xFFFFFF9C
#define BRSR		0xFFFFFFAC
#define BRDR		0xFFFFFFBC
#define BASRA		0xFFFFFFE4
#define BASRB		0xFFFFFFE8

#define WTCNT		0xA415FF84
#define WTCSR		0xA415FF86

#define RWTCNT		0xA4520000
#define RWTCSR		0xA4520004

#define STBCR		0xA415FF82
#define STBCR2		0xA415FF88
#define STBCR3		0xA40A0000
#define STBCR4		0xA40A0004
#define STBCR5		0xA40A0010

#define TMU_TSTR	0xA412FE92
#define TMU_TCOR0	0xA412FE94
#define TMU_TCNT0	0xA412FE98
#define TMU_TCR0	0xA412FE9C
#define TMU_TCOR1	0xA412FEA0
#define TMU_TCNT1	0xA412FEA4
#define TMU_TCR1	0xA412FEA8
#define TMU_TCOR2	0xA412FEAC
#define TMU_TCNT2	0xA412FEBO
#define TMU_TCR2	0xA412FEB4

#define SCSMR0		0xA4430000
#define SCBRR0		0xA4430004
#define SCSCR0		0xA4430008
#define SCTDSR0		0xA443000C
#define SCFER0		0xA4430010
#define SCSSR0		0xA4430014
#define SCFCR0		0xA4430018
#define SCFDR0		0xA443001C
#define SCFTDR0		0xA4430020
#define SCFRDR0		0xA4430024

#define SCSMR1		0xA4450000
#define SCBRR1		0xA4450004
#define SCSCR1		0xA4450008
#define SCTDSR1		0xA445000C
#define SCFER1		0xA4450010
#define SCSSR1		0xA4450014
#define SCFCR1		0xA4450018
#define SCFDR1		0xA445001C
#define SCFTDR1		0xA4450020
#define SCFRDR1		0xA4450024

#define SIOF_SIMDR0	0xA4410000
#define SIOF_SISCR0	0xA4420002
#define SIOF_SITDAR0	0xA4410004
#define SIOF_SIRDAR0	0xA4410006
#define SIOF_SICDAR0	0xA4410008
#define SIOF_SICTR0	0xA441000C
#define SIOF_SIFCTR0	0xA4410010
#define SIOF_SISTR0	0xA4410014
#define SIOF_SIIER0	0xA4410016
#define SIOF_SITDR0	0xA4410020
#define SIOF_SIRDR0	0xA4410024
#define SIOF_SITCR0	0xA4410028
#define SIOF_SIRCR0	0xA441002C

#define SIOF_SIMDR1	0xA4420000
#define SIOF_SISCR1	0xA4420002
#define SIOF_SITDAR1	0xA4420004
#define SIOF_SIRDAR1	0xA4420006
#define SIOF_SICDAR1	0xA4420008
#define SIOF_SICTR1	0xA442000C
#define SIOF_SIFCTR1	0xA4420010
#define SIOF_SISTR1	0xA4420014
#define SIOF_SIIER1	0xA4420016
#define SIOF_SITDR1	0xA4420020
#define SIOF_SIRDR1	0xA4420024
#define SIOF_SITCR1	0xA4420028
#define SIOF_SIRCR1	0xA442002C

#define SIO_SIMDR0	0xA4500000
#define SIO_SICTR0	0xA4500004
#define SIO_SISTBCR00	0xA4500008
#define SIO_SISTBCR10	0xA450000C
#define SIO_SITDR0	0xA4500014
#define SIO_SIRDR0	0xA4500018
#define SIO_SISTR0	0xA450001C
#define SIO_SIIER0	0xA4500020
#define SIO_SISCR0	0xA4500024

#define SIO_SIMDR1	0xA4510000
#define SIO_SICTR1	0xA4510004
#define SIO_SISTBCR01	0xA4510008
#define SIO_SISTBCR11	0xA451000C
#define SIO_SITDR1	0xA4510014
#define SIO_SIRDR1	0xA4510018
#define SIO_SISTR1	0xA451001C
#define SIO_SIIER1	0xA4510020
#define SIO_SISCR1	0xA4510024

#ifndef PACR
#define PACR		0xA4050100
#define PBCR		0xA4050102
#define PCCR		0xA4050104
#define PDCR		0xA4050106
#define PECR		0xA4050108
#define PFCR		0xA405010A
#define PGCR		0xA405010C
#define PHCR		0xA405010E
#define PJCR		0xA4050110
#define PKCR		0xA4050112
#define PLCR		0xA4050114
#define SCPCR		0xA4050116
#define PMCR		0xA4050118
#define PNCR		0xA405011A
#define PQCR		0xA405011C
#define SCPCR2		0xA405011E
#endif

#define PSELA		0xA4050140
#define HIZCRA		0xA4050146
#define HIZCRB		0xA4050148

#define PADR		0xA4050120
#define PBDR		0xA4050122
#define PCDR		0xA4050124
#define PDDR		0xA4050126
#define PEDR		0xA4050128
#define PFDR		0xA405012A
#define PGDR		0xA405012C
#define PHDR		0xA405012E
#define PJDR		0xA4050130
#define PKDR		0xA4050132
#define PLDR		0xA4050134
#define SCPDR		0xA4050136
#define PMDR		0xA4050138
#define PNDR		0xA405013A
#define PQDR		0xA405013C
#define SCPDR2		0xA405013E

#define ADDRA		0xA44C0080
#define ADDRB		0xA44C0082
#define ADDRC		0xA44C0084
#define ADDRD		0xA44C0086
#define ADCSR		0xA44C0088

#define CMSTR		0xA44A0000
#define CMCSR0		0xA44A0010
#define CMCNT0		0xA44A0014
#define CMCOR0		0xA44A0018
#define CMCSR1		0xA44A0020
#define CMCNT1		0xA44A0024
#define CMCOR1		0xA44A0028
#define CMCSR2		0xA44A0030
#define CMCNT2		0xA44A0034
#define CMCOR2		0xA44A0038
#define CMCSR3		0xA44A0040
#define CMCNT3		0xA44A0044
#define CMCOR3		0xA44A0048
#define CMCSR4		0xA44A0050
#define CMCNT4		0xA44A0054
#define CMCOR4		0xA44A0058
#define CMCSR5		0xA44A0060
#define CMCNT5		0xA44A0064
#define CMCOR5		0xA44A0068

#define USBIFR0		0xA4480000
#define USBISR0		0xA4480010
#define USBIER0		0xA4480020
#define USBEPDR0I	0xA4480030
#define USBEPDR0O	0xA4480034
#define USBEPDR0S	0xA4480038
#define USBEPDR1	0xA448003C
#define USBEPDR2	0xA4480040
#define USBEPDR3	0xA4480044
#define USBEPDR4	0xA4480048
#define USBEPDR5	0xA448004C
#define USBEPDR6	0xA4480050
#define USBEPDR7	0xA4480054
#define USBEPDR8	0xA4480058
#define USBEPDR9	0xA448005C
#define USBEPSZ0O	0xA4480080
#define USBEPSZ3	0xA4480084
#define USBEPSZ6	0xA4480088
#define USBEPSZ9	0xA448008C
#define USBTRG		0xA44800A0
#define USBDASTS	0xA44800A4
#define USBFCLR		0xA44800A8
#define USBDMA		0xA44800AC
#define USBEPSTL	0xA44800B0
#define USBCVR		0xA44800B4
#define USBTSR		0xA44800C0
#define USBXVERCR	0xA44800D0

#define ICDR		0xA4470000
#define ICCR		0xA4470004
#define ICSR		0xA4470008
#define ICIC		0xA447000C
#define ICCL		0xA4470010
#define ICCH		0xA4470014

#define SIM_SCSMR	0xA4490000
#define SIM_SCBRR	0xA4490002
#define SIM_SCSCR	0xA4490004
#define SIM_SCTDR	0xA4490006
#define SIM_SCSSR	0xA4490008
#define SIM_SCRDR	0xA449000A
#define SIM_SCSCMR	0xA449000C
#define SIM_SCSC2R	0xA449000E
#define SIM_SCWAIT	0xA4490010
#define SIM_SCGRD	0xA4490012
#define SIM_SCSMPL	0xA4490014

#define MMC_CMDR0	0xA45C0000
#define MMC_CMDR1	0xA45C0001
#define MMC_CMDR2	0xA45C0002
#define MMC_CMDR3	0xA45C0003
#define MMC_CMDR4	0xA45C0004
#define MMC_CMDR5	0xA45C0005
#define MMC_CMDR6	0xA45C0006
#define MMC_OPCR	0xA45C000A
#define MMC_CSTR	0xA45C000B
#define MMC_INTCR0	0xA45C000C
#define MMC_INTCR1	0xA45C000D
#define MMC_INTCR2	0xA45C0046
#define MMC_INTSTR0	0xA45C000E
#define MMC_INTSTR1	0xA45C000F
#define MMC_INTSTR2	0xA45C0048
#define MMC_CLKON	0xA45C0010
#define MMC_CTOCR	0xA45C0011
#define MMC_IOMCR	0xA45C0013
#define MMC_TBCR	0xA45C0014
#define MMC_MODER	0xA45C0016
#define MMC_CMDTYR	0xA45C0018
#define MMC_RSPTYR	0xA45C0019
#define MMC_TBNCR	0xA45C001A
#define MMC_RSPR0	0xA45C0020
#define MMC_RSPR1	0xA45C0021
#define MMC_RSPR2	0xA45C0022
#define MMC_RSPR3	0xA45C0023
#define MMC_RSPR4	0xA45C0024
#define MMC_RSPR5	0xA45C0025
#define MMC_RSPR6	0xA45C0026
#define MMC_RSPR7	0xA45C0027
#define MMC_RSPR8	0xA45C0028
#define MMC_RSPR9	0xA45C0029
#define MMC_RSPR10	0xA45C002A
#define MMC_RSPR11	0xA45C002B
#define MMC_RSPR12	0xA45C002C
#define MMC_RSPR13	0xA45C002D
#define MMC_RSPR14	0xA45C002E
#define MMC_RSPR15	0xA45C002F
#define MMC_RSPR16	0xA45C0030
#define MMC_DMACR	0xA45C0044
#define MMC_DTOUTR	0xA45C0032
#define MMC_DR		0xA45C0040
#define MMC_FIFOCLR	0xA45C0042

#define MFIIDX		0xA44D0000
#define MFIGSR		0xA44D0004
#define MFISCR		0xA44D0008
#define MFIMCR		0xA44D000C
#define MFIIICR		0xA44D0010
#define MFIEICR		0xA44D0014
#define MFIADR		0xA44D0018
#define MFIDATA		0xA44D001C
#define LCDCR		0xA44D0038
#define MFIBCR		0xA44D0040

#define CAPSR		0xA4401000
#define CAPCR		0xA4401004
#define CAPAR		0xA4401008
#define CAPDR		0xA440100C
#define CNVSR		0xA4401010
#define CNVCR		0xA4401014
#define CNVPR		0xA4401018
#define EVNTRCLR	0xA4401020
#define EVNTRSET	0xA4401024

#define FLCMNCR		0xA4530000
#define FLCMDCR		0xA4530004
#define FLCMCDR		0xA4530008
#define FLADR		0xA453000C
#define FLDATAR		0xA4530010
#define FLDTCNTR	0xA4530014
#define FLINTDMACR	0xA4530018
#define FLBSYTMR	0xA453001C
#define FLBSYCNT	0xA4530020
#define FLDTFIFO	0xA4530024
#define FLECFIFO	0xA4530028
#define FLTRCR		0xA453002C

#define KYCR1		0xA44B0000
#define KYCR2		0xA44B0004
#define KYINDR		0xA44B0008
#define KYOUTDR		0xA44B000C

#endif /* __ASM_SH_SH7290_H */
