/*
 * linux/drivers/mq1100fb-pci.c
 *
 * Copyright © 2003 Keith Packard
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive for
 * more details.
 *
 *	    MediaQ 1100/1132 LCD Controller Frame Buffer Driver
 *
 * Please direct your questions and comments on this driver to the following
 * email address:
 *
 *	keithp@keithp.com
 *
 * ChangeLog
 *
 * 2003-05-18: <keithp@keithp.com>
 *	- Ported from PCI development board to ARM H5400
 */

#include "mq1100.h"

#define MQ_INIT (&mqInitSharp)

static MqInitData  mqInitSharp = {
    /* DC */
    {
	/* dc00 */		0x00000001,
	/* dc01 */		0x00000003,
	/* dc02 */		0x00000001,
	/* dc03 NOT SET */	0x0,
	/* dc04 */		0x00000004,
	/* dc05 */		0x00000003,
    },
    /* CC */
    {
	/* cc00 */		0x00000002,
	/* cc01 */		0x00001010,
	/* cc02 */		0x00000aa0,
	/* cc03 */		0x00000000,
	/* cc04 */		0x00000000,
    },
    /* MIU */
    {
	/* mm00 */		0x00000001,
	/* mm01 */		0x1b676ca8,
	/* mm02 */		0x00000000,
	/* mm03 */		0x00000000,
	/* mm04 */		0x00000000,
    },
    /* GC */
    {
	/* gc00 */		0x032100c8, /* powered down */
	/* gc01 */		0x00000000,
	/* gc02 */		0x01400194,
	/* gc03 */		0x00ef0106,
	/* gc04 */		0x0157014d,
	/* gc05 */		0x01040103,
	/* gc06 */		0x013f0000,
	/* gc07 NOT SET */	0x0,
	/* gc08 */		0x013f0000,
	/* gc09 */		0x00ef0000,
	/* gc0a */		0x00000000,
	/* gc0b */		0x01550120,
	/* gc0c */		0x00000000,
	/* gc0d */		0x0001c408,
	/* gc0e */		0x00000280,
	/* gc0f NOT SET */	0x0,
	/* gc10 */		0x02ff07ff,
	/* gc11 */		0x000000ff,
	/* gc12 NOT SET */	0x0,
	/* gc13 NOT SET */	0x0,
	/* gc14 */		0x00000000,
	/* gc15 */		0x00000000,
	/* gc16 */		0x00000000,
	/* gc17 */		0x00000000,
	/* gc18 */		0x00000000,
	/* gc19 */		0x00000000,
	/* gc1a */		0x00000000,
    },
    /* FP */
    {
	/* fp00 */		0x00406120,
	/* fp01 */		0x001d5088,
	/* fp02 */		0xbffcfcff,
	/* fp03 */		0x00000000,
	/* fp04 */		0x80bd0001,
	/* fp05 */		0x89000000,
	/* fp06 */		0x80000000,
	/* fp07 */		0x00000000,
	/* fp08 NOT SET */	0x0,
	/* fp09 NOT SET */	0x0,
	/* fp0a */		0x00000000,
	/* fp0b */		0x00000000,
	/* fp0c NOT SET */	0x0,
	/* fp0d NOT SET */	0x0,
	/* fp0e NOT SET */	0x0,
	/* fp0f NOT SET */	0x0,
	/* fp10 */		0x97a4c5f8,
	/* fp11 */		0x61e3db02,
	/* fp12 */		0xd3e081bc,
	/* fp13 */		0x25a79f46,
	/* fp14 */		0x4a791825,
	/* fp15 */		0xbc2e06df,
	/* fp16 */		0x0e3d5c61,
	/* fp17 */		0xf87a429b,
	/* fp18 */		0xf1c2a39e,
	/* fp19 */		0x0785bd64,
	/* fp1a */		0xb586e7da,
	/* fp1b */		0x43c1f920,
	/* fp1c */		0x2c1f7e43,
	/* fp1d */		0xda5860b9,
	/* fp1e */		0x685b3a07,
	/* fp1f */		0x9e1c24fd,
	/* fp20 */		0xe0d3b28f,
	/* fp21 */		0x1694ac75,
	/* fp22 */		0xa497f6cb,
	/* fp23 */		0x52d0e831,
	/* fp24 */		0x3d0e6f52,
	/* fp25 */		0xcb4971a8,
	/* fp26 */		0x794a2b16,
	/* fp27 */		0x8f0d35ec,
	/* fp28 */		0x86b5d4e9,
	/* fp29 */		0x70f2ca13,
	/* fp2a */		0xc2f190ad,
	/* fp2b */		0x34b68e57,
	/* fp2c */		0x5b680934,
	/* fp2d */		0xad2f17ce,
	/* fp2e */		0x1f2c4d70,
	/* fp2f */		0xe96b538a,
	/* fp30 */		0x80800000,
	/* fp31 */		0x88888420,
	/* fp32 */		0x94a49248,
	/* fp33 */		0xaaaaaa54,
	/* fp34 */		0x6b5b55ab,
	/* fp35 */		0x77776db7,
	/* fp36 */		0x7f7f7bdf,
	/* fp37 */		0xffff7fff,
    },
    /* GE */
    {
	/* ge00 NOT SET */	0x0,
	/* ge01 NOT SET */	0x0,
	/* ge02 NOT SET */	0x0,
	/* ge03 NOT SET */	0x0,
	/* ge04 NOT SET */	0x0,
	/* ge05 NOT SET */	0x0,
	/* ge06 NOT SET */	0x0,
	/* ge07 NOT SET */	0x0,
	/* ge08 NOT SET */	0x0,
	/* ge09 NOT SET */	0x0,
	/* ge0a */		0x40000280,
	/* ge0b */		0x00000000,
    },
};

static MqInitData *
mq1100_pci_detect_lcd (MqMap *mq)
{
    return MQ_INIT;
}

static struct MqFuncs
mq1100_pci_funcs =
{
    mq1100_pci_detect_lcd
};

static int __devinit
mq1100_pci_probe(struct pci_dev		    *pdev,
		 const struct pci_device_id *ent)
{
    int err;

    debug ("enter\n");
    err = pci_enable_device(pdev);
    if (err) {
	debug ("error enabling device %d\n", err);
	return err;
    }
    return mq1100_probe (pci_resource_start (pdev, 0),
			 pci_resource_start (pdev, 1),
			 &mq1100_pci_funcs);
}

static void __devexit mq1100_pci_remove(struct pci_dev * pdev)
{
    mq1100_cleanup ();
}

enum mq1100_pci_chipsets {
    MQ_1132,
};

static struct pci_device_id mq1100fb_pci_tbl[] __devinitdata = {
    { 0x4d51, 0x0120, PCI_ANY_ID, PCI_ANY_ID, 0, 0, MQ_1132 },
    { 0,}
};

MODULE_DEVICE_TABLE(pci, mq1100fb_pci_tbl);

static struct pci_driver mq1100fb_pci_driver = {
    name:	    "mq1100fb",
    probe:	    mq1100_pci_probe,
    remove:	    __devexit_p(mq1100_pci_remove),
    id_table:	    mq1100fb_pci_tbl,
};

int __init mq1100fb_pci_init(void)
{
    int	i, rc = -ENODEV;

    debug ("Calling pci_module_init (%X) %X\n",
	   (unsigned) pci_module_init,
	   (unsigned) &mq1100fb_pci_driver);
    i = pci_register_driver (&mq1100fb_pci_driver);
    debug ("pci_register_driver returns %d\n", i);
    if (i <= 0) {
	debug ("calling pci_unregister driver\n");
	pci_unregister_driver (&mq1100fb_pci_driver);
	debug ("back from pci_unregister_driver\n");
    }
    else
	rc = 0;

    return rc;
}

void __exit mq1100fb_pci_exit(void)
{
    pci_unregister_driver(&mq1100fb_pci_driver);
}

module_init(mq1100fb_pci_init);
module_exit(mq1100fb_pci_exit);

MODULE_AUTHOR("Keith Packard <keithp@keithp.com>");
MODULE_DESCRIPTION("Framebuffer driver for MediaQ 1100 chips");
MODULE_LICENSE("GPL");
