/*
 * Copyright (C) 2000 Jeff Dike (jdike@karaya.com)
 * Licensed under the GPL
 */

#include "linux/init.h"
#include "linux/bootmem.h"
#include "linux/blk.h"
#include "asm/types.h"
#include "user_util.h"
#include "initrd.h"
#include "init.h"

extern __u64 file_size(char *file);

static char *initrd __initdata = NULL;

static int __init read_initrd(void)
{
	void *area;
	int size;

	if(initrd == NULL) return 0;
	size = file_size(initrd);
	if(size < 0) return 0;
	area = alloc_bootmem(size);
	if(area == NULL) return 0;
	if(load_initrd(initrd, area, size) == -1) return 0;
	initrd_start = (unsigned long) area;
	initrd_end = initrd_start + size;
	return 0;
}

__uml_postsetup(read_initrd);

static int __init uml_initrd_setup(char *line, int *add)
{
	initrd = line;
	return 0;
}

__uml_setup("initrd=", uml_initrd_setup, 
"initrd=<initrd image>\n"
"    This is used to boot UML from an initrd image.  The argument is the\n"
"    name of the file containing the image\n"
);

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
