
/*
 * linux/arch/arm/mach-sa1100/jornada56x.c
 * Interrupt demux modeled on:
 *     linux/arch/arm/mach-sa1100/sa1111.c
 *         Original code by John Dorsey
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <asm/arch/irqs.h>
#include <asm/setup.h>
#include <asm/hardware.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/serial_sa1100.h>
#include <linux/sched.h>
#include <linux/serial_core.h>

#include "generic.h"
#include <linux/wait.h>          /* for wait_queue_head_t, used in h3600_ts.h */
#include <linux/types.h>         /* for u_char, used in h3600_ts.h */
#include <linux/h3600_ts.h>      /* for TS_RET */
#include <asm/arch/irq.h>
#include <asm/mach/irq.h>
#include <linux/pm.h>
#include <asm/arch/pm.h>

void jornada_ts_touchpanel_event( unsigned short x, unsigned short y, int down );
#define ASIC_INT_DELAY  10  /* Poll every 10 milliseconds */
#define MICROWIRE_SIZE	8	/* we always do 8 write/read pairs */
enum {PCR_GET_VALUE=1, PCR_SET_VALUE, PCR_BIT_SET, PCR_BIT_CLEAR};

int microwire_data[MICROWIRE_SIZE];
unsigned long jornada_touch_mask = 0;

static void jornada56x_IRQ_demux(int irq, void *dev_id, struct pt_regs *regs);
struct pt_regs jcareg;

void SetPMUPCRRegister(long arg_action, long arg_value)
{
	long this_pcr;
	
	//Read PCR and remove the unwanted bit 6
	this_pcr = (((JORNADA_PCR & 0xff80) >>1) | (JORNADA_PCR & 0x3f));

	this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1); 
	if (this_pcr & JORNADA_SM_CLK_EN)
		this_pcr |= JORNADA_MUX_CLK1;
	else if (this_pcr & JORNADA_MMC_CLK_EN)
		this_pcr |= JORNADA_MUX_CLK0; 
	switch (arg_action) {
		case PCR_SET_VALUE:
			this_pcr = arg_value;
			break;
		case PCR_BIT_SET: /* enable controller */
			if(arg_value & JORNADA_SM_CLK_EN) {		/* smart card controller */
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1);
				this_pcr |= JORNADA_MUX_CLK1;
			}
			else if(arg_value & JORNADA_MMC_CLK_EN) {	/* mmc controller */
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1); 
				this_pcr |= JORNADA_MUX_CLK0;
			}			
			this_pcr |= arg_value;
			break;
		case PCR_BIT_CLEAR:		/* disable controller */
			/* smart card or mmc controller */
			if (arg_value & (JORNADA_SM_CLK_EN | JORNADA_MMC_CLK_EN))
				this_pcr &= ~(JORNADA_MUX_CLK0 | JORNADA_MUX_CLK1);
			this_pcr &= ~arg_value;
			break;
		case PCR_GET_VALUE:
		default:
			break;
	}
	JORNADA_PCR = this_pcr;	
}

void jornada_microwire_init(void)
{
static int initialized = 0;

	if (initialized)
		return;
	initialized = 1;
	JORNADA_GPIOAFR |= JORNADA_GP_MW;
	udelay(100);
	JORNADA_MWFTR = (8 << JORNADA_MWFTR_V_TFT)
		| (8 << JORNADA_MWFTR_V_RFT); /* 0x108 */
	udelay(100);
  	SetPMUPCRRegister(PCR_BIT_SET, JORNADA_MW_CLK_EN);
	udelay(100);
	JORNADA_MWCR = JORNADA_MW_EN | JORNADA_DSS_16_BIT
		| (10 << JORNADA_MWCR_V_SCR) /* 0xa07 */
		| JORNADA_FIFO_RST; /* reset FIFO */
	udelay(100);
	JORNADA_MWCR &= ~JORNADA_FIFO_RST;
	/* set FIFO interrupt levels to 8 for each of Rx, Tx */
	udelay(100);
	JORNADA_MWFTR = (8 << JORNADA_MWFTR_V_TFT)
		| (8 << JORNADA_MWFTR_V_RFT); /* 0x108 */
}
void jornada_sound_init(void)
{
static int initialized = 0;

	if (initialized)
		return;
	initialized = 1;
	JORNADA_GPIOAFR |= JORNADA_GP_L3;
	udelay(100);
  	SetPMUPCRRegister(PCR_BIT_SET, JORNADA_L3CLK_EN | JORNADA_I2S_CLK_EN);
	udelay(100);
	JORNADA_L3CFR |= JORNADA_L3_EN; /* Enable L3 interface */
}

void jornada_contrast(int arg_contrast)
{
}

int jornada_brightness(int arg_brightness)
{
	int i = 0;

        if (arg_brightness) {
        	// To adjust the brightness, range is from 0 to 255.
        	JORNADA_PWM1_DATA = 50;
        } else {
        	JORNADA_PWM1_DATA = 0;
        }
	return i;
}

void jornada_microwire_start(void)
{
int i;
int retry = 90000;

	GRER &= ~GPIO_JORNADA56X_TOUCH;
	GFER &= ~GPIO_JORNADA56X_TOUCH;
	jornada_microwire_init();
	while(retry-- && (JORNADA_MWFSR & JORNADA_MW_RNE))
		i = JORNADA_MWDR;	 /* empty out existing data */
}

void jornada_microwire_wait(void)
{
int retry = 1000000;
	JORNADA_MWDR = JORNADA_MW_END;
while (retry-- && !(JORNADA_MWFSR & JORNADA_MW_RFS))
	;
}

void jornada_microwire_read(void)
{
int i;

	jornada_microwire_wait();
	for (i = 0; i < MICROWIRE_SIZE; i++)
		microwire_data[i] = (JORNADA_MWDR & 0xffff) >> 4;
}

void jornada56x_battery(void)
{
int i;
printk("%s() ", __FUNCTION__);
	jornada_microwire_start();
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_MAIN_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	JORNADA_MWDR = JORNADA_MW_BACKUP_BATTERY;
	jornada_microwire_read();
}
static struct pm_dev *jornada56x_pm_dev;
static int suspended = 0;

static int jornada56x_pm_callback(struct pm_dev *pm_dev,
        pm_request_t req, void *data)
{
#if 0
printk("%s %x\n", __FUNCTION__, req);
udelay(20000);
#endif
        switch (req) {
        case PM_SUSPEND: /* Enter D1-D3 */
                suspended = 1;
                break;
        case PM_RESUME:  /* Enter D0 */
                if ( suspended ) {
                        suspended = 0;
                        /* turn on RS232 transceiver */
			JORNADA_GPDPSR = JORNADA_RS232_ON;
/* re-init serial port for sound */
                }
                break;
        }
        return 0;
}

static void suspend_button_task_handler(void *data)
{
    pm_suggest_suspend();
}
static struct tq_struct  suspend_button_task =
	{ routine: suspend_button_task_handler };

void jornada56x_suspend(void)
{
       	schedule_task(&suspend_button_task);
}
int jornada56x_gettouch(int *arg_x, int *arg_y)
{
int i;
static int last_x, last_y;
int this_pressure = 0;

	jornada_microwire_start();
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_X;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	JORNADA_MWDR = JORNADA_MW_TOUCH_Y;
	jornada_microwire_read();
        this_pressure = ( (GPLR & GPIO_JORNADA56X_TOUCH) == 0);
	if (this_pressure) {
		for (i = 0; i < 2; i++)
		jornada_ts_touchpanel_event(microwire_data[i], microwire_data[i+4], this_pressure);
		last_x = (microwire_data[0] + microwire_data[1]
			+ microwire_data[2] + microwire_data[3]) / 4;
		last_y = (microwire_data[4] + microwire_data[5]
			+ microwire_data[6]) / 3;
	}
	else
		jornada_ts_touchpanel_event(0, 0, 0);
	*arg_x = last_x;
	*arg_y = last_y;
#if 0
printk("(%d,%d)=%d\n", *arg_x, *arg_y, this_pressure);
#endif
	return this_pressure;
}

#define MAKEIRQ(A, B, C, D) \
  static void jmask_and_ack_ ## A (unsigned int irq) { C = (1 << (irq - B)); } \
  static void jmask_ ## A (unsigned int irq) { D &= ~(1 << (irq - B)); } \
  static void junmask_ ## A (unsigned int irq) { D |= (1 << (irq - B)); } \
  static void jsetup_ ## A (void) { \
    int irq; \
	for (irq = B; irq <= B+15; irq++) { \
		irq_desc[irq].valid	= 1; \
		irq_desc[irq].probe_ok	= 0; \
		irq_desc[irq].mask_ack	= jmask_and_ack_ ## A; \
		irq_desc[irq].mask	= jmask_ ## A; \
		irq_desc[irq].unmask	= junmask_ ## A; \
	} \
  }

MAKEIRQ(low, IRQ_JORNADA_MMC, JORNADA_INT_STAT, JORNADA_INT_EN)
MAKEIRQ(high, IRQ_JORNADA_UART, JORNADA_INT_STAT2, JORNADA_INT_EN2)
MAKEIRQ(gpiob, IRQ_JORNADA_GPIO_B0, JORNADA_GPIOB_STAT, JORNADA_GPIOB_FE_EN)
MAKEIRQ(gpioc, IRQ_JORNADA_GPIO_C0, JORNADA_GPIOC_STAT, JORNADA_GPIOC_FE_EN)

static void jornada56x_IRQ_demux(int irq, void *dev_id, struct pt_regs *regs)
{
unsigned long stat0, stat1, statb, statc;
int i, found_one;

	do {
		found_one = 0;
		stat0 = JORNADA_INT_STAT & 0xffff & JORNADA_INT_EN
			& ~(JORNADA_GPIO_B_INT | JORNADA_GPIO_C_INT);
		stat1 = JORNADA_INT_STAT2 & 0xffff & JORNADA_INT_EN2;
		statb = JORNADA_GPIOB_STAT & 0xffff & JORNADA_GPIOB_FE_EN;
		statc = JORNADA_GPIOC_STAT & 0xffff & JORNADA_GPIOC_FE_EN;
#define CHECK_STAT(A,B) \
		for (i = A; B; i++, B >>= 1) \
			if (B & 1) { \
				found_one = 1; \
				do_IRQ(i, regs); \
			}
		CHECK_STAT(IRQ_JORNADA_MMC, stat0);
		CHECK_STAT(IRQ_JORNADA_UART, stat1);
		CHECK_STAT(IRQ_JORNADA_GPIO_B0, statb);
		CHECK_STAT(IRQ_JORNADA_GPIO_C0, statc);
	} while(found_one);
}

static int __init jornada56x_init(void)
{
int irq;
	GPCR = 0x0f424000;
	GAFR = 0x080803fc;
	GPDR = 0x0f5243fc;

	JORNADA_INT_EN = 0;
	JORNADA_INT_STAT = 0xffff;
	JORNADA_INT_EN2 = 0;
	JORNADA_INT_STAT2 = 0xffff;
	JORNADA_GPIOB_FE_EN = 0;
	JORNADA_GPIOB_RE_EN = 0;
	JORNADA_GPIOB_STAT = 0xffff;
	JORNADA_GPIOC_FE_EN = 0;
	JORNADA_GPIOC_RE_EN = 0;
	JORNADA_GPIOC_STAT = 0xffff;
	udelay(1);
	jsetup_low();
	jsetup_high();
	jsetup_gpiob();
	jsetup_gpioc();
        set_GPIO_IRQ_edge( GPIO_JORNADA56X_ASIC, GPIO_BOTH_EDGES );
        if (request_irq(GPIO_JORNADA56X_ASIC_IRQ, jornada56x_IRQ_demux,
                0, "Jornada56x ASIC", 0)) {
		printk("%s(): request_irq failed\n", __FUNCTION__);
                return -1;
        }
	mdelay(2);	// Delay 2 milliseconds.

	// Initialise the PMU register
  	JORNADA_GPIOAFR = 0x02; /* enable pwm */
  	JORNADA_SCR = JORNADA_RCLK_EN;      // Enable the internal system reference clock for ASIC
	mdelay(1); /* ???????? */


	// Read more on SetPMUPCRRegister function on the next section
	// It is better to turn on the GPIO int clock here,
	// the PWM clock is for adjusting the brightness of the display
  	SetPMUPCRRegister(PCR_BIT_SET,
		(JORNADA_GPIO_INT_CLK_EN|JORNADA_PWM1CLK_EN));

	JORNADA_PWM1_CKDR = 0;
	JORNADA_PWM2_CKDR = 0;
	mdelay(2);	// Delay 2 milliseconds.

	// Initialise the GPIO registers
  	JORNADA_GPBPSR = 0x001B;
  	JORNADA_GPCPSR = 0x31C0;
  	JORNADA_GPDPSR = 0xAD99;
  	
  	JORNADA_GPBPCR = 0x3E24;
  	JORNADA_GPCPCR = 0x0002;
  	JORNADA_GPDPCR = 0x5264;
	JORNADA_GPDPSR = JORNADA_RS232_ON;	/* enable rs232 transceiver */
	JORNADA_GPDPSR = JORNADA_CF_POWER_OFF;	/* turn power off to CF */

  	JORNADA_GPBPSDR = 0x81FF;
  	JORNADA_GPCPSDR = 0xB96F;
  	JORNADA_GPDPSDR = 0xFBFF;
  	
  	JORNADA_GPBPSLR = 0x00D0;
  	JORNADA_GPCPSLR = 0x0000;
  	JORNADA_GPDPSLR = 0xA198;
  	
  	JORNADA_GPBPFDR = 0x81FF;
  	JORNADA_GPCPFDR = 0xB96F;
  	JORNADA_GPDPFDR = 0xFBFF;
  	
  	JORNADA_GPBPFLR = 0x01D0;
  	JORNADA_GPCPFLR = 0x0000;
  	JORNADA_GPDPFLR = 0xA198;

  	JORNADA_GPBPDR = 0x01FF;
  	JORNADA_GPCPDR = 0x37C2;
  	JORNADA_GPDPDR = 0xFFFF;

	// Clear screen here
	JORNADA_GPDPSR = JORNADA_BACKLIGHT; // Turn off the front light
	JORNADA_GPDPCR = GPIO_GPIO5;
	JORNADA_GPDPCR = GPIO_GPIO13;   // Turn on power to panel

	JORNADA_GPBPCR = 0x1c0;		/* Buttons: row lines all output 0 */
	JORNADA_GPBPDR |= 0x1c0;	/* Buttons: turn row lines into outputs */

	mdelay(2);	// Delay 2 milliseconds.
	JORNADA_INT_EN |= JORNADA_GPIO_B_INT | JORNADA_GPIO_C_INT;
	jornada56x_battery();	/* Initialize state of ADC/touch screen */
        jornada56x_pm_dev = pm_register(PM_UNKNOWN_DEV, PM_SYS_UNKNOWN, jornada56x_pm_callback);
	return 0;
}
__initcall(jornada56x_init);

static void __init
fixup_jornada56x(struct machine_desc *desc, struct param_struct *params,
		 char **cmdline, struct meminfo *mi)
{
} 
static void uart_set_mctrl(struct uart_port *port, u_int mctrl)
{
} 
static u_int uart_get_mctrl(struct uart_port *port)
{
	u_int ret = TIOCM_CD | TIOCM_CTS | TIOCM_DSR; 
	return ret;
} 
static void dcd_intr(int irq, void *dev_id, struct pt_regs *regs)
{
} 
static void cts_intr(int irq, void *dev_id, struct pt_regs *regs)
{
} 
static void uart_pm(struct uart_port *port, u_int state, u_int oldstate)
{
} 
static int uart_set_wake(struct uart_port *port, u_int enable)
{
	int err = -EINVAL;

	if (port->mapbase == _Ser3UTCR0) {
		err = 0;
	}
	return err;
} 
static int uart_open(struct uart_port *port, struct uart_info *info)
{
	int ret = 0; 
	return ret;
} 
static void uart_close(struct uart_port *port, struct uart_info *info)
{
	if (port->mapbase == _Ser3UTCR0) {
	}
}

static struct sa1100_port_fns port_fns __initdata = {
	set_mctrl: uart_set_mctrl, get_mctrl: uart_get_mctrl, pm: uart_pm,
	set_wake: uart_set_wake, open: uart_open, close: uart_close };

static struct map_desc jornada56x_io_desc[] __initdata = {
        /* virtual     physical    length      domain     r  w  c  b */
        { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 1, 1, 0, 0 }, /* Flash bank 0 */
        { 0xf0000000, 0x40000000, 0x00100000, DOMAIN_IO, 1, 1, 0, 0 }, /* ASIC */
        LAST_DESC
};

static void __init jornada56x_map_io(void)
{
	sa1100_map_io();
	iotable_init(jornada56x_io_desc);

        sa1100_register_uart_fns(&port_fns);
	sa1100_register_uart(0, 3);
	sa1100_register_uart(1, 1);

	/* Ensure those pins are outputs and driving low  */
 	PPDR |= 0;
 	PPSR &= ~(0);

	/* Configure suspend conditions */
	PGSR = 0;
#if 1
PGSR = GPLR; /* preserve GPIO levels */
#endif
	PWER = GPIO_JORNADA56X_POWER_SWITCH | GPIO_JORNADA56X_ASIC | GPIO_JORNADA56X_TOUCH | PWER_RTC;
	PCFR = PCFR_OPDE;
	PSDR = 0;
}

MACHINE_START(JORNADA56X, "HP Jornada 56x")
BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
BOOT_PARAMS(0xc0000100)
FIXUP(fixup_jornada56x)
MAPIO(jornada56x_map_io)
INITIRQ(sa1100_init_irq)
MACHINE_END
