/*
 *  linux/include/asm-arm/arch-lh79520/cpld.h
 *
 *  Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef _LH79520_CPLD_H 
#define  _LH79520_CPLD_H 

typedef __attribute((packed))  struct {
	volatile u16 keys_status;
	volatile u16 reserved1;
	volatile u16 l3_reg;
	volatile u16 reserved2;
	volatile u16 lcd_pwr_cntl;
	volatile u16 reserved3;
	volatile u16 l3_mode;
	volatile u16 reserved4;
	volatile u16 gpi;
	volatile u16 reserved5;
	volatile u16 gpo;
	volatile u16 reserved6;
	volatile u16 adc_dac_left;
	volatile u16 adc_dac_right;
	volatile u16 audio_control;
	volatile u16 reserved7;
	volatile u16 display_dip_sw;
	volatile u16 reserved8;
	volatile u16 seven_seg;
	volatile u16 reserved9;
	volatile u16 misc_stat;
	volatile u16 reserved10;
	volatile u16 gpio_data_dir;
	volatile u16 reserved11;
	volatile u16 ssp_dev_sel;
	volatile u16 reserved12;
	volatile u16 ser_port1_rts;
	volatile u16 reserved13;
	volatile u16 cf_reset;
	volatile u16 reserved14;
	volatile u16 cpu_dip_sw;
	volatile u16 reserved15;
	volatile u16 intr_mask;
	volatile u16 reserved16;
	volatile u16 reserved17;
	volatile u16 reserved18;
	volatile u16 reserved19;
	volatile u16 reserved20;
	volatile u16 reserved21;
	volatile u16 reserved22;
	volatile u16 nio_reg_clk;
	volatile u16 reserved23;
} cpldRegs_t;


/* LCD power bits */
#define CPLD_EN26V		_BIT(0)		/* turn on the 26V supply */
#define CPLD_BACKLIGHT_ON	_BIT(1)		/* turn on the backlight */
#define CPLD_DISP_EN		_BIT(2)		/* note DISP_EN is not wired on the Sharp EVB display board */
#define CPLD_LCD_OE		_BIT(3)		/* enable the LCD drive signals */

/* 
 * enable the LCD 3.3V or 5V power supply; 
 * does not effect HR-TFT power on the Sharp EVB display board.
 */
#define CPLD_LCDP_EN		_BIT(4)


/* intr_mask bits */
#define CPLD_TS_INTR_ENABLE	_BIT(7)		/* Enable touch screen IRQ */
#define CPLD_CTS_INTR_ENABLE	_BIT(6)
#define CPLD_RI_INTR_ENABLE	_BIT(5)

/* misc_status bits */
#define CPLD_MISCSTS_TS_IRQ	_BIT(4)		/* Touch Screen caused IRQ */
#define CPLD_MISCSTS_TS_BUSY	_BIT(5)		/* Touch Screen busy */

/* L3 mode bits */
#if 0 // DDD
#define CPLD_L3_MODE_HI		(cpld->l3_mode |= _BIT(0))
#define CPLD_L3_MODE_LOW	(cpld->l3_mode |= ~(_BIT(0)))
#else
#define CPLD_L3_MODE_HI		cpld->l3_mode = _BIT(0) ; barrier()
#define CPLD_L3_MODE_LOW	cpld->l3_mode = 0; barrier()
#endif

/* I2S audio control register bits */
#define CPLD_DAC_USE_REQ1		_BIT(12)
#define CPLD_ADC_DMA_ENABLE		_BIT(7)
#define CPLD_DAC_DMA_ENABLE		_BIT(6)
#define CPLD_ADC_DMA_AUTO		_BIT(5)
#define CPLD_DAC_DMA_AUTO		_BIT(4)
#define CPLD_ADC_IRQ_ENABLE		_BIT(3)
#define CPLD_DAC_IRQ_ENABLE		_BIT(2)
#define CPLD_ADC_IRQ_STATUS		_BIT(1)
#define CPLD_DAC_IRQ_STATUS		_BIT(0)
#define CPLD_AUDIO_DAC_INT_PENDING	_BIT(0)
#define CPLD_AUDIO_ADC_INT_PENDING	_BIT(1)
#define CPLD_AUDIO_DAC_INT_ENALBED	_BIT(2)
#define CPLD_AUDIO_ADC_INT_ENABLED	_BIT(3)
#define CPLD_AUDIO_DAC_INT_MASK \
		(CPLD_AUDIO_DAC_INT_PENDING | CPLD_AUDIO_DAC_INT_ENALBED)
#define CPLD_AUDIO_ADC_INT_MASK \
		(CPLD_AUDIO_ADC_INT_PENDING | CPLD_AUDIO_ADC_INT_ENABLED)

#define CPLD_ALL_ADC_BITS (CPLD_ADC_IRQ_STATUS | \
		CPLD_ADC_IRQ_ENABLE | \
		CPLD_ADC_DMA_AUTO | \
		CPLD_ADC_DMA_ENABLE)

#define CPLD_ALL_DAC_BITS (CPLD_DAC_IRQ_STATUS | \
		CPLD_DAC_IRQ_ENABLE | \
		CPLD_DAC_DMA_AUTO | \
		CPLD_DAC_DMA_ENABLE | \
		CPLD_DAC_USE_REQ1)

#define CPLD_ALL_AUDIO_BITS (CPLD_ALL_DAC_BITS | CPLD_ALL_DAC_BITS)

#define CPLD_FS_BIT_FIELD	8
#define CPLD_FS_BITS		_SBF(CPLD_FS_BIT_FIELD, _BITMASK(4) );
#define CPLD_FS_8000		0
#define CPLD_FS_11025		1
#define CPLD_FS_12000		2
#define CPLD_FS_16000		3
#define CPLD_FS_22050		4
#define CPLD_FS_24000		5
#define CPLD_FS_32000		6
#define CPLD_FS_44100		7
#define CPLD_FS_48000		8

#endif // _LH79520_CPLD_H 

