/**********************************************************************
 *	$Workfile:   LH79520_wdt.h  $
 *	$Revision: 1.1.1.1 $
 *	$Author: LOGIC+miket $
 *	$Date: 2003/04/02 22:25:03 $
 *
 *	Project: LH79520 headers
 *
 *	Description:
 *      This file contains the structure definitions and manifest
 *      constants for LH79520 component:
 *      	Watchdog Timer
 *
 *	References:
 *		(1) ARM Isis Technical Reference Manual, System on Chip Group,
 *		ARM SC063-TRM-0001-B
 *
 *	COPYRIGHT (C) 2001 SHARP MICROELECTRONICS OF THE AMERICAS, INC.
 *		CAMAS, WA
 *********************************************************************/

#ifndef LH79520_WDT_H
#define LH79520_WDT_H

/*
 * Watchdog Timer Module Register Structure
 */ 
typedef struct {
	volatile unsigned int	wdctlr;	/* Control */ 
	volatile unsigned int	wdcntr;	/* Counter Reset */ 
	volatile unsigned int	wdtstr;	/* Test */ 
	volatile unsigned int	wdcnt0;	/* Counter Bits [7:0] */ 
	volatile unsigned int	wdcnt1;	/* Counter Bits [15:8] */ 
	volatile unsigned int	wdcnt2;	/* Counter Bits [23:16] */ 
	volatile unsigned int	wdcnt3;	/* Counter Bits [31:24] */ 
} WDTIMERREGS;

/**********************************************************************
 * Watchdog Timer Register Bit Fields
 *********************************************************************/ 

/**********************************************************************
 * Watchdog Control Register Bit Fields
 *********************************************************************/ 
#define	WDT_CTRL_DISABLE	0
#define	WDT_CTRL_ENABLE		_SBF(0,1)
#define WDT_CTRL_RSP_FIQ	_SBF(1,0)		
#define WDT_CTRL_RSP_RESET	_SBF(1,1)		
#define	WDT_CTRL_FRZ_ENABLE	_BIT(3)
#define WDT_CTRL_TOP		_SBF(4,((n)&0xF)

/**********************************************************************
 * Watchdog Counter Reset Register Bit Fields
 *********************************************************************/ 
#define	WDT_WDCNTR			(0x1984)

/**********************************************************************
 * Watchdog Register Bit Fields
 *********************************************************************/ 
#define WDT_WD_NWDFIQ			_BIT(7)
#define WDT_WD_NWDRES			_BIT(6)

#endif /* LH79520_WDT_H */
