#include <stdio.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <opie/ocontact.h>
#include <opie/orecordlist.h>
#include "opieaddressbookplugin.h"
#include "opieaddressee.h"

OpieAddressBookPlugin::OpieAddressBookPlugin() : ref(0) {

  access = new OContactAccess("OpieAddressBookPlugin");
  
}

KABC::Addressee::List OpieAddressBookPlugin::getAddressees() {
    KABC::Addressee::List results;
    OContactAccess access("OpieAddressBookPlugin");
    OContactAccess::List::Iterator it;
    ORecordList<OContact> accessList = access.sorted(true,0,0,0);
    for(it = accessList.begin(); it != accessList.end(); ++it ) {
        OpieAddressee addressee( *it );
        results.append(addressee);
    }
    return results;
}

QString OpieAddressBookPlugin::name() {
  return QString::QString("OpieAddressBookPlugin");
}


KABC::Addressee::List OpieAddressBookPlugin::findByEmail(const QString &email) {
printf("OpieAddressBookPlugin::findByEmail: email=%s\n", email.ascii());
  KABC::Addressee::List results;

  ORecordList<OContact> accessList = access->sorted(true,0,0,0);
  OContactAccess::List::Iterator it;
  for(it = accessList.begin(); it != accessList.end(); ++it ) {
    OContact contact = *it;
    QStringList emailList = contact.emailList();
    QStringList foundEmails = emailList.grep(email,false);
    if (foundEmails.count() >= 1) {
      OpieAddressee a(contact);
  printf("Found Contact %s\n", a.formattedName().ascii());
      results.append(a);
    }
  }
  return results;
  
}

QRESULT OpieAddressBookPlugin::queryInterface( const QUuid &uuid, QUnknownInterface **iface )
{
printf("Start: OpieAddressBookPlugin::queryInterface\n");
    *iface = 0;
    if ( uuid == IID_QUnknown )
      *iface = this;
    else if ( uuid == IID_KOAddressBookInterface )
      *iface = this;
    if ( *iface )
      (*iface)->addRef();
    return QS_OK;
printf("End:   OpieAddressBookPlugin::queryInterface\n");
}

Q_EXPORT_INTERFACE()
{
    Q_CREATE_INSTANCE( OpieAddressBookPlugin )
}

