/*
    This file is part of libkabc.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KABC_STDADDRESSBOOK_H
#define KABC_STDADDRESSBOOK_H

#include <opie/ocontactaccess.h>
#include "opieaddressee.h"
#include "opieaddress.h"

namespace KABC {

class AddressBook {

    public:
        AddressBook();
       ~AddressBook();
        Addressee::List findByEmail( const QString & );

    protected:
	OContactAccess *access;
};
    

class StdAddressBook : public AddressBook
{
  public:
    /**
      Return the standard addressbook object.
    */
    static AddressBook *self();


  protected:
    StdAddressBook();
    ~StdAddressBook();

    void init( bool onlyFastResources );

  private:
    static AddressBook *mSelf;
    static bool mAutomaticSave;
};

}
#endif
