#include <kfiledialog.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qapplication.h>

#ifndef DESKTOP_VERSION
#include <ofileselector.h>
QString KFileDialog::getSaveFileName( const QString & fn,
                                             const QString & cap , QWidget * par )
{
    QString retfile = "";
    QDialog dia ( par, "input-dialog", true ); 
    QVBoxLayout lay( &dia );
    lay.setMargin(7); 
    lay.setSpacing(7); 
    //  if ( QApplication::desktop()->width() < 480 ) 
//          dia.setMaximumSize( 230,280 );
//      else
//          dia.setFixedSize( 400,400 ); 
    QFileInfo fi ( fn );
    OFileSelector o ( &dia,OFileSelector::FileSelector, OFileSelector::Save, fi.dirPath(true), fi.fileName() );
    lay.addWidget( &o);
    // o.setNewVisible( true );
    // o.setNameVisible( true ); 
    dia.setCaption( cap );
    dia.showMaximized();
    int res = dia.exec();
    if ( res )
        retfile = o.selectedName();
    return retfile;
}

QString KFileDialog::getOpenFileName( const QString & fn,
                                             const QString & cap, QWidget * par )
{
   QString retfile = "";
    QDialog dia ( par, "input-dialog", true ); 
    // QLineEdit lab ( &dia ); 
    QVBoxLayout lay( &dia );
    lay.setMargin(7); 
    lay.setSpacing(7); 
   //   if ( QApplication::desktop()->width() < 480 ) 
//          dia.setMaximumSize( 230,280 );
//      else
//          dia.setFixedSize( 400,400 ); 
    dia.setCaption( cap );
    QFileInfo fi ( fn );
    OFileSelector o ( &dia,OFileSelector::FileSelector, OFileSelector::Open, fi.dirPath(true), fi.fileName() );
    lay.addWidget( &o);
    dia.setCaption( cap );
    dia.showMaximized();
    int res = dia.exec();
    if ( res )
        retfile = o.selectedName();
    return retfile;
}

#else

#include <qfiledialog.h> 

QString KFileDialog::getSaveFileName( const QString & fn,
                                             const QString & cap , QWidget * par )
{
    return QFileDialog::getSaveFileName( fn, QString::null, par, "openfile", cap );
}
QString KFileDialog::getOpenFileName( const QString & fn,
                                             const QString & cap, QWidget * par )
{

    return QFileDialog::getOpenFileName( fn, QString::null, par, "openfile", cap );
}
#endif

