#include "kcolordialog.h"
#include <qdialog.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qslider.h>
#include <qhbox.h>
#include <qapplication.h>
#include <qpushbutton.h>

#include <kglobal.h>
QColor KColorDialog::getColor( ) const
{
     QColor c ( r->value(), g->value(), b->value() );
     lar->setText ( "R: " + QString::number ( c.red() ) );
     lag->setText ( "G: " + QString::number ( c.green() ) );
     lab->setText ( "B: " + QString::number ( c.blue() ) );
     return c;
}
void  KColorDialog::setColor(  const QColor & d )
{
    r->setValue(d.red()  );
    g->setValue(d.green()  );
    b->setValue(d.blue()  );
    old_color->setPalette( QPalette( d.dark(), d ) );
    lar->setText ( "R: " + QString::number ( d.red() ) );
    lag->setText ( "G: " + QString::number ( d.green() ) );
    lab->setText ( "B: " + QString::number ( d.blue() ) );

}
KColorDialog::KColorDialog( QWidget *p ):QDialog( p, "input-dialog", true  )
{
    setCaption( i18n("Choose Color") );

    setMaximumSize( QApplication::desktop()->width() - 20, QApplication::desktop()->height() - 40 ); // for zaurus 5500er.
    QGridLayout* lay = new QGridLayout ( this, 4, 2 );
    lay->setSpacing( 6 );
    lay->setMargin( 11 );

    old_color = new QLabel("Old color",this);
    old_color->setFrameStyle( QFrame::Panel | QFrame::Plain );
    old_color->setLineWidth( 1 );
    lay->addWidget(old_color, 0, 0);

    new_color = new QLabel("New color", this);
    new_color->setFrameStyle( QFrame::Panel | QFrame::Plain );
    new_color->setLineWidth( 1 );
    lay->addWidget(new_color, 0, 1);
    new_color->setAlignment( AlignCenter );

    QHBox* hb = new QHBox ( this );
    lar = new QLabel( hb );
    lag = new QLabel( hb );
    lab = new QLabel( hb );
    lay->addMultiCellWidget( hb,1,1, 0,1 );

    QLabel* lr = new QLabel ( "Red:", this );
    lay->addWidget( lr,2,0 );
    r = new QSlider  ( 0, 255, 1, 1, Horizontal, this );
    lay->addWidget(r ,2,1 );

    QLabel* lg  = new QLabel( "Green:",this );
    lay->addWidget(lg ,3,0 );
    g = new QSlider  ( 0, 255, 1, 1, Horizontal, this );
    lay->addWidget( g ,3,1 );

    QLabel* lb = new QLabel ( "Blue:",this );
    lay->addWidget( lb,4,0 );
    b = new QSlider  ( 0, 255, 1, 1, Horizontal, this );
    lay->addWidget(b ,4,1 );

    QColor d = backgroundColor();
    r->setValue(d.red()  );
    g->setValue(d.green()  );
    b->setValue(d.blue()  );
    old_color->setPalette( QPalette( d.dark() , d ) );
    // kannst du wieder reinnehmen, aber es geht auch so.
    QPushButton * ok = new QPushButton (i18n(" OK "), this );
    QPushButton * cancel = new QPushButton (i18n(" Cancel "), this );

    lay->addWidget(ok ,5,0 );
    lay->addWidget(cancel ,5,1 );
    connect (ok, SIGNAL( clicked() ), this ,SLOT (accept() ));
    connect (cancel, SIGNAL( clicked() ), this ,SLOT (reject() ));
    connect (r, SIGNAL(  valueChanged ( int )  ), this ,SLOT (updateColor( int ) ));
    connect (g, SIGNAL(  valueChanged ( int )  ), this ,SLOT (updateColor( int ) ));
    connect (b, SIGNAL(  valueChanged ( int )  ), this ,SLOT (updateColor( int ) ));
}
void KColorDialog::updateColor( int )
{
    QColor c = getColor( ) ;
    new_color->setPalette( QPalette( c.dark(), c ) );
}
