/*
    This file is part of KOrganizer.
    Copyright (c) 2004 Lutz Rogowski <rogowski@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef _KSYNCPROFILE_H
#define _KSYNCPROFILE_H

#include <qptrlist.h>
#include <qcolor.h>
#include <qfont.h>
#include <qstringlist.h>
#include <qobject.h>
#include <qstring.h>

#define SYNC_PREF_LOCAL 0
#define SYNC_PREF_REMOTE 1
#define SYNC_PREF_NEWEST 2
#define SYNC_PREF_ASK 3
#define SYNC_PREF_FORCE_LOCAL 4
#define SYNC_PREF_FORCE_REMOTE 5
#define SYNC_PREF_TAKE_BOTH 6

class KConfig;

/**
  @short Class for storing a preferences setting
  @author Cornelius Schumacher
  @see KPref
  
  This class represents one preferences setting as used by @ref KPrefs.
  Subclasses of KPrefsItem implement storage functions for a certain type of
  setting. Normally you don't have to use this class directly. Use the special
  addItem() functions of KPrefs instead. If you subclass this class you will
  have to register instances with the function KPrefs::addItem().
*/
class KSyncProfile : public QObject {
  public:
    KSyncProfile( const char * name = 0);
    ~KSyncProfile() ;
    
    KSyncProfile* clone();
    void setDefault();
    void readConfig(KConfig *);
    void writeConfig(KConfig *);
    void setName( const QString& n ) {mName = n;}
    QString getName( ) { return mName;}
    void setPreSyncCommand( const QString& n ) {mPreSyncCommand = n;}
    QString getPreSyncCommand( ) { return mPreSyncCommand; }
    void setPostSyncCommand( const QString& n ) {mPostSyncCommand = n;}
    QString getPostSyncCommand( ) { return mPostSyncCommand;}

    void setLocalTempFile( const QString& n ) { mLocalTempFile= n;}
    QString getLocalTempFile( ) { return mLocalTempFile;}
    void setRemoteFileName( const QString& n ) { mRemoteFileName = n;}
    QString getRemoteFileName( ) { return mRemoteFileName;}
    /*
    void set( const QString& n ) { = n;}
    QString get( ) { return ;}
    */

    void setShowSummaryAfterSync( bool b ) { mShowSummaryAfterSync = b;}
    bool getShowSummaryAfterSync( ) { return mShowSummaryAfterSync ;}
    void setAskForPreferences( bool b ) { mAskForPreferences= b;}
    bool getAskForPreferences( ) { return mAskForPreferences;}
    void setWriteBackExisting( bool b ) { mWriteBackExisting = b;}
    bool getWriteBackExisting( ) { return mWriteBackExisting;}
    void setWriteBackFile( bool b ) { mWriteBackFile= b;}
    bool getWriteBackFile( ) { return mWriteBackFile;}
    void setIncludeInRingSync( bool b ) {mIncludeInRingSync = b;}
    bool getIncludeInRingSync( ) { return mIncludeInRingSync;}
    void setSyncPrefs( int n ) { mSyncPrefs= n;}
    int getSyncPrefs( ) { return mSyncPrefs;}
    void setIsLocalFileSync( bool b ) { mIsLocalFileSync= b;}
    bool getIsLocalFileSync( ) { return mIsLocalFileSync;}
    
  private:
    QString mName;
    QString mPreSyncCommand;
    QString mPostSyncCommand;
    QString mLocalTempFile;
    QString mRemoteFileName;
    bool mIncludeInRingSync;
    int mSyncPrefs;
    bool mWriteBackFile;
    bool mWriteBackExisting;
    bool mAskForPreferences;
    bool mShowSummaryAfterSync;
    bool mIsLocalFileSync;
};

#endif
