/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qfont.h>
#include <qslider.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qcombobox.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qspinbox.h>
#include <qdatetime.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qstrlist.h>
#include <qapplication.h>

#include <kcolorbutton.h>
#include <kdebug.h>
#include <klocale.h>
#include <kglobal.h>
#include <kfontdialog.h>
#include <kmessagebox.h>
#include <kcolordialog.h>
#include <kiconloader.h>
#include <kemailsettings.h>
#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <kmessagebox.h>

#include <kurlrequester.h>
#include <klineedit.h>
#include <libkdepim/ksyncprofile.h>

#if defined(USE_SOLARIS)
#include <sys/param.h>

#define ZONEINFODIR    "/usr/share/lib/zoneinfo"
#define INITFILE       "/etc/default/init"
#endif

#include "koprefs.h"

#include "kosyncprefsdialog.h"
#include "koglobals.h"
#include "kosyncprefsdialog.moc"


KOSyncPrefsDialog::KOSyncPrefsDialog(QWidget *parent, char *name, bool modal) :
  KDialog(parent,name,true)
{

  setCaption( i18n("Synchronization Preferences"));

  mSyncProfiles.setAutoDelete( true );
   setupSyncAlgTab();
}


KOSyncPrefsDialog::~KOSyncPrefsDialog()
{
}
  
#include <qlayout.h>
#include <qscrollview.h>
void KOSyncPrefsDialog::setupSyncAlgTab()
{
  QLabel * lab;
  //QFrame *page = addPage(i18n("Sync Prefs"),0,0);
  QVBox * mainbox = new QVBox( this );
   QScrollView* sv = new QScrollView( mainbox );
   QHBoxLayout * lay = new QHBoxLayout( this );
   lay->addWidget( mainbox );
   QHBox * b_box = new QHBox( mainbox );

   QPushButton* button = new QPushButton( i18n("Ok"), b_box );
   connect ( button, SIGNAL( clicked()), this, SLOT (slotOK() ) );
   button = new QPushButton( i18n("Cancel"), b_box );
   connect ( button, SIGNAL( clicked()), this, SLOT (reject() ) );
   //QBoxLayout * sl = new QVBoxLayout(this );
   //sl->addWidget ( sv );  
   sv->setResizePolicy ( QScrollView::AutoOneFit );
   QFrame *topFrame = new QFrame ( sv );
   sv->addChild( topFrame );
   mSetupSyncAlgTab = topFrame;
   QGridLayout *topLayout = new QGridLayout(topFrame,6,2);
   topLayout->setSpacing(spacingHint());
   topLayout->setMargin(marginHint());  

   //lab = new QLabel(i18n("Sync settings not yet implemented. DO NOT USE!"), topFrame);
   int iii = 0;
   //topLayout->addMultiCellWidget(lab , iii,iii,0,1);
   //++iii;

   mMyMachineName = new QLineEdit(topFrame);
   lab = new QLabel(mMyMachineName, i18n("Local device name:"), topFrame);
   topLayout->addWidget(lab ,iii,0);
   topLayout->addWidget(mMyMachineName,iii,1);
   ++iii;
  
   QHBox* buttonbox = new QHBox( topFrame);
   topLayout->addMultiCellWidget(buttonbox, iii,iii,0,1);
   ++iii;
   button = new QPushButton( i18n("New profile"), buttonbox );
   connect ( button, SIGNAL( clicked()), this, SLOT (newProfile() ) ); 

   button = new QPushButton( i18n("Clone profile"), buttonbox );
   connect ( button, SIGNAL( clicked()), this, SLOT ( cloneProfile() ) );

   button = new QPushButton( i18n("Delete profile"), buttonbox );
   connect ( button, SIGNAL( clicked()), this, SLOT (deleteProfile() ) );

   mProfileBox = new QComboBox(topFrame);
   mProfileBox->setEditable ( true ); 
   connect ( mProfileBox, SIGNAL(activated ( int ) ), this, SLOT (profileChanged( int ) ) );
   connect ( mProfileBox, SIGNAL(  textChanged ( const QString & ) ), this, SLOT (textChanged( const QString & ) ) );
  
   lab = new QLabel(mProfileBox, i18n("Profile:"), topFrame);
   topLayout->addWidget(lab ,iii,0);
   topLayout->addWidget(mProfileBox, iii,1); 
   ++iii;

   mIncludeInRing = new QCheckBox( i18n("Include in multiple sync"), topFrame   );
   topLayout->addMultiCellWidget(mIncludeInRing, iii,iii,0,1);
   ++iii;

   mAskForPreferences = new QCheckBox( i18n("Ask for preferences before sync"), topFrame   );
   topLayout->addMultiCellWidget(mAskForPreferences, iii,iii,0,1);
   ++iii;
    QButtonGroup* gr = new QButtonGroup ( 1,  Qt::Horizontal, i18n("Sync preferences"), topFrame);
   topLayout->addMultiCellWidget(gr, iii,iii,0,1);
   ++iii;
   loc = new QRadioButton ( i18n("Take local entry on conflict"), gr );
   rem = new QRadioButton ( i18n("Take remote entry on conflict"), gr );
   newest = new QRadioButton ( i18n("Take newest entry on conflict"), gr );
   ask = new QRadioButton ( i18n("Ask for every entry on conflict"), gr );
   f_loc= new QRadioButton ( i18n("Force: Take local entry always"), gr );
   f_rem = new QRadioButton ( i18n("Force: Take remote entry always"), gr );
   // both = new QRadioButton ( i18n("Take both on conflict"), gr );

   mShowSummaryAfterSync = new QCheckBox( i18n("Show summary after sync"), topFrame   );
   topLayout->addMultiCellWidget(mShowSummaryAfterSync, iii,iii,0,1);
   ++iii;
   
   mWriteBackExisting= new QCheckBox( i18n("Write back existing entries only"), topFrame   );
   topLayout->addMultiCellWidget(mWriteBackExisting, iii,iii,0,1);
   ++iii;
   
   mWriteBackFile = new QCheckBox( i18n("Write back file"), topFrame   );
   topLayout->addMultiCellWidget(mWriteBackFile, iii,iii,0,1);
   ++iii;

   proGr = new QButtonGroup ( 1,  Qt::Horizontal, i18n("Profile kind"), topFrame);
   gr = proGr;
   topLayout->addMultiCellWidget(gr, iii,iii,0,1);
   ++iii;
   mIsLocal = new QRadioButton ( i18n("Local file"), gr );
   mIsNotLocal = new QRadioButton ( i18n("Remote file (w down/upload command)"), gr );
   connect (mIsLocal, SIGNAL( toggled(bool)), this, SLOT (kindChanged(bool) ) ); 

   localFileWidget = new QVBox( topFrame);
   topLayout->addMultiCellWidget(localFileWidget, iii,iii,0,1);
   ++iii;
   QHBox* temphb = new QHBox( localFileWidget );
   lab = new QLabel( i18n("Local file:"), temphb);
   mRemoteFile = new QLineEdit(localFileWidget);

   button = new QPushButton( i18n("Choose..."), temphb );
   connect ( button, SIGNAL( clicked()), this, SLOT ( chooseFile() ) );


   remoteFileWidget = new QVBox( topFrame);
   topLayout->addMultiCellWidget(remoteFileWidget, iii,iii,0,1);
   ++iii;
   lab = new QLabel( i18n("Pre sync (download) command:"), remoteFileWidget);
   mRemotePrecommand = new QLineEdit(remoteFileWidget);

   lab = new QLabel( i18n("Local temp file:"), remoteFileWidget);
   mLocalTempFile = new QLineEdit(remoteFileWidget);

  
   lab = new QLabel( i18n("Post sync (upload) command:"), remoteFileWidget);
   mRemotePostcommand = new QLineEdit(remoteFileWidget);

   lab = new QLabel( i18n("Fill in default values for:"), remoteFileWidget);
   temphb = new QHBox( remoteFileWidget );
   button = new QPushButton( i18n("ssh/scp"), temphb );
   connect ( button, SIGNAL( clicked()), this, SLOT (fillSSH() ) );
   button = new QPushButton( i18n("ftp"), temphb );
   connect ( button, SIGNAL( clicked()), this, SLOT (fillFTP() ) );
   lab = new QLabel( i18n("Hint: Use $PWD$ for placeholder of password!"), remoteFileWidget);
   

}
void KOSyncPrefsDialog::slotOK()
{
    if ( mMyMachineName->text() == "undefined" ) {
        KMessageBox::error(this,i18n("Local device name undefined!\nPlease define device name!"),i18n("KO/Pi config error"));
        return;
    }
    int i;
    for (i = 0; i < mSyncProfileNames.count(); ++ i) {
        if ( mSyncProfileNames.contains( mSyncProfileNames[i]) > 1  ) {
            KMessageBox::error(this,i18n("Multiple profiles with same name!\nPlease use unique profile names!"),i18n("KO/Pi config error"));
            return;
        }
    }
    usrWriteConfig();
    QDialog::accept();
}
void KOSyncPrefsDialog::accept()
{
    slotOK();
}
void KOSyncPrefsDialog::chooseFile()
{
    QString fn =KOPrefs::instance()->mLastSyncedLocalFile;

    fn =KFileDialog:: getOpenFileName( fn, i18n("Sync filename(*.ics/*.vcs)"), this );
    if ( fn == "" )
        return;
    mRemoteFile->setText( fn );
}

void KOSyncPrefsDialog::textChanged( const QString &  s )
{
    if ( mProfileBox->count() == 0 )
        return;
    if ( currentSelection < 3 ) {
        //KMessageBox::error(this,i18n("This profil name\ncannot be edited!\n"),i18n("KO/Pi config error"));
        mProfileBox->blockSignals( true );
        mProfileBox->setCurrentItem(mProfileBox-> currentItem ());
        mProfileBox->blockSignals( false );
        return;
    }
    //qDebug("cur i %d ",mProfileBox-> currentItem () );
    mProfileBox->changeItem ( s, mProfileBox-> currentItem () ) ;
    KSyncProfile* prof = mSyncProfiles.at(mProfileBox-> currentItem ()) ;
    prof->setName( s );
    mSyncProfileNames[mProfileBox-> currentItem ()] = s;
}
void KOSyncPrefsDialog::profileChanged( int item )
{
    //qDebug("KOSyncPrefsDialog::profileChanged %d ", item ); 
    KSyncProfile* prof;
    saveProfile();
    currentSelection = item;
    prof = mSyncProfiles.at(item) ;
    mRemotePrecommand->setText(prof->getPreSyncCommand());
    mRemotePostcommand->setText(prof->getPostSyncCommand());
    mLocalTempFile->setText(prof->getLocalTempFile());
    mRemoteFile->setText(prof->getRemoteFileName()) ;
    mShowSummaryAfterSync->setChecked( prof->getShowSummaryAfterSync());
    mAskForPreferences->setChecked( prof->getAskForPreferences());
    mWriteBackExisting->setChecked( prof->getWriteBackExisting() );
    mWriteBackFile->setChecked( prof->getWriteBackFile());
    mIncludeInRing->setChecked( prof->getIncludeInRingSync() );
    
    switch ( prof->getSyncPrefs() ) {
    case 0:
        loc->setChecked( true);
        break;
    case 1:
        rem->setChecked( true );
        break;
    case 2:
        newest->setChecked( true);
        break;
    case 3:
        ask->setChecked( true);
        break;
    case 4:
        f_loc->setChecked( true);
        break;
    case 5:
        f_rem->setChecked( true);
        break;
    case 6:
        //both->setChecked( true);
        break; 
    default:
        break;
    }
    mIsLocal->setChecked(prof->getIsLocalFileSync()) ;
    mIsNotLocal->setChecked(!prof->getIsLocalFileSync());
    proGr->setEnabled( item > 2 );
    if ( item < 3 ) {
        localFileWidget->setEnabled(false);
        remoteFileWidget->setEnabled(false);

    } else
        kindChanged( prof->getIsLocalFileSync() );
}

void KOSyncPrefsDialog::fillSSH()
{
    mRemotePrecommand->setText("scp zaurus@192.168.0.65:/home/zaurus/Applications/korganizer/mycalendar.ics /tmp/mycalendar.ics" );
    mLocalTempFile->setText("/tmp/mycalendar.ics" );
    mRemotePostcommand->setText("scp /tmp/mycalendar.ics zaurus@192.168.0.65:/home/zaurus/Applications/korganizer/mycalendar.ics" );
}
void KOSyncPrefsDialog::fillFTP()
{
    mRemotePrecommand->setText("cd /tmp;ftp ftp://zaurus:a@192.168.0.65/Applications/korganizer/mycalendar.ics" );
    mLocalTempFile->setText("/tmp/mycalendar.ics" );
    mRemotePostcommand->setText("ftp -u ftp://zaurus:a@192.168.0.65/Applications/korganizer/mycalendar.ics /tmp/mycalendar.ics" );
   
}
void KOSyncPrefsDialog::kindChanged( bool b )
{
  
   localFileWidget->setEnabled(b);
   remoteFileWidget->setEnabled(!b);
   
}
void KOSyncPrefsDialog::deleteProfile()
{
    //qDebug("KOSyncPrefsDialog::deleteProfile() "); 
    if ( currentSelection >= 0 ) {
        if ( currentSelection < 3 ) {
            KMessageBox::error(this,i18n("This profil cannot be deleted!\n"),i18n("KO/Pi config error"));
            return;
        }
        KSyncProfile* temp = mSyncProfiles.at(currentSelection);
        mSyncProfiles.remove( temp );
        mSyncProfileNames.remove( mSyncProfileNames.at( currentSelection ));
        insertProfiles();
    }
}

void KOSyncPrefsDialog::saveProfile()
{
    KSyncProfile* prof;
    if ( currentSelection >= 0 ) {
        prof = mSyncProfiles.at(currentSelection) ;
        prof->setPreSyncCommand( mRemotePrecommand->text());
        prof->setPostSyncCommand( mRemotePostcommand->text() );
        prof->setLocalTempFile( mLocalTempFile->text());
        prof->setRemoteFileName( mRemoteFile->text() );
        prof->setShowSummaryAfterSync( mShowSummaryAfterSync->isChecked() );
        prof->setAskForPreferences( mAskForPreferences->isChecked());
        prof->setWriteBackExisting(mWriteBackExisting->isChecked() );
        prof->setWriteBackFile( mWriteBackFile->isChecked());
        prof->setIncludeInRingSync( mIncludeInRing->isChecked() );
        int syncprefs = rem->isChecked()*1+newest->isChecked()*2+  ask->isChecked()*3+  f_loc->isChecked()*4+  f_rem->isChecked()*5 ;//+  both->isChecked()*6 ;
        prof->setSyncPrefs( syncprefs);
        prof->setIsLocalFileSync( mIsLocal->isChecked() );
    }

}

void KOSyncPrefsDialog::insertProfiles()
{
    int curItem = mProfileBox->currentItem();
    mProfileBox->blockSignals( true );
    mProfileBox->clear();
    mProfileBox->insertStringList (mSyncProfileNames ); 
    int item = mSyncProfileNames.count() -1; 
    if ( curItem >= 0 &&  mSyncProfileNames.count() > 0 && curItem < mSyncProfileNames.count() )
        mProfileBox->setCurrentItem( curItem );  
    else if ( item >= 0 ) {
        mProfileBox->setCurrentItem( item );
    }
    currentSelection = -1;
    if ( mSyncProfileNames.count() > 0 ) {
        //qDebug(" profileChanged( mProfileBox->currentItem()  ");
        profileChanged( mProfileBox->currentItem() );
        currentSelection = mProfileBox->currentItem();
    }
    mProfileBox->blockSignals( false );
}
   
void KOSyncPrefsDialog::addProfile ( KSyncProfile* temp )
{
    saveProfile();
    mSyncProfiles.append( temp );
    mSyncProfileNames << temp->getName();
    insertProfiles();
    int last = mProfileBox->count() -1;
    mProfileBox->blockSignals( true );
    mProfileBox->setCurrentItem( last );
    mProfileBox->blockSignals( false );
    profileChanged(last);
}
void KOSyncPrefsDialog::newProfile()
{
    addProfile ( new KSyncProfile () );
}

void KOSyncPrefsDialog::cloneProfile()
{ 
    if ( currentSelection >= 0 ) 
        addProfile (mSyncProfiles.at(currentSelection)->clone()) ;
    else
        newProfile();
}


void KOSyncPrefsDialog::usrReadConfig()
{ 
    KConfig *config = KOGlobals::config();
    config->setGroup("SyncProfiles");
    mSyncProfileNames = KOPrefs::instance()->mSyncProfileNames;
    int i;
    KSyncProfile* temp ;
    mSyncProfiles.clear();
    for ( i = 0; i < mSyncProfileNames.count();++i ) {
        temp = new KSyncProfile ();
        temp->setName( mSyncProfileNames[i] );
        temp->readConfig( config );
        mSyncProfiles.append( temp );
    }
    insertProfiles();
    mMyMachineName->setText(KOPrefs::instance()->mLocalMachineName );
}


void KOSyncPrefsDialog::usrWriteConfig()
{
    saveProfile();
    if ( currentSelection >= 0 ) 
        profileChanged(currentSelection);
    KConfig *config = KOGlobals::config();
    config->setGroup("SyncProfiles");
    KSyncProfile* prof = mSyncProfiles.first();
    while ( prof ) {
        prof->writeConfig(config);
        prof = mSyncProfiles.next();
    }
    KOPrefs::instance()->mSyncProfileNames = mSyncProfileNames;
    KOPrefs::instance()->mLocalMachineName = mMyMachineName->text();
    config->writeEntry("SyncProfileNames",&mSyncProfileNames);
}

