/*  This file is part of the KDE project
    Copyright (C) 1999 Matthias Ettrich (ettrich@kde.org)
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2005 Fastweb SpA

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/


#include "kwin.h"

#ifdef _WS_QWS_
#include <qwsmanager_qws.h>
#endif

#ifdef Q_WS_X11
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

#include <qpaintdevice.h>

static bool atoms_created = false;
static Atom net_wm_context_help;
static Atom kde_wm_change_state;
static Atom kde_wm_window_opacity;
static Atom kde_wm_window_shadow;

static void kwin_net_create_atoms() 
{
    if (!atoms_created) {
	const int max = 20;
	Atom* atoms[max];
	const char* names[max];
	Atom atoms_return[max];
	int n = 0;

	atoms[n] = &net_wm_context_help;
	names[n++] = "_NET_WM_CONTEXT_HELP";

	atoms[n] = &kde_wm_change_state;
	names[n++] = "_KDE_WM_CHANGE_STATE";
        
        atoms[n] = &kde_wm_window_opacity;
        names[n++] = (char*) "_KDE_WM_WINDOW_OPACITY";

        atoms[n] = &kde_wm_window_shadow;
        names[n++] = (char*) "_KDE_WM_WINDOW_SHADOW";

	// we need a const_cast for the shitty X API
	XInternAtoms(QPaintDevice::x11AppDisplay(), const_cast<char**>(names), 
		n, false, atoms_return);
	for (int i = 0; i < n; i++ )
	    *atoms[i] = atoms_return[i];

	atoms_created = True;
    }
}

/*
  Sends a client message to the ROOT window.
 */
static void 
sendClientMessageToRoot(Window w, Atom a, long x, long y = 0, long z = 0)
{
    XEvent ev;
    long mask;

    memset(&ev, 0, sizeof(ev));
    ev.xclient.type = ClientMessage;
    ev.xclient.window = w;
    ev.xclient.message_type = a;
    ev.xclient.format = 32;
    ev.xclient.data.l[0] = x;
    ev.xclient.data.l[1] = y;
    ev.xclient.data.l[2] = z;
    mask = SubstructureRedirectMask;
    XSendEvent(QPaintDevice::x11AppDisplay(), QPaintDevice::x11AppRootWindow(), False, mask, &ev);
}
#endif

class HackWidget : public QWidget
{
public:
    using QWidget::topData;
};

KWin::Info KWin::info( WId id )
{
    KWin::Info res;

    QWidget *w = QWidget::find( id );
    if ( !w )
        return res;
 
#ifdef _WS_QWS_
#ifndef QT_NO_QWS_MANAGER
    QWSManager *manager = static_cast<HackWidget *>( w )->topData()->qwsManager;
    if ( manager )
    {
        res.geometry = manager->region().boundingRect();
        return res;
    }
#endif    
#endif

    // ###
    res.geometry = w->geometry(); 
    return res;
}

void KWin::deIconifyWindow( WId win, bool animation )
{
#ifdef Q_WS_X11
    if ( !animation )
    {
        kwin_net_create_atoms();
	sendClientMessageToRoot( win, kde_wm_change_state, NormalState, 1 );
    }
    XMapWindow( QPaintDevice::x11AppDisplay(), win );
#endif
}
