/*  This file is part of the KDE project
    Copyright (C) 1999 David Faure <faure@kde.org>
    Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kfileitem_h__
#define __kfileitem_h__

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <global.h>
#include <kmimetype.h>
#include <qstylesheet.h>

#include <kio/global.h>

// ### ;-)
#if 0 // This does not work here - ML
namespace KIO
{
    typedef struct stat UDSEntry;
}
#endif


class KFileItem
{
public:
    // needed by kdelibs 3.1
    enum { Unknown = (mode_t) - 1 };
    
    KFileItem( KIO::UDSEntry udsEntry, const KURL &, bool, bool )
        { m_entry = udsEntry; }

    // Needed by kdelibs 3.1
    KFileItem( const KURL &, const QString &, mode_t ) 
        { }
    
    //I don't care about files... at least for now. Check later XXX - ML
    //bool isDir() const { return S_ISDIR( m_entry.st_mode ); }
    bool isDir() const { return false; }
    bool isFile() const { return true; }

private:
    KIO::UDSEntry m_entry;
};

#endif
