/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __dcopdispatcher_h__
#define __dcopdispatcher_h__

#include <qcstring.h>
#if QT_VERSION < 300
#include <qlist.h>
#else
#include <qptrlist.h>
#endif
#include <qobject.h>
#include <qvaluelist.h>
#include <qasciidict.h>
#include <qthread.h>
#include <dcopobject.h>
#if defined(Q_WS_WIN32)
#include <channel.h>
#endif

class DCOPDispatcherChannel;
class QSocketNotifier;

namespace KIO
{
    class Connection;
}

class DCOPClientTransaction;

class DCOPDispatcher : public QObject
{
    Q_OBJECT
    friend class DCOPDispatcherChannel;
public:
    DCOPDispatcher();
    virtual ~DCOPDispatcher();

    DCOPClientTransaction *beginTransaction();
    void endTransaction( DCOPClientTransaction *transaction, QCString &replyType, QByteArray &replyData );

#if defined(Q_WS_WIN)
    bool process( Channel::SendType sendType, const QCString &appname,
		  const QCString &fun, const QByteArray &data,
		  QCString &replyType, QByteArray &replyData );
#else
    // extension
    void addClient( KIO::Connection *connection, QObject *owner );

    bool process( const QCString &appname,
		  const QCString &fun, const QByteArray &data,
		  QCString &replyType, QByteArray &replyData );
#endif

    void registerObject(DCOPObject *obj);

    void unregisterObject(DCOPObject *obj);

    static DCOPDispatcher *self();

#if defined(Q_WS_WIN)
protected:
    virtual void receiveMessage( ChannelMessage *message, Channel::SendType type );

private:
    struct Request : public ChannelMessage
    {
	Request( const QCString &_appname, const QCString &_fun,
		 const QByteArray &_data )
	    : appname( _appname ), fun( _fun ), data( _data )
	{
	    appname.detach();
	    fun.detach(); 
	    data.detach();
	}

	bool send;
	QCString appname;
	QCString fun;
	QByteArray data;
	bool result;
	QCString replyType;
	QByteArray replyData;
    };

    Request *m_currentRequest;
    QList<Request> m_transactions;
    bool m_transactionAdded;

    QMutex m_objpoolGuard;

    uint m_guiThread;

    DCOPDispatcherChannel *m_channel;
#else
private:
    struct Client
    {
        KIO::Connection *m_connection;
        QObject *m_owner;
        QSocketNotifier *m_notifier;
        int m_infd;
    };
#if QT_VERSION < 300
    QList<Client> m_clients;
#else
    QPtrList<Client> m_clients;
#endif
    void disconnectClient( const QObject *owner );
    void dispatchClient( Client *client );

    struct InternalDCOPClientTransaction
    {
        Client *m_client;
    };
#if QT_VERSION < 300
    QList<InternalDCOPClientTransaction> m_transactions;
#else
    QPtrList<InternalDCOPClientTransaction> m_transactions;
#endif

    bool m_transactionAdded;

    static Client *s_currentClient;

#endif
private slots:
    void slotDisconnectClient();
    void slotDispatch( int sockfd );

private:
    QAsciiDict<DCOPObject> m_objpool;

    static DCOPDispatcher *s_self;
};

#endif
