#ifndef _CSVPARSER_H_
#define _CSVPARSER_H_

#include <qstring.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qtextstream.h>

class CSVParser
{
public:
	static QStringList parse(const QString& str){
		QString s = str;
		QTextIStream stream(&s);
		return parse(stream);
	}
	static QStringList parse(QTextStream& stream){
		QStringList list;
		if(stream.atEnd()) return list;

		int pos;
		int len;
		QString str = stream.readLine();
		if(str.length() == 0) list.append(QString::null);
		for(unsigned int i=0; i<str.length(); ){
			bool quote = false;
			len = 0;
			QRegExp("^\\s*").match(str, i, &len);
			if(len > 0){
				i += len;
			}
			if(str[i] == '\"'){
				quote = true;
				i++;
			}
			int start = i;
			if(quote){
				QString s;
				while(true){
					pos = str.find('\"', i);
					if(pos < 0){
						i = str.length() + 1;
						if(stream.atEnd()){
							//list.append(str.mid(start));
							s = str.mid(start);
							break;
						}
						str.append("\n");
						str.append(stream.readLine());
					} else {
						i = pos + 1;
						if(str[i] == '\"'){
							i++;
						} else {
							//list.append(str.mid(start, pos-start));
							s = str.mid(start, pos-start);
							break;
						}
					}
				}
				s.replace(QRegExp("\"\""), "\"");
				list.append(s);
				pos = str.find(',', i);
				if(pos < 0){
					i = str.length() + 1;
				} else {
					i = pos + 1;
				}
			} else {
				pos = str.find(',', i);
				QString s;
				if(pos < 0){
					i = str.length() + 1;
					s = str.mid(start).stripWhiteSpace();
				} else {
					i = pos + 1;
					s = str.mid(start, pos-start).stripWhiteSpace();
				}
				if(s.length() > 0){
					list.append(s);
				} else {
					list.append(QString::null);
				}
			}
			if(i == str.length()){
				list.append(QString::null);
			}
		}
		return list;
	}
	static QString build(const QStringList& list){
		QString text;
		QStringList csv(list);
		for(QStringList::Iterator it=csv.begin();
				it!=csv.end(); ++it){
			QString& s = (*it);
			s.replace(QRegExp("\""), "\"\"");
			if(s.contains(QRegExp("[,\"\r\n]")) || s.stripWhiteSpace() != s){
				s.prepend('\"');
				s.append('\"');
			} else if(s.isEmpty() && !s.isNull()){
				s = "\"\"";
			}
		}
		text = csv.join(",");
		return text;
	}
};

#endif
