/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"
#include "dict.h"
#include "mainwindow.h"

/*
 */
static void read_config(mainwindow_t *mainwin) {
	char path[2048];
	struct stat st;
	FILE *file;
	sprintf(path,"%s/."PACKAGE,g_get_home_dir());
	if(stat(path,&st) == -1 && mkdir(path,0755) == -1) {
		fprintf(stderr,"error create \"%s\" directory\n",path);
		return;
	}
	sprintf(path,"%s/."PACKAGE"/dict",g_get_home_dir());
	if(stat(path,&st) == -1 && mkdir(path,0755) == -1) {
		fprintf(stderr,"error create \"%s\" directory\n",path);
		return;
	}
	sprintf(path,"%s/."PACKAGE"/"PACKAGE"rc",g_get_home_dir());
	file = fopen(path,"rb");
	if(!file) return;
	while(fgets(path,sizeof(path),file) != NULL) {
		char *p = strchr(path,'\n');
		if(p) *p = '\0';
		main_window_dict_load(mainwin,path);
	}
	main_window_clist_load(mainwin);
	fclose(file);
}

/*
 */
static void save_config(mainwindow_t *mainwin) {
	int i;
	char path[2048];
	FILE *file;
	sprintf(path,"%s/."PACKAGE"/"PACKAGE"rc",g_get_home_dir());
	file = fopen(path,"wb");
	if(!file) {
		fprintf(stderr,"error create \"%s\" file\n",path);
		return;
	}
	for(i = 0; i < mainwin->num_dicts; i++) {
		fprintf(file,"%s\n",mainwin->dicts[i]);
	}
	fclose(file);
}

/*
 */
int main(int argc,char **argv) {
	mainwindow_t *mainwin;
	
#ifdef ENABLE_NLS
	bindtextdomain(PACKAGE,PREFIX"/share/locale");
	textdomain(PACKAGE);
#endif
	
	gtk_set_locale();
	gtk_init(&argc,&argv);
	
	mainwin = main_window_create();
	
	read_config(mainwin);
	
	gtk_main();
	
	save_config(mainwin);
	
	return 0;
}
