# Older RPM doesn't define these by default
%{!?perl_vendorlib: %define perl_vendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)}
%{!?perl_vendorarch: %define perl_vendorarch %(eval "`%{__perl} -V:installvendorarch`"; echo $installvendorarch)}
%{!?perl_archlib: %define perl_archlib %(eval "`%{__perl} -V:installarchlib`"; echo $installarchlib)}

# When not doing betas comment this out
# NOTE: %defines in spec files are evaluated in comments so the correct
#       way to comment it out is to replace the % with #
%define beta 4

%if 0%{?beta}
%define gaimver %(echo "2.0.0beta4"|sed -e 's/dev//; s/beta.*//')
%else
%define gaimver 2.0.0beta4
%endif

Summary:    A GTK+ based multiprotocol instant messaging client
Name:       gaim
Version:    %gaimver
Release:    0%{?beta:.beta%{beta}}
Epoch:      1
License:    GPL
Group:      Applications/Internet
URL:        http://gaim.sourceforge.net/
Packager:   %{packager}
Source:     %{name}-2.0.0beta4.tar.bz2
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

# Generic build requirements
BuildRequires: libtool, pkgconfig, intltool, gettext, libxml2-devel
%{?_with_avahi:BuildRequires: avahi-compat-howl-devel}
%{?_with_dbus:BuildRequires: dbus-devel >= 0.35}
%{!?_without_gstreamer:BuildRequires: gstreamer-devel}
%{!?_without_gtkspell:BuildRequires: gtkspell-devel}
%{?_with_howl:BuildRequires: howl-devel}
%{?_with_meanwhile:BuildRequires: meanwhile-devel}
%{?_with_mono:BuildRequires: mono-devel}
%{?_with_sasl:BuildRequires: cyrus-sasl-devel >= 2}
%{?_with_silc:BuildRequires: /usr/include/silc/silcclient.h}
%{?_with_tcl:BuildRequires: tcl, tk, /usr/include/tcl.h}
%{!?_without_text:BuildRequires: ncurses-devel}

# Mandrake 10.1 and lower || Mandrake 10.2 (and higher?)
%if "%{_vendor}" == "MandrakeSoft" || "%{_vendor}" == "Mandrakesoft" || "%{_vendor}" == "Mandriva"
# For Mandrake/Mandriva:
BuildRequires: libgtk+2.0_0-devel, libnss3-devel, perl-devel
Obsoletes:  libgaim-remote0
%else
# For SuSE, Red Hat, Fedora and others:
BuildRequires: gtk2-devel
%if "%{_vendor}" == "suse"
# For SuSE:
BuildRequires: gnutls-devel
%else
# For Red Hat, Fedora and others:
# let's assume RH & FC1 are the only brain-dead distros missing the
# perl-XML-Parser dependency on intltool and that other RH/FC releases
# don't care if we specify it here
BuildRequires: perl-XML-Parser
BuildRequires: mozilla-nss-devel
%endif
%endif

# For some reason perl isn't always automatically detected as a requirement :(
Requires: perl
# Gadu-Gadu support was split out temporarily
Provides: gaim-gadugadu = %{epoch}:%{version}-%{release}

%package devel
Summary:    Development headers, documentation, and libraries for Gaim.
Group:      Applications/Internet
Requires:   pkgconfig, gaim = %{epoch}:%{version}

%if 0%{?_with_howl:1} || 0%{?_with_avahi:1}
%package bonjour
Summary:    Bonjour plugin for Gaim
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%if 0%{?_with_meanwhile:1}
%package meanwhile
Summary:    Lotus Sametime plugin for Gaim using the Meanwhile library
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%if 0%{?_with_mono:1}
%package mono
Summary:    Mono .NET plugin support for Gaim
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%if 0%{?_with_silc:1}
%package silc
Summary:    SILC (Secure Internet Live Conferencing) plugin for Gaim
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%if 0%{?_with_tcl:1}
%package tcl
Summary:    Tcl scripting support for Gaim
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%if 0%{!?_without_text:1}
%package text
Summary:    A text-based user interface for Gaim
Group:      Applications/Internet
Requires:   gaim = %{epoch}:%{version}
%endif

%description
Gaim allows you to talk to anyone using a variety of messaging
protocols including AIM, MSN, Yahoo!, Jabber, Bonjour, Gadu-Gadu,
ICQ, IRC, Novell Groupwise, QQ, Lotus Sametime, SILC, Simple and
Zephyr.  These protocols are implemented using a modular, easy to
use design.  To use a protocol, just add an account using the
account editor.

Gaim supports many common features of other clients, as well as many
unique features, such as perl scripting, TCL scripting and C plugins.

Gaim is not affiliated with or endorsed by America Online, Inc.,
Microsoft Corporation, Yahoo! Inc., or ICQ Inc.

%description devel
The gaim-devel package contains the header files, developer
documentation, and libraries required for development of Gaim scripts
and plugins.

%if 0%{?_with_howl:1} || 0%{?_with_avahi:1}
%description bonjour
Bonjour plugin for Gaim.
%endif

%if 0%{?_with_meanwhile:1}
%description meanwhile
Lotus Sametime plugin for Gaim using the Meanwhile library.
%endif

%if 0%{?_with_mono:1}
%description mono
Mono plugin loader for Gaim.  This package will allow you to write or
use Gaim plugins written in the .NET programming language.
%endif

%if 0%{?_with_silc:1}
%description silc
SILC (Secure Internet Live Conferencing) plugin for Gaim.
%endif

%if 0%{!?without_text:1}
%description text
A text-based user interface for Gaim.  This can be run from a
standard text console or from a terminal within X Windows.  It
uses ncurses and our homegrown gnt library for drawing windows
and text.
%endif

%if 0%{?_with_tcl:1}
%description tcl
Tcl plugin loader for Gaim.  This package will allow you to write or
use Gaim plugins written in the Tcl programming language.
%endif

%prep
%setup -q -n %{name}-2.0.0beta4

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} \
                                    --bindir=%{_bindir} \
                                    --datadir=%{_datadir} \
                                    --includedir=%{_includedir} \
                                    --libdir=%{_libdir} \
                                    --mandir=%{_mandir} \
                                    --sysconfdir=%{_sysconfdir} \
                                    --disable-schemas-install \
                                    %{!?_with_dbus:--disable-dbus} \
                                    %{?_without_gstreamer:--disable-gstreamer} \
                                    %{?_without_gtkspell:--disable-gtkspell} \
                                    %{?_with_mono:--enable-mono} \
                                    %{?_with_perlmakehack:--with-perl-lib=%{buildroot}%{_prefix}} \
                                    %{!?_with_perlmakehack:--with-perl-lib=%{_prefix}} \
                                    %{?_with_sasl:--enable-cyrus-sasl} \
                                    %{?_with_silc:--with-silc-includes=%{_includedir}/silc} \
                                    %{?_with_silc:--with-silc-libs=%{_libdir}/silc} \
                                    %{!?_with_tcl:--disable-tcl} \
                                    %{?_without_text:--disable-consoleui}

make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%if 0%{?_with_perlmakehack:1}
make prefix=%{buildroot}%{_prefix} bindir=%{buildroot}%{_bindir} \
     datadir=%{buildroot}%{_datadir} includedir=%{buildroot}%{_includedir} \
     libdir=%{buildroot}%{_libdir} mandir=%{buildroot}%{_mandir} \
     sysconfdir=%{buildroot}%{_sysconfdir} \
     install
%else
make DESTDIR=$RPM_BUILD_ROOT install
%endif

# Delete files that we don't want to put in any of the RPMs
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{perl_archlib}/perllocal.pod
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -type f -name '*.bs' -empty -exec rm -f {} ';'

%if 0%{!?_with_howl:1} && 0%{!?_with_avahi:1}
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/libbonjour.so
%endif

%if 0%{!?_with_meanwhile:1}
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/libsametime.so
%endif

%if 0%{!?_with_mono:1}
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/mono.so
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.dll
%endif

%if 0%{!?_with_silc:1}
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/libsilcgaim.so
%endif

%if 0%{!?_with_tcl:1}
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/tcl.so
%endif

%if 0%{?_without_text:1}
rm -f $RPM_BUILD_ROOT%{_mandir}/man1/gaim-text.*
rm -f $RPM_BUILD_ROOT%{_bindir}/gaim-text
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/gntgf.so
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/gnthistory.so
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/s.so
rm -f $RPM_BUILD_ROOT%{_libdir}/libgnt.so.*
%endif

%find_lang %{name}

find $RPM_BUILD_ROOT%{_libdir}/gaim -type f -print | \
        sed "s@^$RPM_BUILD_ROOT@@g" | \
        grep -v /gntgf.so | \
        grep -v /gnthistory.so | \
        grep -v /libbonjour.so | \
        grep -v /libsilcgaim.so | \
        grep -v /libsametime.so | \
        grep -v /mono.so | \
        grep -v /s.so | \
        grep -v /tcl.so | \
        grep -v ".dll$" | \
        grep -v ".tcl$" > %{name}-%{version}-coreplugins

# files -f file can only take one filename :(
cat %{name}.lang >> %{name}-%{version}-coreplugins

%clean
rm -rf %{buildroot}

%pre
if [ "$1" -gt 1 -a -n "`which gconftool-2 2>/dev/null`" ]; then
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule \
        %{_sysconfdir}/gconf/schemas/gaim.schemas >/dev/null || :
    killall -HUP gconfd-2 || :
fi

%post
if [ -n "`which gconftool-2 2>/dev/null`" ]; then
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-install-rule \
        %{_sysconfdir}/gconf/schemas/gaim.schemas > /dev/null || :
    killall -HUP gconfd-2 || :
fi
/sbin/ldconfig

%preun
if [ "$1" -eq 0 -a -n "`which gconftool-2 2>/dev/null`" ]; then
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule \
      %{_sysconfdir}/gconf/schemas/gaim.schemas > /dev/null || :
    killall -HUP gconfd-2 || :
fi

%postun -p /sbin/ldconfig

%files -f %{name}-%{version}-coreplugins
%defattr(-, root, root)

%doc AUTHORS
%doc COPYING
%doc COPYRIGHT
%doc ChangeLog
%doc NEWS
%doc README
%doc README.SVN
%doc doc/FAQ
%doc doc/the_penguin.txt
%doc %{_mandir}/man1/gaim.*
%doc %{_mandir}/man3*/*

%dir %{_libdir}/gaim
%attr(755, root, root) %{perl_vendorarch}/Gaim*
%attr(755, root, root) %{perl_vendorarch}/auto/Gaim

%{_bindir}/gaim
%{_datadir}/pixmaps/*
%dir %{_datadir}/sounds/gaim
%{_datadir}/sounds/gaim/*
%{_datadir}/applications/*
%{_libdir}/libgaim.so.*
%{_sysconfdir}/gconf/schemas/gaim.schemas

%if 0%{?_with_dbus:1}
%{_bindir}/gaim-client-example
%{_bindir}/gaim-remote
%{_bindir}/gaim-send
%{_bindir}/gaim-send-async
%{_bindir}/gaim-url-handler
%{_libdir}/libgaim-client.so.*
%{_datadir}/dbus-1/services/gaim.service
%doc README.dbus
%doc libgaim/gaim-notifications-example
%endif

%files devel
%defattr(-, root, root)

%doc ChangeLog.API
%doc HACKING
%doc PLUGIN_HOWTO
%doc PROGRAMMING_NOTES

%dir %{_includedir}/gaim
%{_includedir}/gaim/*.h
%dir %{_includedir}/gaim/gnt
%{_includedir}/gaim/gnt/*.h
%dir %{_includedir}/gnt
%{_includedir}/gnt/*.h
%{_libdir}/libgaim.so
%{_libdir}/libgnt.so
%{_libdir}/pkgconfig/gaim.pc
%{_libdir}/pkgconfig/gnt.pc
%{_datadir}/aclocal/gaim.m4
%if 0%{?_with_dbus:1}
%{_libdir}/libgaim-client.so
%endif

%if 0%{?_with_howl:1} || 0%{?_with_avahi:1}
%files bonjour
%defattr(-, root, root)

%{_libdir}/gaim/libbonjour.*
%endif

%if 0%{?_with_meanwhile:1}
%files meanwhile
%defattr(-, root, root)

%{_libdir}/gaim/libsametime.*
%endif

%if 0%{?_with_mono:1}
%files mono
%defattr(-, root, root)

%{_libdir}/gaim/mono.so
%{_libdir}/gaim/*.dll
%endif

%if 0%{?_with_silc:1}
%files silc
%defattr(-, root, root)

%{_libdir}/gaim/libsilcgaim.*
%endif

%if 0%{?_with_tcl:1}
%files tcl
%defattr(-, root, root)

%{_libdir}/gaim/tcl.so
%endif

%if 0%{!?_without_text:1}
%files text
%defattr(-, root, root)

%doc %{_mandir}/man1/gaim-text.*
%{_bindir}/gaim-text
%{_libdir}/gaim/gntgf.so
%{_libdir}/gaim/gnthistory.so
%{_libdir}/gaim/s.so
%{_libdir}/libgnt.so.*
%endif

%changelog
* Sun Oct  1 2006 Stu Tomlinson <stu@nosnilmot.com>
- We can build with internal gadu gadu again, so bring it back into the
  main package
- Deal with gconf schame uninstallation on package upgrade and removal

* Sun Aug 20 2006 Stu Tomlinson <stu@nosnilmot.com>
- Make the gstreamer-devel dependency overridable with '--without-gstreamer'
  to allow building on older distributions without suitable gstreamer

* Tue Aug 15 2006 Mark Doliner <thekingant@users.sourceforge.net>
- Add a BuildRequire for gstreamer-devel
- Remove the BuildRequires for audiofile-devel and libao-devel

* Mon May 8 2006 Mark Doliner <thekingant@users.sourceforge.net>
- Add --with avahi option to compile the gaim-bonjour package against
  Avahi's Howl compatibility layer

* Wed Mar 29 2006 Stu Tomlinson <stu@nosnilmot.com>
- Source RPM uses tar.bz2 now to save space
- Update BuildRequires for new intltool dependencies
- Add a --with perlmakehack option to allow builds to succeed on RH9
- Add a --with gadugadu to build (separate) gaim-gadugadu package

* Sat Dec 17 2005 Stu Tomlinson <stu@nosnilmot.com>
- Add support for beta versions so the subsequent releases are seen as newer
  by RPM
- Split of sametime support to gaim-meanwhile
- Use make DESTDIR=... instead of overloading prefix etc. when installing
- Default build to include cyrus-sasl support in Jabber
- Add --with dbus to build with DBUS support

* Sun Dec 04 2005 Christopher O'Brien <siege@preoccupied.net>
- Added obsoletes gaim-meanwhile

* Sun Oct 30 2005 Stu Tomlinson <stu@nosnilmot.com>
- Add separate gaim-bonjour package if built with --with-howl
- Add separate gaim-mono package if built with --with-mono
- Exclude some unwanted perl files

* Sat Aug 20 2005 Stu Tomlinson <stu@nosnilmot.com>
- Include libgaimperl.so
- Include gaim.m4 in gaim-devel

* Thu Apr 28 2005 Stu Tomlinson <stu@nosnilmot.com>
- Use perl_vendorlib & perl_archlib for better 64bit compat (Jeff Mahoney)
- Clean up Requires, most should be auto-detected
- Restore gtkspell-devel build requirement (and add --without gtkspell option)
- Fix Tcl build requirements to work across more distros
- Fix SILC build requirements to work across more distros

* Mon Oct 11 2004 John Jolly <john.jolly@gmail.com>
- Added if "%{_vendor}" == "suse" to handle GnuTLS libraries for SuSE

* Sat Oct  2 2004 Stu Tomlinson <stu@nosnilmot.com>
- If --with tcl or silc are not specified, make sure the plugins don't
  exist to prevent RPM complaining about unpackaged files

* Tue Jun 29 2004 Ethan Blanton <eblanton@cs.ohiou.edu>
- Change Tcl to use --with tcl, the same as SILC, and build a gaim-tcl
  package if specified.

* Thu Jun 24 2004 Mark Doliner <thekingant@users.sourceforge.net>
- Add --with silc rebuild option for compiling a separate gaim-silc
  RPM containing the silc protocol plugin (Stu Tomlinson).

* Wed Jun 23 2004 Ethan Blanton <eblanton@cs.ohiou.edu>
- Moved gaim headers and a pkgconfig configuration file into the
  gaim-devel RPM (Stu Tomlinson).

* Thu Jan 15 2004 Ethan Blanton <eblanton@cs.ohiou.edu>
- Removed the manual strip command, as it seems to be unwarranted if
  the necessary programs are properly installed.  (For me, this was
  elfutils.)

* Sun Jul 20 2003 Bjoern Voigt <bjoern@cs.tu-berlin.de>
- Added pkgconfig build dependency.
- if "%{_vendor}" != "MandrakeSoft" now also works with rpm 3.x.
- Added Gaim-specific directories to list of Gaim's files.

* Wed Jul 16 2003 Ethan Blanton <eblanton@cs.ohiou.edu>
- Complete spec file rewrite to take advantage of "new" RPM features
  and make things prettier.
- Use system-supplied %%{_prefix}, %%{_datadir}, etc. rather than
  attempt to define our own.
