#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <ipmc.h>

int  main(int argc, char *argv[]) 
{	
	int file,res;
	struct  ipm_config conf;
	char	filename[]="/dev/ipmc";

	memset(&conf, 0, sizeof(conf));
	if( argc < 6 ) {
		printf("Usage: %s l_value 2n_value fast_bus_mode turbo_mode mem_clk_conf\n", argv[0]);
		printf("\tl_value:\t\tthe L settings in CCCR\n");
		printf("\t2n_value:\t\tthe 2N settings in CCCR\n");
	   	printf("\tfast_bus_mode:\t\t1 - use fast bus mode, 0 - not use\n");
		printf("\tturbo_mode:\t\t2 - use turbo mode, 1 - use half turbo mode, 0 - not use turbo or half turbo mode\n");
		printf("\tmem_clk_conf:\t\t1 - set A bit in CCCR, 0 - clear A bit in CCCR\t\t\n");
		exit(0);
	}
	conf.l = atoi(argv[1]);	//182000;  /*  in khz.*/
	conf.n2	= atoi( argv[2] );
	conf.cpu_mode = 0;
	conf.core_vltg = 0;
//	conf.mem_bus_freq = 200;
//	conf.lcd_freq	= 100;
	conf.fast_bus_mode= atoi( argv[3]);
	conf.turbo_mode = atoi(argv[4]);
	conf.mem_clk_conf = atoi(argv[5]);
	if ((file = open(filename,O_RDWR)) < 0) {
	/* ERROR HANDLING; you can check errno to see what went wrong */
		printf("Open device file %s error.\n", filename);
		return -1;
	}
	/*
	 * 	When you have opened the device, you must specify with what device
	 * 		address you want to communicate:
	 */

	if (ioctl(file, IPMC_IOCTL_SET_DVFM_CONFIG, &conf) < 0) {
		printf("ioctl set error..\n");
		return -1;
	}
	return 0;
}
