#!/usr/bin/env python
#
import gtk,os,getpass,sys
from xml.dom import minidom, Node

class cpuconfig:
	DEF_PAD = 5

	f = open("/proc/cpuinfo","r")
	MODEL = f.read()
	f.close()

	MODEL = MODEL.split();

	MODEL = MODEL[2]

	CPU = MODEL.split("-");

	CPU = CPU[1]

	print MODEL
	
	if (CPU == "PXA250") |(CPU == "PXA255"):
	   print "Not implemented for " +CPU+ " need testers before!"
	elif CPU == "PXA270":
	   KERNEL_POINT = "/sys/devices/system/cpu/cpu0/cpufreq/"
	   KRN_AVAL_FREQS = KERNEL_POINT + "scaling_available_frequencies"
	   KRN_FREQ = KERNEL_POINT + "scaling_cur_freq"
	   KRN_VOLT = KERNEL_POINT + "cpu-voltage"
	   FREQ_TAB    = ["104", "208", "312", "416", "520", "624"]
	   CCCR_L_TAB  = [  "8",  "16",  "16",  "16",  "16",  "16"]
	   CCCR_2N_TAB = [  "2",   "2",   "3",   "4",   "5",   "6"]
	
	CPU_FREQ    = 0
        CPU_CCCR_L  = 0
	CPU_CCCR_2N = 0
	CPU_VCORE   = 0

	if os.name == "nt":
		CFG_FILENAME = ".\\cpuconfig.cfg"
	else:
		CFG_FILENAME = os.environ['HOME'] + "/Choices/cpuconfig.cfg"

	def __init__(self):
		if (self.CPU == "PXA250") | (self.CPU == "PXA255"):
        	 	Warningdialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"Not implemented for " +self.CPU+ " need testers before!")
                 	Warningdialog.run()
                 	Warningdialog.destroy()
                 	sys.exit()

		if (getpass.getuser().lower() != "root"):
			Warningdialog = gtk.MessageDialog(None,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,gtk.MESSAGE_WARNING,gtk.BUTTONS_OK,"You need to be root in order to run this program.")
			Warningdialog.run()
			Warningdialog.destroy()
			sys.exit()
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
	        self.window.set_title("CPU Config")
	        self.window.set_border_width(5)
		self.window.set_position(gtk.WIN_POS_CENTER)
	        self.window.set_resizable(gtk.FALSE)
	        self.window.connect("delete_event", gtk.main_quit)
	        self.window.connect("destroy", gtk.main_quit)

		MainBox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		self.window.add(MainBox)
		
	        mainframe = gtk.Frame(self.CPU + " (" + self.MODEL + ")")
		MainBox.pack_start(mainframe, gtk.TRUE, gtk.TRUE, self.DEF_PAD)
		
		vbox = gtk.VBox(gtk.FALSE, self.DEF_PAD)
		vbox.set_border_width(self.DEF_PAD)
	        mainframe.add(vbox)

		hbox = gtk.HBox(gtk.FALSE, self.DEF_PAD)
		vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, self.DEF_PAD)

		self.freq_menu = gtk.combo_box_new_text()
        	for freq in self.FREQ_TAB:
		    self.freq_menu.append_text(freq)
		
	        self.freq_menu.connect('changed', self.change_freq)
		self.freq_menu.set_size_request(80,30)
		hbox.pack_start(self.freq_menu, gtk.FALSE, gtk.TRUE, 0)

		self.freq_label = gtk.Label("MHz")
		hbox.pack_end(self.freq_label, gtk.TRUE, gtk.TRUE, self.DEF_PAD)

	        bbox = gtk.HButtonBox ()
	        MainBox.pack_start(bbox, gtk.FALSE, gtk.FALSE, 0)
	        bbox.set_layout(gtk.BUTTONBOX_END)

	        cancel_button = gtk.Button("Cancel",gtk.STOCK_CANCEL)
	        cancel_button.connect("clicked", gtk.main_quit)
	        bbox.add(cancel_button)

	        okbutton = gtk.Button("Ok",gtk.STOCK_OK)
	        okbutton.connect("clicked", self.close_and_update)
	        bbox.add(okbutton)
	        okbutton.set_flags(gtk.CAN_DEFAULT)
	        okbutton.grab_default()

		self.load_prefs();

		self.get_sys_freq();		

		self.find_freq(self.CPU_FREQ)
		
		self.window.show_all()

	def get_sys_freq(self):
	        f = open(self.KRN_FREQ,"r")
		val = f.read()
		f.close()
		
		self.CPU_FREQ = eval(val)/1000;
		
		f = open(self.KRN_VOLT,"r")
		val = f.read()
		f.close()
		self.CPU_VCORE = val;		
		
		return True

	def find_freq(self, data=None):
		n = 0
		for freq in self.FREQ_TAB:
		    if (eval(freq) == data):
			self.freq_menu.set_active(n)
			return True
		    else:
			n = n + 1
		self.freq_menu.set_active(0)
		return False

	def change_freq(self, combobox):
		n = combobox.get_active()
		self.CPU_FREQ    = self.FREQ_TAB[n]
		self.CPU_CCCR_L  = self.CCCR_L_TAB[n]
		self.CPU_CCCR_2N = self.CCCR_2N_TAB[n]
		return True

	def close_and_update(self,widget):
		self.save_prefs()
		
		CMD = "dvfm " + self.CPU_CCCR_L + " " + self.CPU_CCCR_2N + " 1 2 1"
		
		try:
			retcode = os.system(CMD)
		except OSError, e:
			print >>sys.stderr, "Execution failed:", e
		
		gtk.main_quit()

	def write_val(self, file, val):
		try:
		    f = open(file, "w");
		    f.write(val);
		    f.close();
		except IOError:
		    return False
		return True

	def load_prefs(self):
		if os.path.isfile(self.CFG_FILENAME):
			try:
				xmldoc = minidom.parse(self.CFG_FILENAME)
			except:
				return False
			else:
				tags = xmldoc.getElementsByTagName("CPUCONFIGSETTINGS");
				for tag in tags:			
					usbtypes = tag.getElementsByTagName("FREQ")
					for usbtype in usbtypes:
						self.CPU_FREQ = usbtype.getAttribute("freq")
						
				return True
		else:
			return False

	def save_prefs(self,widget=None):
		conf_tree = minidom.Document()
		conf_tree.appendChild(conf_tree.createComment("pdaXrom settings file"))
		root_node = conf_tree.createElement("CPUCONFIGSETTINGS")

		node = conf_tree.createElement("FREQ")
		node.setAttribute("freq", self.CPU_FREQ)
		root_node.appendChild(node)

		conf_tree.appendChild(root_node)
		FD = open(self.CFG_FILENAME, "w")
		FD.write(conf_tree.toprettyxml())
		FD.close()

	def main(self):
		gtk.main()

if __name__ == "__main__":
	cpuconfig = cpuconfig()
	cpuconfig.main()
	
