/*
  BlueNIC - Bluetooth PAN profile implementation for BlueZ
  Copyright (C) 2002 Sony Corporation

  Author: Johannes Loebbert <loebbert@sony.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

/*
 * $Id: bnep_common.h,v 1.1 2002/08/04 21:35:46 maxk Exp $
*/


#ifndef _BNEP_H
#define _BNEP_H

#include <bluetooth/bluetooth.h>

//Compile with support for certification infrastructure / Debug messages
#define BNEP_ERR_PRINT 1

#ifdef CONFIG_BNEP_TEST
#define BNEP_TEST 1
#endif				/* CONFIG_BNEP_TEST */

#ifdef CONFIG_BNEP_DEBUG
#define BNEP_DEBUG 1
#endif				/* CONFIG_BNEP_DEBUG */

//Basic IO Commands 
#define SIOC_CONNECT	(SIOCDEVPRIVATE+1)
#define SIOC_DISCONNECT	(SIOCDEVPRIVATE+2)
#define SIOC_TESTCASE	(SIOCDEVPRIVATE+3)
#define SIOC_DEBUG	(SIOCDEVPRIVATE+4)
#define SIOC_SET_ROLE	(SIOCDEVPRIVATE+5)
#define SIOC_SET_FILTER	(SIOCDEVPRIVATE+6)

//Control for mapping of eth - hci
#define NET_DEVICE_INSERT 0
#define NET_DEVICE_REMOVE 1

//Control of layer of connection
#define CONN_BNEP_LAYER  0
#define CONN_L2CAP_LAYER 1

//***********************************************************************
// Constants defined by the PAN profile
//***********************************************************************
//BNEP Packet Types
#define BNEP_GENERAL_ETHERNET                   0x00
#define BNEP_CONTROL                            0x01
#define BNEP_COMPRESSED_ETHERNET                0x02
#define BNEP_COMPRESSED_ETHERNET_SOURCE_ONLY    0x03
#define BNEP_COMPRESSED_ETHERNET_DEST_ONLY      0x04
#define BNEP_PACKET_TYPE_AUTO			0xff	//Not defined by Bluetooth SIG

//UUIDs
#define UUID_ROLE_UNKNOWN 0x0000	//Not defined by Bluetooth SIG
#define UUID_PANU 0x1115
#define UUID_NAP  0x1116
#define UUID_GN   0x1117
#define BASE_UUID 0x0000000000001000800000805F9B34FB

#define UUID16  0x02
#define UUID32  0x04
#define UUID128 0x16

//Command package types
#define BNEP_CONTROL_COMMAND_NOT_UNDERSTOOD    0x00
#define BNEP_SETUP_CONNECTION_REQUEST_MSG      0x01
#define BNEP_SETUP_CONNECTION_RESPONSE_MSG     0x02
#define BNEP_FILTER_NET_TYPE_SET_MSG           0x03
#define BNEP_FILTER_NET_TYPE_RESPONSE_MSG      0x04
#define BNEP_FILTER_MULT_ADDR_SET_MSG          0x05
#define BNEP_FILTER_MULT_ADDR_RESPONSE_MSG     0x06
#define BNEP_UNKNOWN_COMMAND                   0xFF

//Response messages for connection setup
#define CONN_OPERATION_SUCCESSFUL                      0x0000
#define CONN_OPERATION_FAILED_INVALID_DESTINATION_UUID 0x0001
#define CONN_OPERATION_FAILED_INVALID_SOURCE_UUID      0x0002
#define CONN_OPERATION_FAILED_INVALID_SERVICE_UUID     0x0003
#define CONN_OPERATION_FAILED_CONNECTION_NOT_ALLOWED   0x0004

//Response messages for filter control
#define NETFILTER_OPERATION_SUCCESSFUL        0x00
#define NETFILTER_UNSUPPORTED_REQUEST         0x01
#define NETFILTER_INVALID_RANGE               0x02
#define NETFILTER_MAX_FILTER_LIMITED_REACHED  0x03
#define NETFILTER_UNABLE_TO_FULFILL_SECURITY  0x04

//Response messages for multicast filter
#define MCFILTER_OPERATION_SUCCESSFUL         	0x00
#define MCFILTER_UNSUPPORTED_REQUEST           	0x01
#define MCFILTER_FAILD_INVALID_MC_ADDR         	0x02
#define MCFILTER_MAX_MCFILTER_LIMITED_REACHED   0x03
#define MCFILTER_UNABLE_TO_FULFILL_SECURITY  	0x04

//Messages for extension header
#define BNEP_EXTENSION_CONTROL 0x00

#define EXTENSION_HEADER_LENGTH 3

#define PAN_IMTU 1691
#define PAN_OMTU 1691
#define PAN_FLUSH_TO 0xffff
#define PAN_PSM	0x0f
#define BNEP_CONN_TIMEOUT 15
#define BNEP_FILTER_TIMEOUT 15
//**********************************************************************

//**********************************************************************
//Testing messages
//**********************************************************************
#ifdef BNEP_TEST
#define TEST_PAYLOAD_DATA                    1
#define TEST_PAYLOAD_CONTROL_NETFILTER       2
#define TEST_PAYLOAD_CONTROL_MULTICASTFILTER 3
#define TEST_PAYLOAD_UNKNOWN_CONTROL         4
#define TEST_PAYLOAD_CONNECT_CONTROL         5

#define TESTCASE_ADD_EXTENSION  0
#define TESTCASE_ADD_PAYLOAD    1

#define TESTCASE_CONTENT_DATA 			0
#define TESTCASE_CONTENT_PROTOCOL_FILTER 	1
#define TESTCASE_CONTENT_MULTICAST_FILTER 	2
#define TESTCASE_CONTENT_CONNECT 		3
#define TESTCASE_CONTENT_CONTROL 		4
#define TESTCASE_CONTENT_UNKNOWN_HEADER 	5

#define TESTCASE_ADD	0
#define TESTCASE_RESET	1
#define TESTCASE_SEND	2
#define TESTCASE_IGNORE	3

#define TESTCASE_IGNORE_CONNECT          1
#define TESTCASE_IGNORE_NETFILTER        2
#define TESTCASE_IGNORE_MULTICASTFILTER  3

#define TESTCASE_IGNORE_MESSAGE_ON	1
#define TESTCASE_IGNORE_MESSAGE_OFF	2

#define H802_1P_OFF	0
#define H802_1P_ON	1
#endif
//**********************************************************************/
//BNEP_CORE <-> PANTOOL - Communication
#define BNEP_ERR_DEV_NOT_LOADED   	1
#define BNEP_ERR_MAX_DEV_EXCEEDED 	2
#define BNEP_ERR_UNKNOWN_NETDEV_COMMAND 3
#define BNEP_ERR_USED_BDADDR		4
#define BNEP_ERR_ALLOC_NAME 		5
#define BNEP_ERR_REGISTER_NETDEV 	6
#define BNEP_ERR_NO_L2CAP 		7
#define BNEP_ERR_SOCK_ACCEPT		8
#define BNEP_ERR_CONNECT_L2CAP		9
#define BNEP_ERR_DEVICE_CONNECTED 	10

#define BNEP_ERR_CONNECT_BNEP_TIMEOUT	11
#define BNEP_ERR_CONNECT_BNEP_ERROR	12
#define BNEP_ERR_BNEP_CONN_REQ_PENDING  13
#define BNEP_ERR_CONN_UNKNOWN_LAYER	14
#define BNEP_ERR_CONN_UNKNOWN_DEF_ROLE	15
#define BNEP_ERR_SOCK_BIND		16
#define BNEP_ERR_BNEP_FILTER_REQ_PENDING 17
#define BNEP_ERR_FILTER_TIMEOUT		18
#define BNEP_ERR_FILTER_ERROR		19

#define FILTER_TYPE_PROTOCOL  0
#define FILTER_TYPE_MULTICAST 1
//**********************************************************************/

#ifndef __cplusplus
typedef int bool;
#define true  1
#define false 0
#endif				/* __cplusplus */

struct filter_request_struct {
	int filter_type;
	int data_length;
	void *data;
	bdaddr_t destination_address;
};

struct protocol_range {
	uint16_t start;
	uint16_t stop;
};

struct multicast_range {
	uint64_t start;
	uint64_t stop;
};

struct bnep_ioctl_debug {
	int command;
};

struct bnep_dev_ioctl_struct {
	char name[8];
	bdaddr_t source_address;
	int net_device_command;
	int role_uuid;
};

struct bnep_connect_mgnt_struct {
	bdaddr_t destination_address;
	int protocol;
	int destination_uuid;
};

struct filter_info_summary_struct {
	struct protocol_range *NetFilter;
	struct multicast_range *MulticastFilter;
	int net_filter_count;
	int multicast_filter_count;
};

//*********************************************************************
//Testing messages data structures
//*********************************************************************
#ifdef BNEP_TEST
struct bnep_test_ioctl_packet_struct {
	int command;
	int option_length;
	unsigned char *options;
};

struct bnep_test_ioctl_send_struct {
	bdaddr_t destination_address;
	int packet_type;
	uint16_t protocol;
	int h802_1p;
};

struct bnep_test_ctrl_struct {
	int test_command;
	void *opt_args;
};

struct bnep_test_ioctl_ignore_msg_struct {
	int msg_type;
	int switch_value;
};

struct bnep_test_ioctl_add_field_struct {
	int field;
	int content;
	int add_opts_length;
	void *add_opts;
};

struct bnep_test_ioctl_data_opt_struct {
	int length;
	int header_length;
};

struct bnep_test_ioctl_connect_opt_struct {
	uint16_t source_uuid;
	uint16_t destination_uuid;
};

struct bnep_test_ioctl_control_opt_struct {
	int control_value;
	int length;
};

struct bnep_test_ioctl_unknown_header_opt_struct {
	int control_value;
	int length;
};
#endif

#endif
